/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import oracle.olap.app.db.Database;
import oracle.olap.app.tree.loader.TreeLoaderBreadthFirst;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.Tree;

public class HierarchyStarLoader
extends TreeLoaderBreadthFirst {
    private Database db;
    private String[] sql;
    private int rowNum;

    public HierarchyStarLoader(Database database, List<String> list, String[] stringArray) {
        super(new Tree());
        this.db = database;
        this.sql = stringArray;
        this.getTree().setTreeLoader(this);
        this.getTree().setLevelNames(list);
        this.rowNum = 1;
    }

    @Override
    public void loadData() throws SQLException {
        int n = this.sql.length;
        if (n > 2) {
            n = 2;
        }
        for (int i = 0; i < n; ++i) {
            this.loadTree(this.db, this.sql[i]);
        }
        Database database = this.db;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 2; i < HierarchyStarLoader.this.sql.length; ++i) {
                        HierarchyStarLoader.this.loadTree(HierarchyStarLoader.this.db, HierarchyStarLoader.this.sql[i]);
                    }
                    HierarchyStarLoader.this.setLoadingState(false);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                finally {
                    HierarchyStarLoader.this.setLoadingState(false);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void loadTree(Database database, String string) throws SQLException {
        Date date = new Date();
        Statement statement = database.getConnection().createStatement();
        statement.execute(string);
        ResultSet resultSet = statement.getResultSet();
        resultSet.setFetchSize(10000);
        int n = -1;
        int n2 = -1;
        while (resultSet.next()) {
            HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
            hierarchyNodeData.dimKey = resultSet.getString("key");
            n2 = resultSet.getInt("depth");
            hierarchyNodeData.parent = resultSet.getString("parent");
            hierarchyNodeData.desc = resultSet.getString("description");
            Node node = this.load(hierarchyNodeData, hierarchyNodeData, n2);
            ++this.rowNum;
            if (n2 != n) {
                this.setFinishedLoadingDepth(n);
                n = n2;
            }
            if (!this.isStopLoadingData()) continue;
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return;
        }
        this.getTree().setCount(this.rowNum);
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

