/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.UISettings;
import oracle.olap.app.actions.ActionCallback;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.tree.loader.TreeLoader;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.VirtualTreeModel;
import oracle.olap.app.tree.view.JTreeV;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.util.OLAPFetchIcon;

public class HierarchyViewerDialog
extends JDialog {
    private JTreeV tree;
    private VirtualTreeModel treeModel;
    private JScrollPane sp;
    private TreeLoader treeLoader;
    private ActionCallback actionCallback;
    private SearchField searchField;
    private JComboBox hierarchySelector;
    private JLabel hierarchyLabel;
    private SearchOptions searchOptions;
    private DialogButtonBar bb;
    private Resources resources;
    private List<Node> searchResults;
    private String previousSearch;
    private int searchIndex;
    private boolean flat = false;
    private boolean isOKSelected = false;
    private JButton okButton;
    public static final String VIEW_DIMENSION_MEMBERS_MODE = "VIEW_DIMENSION_MEMBERS_MODE";
    public static final String SELECT_DIMENSION_MEMBERS_MODE = "SELECT_DIMENSION_MEMBERS_MODE";

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources, String string3) throws Exception {
        super(window);
        if (list != null && list.size() > 0) {
            this.init(string, list, string2, resources, string3);
        }
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources) throws Exception {
        this(window, string, list, string2, resources, null);
    }

    /*
     * WARNING - void declaration
     */
    private void init(String string, final List<HierarchyET> list, String string2, Resources resources, String string3) throws Exception {
        void var8_11;
        Object object;
        if (string3 == null) {
            string3 = VIEW_DIMENSION_MEMBERS_MODE;
        }
        this.setTitle(string);
        this.resources = resources;
        HierarchyET hierarchyET = null;
        if (string2 != null) {
            for (HierarchyET object32 : list) {
                if (!object32.getHierarchyName().equalsIgnoreCase(string2)) continue;
                hierarchyET = object32;
            }
        }
        if (hierarchyET == null) {
            hierarchyET = list.get(0);
        }
        hierarchyET.getTreeLoader().loadData();
        JPanel jPanel = new JPanel();
        this.okButton = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_OK_BUTTON_TEXT")));
        JButton jButton = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_CLOSE_BUTTON_TEXT")));
        JButton jButton2 = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
        if (hierarchyET.getLevelNames() != null) {
            this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size());
        }
        this.tree = new JTreeV(this.treeModel);
        this.tree.setContextProperty("DIALOG", this);
        this.tree.setShowsRootHandles(true);
        if (string3.equalsIgnoreCase(VIEW_DIMENSION_MEMBERS_MODE)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.tree, "olap_dimension_data_viewer");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.tree, "olap_select_dimension_member");
            this.okButton.setEnabled(false);
            JButton jButton3 = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_CANCEL_BUTTON_TEXT")));
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
                        HierarchyViewerDialog.this.okButton.setEnabled(true);
                    } else {
                        HierarchyViewerDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            int n = 1;
            object = new DefaultTreeSelectionModel();
            object.setSelectionMode(n);
            this.tree.setSelectionModel((TreeSelectionModel)object);
        }
        this.searchOptions = new SearchOptions(null);
        OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
        this.searchField = new SearchField();
        this.searchField.setStyle(SearchField.Style.FIND);
        this.searchResults = new ArrayList<Node>();
        this.previousSearch = "";
        this.searchIndex = 0;
        this.hierarchyLabel = new JLabel(OLAPArb.getString("HIERARCHY_VIEWER_DIALOG_HIER"));
        this.hierarchySelector = new JComboBox();
        if (hierarchyET.getHierarchyName() != null) {
            for (HierarchyET hierarchyET2 : list) {
                this.hierarchySelector.addItem(hierarchyET2.getHierarchyName());
            }
            this.hierarchySelector.setSelectedItem(hierarchyET.getHierarchyName());
            this.hierarchySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)HierarchyViewerDialog.this.hierarchySelector.getSelectedItem();
                    HierarchyET hierarchyET = null;
                    for (HierarchyET hierarchyET2 : list) {
                        if (!hierarchyET2.getHierarchyName().equalsIgnoreCase(string)) continue;
                        hierarchyET = hierarchyET2;
                        break;
                    }
                    if (hierarchyET != null) {
                        if (hierarchyET.getTreeLoader().getFinishedLoadingAtDepth() < 0) {
                            try {
                                hierarchyET.getTreeLoader().loadData();
                            }
                            catch (Exception exception) {
                                return;
                            }
                        }
                        HierarchyViewerDialog.this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
                        if (hierarchyET.getLevelNames() != null) {
                            HierarchyViewerDialog.this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size());
                        }
                        HierarchyViewerDialog.this.tree.setModel(HierarchyViewerDialog.this.treeModel);
                    }
                }
            });
        } else {
            this.flat = true;
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            this.treeModel.setNumberOfLevels(1);
            this.tree.setModel(this.treeModel);
        }
        object = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.findNode(HierarchyViewerDialog.this.searchField.getText(), SearchEvent.Direction.FORWARD);
            }
        };
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.searchField.requestFocus();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.setVisible(false);
                HierarchyViewerDialog.this.dispose();
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.showHelp();
            }
        };
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("control F"), abstractAction);
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("control F"), "findFocus");
        actionMap.put("findFocus", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke("F3"), "find");
        actionMap.put("find", (Action)object);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        actionMap.put("close", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", abstractAction3);
        Icon icon = oLAPFetchIcon.getIcon("MEMBER");
        Icon icon2 = oLAPFetchIcon.getIcon("MEMBER_FOLDER");
        if (icon != null && icon2 != null) {
            this.tree.setFolderIcon(icon2);
            this.tree.setLeafIcon(icon);
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        if (!this.flat) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.insets.left = 10;
            jPanel.add((Component)this.hierarchyLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = UISettings.getPanelInsets();
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)this.hierarchySelector, gridBagConstraints);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)this.searchField, gridBagConstraints);
        gridBagConstraints.insets = UISettings.getPanelInsets();
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree, 30, 20);
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(insets.top, insets.left, -2, insets.right);
        jPanel.add((Component)this.sp, gridBagConstraints);
        gridBagConstraints.insets = UISettings.getPanelInsets();
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        this.bb = new DialogButtonBar();
        this.bb.add((Component)jButton2, DialogButtonBar.CONSTRAINT_HELP);
        if (string3.equalsIgnoreCase(SELECT_DIMENSION_MEMBERS_MODE)) {
            this.getRootPane().setDefaultButton(this.okButton);
            this.bb.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        }
        this.bb.add((Component)var8_11, DialogButtonBar.CONSTRAINT_CANCEL);
        gridBagConstraints.ipady = 10;
        jPanel.add((Component)this.bb, gridBagConstraints);
        this.setContentPane(jPanel);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.isOKSelected = true;
                HierarchyViewerDialog.this.dispose();
            }
        });
        var8_11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.showHelp();
            }
        });
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                HierarchyViewerDialog.this.findNode(searchEvent.getSearchText(), searchEvent.getDirection());
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                HierarchyViewerDialog.this.cleanup();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
    }

    public void addDialogSaveButton(JButton jButton) {
        this.bb.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
    }

    public void setActionCallback(ActionCallback actionCallback) {
        this.actionCallback = actionCallback;
    }

    public void showHelp() {
        if (this.actionCallback != null) {
            this.actionCallback.action(this, "HELP");
        } else {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.tree);
        }
    }

    public void cleanup() {
        if (this.treeLoader != null) {
            this.treeLoader.setStopLoadingData(true);
        }
        this.treeLoader = null;
        this.tree = null;
        this.treeModel = null;
    }

    private void findNode(String string, SearchEvent.Direction direction) {
        if (string.length() > 0) {
            if (this.searchResults.isEmpty()) {
                this.tree.findNodes("DESC", string, this.searchOptions, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            } else if (this.previousSearch.equals(string)) {
                this.searchIndex = direction.equals((Object)SearchEvent.Direction.FORWARD) ? (this.searchIndex + 1 < this.searchResults.size() ? ++this.searchIndex : 0) : (this.searchIndex - 1 >= 0 ? --this.searchIndex : this.searchResults.size() - 1);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(this.searchIndex));
                }
            } else {
                this.searchResults.clear();
                this.searchIndex = 0;
                this.tree.findNodes("DESC", string, this.searchOptions, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            }
        }
    }

    public JTreeV getTree() {
        return this.tree;
    }

    public boolean isOKSelected() {
        return this.isOKSelected;
    }
}

