/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.map.panels;

import com.adbs.querybuilder.QueryBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.dbtools.raptor.editors.RaptorEditorPlugin;
import oracle.dbtools.raptor.editors.WorksheetEditorPluginRegistry;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.UpdateProcessorPropertiesFilter;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.DragDropPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.util.Pair;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.context.ContextUtil;
import oracle.olap.cube.model.SideEffects;
import oracle.olap.cubexml.BaseCubeXML;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.olap.ddl.Identifier;
import oracle.olap.map.ColumnListRunnable;
import oracle.olap.map.Projection;
import oracle.olap.map.SQLExtractor;
import oracle.olap.map.TableMetadata;
import oracle.olap.map.panels.MapDefinition;
import oracle.olap.map.panels.MapElement;
import oracle.olap.map.panels.SourceTextField;
import oracle.olap.map.panels.SourceValidator;
import oracle.olap.sql.QueryPanel;
import oracle.olap.syntax.SyntaxTree;
import oracle.olap.syntax.SyntaxVisitor;
import oracle.olap.util.ColumnSelectionDialog;
import oracle.olap.util.CompletionCellEditor;
import oracle.olap.util.CompletionStringMatchProvider;
import oracle.olap.util.OLAPHelpProvider;
import oracle.olap.util.SourceMetadata;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxObject;

public abstract class MapPanel<T extends AbstractMappableSchemaObjectWithDesc>
extends BaseEditorPanel<T>
implements ActionListener,
TableModelListener,
SourceValidator {
    private static final String CLEAR_ACTION = "clearAction";
    private static final String MAP_PANEL_SELECT_MAPPING = OLAPArb.get("MAP_PANEL_SELECT_MAPPING");
    private static final int MAP_TAB = 0;
    private static final int QUERY_TAB = 1;
    private static final int QUERY_BUILDER_TAB = 2;
    private List<DatabaseObject> sources;
    private JComboBox sourceColumnComboBox;
    private JTabbedPane mapTab;
    private Toolbar mapToolbar;
    private JLabel mapLabel;
    private QueryPanel queryBuilderPanel;
    private DefaultTableModel mapTableModel;
    private JTable mapTable;
    private SuperLabel mapErrorMessage;
    private CompletionStringMatchProvider sourceCompletionProvider;
    private CompletionTextField ctf;
    private BasicEditorPane queryEditor;
    private JLabel feedbackLabel;
    private ReadOnlyScrollPane feedback;
    private JButton checkSyntaxButton;
    private boolean invalidChangeCommitted;
    private List<RaptorEditorPlugin> installedPlugins = new ArrayList<RaptorEditorPlugin>();
    private CompletionInsight insightPlugin;
    private WorksheetFoldingPlugin foldingPlugin;
    private SQLQueryBuilderFactory sqlQueryBuilderFactory;
    private DBObjectProvider prov;
    private Schema defaultSchema;
    private boolean showQueryBuilder;
    private SourceTextField sourceTextField;
    private JTextField filterTextField;
    private MapDefinition mapDefn;
    private SourceMetadata sourceMetaData;
    private ColumnSelectionDialog columnSelectiondialog;
    public static final int MAP_EXPR_COLUMN = 0;
    public static final int MAP_DISPLAY_COLUMN = 1;
    public static final int MAP_AT_COLUMN = 2;
    public static final int MAP_KEY_COLUMN = 3;
    public static final String EMPTY_STRING = "";
    private final String SOURCE_QUERY_XML_FILE = "sourcequeries.xml";
    private String sourceName;
    private String extractedSource;

    public MapPanel() {
        this.mapTableModel = new DefaultTableModel();
        this.mapTableModel.setColumnIdentifiers(this.getMapObjectColumnNames());
        this.sourceColumnComboBox = new JComboBox();
        this.sourceColumnComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    MapPanel.this.sourceColumnSelected();
                }
            }
        });
        this.sourceMetaData = new SourceMetadata("sourcequeries.xml");
        OLAPHelpProvider oLAPHelpProvider = new OLAPHelpProvider();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        this.columnSelectiondialog = new ColumnSelectionDialog(window, this.sourceMetaData, oLAPHelpProvider);
        this.layoutComponents();
    }

    @Override
    public String validateSource(String string) {
        Object object;
        String[] stringArray = string.split("\\,");
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String charSequence2 : list) {
            object = charSequence2.trim();
            if (!charSequence2.startsWith("\"")) {
                object = charSequence2.toUpperCase();
            }
            arrayList.add((String)object);
        }
        List<String> list2 = this.columnSelectiondialog.findMissingSources(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        object = list2.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            stringBuffer.append(string2 + ",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        object = null;
        if (stringBuffer.length() > 0) {
            object = OLAPArb.format("MAP_PANEL_MAP_SOURCE_NOT_FOUND_MSG", stringBuffer.toString());
        }
        return object;
    }

    public void sourceColumnSelected() {
    }

    public void sourceExpressionChange(String string, String string2) throws SQLException, DBException {
    }

    public String[] getMapObjectColumnNames() {
        String[] stringArray = new String[]{OLAPArb.get("MAP_PANEL_TABLE_SOURCE_COLUMN"), OLAPArb.get("MAP_PANEL_TABLE_MAP_OBJECT_COLUMN"), OLAPArb.get("MAP_PANEL_TABLE_MAP_AT_COLUMN"), OLAPArb.get("MAP_PANEL_TABLE_MAP_KEY_COLUMN")};
        return stringArray;
    }

    public Set<String> parseSources(final Set<String> set, String string) throws SQLException {
        SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null, (String)((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName());
        SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

            @Override
            public void visit(SyntaxObject syntaxObject) throws SQLException {
                if (syntaxObject instanceof ColumnExpression) {
                    ColumnExpression columnExpression = (ColumnExpression)syntaxObject;
                    Query query = columnExpression.getQuery();
                    String string = query.toSyntax();
                    IdentifierElement identifierElement = new IdentifierElement(string);
                    if (identifierElement.getCount() == 2 && identifierElement.getFirst().equals(((AbstractMappableSchemaObjectWithDesc)MapPanel.this.getUpdatedObject()).getSchema().getName())) {
                        string = identifierElement.getSecond();
                    }
                    set.add(string);
                }
            }
        });
        return set;
    }

    public String extractSourceFromExpression(String string) throws SQLException {
        this.sourceName = null;
        if (!string.isEmpty()) {
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null, (String)((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName());
            SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

                @Override
                public void visit(SyntaxObject syntaxObject) throws SQLException {
                    if (syntaxObject instanceof ColumnExpression) {
                        String string;
                        ColumnExpression columnExpression = (ColumnExpression)syntaxObject;
                        Query query = columnExpression.getQuery();
                        String string2 = query.toSyntax();
                        String string3 = query.getName();
                        string2 = string3;
                        if (string2.startsWith(string = ((AbstractMappableSchemaObjectWithDesc)MapPanel.this.getUpdatedObject()).getSchema().getName())) {
                            string2 = string2.substring(string.length() + 1, string2.length());
                        }
                        MapPanel.this.sourceName = string2;
                    }
                }
            });
        }
        return this.sourceName;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.checkSyntaxButton) {
            try {
                this.testQuery(null);
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
        }
    }

    public void setColumns(String[] stringArray) {
        this.mapTableModel.setColumnIdentifiers(stringArray);
    }

    public DefaultTableModel getMapTableModel() {
        return this.mapTableModel;
    }

    public MapDefinition getMapDefinition() {
        return this.mapDefn;
    }

    public List<String> getMapObjects() {
        DefaultTableModel defaultTableModel = this.getMapTableModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 1);
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Map<String, List<String>> getMapObjectElements() {
        return null;
    }

    public JTable getMapTable() {
        return this.mapTable;
    }

    public void setColumnWidth(int n, int n2) {
        TableColumn tableColumn;
        int n3 = this.mapTable.getColumnCount();
        if (n < n3 && (tableColumn = this.mapTable.getColumnModel().getColumn(n)) != null) {
            tableColumn.setWidth(n2);
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
        }
    }

    public void setMapTableProperties(JTable jTable) {
    }

    public void setSource(String string) throws SQLException, DBException {
        this.sourceTextField.setText(string);
        this.getAllColumnsForSources();
        this.setMapTableColumns(this.sources);
        this.sourceValueChanged();
    }

    public String getSource() {
        return this.sourceTextField.getText();
    }

    public void setFilter(String string) {
        this.filterTextField.setText(string);
    }

    public String getFilter() {
        return this.filterTextField.getText();
    }

    public String processExpression(String string, String string2) {
        String string3 = ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
        SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string2, null, null);
        if (syntaxObject instanceof ColumnExpression) {
            String string4 = null;
            ColumnExpression columnExpression = (ColumnExpression)syntaxObject;
            string2 = string4 = columnExpression.toSyntax();
        }
        return string2;
    }

    protected String processExpression2(String string) {
        return BaseCubeXML.processExpression(string);
    }

    public String processSource(String string) {
        IdentifierElement identifierElement = new IdentifierElement(string);
        try {
            String string2 = this.getProvider().getDefaultSchema().getName();
            if (identifierElement.getCount() == 2 && identifierElement.getFirst().equals(string2)) {
                return identifierElement.getSecond();
            }
        }
        catch (DBException dBException) {
            String string3 = dBException.getStackTrace()[0].toString();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string3, dBException);
        }
        return string;
    }

    public String extractSource(String string) throws DBException {
        String string2 = ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
        String[] stringArray = string.split("\\.");
        String string3 = string;
        if (stringArray.length == 2 && string2.equals(stringArray[0])) {
            string3 = stringArray[1];
        }
        return string3;
    }

    public String getQualifiedSource(String string) throws DBException {
        String string2 = string;
        if (string != null && string.indexOf(".") == -1) {
            String string3 = this.getProvider().getDefaultSchema().getName();
            string2 = new Identifier(string3, string).toString();
        }
        return string2;
    }

    private void getAllColumnsForSources() {
        String string = this.sourceTextField.getText();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        List<DatabaseObject> list = this.getColumns(oracleDatabaseImpl, string);
        if (this.sources == null || this.sources.size() < 1) {
            this.sources = list;
        }
        this.updateSourceColumns(this.sources);
    }

    private static String getQuotedIdentifier(String string) {
        if (string.indexOf(".") != -1 || !string.toUpperCase().equals(string)) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private void updateSourceColumns(List<DatabaseObject> list) {
        String string = ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
        StringBuffer stringBuffer = new StringBuffer();
        for (DatabaseObject databaseObject : list) {
            String string2 = MapPanel.getQuotedIdentifier(databaseObject.getName());
            if (databaseObject.getSchemaName().equals(string)) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(String.format("%s.%s", databaseObject.getSchemaName(), string2));
            }
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
            this.sourceTextField.setText(stringBuffer.toString());
        }
        this.setMapTableColumns(list);
    }

    private void setMapTableColumns(List<DatabaseObject> list) {
        String string = ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (DatabaseObject object : list) {
                for (Column column : object.getColumns()) {
                    String string2 = MapPanel.getQuotedIdentifier(object.getSchemaName());
                    String string3 = MapPanel.getQuotedIdentifier(object.getName());
                    String string4 = MapPanel.getQuotedIdentifier(column.getName());
                    String string5 = String.format("%s.%s", string3, string4);
                    if (!string2.equals(string)) {
                        string5 = String.format("%s.%s.%s", string2, string3, string4);
                    }
                    arrayList.add(string5);
                }
            }
        }
        TableColumn tableColumn = this.mapTable.getColumnModel().getColumn(0);
        if (!bl) {
            this.sourceColumnComboBox.removeAllItems();
            this.sourceColumnComboBox.addItem(EMPTY_STRING);
            for (String string6 : arrayList) {
                this.sourceColumnComboBox.addItem(string6);
            }
            this.sourceColumnComboBox.setEditable(true);
            tableColumn.setCellEditor(new DefaultCellEditor(this.sourceColumnComboBox));
        } else {
            CompletionTextField completionTextField = new CompletionTextField();
            this.sourceCompletionProvider = new CompletionStringMatchProvider(completionTextField.getPopupHandler().getInsightList(), arrayList);
            completionTextField.getPopupHandler().registerInsightProvider((CompletionProvider)this.sourceCompletionProvider);
            tableColumn.setCellRenderer(new MapSourceRenderer());
            tableColumn.setCellEditor(new CompletionCellEditor(completionTextField, this.sourceCompletionProvider));
        }
    }

    public List<DatabaseObject> getSources() {
        return this.sources;
    }

    private Pair<String, String> getSchemaAndSource(String string) throws DBException {
        String string2 = this.getProvider().getDefaultSchema().getName();
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() == 2) {
            return new Pair((Object)identifierElement.getFirst(), (Object)identifierElement.getSecond());
        }
        return new Pair((Object)string2, (Object)string);
    }

    public List<Column> getSourceColumns(String string) throws SQLException, DBException {
        IdentifierElement identifierElement;
        if (string == null) {
            return new ArrayList<Column>();
        }
        if (this.sources == null) {
            this.sources = new ArrayList<DatabaseObject>();
        }
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string2 = this.getProvider().getDefaultSchema().getName();
        String string3 = string;
        if (string3.startsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if ((identifierElement = new IdentifierElement(string3)).getCount() == 1) {
            string = new Identifier(string2, string3).toString();
        }
        for (DatabaseObject object2 : this.sources) {
            String string4 = new Identifier(object2.getSchemaName(), object2.getName()).toString();
            if (!string4.equals(string)) continue;
            return object2.getColumns();
        }
        Iterator<DatabaseObject> iterator = this.getSchemaAndSource(string);
        List<Column> list = DatabaseUtils.GetTableColumns(oracleDatabaseImpl.getConnection(), (String)iterator.getFirst(), (String)iterator.getSecond());
        return list;
    }

    public List<String> getAllSources(String string) throws SQLException, DBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        List list = DatabaseUtils.GetTables(oracleDatabaseImpl.getConnection(), oracleDatabaseImpl.getUserName());
        return list;
    }

    private void sourceSelected(List<DatabaseObject> list) throws SQLException, DBException, TraversalException {
        this.sources = list;
        if (this.mapTable.isEditing()) {
            int n = this.mapTable.getEditingRow();
            int n2 = this.mapTable.getEditingColumn();
            TableCellEditor tableCellEditor = this.mapTable.getCellEditor(n, n2);
            tableCellEditor.stopCellEditing();
        }
        this.updateSourceColumns(list);
        this.updateMappings(list);
        String string = this.getPseudoBuildQuery();
        this.setQuery(string);
        this.commitPanel();
        this.sourceValueChanged();
    }

    protected void commitMapTableEdits() {
        if (this.mapTable.isEditing()) {
            int n = this.mapTable.getEditingRow();
            int n2 = this.mapTable.getEditingColumn();
            TableCellEditor tableCellEditor = this.mapTable.getCellEditor(n, n2);
            tableCellEditor.stopCellEditing();
        }
    }

    private void filterChanged() {
        String string = this.getPseudoBuildQuery();
        this.setQuery(string);
    }

    private void sourceChanged() throws SQLException, DBException, TraversalException {
        this.commitMapTableEdits();
        String string = this.sourceTextField.getText();
        this.sources.clear();
        this.clearMap();
        this.clearMapTable();
        this.getAllColumnsForSources();
        this.setMapTableColumns(this.sources);
        this.updateMappings(this.sources);
        String string2 = this.getPseudoBuildQuery();
        this.setQuery(string2);
        this.commitPanel();
        this.sourceValueChanged();
    }

    public void sourceValueChanged() throws SQLException, DBException {
    }

    public void updateMappings(List<DatabaseObject> list) {
        for (int i = 0; i < this.mapTableModel.getRowCount(); ++i) {
            String string = (String)this.mapTableModel.getValueAt(i, 3);
            String string2 = (String)this.mapTableModel.getValueAt(i, 0);
            if (string2 != null && !string2.isEmpty() || (string2 = this.findMatchingColumn(string, list)).isEmpty()) continue;
            string2 = this.processColumn(string, string2);
            this.mapTableModel.setValueAt(string2, i, 0);
        }
    }

    public String findMatchingColumn(String string, List<DatabaseObject> list) {
        for (DatabaseObject databaseObject : list) {
            for (Column column : databaseObject.getColumns()) {
                String string2 = new Identifier(databaseObject.getName(), column.getName()).toString();
                String string3 = column.getName();
                if (string3.equalsIgnoreCase(string)) {
                    return string2;
                }
                if (string3.equalsIgnoreCase(string + "_ID")) {
                    return string2;
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                for (int i = 2; i > 0 && Character.isDigit(stringBuffer.charAt(stringBuffer.length() - 1)); ++i) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                String string4 = stringBuffer.toString();
                if (!string3.equalsIgnoreCase(string4 + "_ID")) continue;
                return string2;
            }
        }
        return EMPTY_STRING;
    }

    public String findMatchingMapElement(List<String> list, String string) {
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() == 2) {
            string = identifierElement.getSecond();
        }
        for (String string2 : list) {
            if (string.equalsIgnoreCase(string2)) {
                return string2;
            }
            if (string.equalsIgnoreCase(string2 + "_ID")) {
                return string2;
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            for (int i = 2; i > 0 && Character.isDigit(stringBuffer.charAt(stringBuffer.length() - 1)); ++i) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            String string3 = stringBuffer.toString();
            if (!string.equalsIgnoreCase(string3 + "_ID")) continue;
            return string2;
        }
        return EMPTY_STRING;
    }

    public String processColumn(String string, String string2) {
        return string2;
    }

    public abstract String getPseudoBuildQuery();

    public String getQuery() {
        return this.queryEditor.getText();
    }

    public void setQuery(String string) {
        this.queryEditor.setEditable(true);
        this.queryEditor.setText(string);
        this.queryEditor.setEditable(false);
        try {
            if (this.queryBuilderPanel != null) {
                this.queryBuilderPanel.setSQL(string);
            }
        }
        catch (QueryBuilderException queryBuilderException) {
            this.queryEditor.setText(null);
        }
    }

    protected String getUnmappableMessage() throws Exception {
        return null;
    }

    protected void initialisePanel() {
        String string;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.sourceMetaData.setConnection(oracleDatabaseImpl.getConnection());
        this.columnSelectiondialog.setDefaultSchema(((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName());
        this.columnSelectiondialog.setObjectName(((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getName());
        this.columnSelectiondialog.setObjectType(((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getType());
        this.columnSelectiondialog.init(this.getSources());
        for (int i = 0; i < this.mapTable.getColumnCount(); ++i) {
            if (this.isColumnVisible(i)) continue;
            this.setColumnWidth(i, 0);
        }
        String string2 = null;
        try {
            string2 = this.getUnmappableMessage();
            this.mapErrorMessage.setText(EMPTY_STRING);
            this.setMapVisible(string2 == null);
            if (string2 != null) {
                this.mapErrorMessage.setText(string2);
                return;
            }
        }
        catch (Exception exception) {
            string = exception.getStackTrace()[0].toString();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string, exception);
        }
        this.mapTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.mapTable.getColumnModel().getColumn(1).setPreferredWidth(175);
        this.mapTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.mapTableModel.setRowCount(0);
        this.setMapTableProperties(this.mapTable);
        DBObjectProvider dBObjectProvider = this.getProvider();
        string = null;
        if (Ide.getLastActiveNavigator() != null) {
            string = Ide.getLastActiveNavigator().getContext();
        }
        if (string != null) {
            String string3 = ContextUtil.getConnectionName((Context)string);
            if (string3 == null) {
                string3 = oracleDatabaseImpl.getConnectionName();
            }
            string.setProperty("Connections.db_name", (Object)string3);
            for (RaptorEditorPlugin raptorEditorPlugin : this.installedPlugins) {
                raptorEditorPlugin.setConnection(string3);
            }
            if (this.queryEditor.isEditable()) {
                this.invokeInsight(string3);
            }
            if (this.queryBuilderPanel != null && this.queryBuilderPanel.getConnection() == null) {
                this.queryBuilderPanel.loadMetadata(oracleDatabaseImpl.getConnection());
            }
        }
        try {
            this.loadAndDisplayMappings(true);
            this.queryEditor.setEditable(false);
            this.setColumnWidth(3, 0);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public void loadAndDisplayMappings(boolean bl) throws SQLException, DBException {
        this.mapDefn = this.loadMappings(bl);
        this.mapTableModel.setRowCount(0);
        int n = 0;
        int n2 = 0;
        if (this.mapDefn != null) {
            for (String string : this.mapDefn.getMapSource().keySet()) {
                MapElement mapElement = this.mapDefn.getMapSource().get(string);
                String string2 = mapElement.getMapDisplay();
                String string3 = EMPTY_STRING;
                if (mapElement.getMapAt() != null) {
                    string3 = mapElement.getMapAt();
                }
                String string4 = mapElement.getExpression();
                Object[] objectArray = new String[]{string4, string2, string3, string};
                this.mapTableModel.addRow(objectArray);
                if (!mapElement.isRequired()) continue;
                ++n;
                if (string4 == null || string4.isEmpty()) continue;
                ++n2;
            }
        }
        this.mapLabel.setText(OLAPArb.format("MAP_PANEL_MAP_OBJECTS", n2, n));
    }

    public abstract MapDefinition loadMappings(boolean var1) throws SQLException, DBException;

    private List<DatabaseObject> getColumns(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        Schema schema = ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema();
        List<DatabaseObject> list = null;
        try {
            ColumnListRunnable columnListRunnable = new ColumnListRunnable(oracleDatabaseImpl, schema, string);
            String string2 = String.format("Fetching list of columns for %s", string);
            string2 = MessageFormat.format(string2, EMPTY_STRING);
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)columnListRunnable, true);
            progressBar.setCancelable(false);
            columnListRunnable.setProgressBar(progressBar);
            progressBar.start("Column List", null);
            if (columnListRunnable.getException() != null) {
                throw columnListRunnable.getException();
            }
            list = columnListRunnable.getSources();
        }
        catch (Exception exception) {
            String string3 = null;
            String string4 = exception.getLocalizedMessage();
            if (string4 == null || string4.length() == 0) {
                string4 = exception.getClass().toString();
            }
            String string5 = OLAPArb.get("NEWCUBE_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string3);
        }
        return list;
    }

    void invokeInsight(String string) {
        boolean bl = Connections.getInstance().isOracle(string);
        bl = this.queryEditor.isEditable();
        if (bl) {
            if (this.insightPlugin != null) {
                this.queryEditor.deinstallPlugin((EditorPlugin)this.insightPlugin);
            }
            this.insightPlugin = new CompletionInsight(string, this.foldingPlugin.parser);
            this.queryEditor.installPlugin((EditorPlugin)this.insightPlugin);
        }
    }

    protected final void commitPanel() throws TraversalException {
        this.sourceTextField.hidePopup();
        this.commitMapTableEdits();
        if (this.mapTab.getSelectedIndex() == 0) {
            String string = this.queryEditor.getText();
            if (this.queryBuilderPanel != null) {
                this.queryBuilderPanel.setSQL(string);
            }
        }
        this.clearMap();
        try {
            this.commitMap();
            if (this.queryBuilderPanel != null) {
                this.queryBuilderPanel.clearMetadata();
            }
        }
        catch (Exception exception) {
            String string = exception.getStackTrace()[0].toString();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string, exception);
        }
    }

    protected void clearMapView() {
        this.commitMapTableEdits();
        this.clearMapTable();
        this.filterTextField.setText(EMPTY_STRING);
        this.sourceTextField.setText(EMPTY_STRING);
    }

    private void clearMapTable() {
        for (int i = 0; i < this.getMapTableModel().getRowCount(); ++i) {
            this.getMapTableModel().setValueAt(EMPTY_STRING, i, 0);
        }
        this.mapLabel.setText(OLAPArb.format("MAP_PANEL_MAP_OBJECTS", 0, this.mapTableModel.getRowCount()));
        if (this.sourceCompletionProvider != null) {
            this.sourceCompletionProvider.setStrings(new ArrayList<String>());
        }
    }

    protected abstract void clearMap();

    protected void autoMap() {
        this.updateMappings(this.sources);
    }

    protected abstract void commitMap() throws SQLException, DBException;

    /*
     * WARNING - void declaration
     */
    public List<String> getProjections() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getQuery();
        String string2 = ((AbstractMappableSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
        Database database = null;
        if (this.prov instanceof Database) {
            database = (Database)this.prov;
        }
        TableMetadata tableMetadata = new TableMetadata(database);
        ArrayList arrayList2 = new ArrayList();
        SQLExtractor sQLExtractor = new SQLExtractor(string);
        Collection<String> collection = sQLExtractor.getTableNames();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String object22 : collection) {
            object = tableMetadata.getColumns(string2, object22);
            hashMap.put(object22, (List<String>)object);
        }
        ArrayList<Projection> arrayList3 = sQLExtractor.getProjections(true);
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            void var16_17;
            object = (Projection)iterator.next();
            String string3 = sQLExtractor.getTokenForColumn((Projection)object);
            String string4 = EMPTY_STRING;
            for (String string5 : sQLExtractor.getColumns(((Projection)object).getColExpr())) {
                string4 = string4 + string5.toUpperCase() + ",";
            }
            if (string4.endsWith(",")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            Object object2 = null;
            for (String string6 : collection) {
                if (string3.toUpperCase().indexOf(string6) == -1) continue;
                object2 = string6;
                break;
            }
            if (object2 == null) {
                for (String string6 : hashMap.keySet()) {
                    List list = (List)hashMap.get(string6);
                    if (list.contains(string4.toUpperCase())) {
                        object2 = string6.toUpperCase();
                    }
                    if (!list.contains(string4)) continue;
                    object2 = string6.toUpperCase();
                }
            }
            if (object2 == null && collection.size() > 0) {
                object2 = (String)collection.toArray()[0];
            }
            String string7 = string4;
            if (string4.length() <= 0) continue;
            if (object2 != null && string4.indexOf((String)object2) == -1) {
                String string8 = String.format("%s.%s", object2, string4);
            }
            arrayList.add((String)var16_17);
        }
        return arrayList;
    }

    public List<String> getQueryBuilderProjections() {
        return this.queryBuilderPanel.getProjections();
    }

    public String getMapQueryExpression(String string) throws DBException, SQLException {
        this.extractedSource = EMPTY_STRING;
        if (!string.isEmpty()) {
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null, null);
            SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

                @Override
                public void visit(SyntaxObject syntaxObject) throws SQLException {
                    if (syntaxObject instanceof ColumnExpression) {
                        ColumnExpression columnExpression = (ColumnExpression)syntaxObject;
                        Query query = columnExpression.getQuery();
                        MapPanel.this.extractedSource = query.toSyntax();
                    }
                }
            });
        }
        return this.extractedSource;
    }

    public String getMapQueryExpression() {
        if (this.queryBuilderPanel != null) {
            return this.queryBuilderPanel.getMapQueryExpression();
        }
        return EMPTY_STRING;
    }

    protected String getExpression(String string, String string2) throws SQLException, DBException {
        if (!string2.isEmpty()) {
            List<Column> list = this.getSourceColumns(string);
            for (Column column : list) {
                if (!string2.equalsIgnoreCase(column.getName()) || string2.startsWith("'") || string2.startsWith(string)) continue;
                string2 = String.format("%s.%s", string, string2);
            }
        }
        return string2;
    }

    protected void validateObject() throws TraversalException {
        super.validateObject();
    }

    /*
     * Unable to fully structure code
     */
    private boolean testQuery(TraversableContext var1_1) throws TraversalException {
        block12: {
            var2_2 = false;
            var3_3 = this.getUpdatedObject();
            var4_4 = var3_3 instanceof SchemaObject != false ? (SchemaObject)var3_3 : null;
            var5_5 = var4_4 == null || var4_4.getSchema() == null ? this.defaultSchema : var4_4.getSchema();
            var6_6 = this.sqlQueryBuilderFactory.createSQLQueryBuilder(this.prov, var5_5);
            if (var1_1 != null) {
                var1_1.put(SQLQueryBuilder.class.getName(), (Object)var6_6);
            }
            var7_7 = var1_1 == null ? null : var1_1.get("NewObject");
            var8_8 = this.queryEditor.getText().trim();
            try {
                var6_6.buildQuery(var8_8, var4_4 instanceof SQLQueryOwner != false ? (SQLQueryOwner)var4_4 : null);
                var9_9 = var6_6.getSQLQuery();
                var10_14 = var9_9.getOrderByObjects();
                this.feedback.setText(UIBundle.get((String)"QUERY_SUCCESS"), true);
                var2_2 = true;
            }
            catch (SQLParseException var9_10) {
                this.invalidChangeCommitted = true;
                this.feedback.setText(var9_10.getMessage(), true);
                if (var1_1 != null) {
                    throw new TraversalException(var9_10.getMessage());
                }
            }
            catch (SQLQueryClauseException var9_11) {
                this.feedback.setText(var9_11.getMessage(), true);
            }
            catch (SQLQueryException var9_12) {
                var10_14 = new StringBuilder();
                var10_14.append(UIBundle.get((String)"QUERY_TOO_CLEVER"));
                var10_14.append("\n\n").append(var9_12.getMessage());
                this.feedback.setText(var10_14.toString(), true);
            }
            catch (Exception var9_13) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error parsing sql query", var9_13);
                if (var1_1 == null) break block12;
                this.invalidChangeCommitted = true;
                throw new TraversalException(null);
            }
        }
        var9_9 = var6_6.getSQLQuery();
        if (var7_7 instanceof SQLQueryOwner) {
            ((SQLQueryOwner)var7_7).setSQLQuery(var9_9);
            try {
                var6_6.syncViewColumns();
            }
            catch (AliasInUseException var10_15) {
                if (!var9_9.isDeclarative() && this.prov instanceof Database) ** GOTO lbl51
                throw new TraversalException(var10_15.getMessage());
            }
        } else if (var7_7 instanceof SQLQuery) {
            var1_1.put("NewObject", (Object)var9_9);
        }
lbl51:
        // 5 sources

        this.validate();
        return var2_2;
    }

    public String getSourceColumnID(String string, String string2) throws DBException {
        String string3 = this.getProvider().getDefaultSchema().getName();
        IdentifierElement identifierElement = new IdentifierElement(string);
        if (identifierElement.getCount() > 1 && identifierElement.getFirst().equals(string3)) {
            string = identifierElement.getSecond();
        }
        return new Identifier(string, string2).toString();
    }

    protected boolean isColumnEditable(int n) {
        return n == 0;
    }

    protected boolean isColumnVisible(int n) {
        return true;
    }

    public Component getJoinMapComponent() {
        return null;
    }

    public Component getFunctionComponent() {
        return null;
    }

    private void layoutComponents() {
        Object object;
        AbstractAction abstractAction;
        ActionMap actionMap2;
        JScrollPane jScrollPane;
        this.mapErrorMessage = new SuperLabel();
        this.mapToolbar = new Toolbar();
        this.mapToolbar.setName("mapToolbar");
        this.mapToolbar.setBorderPainted(true);
        JButton jButton = new JButton(OLAPImagesArb.getIcon("AUTO_MAP_ICON"));
        jButton.setToolTipText(OLAPArb.get("MAP_AUTO_TOOL_TIP"));
        jButton.setName("autoMapButton");
        JButton jButton2 = new JButton(OLAPImagesArb.getIcon("CLEAR_MAP_ICON"));
        jButton2.setToolTipText(OLAPArb.get("MAP_CLEAR_TOOL_TIP"));
        jButton2.setName("clearMapButton");
        JButton jButton3 = new JButton(OLAPImagesArb.getIcon("REFRESH_ICON"));
        jButton3.setToolTipText(OLAPArb.get("MAP_REFRESH_TOOL_TIP"));
        jButton3.setName("refreshMapButton");
        JLabel jLabel = new JLabel(OLAPArb.get("MAP_PANEL_SOURCES"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MapPanel.this.sourceChanged();
                }
                catch (Throwable throwable) {
                    String string = throwable.getStackTrace()[0].toString();
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string, throwable);
                }
            }
        };
        this.sourceTextField = new SourceTextField(this, abstractAction2);
        this.sourceTextField.setName("sourceTextField");
        JLabel jLabel2 = new JLabel(OLAPArb.get("MAP_PANEL_FILTER"));
        this.filterTextField = new JTextField();
        this.sourceTextField.setName("filterTextField");
        this.filterTextField.setPreferredSize(new Dimension(25, 15));
        this.feedbackLabel = new JLabel(OLAPArb.get("MAP_PANEL_PARSE_RESULTS"));
        this.feedback = new ReadOnlyScrollPane((Component)((Object)this));
        this.checkSyntaxButton = new JButton(OLAPArb.get("MAP_PANEL_CHECK_SYNTAX"));
        this.checkSyntaxButton.addActionListener(this);
        JButton jButton4 = new JButton(OLAPArb.get("MAP_PANEL_SELECT_SOURCES"));
        jButton4.setName("sourcesButton");
        this.mapLabel = new JLabel(OLAPArb.format("MAP_PANEL_MAP_OBJECTS", 0, 0));
        JLabel jLabel3 = new JLabel(OLAPArb.get("MAP_PANEL_QUERY"));
        KeyStrokeContext[] keyStrokeContextArray = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/worksheet/editor/accelerators.xml")};
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        EditorStatusBar editorStatusBar = new EditorStatusBar();
        boolean bl = true;
        JPanel jPanel = null;
        if (bl) {
            this.queryEditor = EditorFactory.createIdeEditorPane((KeyStrokeContext[])keyStrokeContextArray);
            this.queryEditor.setName("queryEditor");
            this.queryEditor.setEditable(bl);
            if (this.queryEditor.isEditable()) {
                jScrollPane = new BasicDocument("foo.plsql");
                this.queryEditor.setDocument((Document)((Object)jScrollPane));
            }
            this.queryEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this.queryEditor.installPlugin((EditorPlugin)lineGutterPlugin);
            if (this.queryEditor.isEditable()) {
                this.queryEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
                this.queryEditor.installPlugin((EditorPlugin)editorStatusBar);
            }
            jScrollPane = null;
            this.foldingPlugin = new WorksheetFoldingPlugin();
            if (this.queryEditor.isEditable()) {
                this.queryEditor.installPlugin((EditorPlugin)this.foldingPlugin);
                jScrollPane = this.foldingPlugin.getCodeFoldingMargin();
            }
            Context context = null;
            if (Ide.getLastActiveNavigator() != null) {
                context = Ide.getLastActiveNavigator().getContext();
            }
            if (this.queryEditor.isEditable() && context != null) {
                for (ActionMap actionMap2 : WorksheetEditorPluginRegistry.getPlugins((Context)context)) {
                    this.queryEditor.installPlugin((EditorPlugin)actionMap2);
                    if (!(actionMap2 instanceof RaptorEditorPlugin)) continue;
                    abstractAction = (RaptorEditorPlugin)actionMap2;
                    abstractAction.setLineGutter(lineGutterPlugin);
                    this.installedPlugins.add((RaptorEditorPlugin)abstractAction);
                }
                object = new DragDropPlugin(){

                    protected void removeSelectedText() {
                    }
                };
                this.queryEditor.installPlugin((EditorPlugin)object);
            }
            if (this.queryEditor.isEditable()) {
                jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jScrollPane, "East");
                jPanel.add((Component)lineGutterPlugin, "Center");
            }
        } else {
            this.queryEditor = new BasicEditorPane();
            this.queryEditor.setEditable(false);
        }
        jScrollPane = new JScrollPane((Component)this.queryEditor);
        if (jPanel != null) {
            jScrollPane.setRowHeaderView(jPanel);
        }
        this.mapTable = new JTable(this.mapTableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return MapPanel.this.isColumnEditable(n2);
            }

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                MapPanel.this.mapTable.editCellAt(n, n2);
                MapPanel.this.mapTable.transferFocus();
            }
        };
        this.mapTable.setName("mapTable");
        this.mapTable.setCellSelectionEnabled(true);
        this.mapTable.setAutoResizeMode(0);
        int n = 2;
        object = this.mapTable.getInputMap(n);
        actionMap2 = this.mapTable.getActionMap();
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int n : MapPanel.this.mapTable.getSelectedRows()) {
                    MapPanel.this.commitMapTableEdits();
                    MapPanel.this.mapTableModel.setValueAt(MapPanel.EMPTY_STRING, n, 0);
                }
            }
        };
        ((InputMap)object).put(KeyStroke.getKeyStroke(127, 0), CLEAR_ACTION);
        actionMap2.put(CLEAR_ACTION, abstractAction);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("queryPanel");
        jPanel2.setLayout(new GridBagLayout());
        int n2 = 0;
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, ++n2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 15), 0, 0));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.mapTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("mapPanel");
        if (this.showQueryBuilder) {
            this.queryBuilderPanel = new QueryPanel();
            this.queryBuilderPanel.init();
        }
        this.mapTab = new JTabbedPane();
        this.mapTab.setName("mapTab");
        this.mapTab.add(OLAPArb.get("MAP_PANEL_MAP_TAB"), jPanel3);
        this.mapTab.add(OLAPArb.get("MAP_PANEL_QUERY_TAB"), jPanel2);
        if (this.showQueryBuilder) {
            this.mapTab.add(OLAPArb.get("MAP_PANEL_ACTIVE_QUERY_BUILDER_TAB"), this.queryBuilderPanel);
        }
        jPanel3.setLayout(new GridBagLayout());
        this.mapToolbar.add((Component)jButton2);
        this.mapToolbar.add((Component)jButton3);
        this.mapToolbar.add((Component)jButton);
        this.mapToolbar.addFiller();
        this.addToolbar(this.mapToolbar);
        Border border = BorderFactory.createRaisedBevelBorder();
        this.mapToolbar.setBorder(border);
        n2 = 0;
        jPanel3.add((Component)this.mapToolbar, new GridBagConstraints(0, n2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 15), 0, 0));
        jPanel3.add((Component)this.sourceTextField, new GridBagConstraints(1, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 15), 0, 0));
        jPanel3.add((Component)jButton4, new GridBagConstraints(2, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        jPanel3.add((Component)this.mapLabel, new GridBagConstraints(0, ++n2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 15), 0, 0));
        Component component = this.getFunctionComponent();
        if (component != null) {
            jPanel3.add(component, new GridBagConstraints(1, n2, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
        jPanel3.add((Component)jScrollPane2, new GridBagConstraints(0, ++n2, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        Component component2 = this.getJoinMapComponent();
        if (component2 != null) {
            jPanel3.add(component2, new GridBagConstraints(0, ++n2, 3, 1, 1.0, 0.8, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        }
        jPanel3.add((Component)jLabel2, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 15), 0, 0));
        jPanel3.add((Component)this.filterTextField, new GridBagConstraints(1, n2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        n2 = 0;
        this.add(this.mapTab, new GridBagConstraints(0, n2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 15), 0, 0));
        this.add((Component)this.mapErrorMessage, new GridBagConstraints(0, ++n2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 15), 0, 0));
        this.mapTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MapPanel.this.commitMapTableEdits();
                switch (MapPanel.this.mapTab.getSelectedIndex()) {
                    case 0: {
                        if (!MapPanel.this.showQueryBuilder) break;
                        String string = MapPanel.this.queryBuilderPanel.getSQL();
                        MapPanel.this.queryEditor.setText(string);
                        break;
                    }
                    case 1: {
                        String string = MapPanel.this.getPseudoBuildQuery();
                        MapPanel.this.setQuery(string);
                        break;
                    }
                    case 2: {
                        String string = MapPanel.this.queryEditor.getText();
                        MapPanel.this.queryBuilderPanel.setSQL(string);
                        break;
                    }
                }
            }
        });
        this.filterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    keyEvent.consume();
                }
                MapPanel.this.filterChanged();
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void common() {
                MapPanel.this.filterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.common();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapPanel.this.clearMapView();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapPanel.this.autoMap();
            }
        });
        this.mapTableModel.addTableModelListener(this);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.windowForComponent((Component)((Object)MapPanel.this));
                MapPanel.this.columnSelectiondialog.init(MapPanel.this.getSources());
                MapPanel.this.columnSelectiondialog.setLocationRelativeTo(window);
                MapPanel.this.columnSelectiondialog.setVisible(true);
                Object object = MapPanel.this.columnSelectiondialog.getValue();
                if (object instanceof List) {
                    try {
                        MapPanel.this.sourceSelected((List)object);
                    }
                    catch (Exception exception) {
                        String string = exception.getStackTrace()[0].toString();
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string, exception);
                    }
                }
            }
        });
    }

    public void setMapVisible(boolean bl) {
        this.mapTab.setVisible(bl);
        this.mapTable.setVisible(bl);
        this.mapErrorMessage.setVisible(!bl);
    }

    public void addToolbar(Toolbar toolbar) {
    }

    private void updateRequiredMapCount() {
        int n = 0;
        int n2 = 0;
        for (String string : this.mapDefn.getMapSource().keySet()) {
            MapElement mapElement = this.mapDefn.getMapSource().get(string);
            String string2 = mapElement.getExpression();
            if (!mapElement.isRequired()) continue;
            ++n;
            if (string2 == null || string2.isEmpty()) continue;
            ++n2;
        }
        this.mapLabel.setText(OLAPArb.format("MAP_PANEL_MAP_OBJECTS", n2, n));
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        String string;
        if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0) {
            string = (String)this.mapTableModel.getValueAt(tableModelEvent.getFirstRow(), 0);
            String string2 = (String)this.mapTableModel.getValueAt(tableModelEvent.getFirstRow(), 1);
            String string3 = (String)this.mapTableModel.getValueAt(tableModelEvent.getFirstRow(), 3);
            MapElement mapElement = this.mapDefn.getMapSource().get(string3);
            mapElement.setExpression(string);
            this.updateRequiredMapCount();
            try {
                this.sourceExpressionChange(string2, string);
            }
            catch (SQLException sQLException) {
                String string4 = sQLException.getStackTrace()[0].toString();
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string4, sQLException);
            }
            catch (DBException dBException) {
                String string5 = dBException.getStackTrace()[0].toString();
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string5, dBException);
            }
        }
        string = this.getPseudoBuildQuery();
        this.setQuery(string);
    }

    protected void printDiff() {
        Object object;
        Difference difference;
        DBObjectProvider dBObjectProvider = this.getProvider();
        DDLDatabase dDLDatabase = null;
        if (dBObjectProvider instanceof DDLDatabase) {
            dDLDatabase = (DDLDatabase)dBObjectProvider;
        }
        SystemObject systemObject = (SystemObject)this.getUpdatedObject();
        SystemObject systemObject2 = (SystemObject)this.getOriginalObject();
        DDLOptions dDLOptions = new DDLOptions(false, false);
        SystemObject systemObject3 = this.getOriginalObjectForDDL();
        Difference difference2 = null;
        DBObjectTransaction dBObjectTransaction = new DBObjectTransaction(dBObjectProvider);
        dBObjectTransaction.includeUpdate(systemObject3, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject));
        if (systemObject instanceof SideEffects) {
            difference = ((SideEffects)systemObject).getAffectedObjectNew().iterator();
            object = ((SideEffects)systemObject).getAffectedObjectOld().iterator();
            while (difference.hasNext() && object.hasNext()) {
                SystemObject systemObject4 = (SystemObject)object.next();
                SystemObject systemObject5 = (SystemObject)difference.next();
                dBObjectTransaction.includeUpdate(systemObject4, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject5));
            }
        }
        dBObjectTransaction.setReplace(true);
        dBObjectTransaction.setCascade(true);
        try {
            difference = dBObjectTransaction.getTransactionDifference();
            difference2 = difference.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
            this.print(difference2);
        }
        catch (DBException dBException) {
            object = dBException.getStackTrace()[0].toString();
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, (String)object, dBException);
        }
    }

    protected SystemObject getOriginalObjectForDDL() {
        SystemObject systemObject = this.getEditorConfig().getOriginalObject();
        if (systemObject != null && systemObject.getID() == null) {
            systemObject = null;
        }
        return systemObject;
    }

    public static final String stripQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length());
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void print(Difference difference) {
        StringBuilder stringBuilder = new StringBuilder("\n");
        this.toString(difference, stringBuilder, EMPTY_STRING);
        System.out.println(stringBuilder.toString());
    }

    private void toString(Difference difference, StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(this.toString(difference)).append("\n");
        string = string + "  ";
        for (Difference difference2 : difference.getChildren()) {
            this.toString(difference2, stringBuilder, string);
        }
    }

    public String toString(Difference difference) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(difference.isSame() ? "SAME " : "XXXX ").append("  ");
        String string = difference.getPropertyName();
        if (string != null && string.equals("levels")) {
            System.out.println("################ levels##############");
        }
        if (string != null && string.equals("attributes")) {
            System.out.println("################ attributes##############");
        }
        stringBuilder.append(string);
        if (difference.isLeaf()) {
            stringBuilder.append("  ").append("(").append(String.valueOf(difference.getOriginalObject())).append(" : ").append(String.valueOf(difference.getUpdatedObject())).append(")");
        }
        int n = difference.getIndexOfOriginalObject();
        int n2 = difference.getIndexOfUpdatedObject();
        if (n >= 0 || n2 >= 0) {
            stringBuilder.append("  ").append(n + " " + n2);
        }
        return stringBuilder.toString();
    }

    class MapSourceRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            if (object == null || object.toString().length() == 0) {
                object = MAP_PANEL_SELECT_MAPPING;
            }
            if ((component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                Font font = component.getFont();
                if (object.equals(MAP_PANEL_SELECT_MAPPING)) {
                    jLabel.setEnabled(false);
                } else {
                    jLabel.setEnabled(true);
                }
            }
            return component;
        }
    }
}

