/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measurefolder.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.table.TableCheckBoxCellEditor;
import oracle.olap.app.table.TableCheckBoxCellRenderer;
import oracle.olap.measurefolder.MeasureListRunnable;
import oracle.olap.measurefolder.model.MeasureFolder;
import oracle.olap.measurefolder.model.MeasureID;

public class MeasureFolderDetailsPanel
extends JPanel
implements TableModelListener {
    private DefaultTableModel measureTableModel;
    private GenericTable measureTable;
    private JTextField measureFilterFld;
    private List<MeasureID> measureIDs;
    private List<Measure> measures;
    private Map<MeasureID, Boolean> measureSelectedMap = new HashMap<MeasureID, Boolean>();
    private String analyticWorkspace = null;
    private static final int COL_INCLUDE = 0;
    private static final int COL_CUBE_OWNER = 1;
    private static final int COL_CUBE_NAME = 2;
    private static final int COL_MEASURE_NAME = 3;
    private static final int COL_DESC = 4;
    private static final int COL_EXPRESSION = 5;
    private static final int COL_COUNT = 5;
    private Database db;
    private MeasureFolder updatedObject;

    public MeasureFolderDetailsPanel() {
        this.measureTableModel = new DefaultTableModel();
        this.measureTableModel.addTableModelListener(this);
        this.measureIDs = new ArrayList<MeasureID>();
        this.layoutComponents();
        this.initTable();
    }

    private void initTable() {
        this.measureTableModel.setRowCount(0);
        this.measureTableModel.setColumnCount(0);
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_SELECT_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_CUBE_OWNER_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_CUBE_NAME_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_MEASURE_NAME_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_DESCRIPTION_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_EXPRESSION_COLUMN"));
        TableColumn tableColumn = this.measureTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new TableCheckBoxCellEditor());
        tableColumn.setCellRenderer(new TableCheckBoxCellRenderer());
        tableColumn.setPreferredWidth(70);
        tableColumn = this.measureTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(200);
    }

    private void layoutComponents() {
        this.measureTable = new GenericTable(this.measureTableModel){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 == 5 && component instanceof JComponent) {
                    Object object = MeasureFolderDetailsPanel.this.measureTableModel.getValueAt(n, n2);
                    JComponent jComponent = (JComponent)component;
                    if (object != null) {
                        jComponent.setToolTipText(object.toString());
                    }
                }
                return component;
            }
        };
        this.measureTable.setName("measureTable");
        this.measureTable.setAutoResizeMode(0);
        this.measureTable.setRowSelectionAllowed(false);
        this.measureTable.setColumnSelectorAvailable(false);
        JLabel jLabel = new JLabel(OLAPArb.get("MEASURE_FILTER"));
        this.measureFilterFld = new JTextField();
        this.measureFilterFld.setName("measureFilterFld");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("scrollPane");
        jScrollPane.getViewport().add((Component)this.measureTable);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.measureFilterFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.measureFilterFld.getDocument().addDocumentListener(new DocumentListener(){

            private void changed() {
                MeasureFolderDetailsPanel.this.loadMeasureTable();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }
        });
    }

    public void setUpdatedObject(MeasureFolder measureFolder) {
        this.updatedObject = measureFolder;
    }

    public void setProvider(Database database) {
        this.db = database;
    }

    public JTable getMeasuresTable() {
        return this.measureTable;
    }

    public void initialisePanel() {
        if (this.measures == null) {
            this.reloadMeasures();
            this.getUpdatedObject().addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        if (!string.equals("analyticWorkspace")) continue;
                        MeasureFolderDetailsPanel.this.reloadMeasures();
                    }
                }
            });
        }
        for (MeasureID measureID : this.getUpdatedObject().getMeasures()) {
            for (int i = 0; i < this.measureTableModel.getRowCount(); ++i) {
                String string = (String)this.measureTableModel.getValueAt(i, 1);
                String string2 = (String)this.measureTableModel.getValueAt(i, 2);
                String string3 = (String)this.measureTableModel.getValueAt(i, 3);
                String string4 = String.format("%s.%s", string2, string3);
                if (!measureID.getName().equals(string4)) continue;
                this.measureTableModel.setValueAt(true, i, 0);
            }
        }
    }

    private void reloadMeasures() {
        String string = this.getUpdatedObject().getAnalyticWorkspace();
        if (string == null || this.analyticWorkspace != null && this.analyticWorkspace.equalsIgnoreCase(string)) {
            return;
        }
        this.analyticWorkspace = string;
        String string2 = null;
        try {
            string2 = this.db.getUserName();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.measureSelectedMap.clear();
        this.measures = this.getMeasures(this.db.getConnection(), string2, this.analyticWorkspace);
        this.measureIDs.clear();
        for (Measure measure : this.measures) {
            String string3 = String.format("%s.%s", measure.getCube().getName(), measure.getName());
            this.measureIDs.add(new MeasureID(string3));
        }
        this.loadMeasureTable();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n == -1) {
            return;
        }
        if (tableModelEvent.getSource() == this.measureTableModel && tableModelEvent.getType() == 0) {
            this.updateMeasureTableModelFromCell(n, n2);
        }
    }

    private void updateMeasureTableModelFromCell(int n, int n2) {
        String string = (String)this.measureTable.getValueAt(n, 1);
        String string2 = (String)this.measureTable.getValueAt(n, 2);
        String string3 = (String)this.measureTable.getValueAt(n, 3);
        String string4 = String.format("%s.%s", string2, string3);
        MeasureID measureID = null;
        for (Object object2 : this.measureIDs) {
            if (!object2.getName().equals(string4)) continue;
            measureID = object2;
            break;
        }
        Object object = this.measureTable.getValueAt(n, n2);
        if (n > this.measureIDs.size() - 1) {
            return;
        }
        if (n2 == 0) {
            Object object2;
            object2 = (Boolean)object;
            if (((Boolean)object2).booleanValue()) {
                this.measureSelectedMap.put(measureID, (Boolean)object2);
            } else {
                this.measureSelectedMap.remove((Object)measureID);
            }
        }
    }

    private void loadMeasureTable() {
        String string = "";
        if (this.measureFilterFld.getText() != null) {
            string = this.measureFilterFld.getText();
        }
        this.measureTableModel.setRowCount(0);
        for (Measure measure : this.measures) {
            boolean bl;
            String string2 = measure.getName();
            if (string.length() > 0 && !(bl = string2.contains(string.toUpperCase()))) continue;
            Boolean bl2 = this.measureSelectedMap.get(measure.getID());
            if (bl2 == null) {
                bl2 = false;
            }
            this.measureTableModel.addRow(new Object[]{bl2, measure.getCube().getSchema().getName(), measure.getCube().getName(), measure.getName(), measure.getDescription(), measure.getExpression()});
        }
    }

    private List<Measure> getMeasures(Connection connection, String string, String string2) {
        List<Measure> list = null;
        try {
            MeasureListRunnable measureListRunnable = new MeasureListRunnable(connection, string, string2);
            String string3 = OLAPArb.get("MEASUREFOLDER.FETCH.MEASURELIST.TITLE");
            string3 = MessageFormat.format(string3, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string3, (Runnable)measureListRunnable, true);
            progressBar.setCancelable(false);
            measureListRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("MEASUREFOLDER.FETCH.MEASURELIST"), null);
            if (measureListRunnable.getException() != null) {
                throw measureListRunnable.getException();
            }
            list = measureListRunnable.getMeasures();
        }
        catch (Exception exception) {
            String string4 = null;
            String string5 = exception.getLocalizedMessage();
            if (string5 == null || string5.length() == 0) {
                string5 = exception.getClass().toString();
            }
            String string6 = OLAPArb.get("NEWAW_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)string6, string4);
        }
        return list;
    }

    public void commitPanel() throws TraversalException {
        ArrayList<MeasureID> arrayList = new ArrayList<MeasureID>();
        arrayList.addAll(this.measureSelectedMap.keySet());
        this.getUpdatedObject().clearMeasures();
        for (MeasureID measureID : arrayList) {
            this.getUpdatedObject().addMeasure(measureID);
        }
    }

    private MeasureFolder getUpdatedObject() {
        return this.updatedObject;
    }
}

