/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.navigator.calculatedmeasure;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.OLAPResources;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.navigator.calculatedmeasure.DockableSpecTreeFactory;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.olapihelpers.NonLazyFetchIcon;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPSpec;
import oracle.olap.syntaxbuilder.shuttle.DragHandler;
import oracle.olap.syntaxbuilder.shuttle.GuiNodeSelector;
import oracle.olap.syntaxbuilder.shuttle.InputHandler;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;
import oracle.olap.syntaxbuilder.spectree.SpecJTree;
import oracle.olap.util.OLAPErrorDisplay;

public class DockableSpecTree
extends DockableWindow
implements Observer,
EditorListener,
DockableDragSource {
    static final String VIEW_ID = "SPEC_TREE_VIEW_ID";
    private static final String viewId = String.format("%s.%s", "CALC_MEASURE_VIEW_TYPE", "SPEC_TREE_VIEW_ID");
    private static final int ANALYTIC_FUNCTIONS_ROW = 0;
    private static final Logger LOG = Logger.getLogger(DockableSpecTree.class.getName());
    private final GuiNodeSelector selector = new GuiNodeSelector(){

        @Override
        public SpecTreeNode selectClickedNode(MouseEvent mouseEvent) {
            TreePath treePath = DockableSpecTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                DockableSpecTree.this.tree.setSelectionPath(treePath);
                return (SpecTreeNode)treePath.getLastPathComponent();
            }
            return null;
        }

        @Override
        public SpecTreeNode getSelectedNode() {
            TreePath treePath = DockableSpecTree.this.tree.getLeadSelectionPath();
            if (treePath != null) {
                SpecTreeNode specTreeNode = (SpecTreeNode)treePath.getLastPathComponent();
                return specTreeNode;
            }
            return null;
        }

        @Override
        public TemplateHandler getTemplateHandler() {
            return DockableSpecTree.this.templateHandler;
        }
    };
    private final HashMap<String, SpecJTree> specs = new HashMap();
    private static DockableSpecTree INSTANCE;
    private JScrollPane ui;
    private String currentURL;
    private TemplateHandler templateHandler;
    private SpecJTree tree;

    public static synchronized DockableSpecTree getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DockableSpecTree();
            INSTANCE.getGUI();
        }
        return INSTANCE;
    }

    private DockableSpecTree() {
        super(DockableSpecTree.getViewId());
    }

    private String buildKey(String string, String string2, String string3) {
        return String.format("%s/%s/%s", string, string2, string3);
    }

    public static String getViewId() {
        return viewId;
    }

    public String getTabName() {
        return OLAPArb.getString("EXPRESSION_EDITOR_SPEC_TREE");
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Icon getTabIcon() {
        return OLAPImagesArb.getIcon("SHOW_SPEC_TREE");
    }

    public Component getGUI() {
        if (this.ui == null) {
            OLAPResources oLAPResources = new OLAPResources("/oracle/olap/app/calcfactory/ui/calcs.xml");
            Properties properties = new Properties();
            properties.setProperty("CONTEXT", "MEASURE_EXPRESSION");
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(SyntaxBuilderPanel.class.getResourceAsStream("/oracle/olap/measureexpression/OLAPExpressionSpec.xml"), "UTF-8");
                OLAPSpec oLAPSpec = new OLAPSpec(properties, inputStreamReader, null, null, new OLAPErrorDisplay(), oLAPResources, new NonLazyFetchIcon(), null);
                oLAPSpec.initialize();
                boolean bl = true;
                boolean bl2 = false;
                OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
                SpecJTree specJTree = new SpecJTree(oLAPSpec, oLAPErrorDisplay, bl2, bl);
                this.ui = new JScrollPane(specJTree);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.log(Level.WARNING, "Error loading placeholder tree", unsupportedEncodingException);
                this.ui = new JScrollPane(new JTree(new DefaultMutableTreeNode(OLAPArb.getString("EXPRESSION_EDITOR_SPEC_TREE_LOADING"))));
            }
        }
        return this.ui;
    }

    public void setSpecParser(Spec spec, String string, String string2, String string3) {
        String string4 = this.buildKey(string, string2, string3);
        if (!string4.equals(this.currentURL)) {
            this.currentURL = string4;
            boolean bl = true;
            boolean bl2 = false;
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            this.tree = new SpecJTree(spec, oLAPErrorDisplay, bl2, bl);
            this.tree.addMouseListener(new InputHandler(this.selector, this.tree.getActionMap(), this.tree.getInputMap()));
            this.tree.setTransferHandler(new DragHandler(this.selector));
            this.tree.setDragEnabled(true);
            this.ui.setViewportView(this.tree);
            this.tree.expandRow(0);
            this.specs.put(string4, this.tree);
        }
    }

    private void dockTree() {
        if (!this.isVisible()) {
            LOG.finest(String.format("dockable status %s", DockStation.getDockStation().getDockableStatus((Dockable)DockableSpecTree.getInstance())));
            DockableSpecTreeFactory dockableSpecTreeFactory = new DockableSpecTreeFactory();
            DockStation.getDockStation().dock((Dockable)DockableSpecTree.getInstance(), dockableSpecTreeFactory.createDockingParam());
            DockUtil.showDockableWindow((DockableView)DockableSpecTree.getInstance());
        }
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("olap_templates_and_snippets");
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void editorOpened(Editor editor) {
        if (editor.getContext().getNode() instanceof CalculatedMeasureNode) {
            this.dockTree();
        }
    }

    public void editorActivated(Editor editor) {
        if (editor == null) {
            return;
        }
        if (editor.getContext().getNode() instanceof CalculatedMeasureNode) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)editor.getContext().getNode();
            this.setTemplateHandler(calculatedMeasureNode.getTemplateHandler());
            this.setURL(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName());
            this.dockTree();
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (this.openEditors(editor) == 0) {
            DockableSpecTree dockableSpecTree = DockableSpecTree.getInstance();
            DockUtil.hideDockableWindow((DockableView)dockableSpecTree);
        }
    }

    private int openEditors(Editor editor) {
        int n = 0;
        EditorManager editorManager = EditorManager.getEditorManager();
        Node node = editor.getContext().getNode();
        for (Editor editor2 : editorManager.getAllEditors()) {
            Context context = editor2.getContext();
            Node node2 = context.getNode();
            if (!(node2 instanceof CalculatedMeasureNode) || node2 == node) continue;
            ++n;
        }
        return n;
    }

    public boolean hasTreeForURL(String string, String string2, String string3) {
        return this.specs.containsKey(this.buildKey(string, string2, string3));
    }

    public Spec getSpec() {
        SpecJTree specJTree = this.specs.get(this.currentURL);
        return specJTree == null ? null : specJTree.getSpec();
    }

    public Spec getSpec(String string, String string2, String string3) {
        SpecJTree specJTree = this.specs.get(this.buildKey(string, string2, string3));
        return specJTree == null ? null : specJTree.getSpec();
    }

    public void setURL(String string, String string2, String string3) {
        String string4 = this.buildKey(string, string2, string3);
        if (string4 != null && string4.equals(this.currentURL)) {
            return;
        }
        SpecJTree specJTree = this.specs.get(string4);
        if (specJTree != null) {
            this.currentURL = string4;
            this.ui.setViewportView(specJTree);
            this.tree = specJTree;
        } else {
            LOG.severe(String.format("Spec for %s was NOT found!", string4));
        }
    }

    public void setTemplateHandler(TemplateHandler templateHandler) {
        this.templateHandler = templateHandler;
    }

    public void canceled() {
    }
}

