/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.olap.OLAPArb;
import oracle.olap.preferences.OLAPPreferenceSettings;

public class OLAPPreferencesPanel
extends DefaultTraversablePanel {
    private JLabel descriptionLabel;
    private JLabel templateDirLabel;
    private JFileChooser templateDirChooser;
    private JTextField templateDirField;
    private JButton templateDirButton;
    private JFileChooser templateFileChooser;
    private JLabel templateFileLabel;
    private JTextField templateFileField;
    private JButton templateFileButton;
    private JLabel templateNameFileLabel;
    private JTextField templateNameFileField;
    private JButton templateNameFileButton;
    private JLabel dataViewerRowsLabel;
    private JTextField dataViewerField;

    public OLAPPreferencesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.templateDirChooser = new JFileChooser();
        this.templateDirChooser.setFileSelectionMode(1);
        this.templateFileChooser = new JFileChooser();
        this.templateFileChooser.setFileFilter(new FileNameExtensionFilter("Xml", "xml"));
        this.templateDirChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && file.isDirectory();
            }

            @Override
            public String getDescription() {
                return OLAPArb.get("OLAP_PREFERENCES_TEMPLATE_DIR_FILTER_DESCRIPTION");
            }
        });
        this.descriptionLabel = new JLabel(OLAPArb.get("OLAP_PREFERENCES"));
        this.templateDirLabel = new JLabel(OLAPArb.get("OLAP_PREFERENCES_TEMPLATE_DIR"));
        this.templateDirField = new JTextField();
        this.templateDirButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(OLAPPreferencesPanel.this.templateDirField.getText());
                if (file.exists()) {
                    OLAPPreferencesPanel.this.templateDirChooser.setCurrentDirectory(file);
                }
                if ((n = OLAPPreferencesPanel.this.templateDirChooser.showOpenDialog((Component)((Object)OLAPPreferencesPanel.this))) == 0) {
                    OLAPPreferencesPanel.this.templateDirField.setText(OLAPPreferencesPanel.this.templateDirChooser.getSelectedFile().toString());
                }
            }
        });
        this.templateFileLabel = new JLabel(OLAPArb.getString("OLAP_PREFERENCES_TEMPLATE_FILE"));
        this.templateFileField = new JTextField();
        this.templateFileButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(OLAPPreferencesPanel.this.templateFileField.getText());
                if (file.exists()) {
                    OLAPPreferencesPanel.this.templateFileChooser.setSelectedFile(file);
                }
                if ((n = OLAPPreferencesPanel.this.templateFileChooser.showOpenDialog((Component)((Object)OLAPPreferencesPanel.this))) == 0) {
                    OLAPPreferencesPanel.this.templateFileField.setText(OLAPPreferencesPanel.this.templateFileChooser.getSelectedFile().toString());
                }
            }
        });
        this.templateNameFileLabel = new JLabel(OLAPArb.get("OLAP_PREFERENCES_TEMPLATE_NAME_FILE"));
        this.templateNameFileField = new JTextField();
        this.templateNameFileButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(OLAPPreferencesPanel.this.templateNameFileField.getText());
                if (file.exists()) {
                    OLAPPreferencesPanel.this.templateFileChooser.setSelectedFile(file);
                }
                if ((n = OLAPPreferencesPanel.this.templateFileChooser.showOpenDialog((Component)((Object)OLAPPreferencesPanel.this))) == 0) {
                    OLAPPreferencesPanel.this.templateNameFileField.setText(OLAPPreferencesPanel.this.templateFileChooser.getSelectedFile().toString());
                }
            }
        });
        this.dataViewerRowsLabel = new JLabel(OLAPArb.getString("OLAP_PREFERENCES_MAX_ROWS_CUBE_DATA_VIEWER"));
        this.dataViewerField = new JTextField();
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        this.setLayout(groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup();
        GroupLayout.ParallelGroup parallelGroup3 = groupLayout.createParallelGroup();
        parallelGroup.addComponent(this.descriptionLabel);
        parallelGroup.addComponent(this.templateDirLabel);
        parallelGroup.addComponent(this.templateFileLabel);
        parallelGroup.addComponent(this.templateNameFileLabel);
        parallelGroup.addComponent(this.dataViewerRowsLabel);
        parallelGroup2.addComponent(this.templateDirField);
        parallelGroup2.addComponent(this.templateFileField);
        parallelGroup2.addComponent(this.templateNameFileField);
        parallelGroup2.addComponent(this.dataViewerField);
        parallelGroup3.addComponent(this.templateDirButton);
        parallelGroup3.addComponent(this.templateFileButton);
        parallelGroup3.addComponent(this.templateNameFileButton);
        sequentialGroup.addGroup(parallelGroup);
        sequentialGroup.addGroup(parallelGroup2);
        sequentialGroup.addGroup(parallelGroup3);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup4 = groupLayout.createParallelGroup();
        GroupLayout.ParallelGroup parallelGroup5 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        GroupLayout.ParallelGroup parallelGroup6 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        GroupLayout.ParallelGroup parallelGroup7 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        GroupLayout.ParallelGroup parallelGroup8 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup4.addComponent(this.descriptionLabel);
        parallelGroup5.addComponent(this.templateDirLabel);
        parallelGroup5.addComponent(this.templateDirField, -2, -2, -2);
        parallelGroup5.addComponent(this.templateDirButton);
        parallelGroup6.addComponent(this.templateFileLabel);
        parallelGroup6.addComponent(this.templateFileField, -2, -2, -2);
        parallelGroup6.addComponent(this.templateFileButton);
        parallelGroup7.addComponent(this.templateNameFileLabel);
        parallelGroup7.addComponent(this.templateNameFileField, -2, -2, -2);
        parallelGroup7.addComponent(this.templateNameFileButton);
        parallelGroup8.addComponent(this.dataViewerRowsLabel);
        parallelGroup8.addComponent(this.dataViewerField, -2, -2, -2);
        sequentialGroup2.addGroup(parallelGroup4);
        sequentialGroup2.addGroup(parallelGroup5);
        sequentialGroup2.addGroup(parallelGroup6);
        sequentialGroup2.addGroup(parallelGroup7);
        sequentialGroup2.addGroup(parallelGroup8);
        groupLayout.setHorizontalGroup(sequentialGroup);
        groupLayout.setVerticalGroup(sequentialGroup2);
    }

    public void onEntry(TraversableContext traversableContext) {
        OLAPPreferenceSettings oLAPPreferenceSettings = OLAPPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
        String string = oLAPPreferenceSettings.getTemplateDirectory();
        this.templateDirField.setText(string);
        string = oLAPPreferenceSettings.getTemplateFile();
        this.templateFileField.setText(string);
        string = oLAPPreferenceSettings.getTemplateNameFile();
        this.templateNameFileField.setText(string);
        this.dataViewerField.setText(String.valueOf(oLAPPreferenceSettings.getCubeDataViewerMaxRows()));
    }

    public void onExit(TraversableContext traversableContext) {
        OLAPPreferenceSettings oLAPPreferenceSettings = OLAPPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
        String string = this.templateDirField.getText();
        oLAPPreferenceSettings.setTemplateDirectory(string);
        string = this.templateFileField.getText();
        oLAPPreferenceSettings.setTemplateFile(string);
        string = this.templateNameFileField.getText();
        oLAPPreferenceSettings.setTemplateNameFile(string);
        oLAPPreferenceSettings.setCubeDataViewerMaxRows(Integer.valueOf(this.dataViewerField.getText()));
    }
}

