/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.sql;

import com.adbs.querybuilder.PlainTextSQLBuilder;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.sql.QueryPanel;

public class QueryTestFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private PlainTextSQLBuilder plainTextSQLBuilder1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemClearMetadata;
    private JMenuItem jMenuItemEditMetadata;
    private JMenuItem jMenuItemQueryStatistics;
    private JMenuItem jMenuItemRefreshMetadata;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTable jTable1;
    private JTextPane jTextPane1;
    private JMenuItem menuItemProperties;
    private JMenu menuProperties;
    private QueryPanel queryPanel;

    public QueryTestFrame() {
        this.initComponents();
        try {
            this.queryPanel.init();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, exception);
            JOptionPane.showMessageDialog(this, exception.getMessage());
        }
        Preferences preferences = Preferences.userNodeForPackage(QueryTestFrame.class);
        int n = preferences.getInt("x", 0);
        int n2 = preferences.getInt("y", 0);
        int n3 = preferences.getInt("width", 0);
        int n4 = preferences.getInt("height", 0);
        if (n3 != 0 && n4 != 0) {
            this.setBounds(n, n2, n3, n4);
        } else {
            this.setLocationRelativeTo(null);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(keyStroke);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 64);
        hashSet = new HashSet();
        hashSet.add(keyStroke2);
        String string = preferences.get("Language", "Auto");
        try {
            this.setQueryBuilderConnection();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private static Connection connect() throws SQLException {
        String string;
        Connection connection = null;
        String string2 = "adc6141176:1521:omain3";
        String string3 = string = "global";
        connection = DatabaseUtils.GetConnection(string2, string, string3);
        return connection;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.queryPanel = new QueryPanel();
        this.jTable1 = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu3 = new JMenu();
        this.jMenuItemRefreshMetadata = new JMenuItem();
        this.jMenuItemEditMetadata = new JMenuItem();
        this.jMenuItemClearMetadata = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenu4 = new JMenu();
        this.jMenuItemQueryStatistics = new JMenuItem();
        this.menuProperties = new JMenu();
        this.menuItemProperties = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuHelp = new JMenu();
        this.setDefaultCloseOperation(3);
        this.setTitle("Query Demo");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                QueryTestFrame.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.jTextPane1.setFont(new Font("Monospaced", 0, 12));
        this.jTextPane1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                QueryTestFrame.this.jTextPane1FocusLost(focusEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.getContentPane().add(this.queryPanel);
        this.jMenu3.setText("Metadata");
        this.jMenuItemRefreshMetadata.setText("Refresh Metadata");
        this.jMenuItemRefreshMetadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryTestFrame.this.jMenuItemRefreshMetadataActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItemRefreshMetadata);
        this.jMenuItemClearMetadata.setText("Clear Metadata");
        this.jMenuItemClearMetadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryTestFrame.this.jMenuItemClearMetadataActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItemClearMetadata);
        this.jMenu3.add(this.jSeparator1);
        this.jMenu4.setText("Statistics");
        this.jMenuItemQueryStatistics.setText("Show Query Statistics");
        this.jMenuItemQueryStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryTestFrame.this.jMenuItemQueryStatisticsActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.jMenuItemQueryStatistics);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQueryBuilderConnection() throws SQLException {
        Connection connection = QueryTestFrame.connect();
        this.queryPanel.loadMetadata(connection);
        String string = "SELECT SUM(units_fact.SALES),\n  channel_dim.CHANNEL_DSC\nFROM channel_dim\nINNER JOIN units_fact\nON channel_dim.CHANNEL_ID = units_fact.CHANNEL_ID\nGROUP BY units_fact.CHANNEL_ID,\n  channel_dim.CHANNEL_DSC";
        this.queryPanel.setSQL(string);
    }

    private void jMenuItemRefreshMetadataActionPerformed(ActionEvent actionEvent) {
        this.queryPanel.refreshMetadata();
    }

    private void jMenuItemClearMetadataActionPerformed(ActionEvent actionEvent) {
        this.queryPanel.clearMetadata();
    }

    private void jMenuItemQueryStatisticsActionPerformed(ActionEvent actionEvent) {
        String string = this.queryPanel.getSQL();
        String string2 = this.queryPanel.getStatistics();
        JOptionPane.showMessageDialog(this, string + string2, "Query Statistics", 1);
    }

    private void jTextPane1FocusLost(FocusEvent focusEvent) {
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        if (this.getExtendedState() == 0) {
            Preferences preferences = Preferences.userNodeForPackage(QueryTestFrame.class);
            preferences.putInt("x", this.getX());
            preferences.putInt("y", this.getY());
            preferences.putInt("width", this.getWidth());
            preferences.putInt("height", this.getHeight());
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            Logger.getLogger(QueryTestFrame.class.getName()).log(Level.SEVERE, null, exception);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new QueryTestFrame().setVisible(true);
            }
        });
    }
}

