/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntax;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBObjectProvider;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.ddl.CubeDDLSupport;
import oracle.olap.syntax.BaseSyntax;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SyntaxTree;
import oracle.olap.syntax.SyntaxVisitor;
import oracle.olapi.syntax.AggregationCommand;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.KeywordArgument;
import oracle.olapi.syntax.KeywordCatalog;
import oracle.olapi.syntax.ModelCommand;
import oracle.olapi.syntax.QDRExpression;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.StringExpression;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

public class SolveSyntax
extends BaseSyntax {
    private final String AGGREGATION_OPERATOR_12C_NO_AGGREGATE_COMMAND = "NO AGGREGATE";
    private static final String LEVEL_NAME = "LEVEL_NAME";
    private static SolveSyntax solveSyntaxInstance;

    private SolveSyntax() {
    }

    public static SolveSyntax getInstance() {
        if (solveSyntaxInstance == null) {
            solveSyntaxInstance = new SolveSyntax();
        }
        return solveSyntaxInstance;
    }

    private ConsistentSolveSpecification getConsistentSolveSpecification(String string) {
        if (string != null) {
            String string2 = string.replaceAll("''", "'");
            ConsistentSolveSpecification consistentSolveSpecification = (ConsistentSolveSpecification)SyntaxObject.fromSyntax((String)string2, null);
            return consistentSolveSpecification;
        }
        return null;
    }

    private AggregationCommandDetails getAggregationCommandDetails(AggregationCommand aggregationCommand) {
        final AggregationCommandDetails aggregationCommandDetails = new AggregationCommandDetails();
        aggregationCommandDetails.dimID = aggregationCommand.getPrimaryDimensionID();
        aggregationCommandDetails.levelName = null;
        try {
            SyntaxTree.Traverse(aggregationCommand, new SyntaxVisitor(){

                @Override
                public void visit(SyntaxObject syntaxObject) throws SQLException {
                    ValueComparisonCondition valueComparisonCondition;
                    if (syntaxObject instanceof ValueComparisonCondition && (valueComparisonCondition = (ValueComparisonCondition)syntaxObject).getOperator().equals("=")) {
                        ColumnExpression columnExpression;
                        String string;
                        TypedExpression typedExpression = valueComparisonCondition.getLhsArgument();
                        TypedExpression typedExpression2 = valueComparisonCondition.getRhsArgument();
                        if (typedExpression instanceof ColumnExpression && (string = (columnExpression = (ColumnExpression)typedExpression).getColumnName()).equals(SolveSyntax.LEVEL_NAME)) {
                            Query query = columnExpression.getQuery();
                            String string2 = columnExpression.getQuery().getName();
                            if (!string2.equals(aggregationCommandDetails.dimID)) {
                                aggregationCommandDetails.levelName = null;
                            }
                        }
                        if (typedExpression2 instanceof StringExpression) {
                            columnExpression = (StringExpression)typedExpression2;
                            aggregationCommandDetails.levelName = columnExpression.getValue();
                        }
                    }
                    if (syntaxObject instanceof KeywordArgument) {
                        valueComparisonCondition = (KeywordArgument)syntaxObject;
                        if (valueComparisonCondition.equals((SyntaxObject)KeywordCatalog.WEIGHTBY)) {
                            aggregationCommandDetails.weightBy = true;
                        }
                        if (valueComparisonCondition.equals((SyntaxObject)KeywordCatalog.SCALEBY)) {
                            aggregationCommandDetails.scaleBy = true;
                        }
                    }
                    if (syntaxObject instanceof QDRExpression) {
                        valueComparisonCondition = (QDRExpression)syntaxObject;
                        aggregationCommandDetails.measureID = valueComparisonCondition.toSyntax();
                    }
                    if (syntaxObject instanceof ColumnExpression) {
                        valueComparisonCondition = (ColumnExpression)syntaxObject;
                        aggregationCommandDetails.measureID = valueComparisonCondition.toSyntax();
                    }
                }
            });
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return aggregationCommandDetails;
    }

    public List<CubeAggregationDimension> fromSyntax(Cube cube, String string) {
        ArrayList<CubeAggregationDimension> arrayList = new ArrayList<CubeAggregationDimension>();
        ConsistentSolveSpecification consistentSolveSpecification = this.getConsistentSolveSpecification(string);
        if (consistentSolveSpecification != null) {
            int n = 0;
            for (ConsistentSolveCommand consistentSolveCommand : consistentSolveSpecification.getCommands()) {
                if (consistentSolveCommand instanceof ModelCommand) {
                    // empty if block
                }
                if (!(consistentSolveCommand instanceof AggregationCommand)) continue;
                AggregationCommand aggregationCommand = (AggregationCommand)consistentSolveCommand;
                AggregationCommandDetails aggregationCommandDetails = this.getAggregationCommandDetails(aggregationCommand);
                if (aggregationCommandDetails.dimID == null) {
                    for (CubeDimensionality cubeDimensionality : cube.getDimensions()) {
                        String string2 = cubeDimensionality.getName();
                        CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, string2);
                        cubeAggregationDimension.setAggregationOrder(++n);
                        cubeAggregationDimension.setAggregationOperator(aggregationCommand.getFunctionName());
                        if (aggregationCommandDetails.measureID != null) {
                            cubeAggregationDimension.setAggregationBasedOnMeasure(aggregationCommandDetails.measureID);
                        }
                        cubeAggregationDimension.setAggregationMaintainCount(aggregationCommand.getMaintainCount());
                        cubeAggregationDimension.setAggregationFromLevel(null);
                        arrayList.add(cubeAggregationDimension);
                    }
                    continue;
                }
                CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, aggregationCommandDetails.dimID);
                cubeAggregationDimension.setAggregationOrder(n);
                cubeAggregationDimension.setAggregationOperator(aggregationCommand.getFunctionName());
                cubeAggregationDimension.setAggregationFromLevel(aggregationCommandDetails.levelName);
                cubeAggregationDimension.setAggregationBasedOnMeasure(aggregationCommandDetails.measureID);
                cubeAggregationDimension.setAggregationMaintainCount(aggregationCommand.getMaintainCount());
                arrayList.add(cubeAggregationDimension);
            }
        }
        return arrayList;
    }

    public List<CubeAggregationDimension> fromSyntax(Cube cube, Map<String, CubeDimension> map, DBObjectProvider dBObjectProvider, String string) {
        int n = 0;
        CubeDimensionality[] cubeDimensionalityArray = cube.getDimensions();
        ArrayList<CubeAggregationDimension> arrayList = new ArrayList<CubeAggregationDimension>();
        String string2 = string.replaceAll("''", "'");
        ConsistentSolveSpecification consistentSolveSpecification = (ConsistentSolveSpecification)SyntaxObject.fromSyntax((String)string2, null);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (ConsistentSolveCommand object : consistentSolveSpecification.getCommands()) {
            CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
            Object object2;
            Object object3;
            String[] stringArray;
            if (object instanceof ModelCommand) {
                // empty if block
            }
            if (!(object instanceof AggregationCommand)) continue;
            AggregationCommand aggregationCommand = (AggregationCommand)object;
            AggregationCommandDetails aggregationCommandDetails = this.getAggregationCommandDetails(aggregationCommand);
            boolean bl2 = aggregationCommand.getMaintainCount();
            String string3 = aggregationCommand.getFunctionName();
            if (aggregationCommandDetails.scaleBy && string3.equals("SUM")) {
                string3 = "SSUM";
            }
            if (aggregationCommandDetails.weightBy) {
                if (string3.equals("SUM")) {
                    string3 = "WSUM";
                }
                if (string3.equals("AVG")) {
                    string3 = "WAVG";
                }
                if (string3.equals("FIRST")) {
                    string3 = "WFIRST";
                }
                if (string3.equals("LAST")) {
                    string3 = "WLAST";
                }
                if (string3.equals("HIER_AVG")) {
                    string3 = "HIER_WAVG";
                }
                if (string3.equals("HIER_FIRST")) {
                    string3 = "HIER_WFIRST";
                }
                if (string3.equals("HIER_LAST")) {
                    string3 = "HIER_WLAST";
                }
            }
            if (string3.equalsIgnoreCase("NO AGGREGATE")) {
                string3 = "NOAGG";
            }
            if (aggregationCommandDetails.dimID == null) {
                bl = true;
            }
            if (bl) {
                for (CubeDimension cubeDimension : map.values()) {
                    stringArray = cubeDimension.getName();
                    object3 = new CubeAggregationDimension(cube, (String)stringArray);
                    ((CubeAggregationDimension)object3).setAggregationOrder(++n);
                    ((CubeAggregationDimension)object3).setAggregationOperator(string3);
                    if (aggregationCommandDetails.measureID != null) {
                        ((CubeAggregationDimension)object3).setAggregationBasedOnMeasure(aggregationCommandDetails.measureID);
                    }
                    ((CubeAggregationDimension)object3).setAggregationMaintainCount(bl2);
                    ((CubeAggregationDimension)object3).setAggregationFromLevel(null);
                    arrayList.add((CubeAggregationDimension)object3);
                    object2 = cubeDimension.getHierarchies();
                    cubeDimensionHierarchyArray = new ArrayList();
                    for (CubeDimensionHierarchy cubeDimensionHierarchy : object2) {
                        cubeDimensionHierarchyArray.add(cubeDimensionHierarchy);
                    }
                    ((CubeAggregationDimension)object3).setAggregationHierarchies((List<CubeDimensionHierarchy>)cubeDimensionHierarchyArray);
                }
                continue;
            }
            Object object4 = cube.findDimensionality(aggregationCommandDetails.dimID);
            if (object4 == null) continue;
            arrayList2.add(aggregationCommandDetails.dimID);
            CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, aggregationCommandDetails.dimID);
            cubeAggregationDimension.setAggregationOrder(++n);
            cubeAggregationDimension.setAggregationMaintainCount(bl2);
            cubeAggregationDimension.setAggregationFromLevel(aggregationCommandDetails.levelName);
            cubeAggregationDimension.setAggregationOperator(string3);
            cubeAggregationDimension.setAggregationBasedOnMeasure(aggregationCommandDetails.measureID);
            arrayList.add(cubeAggregationDimension);
            stringArray = aggregationCommand.getHierarchyIDs();
            object3 = map.get(object4.getName());
            object2 = object3.getName();
            cubeDimensionHierarchyArray = ((CubeDimension)object3).getHierarchies();
            Object object5 = new ArrayList();
            if (stringArray != null) {
                for (String string4 : stringArray) {
                    for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray) {
                        String string5 = String.format("%s.%s", object2, cubeDimensionHierarchy.getName());
                        if (!string5.equalsIgnoreCase(string4)) continue;
                        object5.add(cubeDimensionHierarchy);
                    }
                }
            } else {
                object5 = new ArrayList();
                for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray) {
                    object5.add(cubeDimensionHierarchy);
                }
            }
            cubeAggregationDimension.setAggregationHierarchies((List<CubeDimensionHierarchy>)object5);
        }
        if (!bl) {
            for (CubeDimension cubeDimension : map.values()) {
                String string5 = cubeDimension.getName();
                if (arrayList2.contains(string5)) continue;
                CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, string5);
                cubeAggregationDimension.setAggregationOrder(++n);
                cubeAggregationDimension.setAggregationOperator("NOAGG");
                cubeAggregationDimension.setAggregationHierarchies(new ArrayList<CubeDimensionHierarchy>());
                arrayList.add(cubeAggregationDimension);
            }
        }
        return arrayList;
    }

    public String toSyntax(Cube cube, Map<String, CubeDimension> map, DBObjectProvider dBObjectProvider, List<CubeAggregationDimension> list) {
        Object object;
        boolean bl = CubeDDLSupport.isDatabaseCompatible12(dBObjectProvider);
        String string = null;
        List<Object> list2 = new ArrayList();
        boolean bl2 = true;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = true;
        for (CubeAggregationDimension cubeAggregationDimension : list) {
            Object object2;
            String string3 = cubeAggregationDimension.getName();
            CubeDimensionality cubeDimensionality = cube.findDimensionality(string3);
            int n = Integer.valueOf(cubeAggregationDimension.getAggregationOrder());
            String string4 = cubeAggregationDimension.getAggregationOperator();
            list2 = cubeAggregationDimension.getAggregationHierarchies();
            if (string4.equalsIgnoreCase("NOAGG")) {
                if (!bl) {
                    bl2 = false;
                    continue;
                }
                string4 = "NO AGGREGATE";
            }
            if (cubeDimensionality.getPhysicalOrder() != n) {
                bl2 = false;
            }
            if (!bl3 && string2 != null && !string2.equalsIgnoreCase(string4)) {
                bl2 = false;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            if (string4.equalsIgnoreCase("SSUM") || string4.equalsIgnoreCase("WAVG") || string4.equalsIgnoreCase("HIER_WAVG") || string4.equalsIgnoreCase("WFIRST") || string4.equalsIgnoreCase("HIER_WFIRST") || string4.equalsIgnoreCase("WLAST") || string4.equalsIgnoreCase("HIER_WLAST") || string4.equalsIgnoreCase("WSUM")) {
                bl2 = false;
                object2 = "SUM";
                if (string4.equals("SSUM")) {
                    object2 = "SUM";
                }
                if (string4.equals("WAVG")) {
                    object2 = "AVG";
                }
                if (string4.equals("WSUM")) {
                    object2 = "SUM";
                }
                if (string4.equals("WFIRST")) {
                    object2 = "FIRST";
                }
                if (string4.equals("WLAST")) {
                    object2 = "LAST";
                }
                if (string4.equals("HIER_WAVG")) {
                    object2 = "HIER_AVG";
                }
                if (string4.equals("HIER_WFIRST")) {
                    object2 = "HIER_FIRST";
                }
                if (string4.equals("HIER_WLAST")) {
                    object2 = "HIER_LAST";
                }
                stringBuffer.append((String)object2);
                stringBuffer.append("(");
                if (string4.equalsIgnoreCase("SSUM")) {
                    stringBuffer.append("SCALEBY ");
                } else {
                    stringBuffer.append("WEIGHTBY ");
                }
                stringBuffer.append(cubeAggregationDimension.getAggregationBasedOnMeasure());
                stringBuffer.append(")");
            } else {
                stringBuffer.append(string4);
            }
            if (cubeAggregationDimension.isAggregationMaintainCount()) {
                stringBuffer.append(" MAINTAIN COUNT OVER");
            } else {
                stringBuffer.append(" OVER");
            }
            object2 = map.get(cubeDimensionality.getName());
            stringBuffer.append(" ");
            stringBuffer.append(String.format("\"%s\"", string3));
            CubeDimensionHierarchy[] cubeDimensionHierarchyArray = ((CubeDimension)object2).getHierarchies();
            String string5 = " HIERARCHIES (";
            if (list2 != null && list2.size() > 0 && list2.size() < cubeDimensionHierarchyArray.length) {
                bl2 = false;
                int n2 = 0;
                for (CubeDimensionHierarchy cubeDimensionHierarchy : list2) {
                    string5 = n2 == 0 ? string5 + cubeDimensionHierarchy.getName() : string5 + "," + cubeDimensionHierarchy.getName();
                    ++n2;
                }
                string5 = string5 + ")";
                stringBuffer.append(string5);
            }
            String string6 = " FROM MEMBERS WHERE ";
            String string7 = cubeAggregationDimension.getAggregationFromLevel();
            if (string7 != null) {
                bl2 = false;
                string6 = string6 + string3 + String.format(".LEVEL_NAME = '%s'", string7);
                stringBuffer.append(string6);
            }
            string2 = string4;
            bl3 = false;
        }
        if (bl2) {
            object = "SUM";
            object = string2;
            string = String.format("SOLVE(%s MAINTAIN COUNT OVER ALL)", object);
        } else if (stringBuffer.length() > 0) {
            string = String.format("SOLVE(%s)", stringBuffer.toString());
        }
        object = (ConsistentSolveSpecification)SyntaxObject.fromSyntax(string, null);
        string = object.toSyntax();
        string = string.replaceAll("'", "''");
        return string;
    }

    static class AggregationCommandDetails {
        protected String dimID;
        protected boolean weightBy;
        protected boolean scaleBy;
        protected String measureID;
        protected String levelName;

        AggregationCommandDetails() {
        }
    }
}

