/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.UndoManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.WaitCursor;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopup;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.editor.popup.PopupEventListener;
import oracle.javatools.editor.popup.StaticHtmlContentProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.MetadataUpdateListener;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.cubeviewer.CubeDataViewerDialog;
import oracle.olap.data.CubeMetadataContextImpl;
import oracle.olap.db.IdentifierElement;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.syntaxbuilder.editor.DocHtmlContentProvider;
import oracle.olap.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.util.OLAPHelpProvider;

public class EditorActions
implements ChangeListener,
UndoableEditListener,
Controller {
    private final FetchIcon fetchIcon;
    private static File path;
    private BasicEditorPane text;
    private final SyntaxParser parser;
    private final UndoManager undoMan;
    private CalcSelectionEditorPlugin calcSel;
    private final AbstractAction undoAction;
    private final AbstractAction redoAction;
    private final AbstractAction copyAction;
    private final AbstractAction pasteAction;
    private final AbstractAction cutAction;
    private final AbstractAction saveAction;
    private final AbstractAction clearAction;
    private final AbstractAction formatAction;
    private final AbstractAction validateAction;
    private final AbstractAction quickDocAction;
    private final AbstractAction viewExceptionAction;
    private final AbstractAction deleteOutter;
    private final AbstractAction runAction;
    private final AbstractAction compileAction;
    private static final Logger LOG;
    private InsertionHandlerEditorPlugin ihandler;
    private Spec spec;
    private String connectionName;
    private String schemaName;
    private String cubeName;
    private static final Type[] ideActions;

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undoAction.setEnabled(this.undoMan.canUndo() && this.text.isEditable());
        this.redoAction.setEnabled(this.undoMan.canRedo() && this.text.isEditable());
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Type type;
        if (context.getView() == CodeEditor.getCodeEditor((BasicEditorPane)this.text) && (type = Type.fromCommandId(ideAction.getCommandId())) != null) {
            this.get(type).actionPerformed(null);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (context.getView() == CodeEditor.getCodeEditor((BasicEditorPane)this.text)) {
            this.stateChanged(null);
            Type type = Type.fromCommandId(ideAction.getCommandId());
            Action action = this.get(type);
            ideAction.setEnabled(action.isEnabled());
            return true;
        }
        return false;
    }

    public void setEditorPane(BasicEditorPane basicEditorPane) {
        this.text = basicEditorPane;
        this.setupKeyBindings();
    }

    public void setView(View view) {
        for (Type type : ideActions) {
            this.getIdeAction(type).addController((Controller)this);
        }
        view.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent viewEvent) {
            }

            public void viewDeactivated(ViewEvent viewEvent) {
            }

            public void viewClosed(ViewEvent viewEvent) {
                for (Type type : ideActions) {
                    IdeAction.removeController((int)type.getCommandId(), (Controller)EditorActions.this);
                }
            }
        });
    }

    private void setupKeyBindings() {
        if (this.text == null) {
            return;
        }
        InputMap inputMap = this.text.getInputMap();
        ActionMap actionMap = this.text.getActionMap();
        Type[] typeArray = Type.values();
        this.text.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                KeyStroke keyStroke = (KeyStroke)EditorActions.this.undoAction.getValue("AcceleratorKey");
                if (keyEvent.getKeyCode() == keyStroke.getKeyCode() && (keyEvent.getModifiers() & keyStroke.getModifiers()) != 0) {
                    EditorActions.this.undoAction.actionPerformed(null);
                }
                KeyStroke keyStroke2 = (KeyStroke)EditorActions.this.redoAction.getValue("AcceleratorKey");
                if (keyEvent.getKeyCode() == keyStroke2.getKeyCode() && (keyEvent.getModifiers() & keyStroke2.getModifiers()) != 0) {
                    EditorActions.this.redoAction.actionPerformed(null);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.text.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EditorActions.this.stateChanged(null);
            }
        });
        for (int i = 0; i < typeArray.length; ++i) {
            KeyStroke keyStroke;
            if (typeArray[i] == Type.UNDO || typeArray[i] == Type.REDO || (keyStroke = (KeyStroke)this.get(typeArray[i]).getValue("AcceleratorKey")) == null) continue;
            actionMap.put((Object)typeArray[i], this.get(typeArray[i]));
            inputMap.put(keyStroke, (Object)typeArray[i]);
        }
    }

    public EditorActions(FetchIcon fetchIcon, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, CalcSelectionEditorPlugin calcSelectionEditorPlugin, BasicEditorPane basicEditorPane, Spec spec, SyntaxParser syntaxParser, UndoManager undoManager, String string, String string2, String string3) {
        this.fetchIcon = fetchIcon;
        this.parser = syntaxParser;
        this.text = basicEditorPane;
        this.undoMan = undoManager;
        this.ihandler = insertionHandlerEditorPlugin;
        this.spec = spec;
        this.calcSel = calcSelectionEditorPlugin;
        this.connectionName = string;
        this.cubeName = string3;
        this.schemaName = string2;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.pasteAction = new PasteAction();
        this.copyAction = new CopyAction();
        this.cutAction = new CutAction();
        this.saveAction = new SaveAction();
        this.clearAction = new ClearAction();
        this.formatAction = new FormatAction();
        this.validateAction = new ValidateAction();
        this.quickDocAction = new QuickDocAction();
        this.viewExceptionAction = new ViewExceptionAction();
        this.deleteOutter = new DeleteOuterAction();
        this.runAction = new RunAction();
        this.compileAction = new CompileAction();
        if (basicEditorPane != null) {
            this.setupKeyBindings();
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
            if (codeEditor != null) {
                this.setView((View)codeEditor);
            }
        }
    }

    public Action get(Type type) {
        switch (type) {
            case UNDO: {
                return this.undoAction;
            }
            case REDO: {
                return this.redoAction;
            }
            case COPY: {
                return this.copyAction;
            }
            case PASTE: {
                return this.pasteAction;
            }
            case CUT: {
                return this.cutAction;
            }
            case SAVE: {
                return this.saveAction;
            }
            case CLEAR: {
                return this.clearAction;
            }
            case FORMAT: {
                return this.formatAction;
            }
            case VALIDATE: {
                return this.validateAction;
            }
            case QUICKDOC: {
                return this.quickDocAction;
            }
            case VIEWEXCEPTION: {
                return this.viewExceptionAction;
            }
            case DELETE_OUTER: {
                return this.deleteOutter;
            }
            case REFRESH_METADATA: {
                return IdeActions.getViewRefreshAction();
            }
            case RUN: {
                return this.runAction;
            }
            case COMPILE: {
                return this.compileAction;
            }
        }
        return null;
    }

    private IdeAction getIdeAction(Type type) {
        Action action = this.get(type);
        if (action instanceof IdeAction) {
            return (IdeAction)action;
        }
        return IdeAction.findOrCreate((int)type.getCommandId(), null, (String)((String)action.getValue("Name")), (String)((String)action.getValue("Category")), (Integer)0, (Icon)((Icon)action.getValue("SmallIcon")), null, (boolean)true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl = this.text.getCaret().getDot() != this.text.getCaret().getMark();
        this.copyAction.setEnabled(bl);
        this.cutAction.setEnabled(bl && this.text.isEditable());
        this.validateAction.setEnabled(bl && this.text.isEditable());
        boolean bl2 = this.text.getText().length() > 0;
        this.clearAction.setEnabled(bl2 && this.text.isEditable());
        this.formatAction.setEnabled(bl2 && this.text.isEditable());
        this.quickDocAction.setEnabled(bl);
        this.deleteOutter.setEnabled(this.calcSel.getInnerExpression() != null && this.text.isEditable());
    }

    private void setActionValues(Action action, String string) {
        action.putValue("Name", OLAPArb.getString("EXPRESSION_EDITOR." + string));
        action.putValue("ShortDescription", action.getValue("Name"));
        action.putValue("COSTELLO", string);
        String[] stringArray = new String[]{"SmallIcon", "_ENABLE", "disabledIcon", "_DISABLE", "rolloverIcon", "_OVER", "pressedIcon", "_DOWN"};
        if (this.fetchIcon != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                Icon icon = this.fetchIcon.getIcon(string + stringArray[i + 1]);
                if (icon == null) continue;
                action.putValue(stringArray[i], icon);
            }
        }
    }

    static {
        LOG = Logger.getLogger(EditorActions.class.getName());
        ideActions = new Type[]{Type.COMPILE, Type.RUN, Type.VIEWEXCEPTION, Type.CLEAR, Type.FORMAT, Type.VALIDATE, Type.DELETE_OUTER};
    }

    private static class Listener
    implements CaretListener,
    PopupEventListener {
        private BasicEditorPane _editorPane;
        private HtmlPopupView _htmlPopupView;

        private Listener(BasicEditorPane basicEditorPane, HtmlPopupView htmlPopupView) {
            this._editorPane = basicEditorPane;
            this._htmlPopupView = htmlPopupView;
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            HtmlPopup.cancelPopup((BasicEditorPane)this._editorPane);
        }

        public void popupCanceled() {
        }

        public void contentsChanged() {
        }

        public void popupClosed() {
            this._editorPane.removeCaretListener((CaretListener)this);
            this._htmlPopupView.removePopupEventListener((PopupEventListener)this);
        }
    }

    private class QuickDocAction
    extends AbstractAction {
        QuickDocAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 128));
            EditorActions.this.setActionValues(this, "QUICKDOC");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = EditorActions.this.text.getCaret().getDot();
            if (n2 != (n = EditorActions.this.text.getCaret().getMark())) {
                String string = EditorActions.this.text.getSelectedText();
                WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                try {
                    String string2;
                    waitCursor.show();
                    DocHtmlContentProvider docHtmlContentProvider = new DocHtmlContentProvider(EditorActions.this.spec, string);
                    if (docHtmlContentProvider == null) {
                        string2 = InsightBundle.get((String)"POPUP_MSG_NO_DOC");
                        docHtmlContentProvider = new StaticHtmlContentProvider(string2);
                    }
                    if ((string2 = HtmlPopup.invokePopup((BasicEditorPane)EditorActions.this.text, (HtmlContentProvider)docHtmlContentProvider)) != null) {
                        Listener listener = new Listener(EditorActions.this.text, (HtmlPopupView)string2);
                        EditorActions.this.text.addCaretListener((CaretListener)listener);
                        string2.addPopupEventListener((PopupEventListener)listener);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "Quick Doc failed", exception);
                }
                finally {
                    waitCursor.hide();
                }
            }
        }
    }

    private class RunAction
    extends AbstractAction
    implements MetadataUpdateListener {
        private CubeDataViewerDialog dataViewer;
        private CalculatedMeasureNode node;

        public RunAction() {
            this.setEnabled(true);
            this.putValue("Name", Messages.getString((String)"Run"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"run.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                try {
                    if (EditorActions.this.ihandler.checkSyntax()) {
                        try {
                            this.node = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
                            if (this.node.isDirty()) {
                                OLAPMetadataCache.addUpdateListener(EditorActions.this.connectionName, EditorActions.this.schemaName, this);
                                IdeActions.getFileSaveAction().performAction();
                                break block6;
                            }
                            this.launchDataViewer(this.node.getCubeName(), this.node.getMeasureName());
                        }
                        catch (Exception exception) {
                            LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
                        }
                        break block6;
                    }
                    CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.format("EXPRESSION_EDITOR_INVALID_SYNTAX", calculatedMeasureNode.getData()));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }

        private void launchDataViewer(final String string, final String string2) {
            RaptorTask raptorTask = new RaptorTask(OLAPArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() {
                    Boolean bl = Boolean.TRUE;
                    try {
                        Object object;
                        Schema schema = OLAPMetadataCache.getSchema(EditorActions.this.connectionName, EditorActions.this.schemaName);
                        Cube cube = schema.findCube(string);
                        CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
                        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)calculatedMeasureNode.getProvider();
                        CubeMetadataContextImpl cubeMetadataContextImpl = new CubeMetadataContextImpl(oracleDatabaseImpl, cube);
                        Measure measure = cube.findMeasure(string2);
                        AnalyticWorkspace analyticWorkspace = new AnalyticWorkspace(schema.getName(), cube.getAWName());
                        for (Cube arrayList2 : schema.getCubes()) {
                            if (!cube.getAWName().equals(arrayList2.getAWName())) continue;
                            analyticWorkspace.addCube(arrayList2);
                        }
                        measure.setSelected(true);
                        List<Measure> list = CalcReferences.getReferences(measure, EditorActions.this.parser, analyticWorkspace);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            object = (Measure)iterator.next();
                            ((NamedObject)object).setSelected(true);
                        }
                        ArrayList<DimensionHierarchy> arrayList = new ArrayList<DimensionHierarchy>();
                        object = new ParseNode();
                        list.add(measure);
                        if (EditorActions.this.parser.parseSyntax(measure.getExpression(), (ParseNode)object)) {
                            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object).breadthFirstEnumeration();
                            while (enumeration.hasMoreElements()) {
                                IdentifierElement identifierElement;
                                Dimension dimension;
                                DimensionHierarchy dimensionHierarchy;
                                ParseNode parseNode = (ParseNode)enumeration.nextElement();
                                if (parseNode.getType() == null || !parseNode.getType().equalsIgnoreCase("hierarchy") || arrayList.contains(dimensionHierarchy = (dimension = cube.findDimension((identifierElement = new IdentifierElement(String.valueOf(parseNode.getUserObject()))).getSecond())).findHierarchy(identifierElement.getThird()))) continue;
                                arrayList.add(dimensionHierarchy);
                            }
                        }
                        RunAction.this.dataViewer = new CubeDataViewerDialog((JFrame)Ide.getMainWindow(), new OLAPHelpProvider(), cubeMetadataContextImpl, null, arrayList);
                        return bl;
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
                        return null;
                    }
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(OLAPArb.getString("EXPRESSION_EDITOR_LOAD_METADATA"));
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunAction.this.dataViewer.showViewer();
                        }
                    });
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }

        @Override
        public void metadataUpdated(Schema schema) {
            try {
                OLAPMetadataCache.removeUpdateListener(EditorActions.this.connectionName, EditorActions.this.schemaName, this);
                this.launchDataViewer(EditorActions.this.cubeName, this.node.getMeasureName());
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }

        @Override
        public void metadataCleared() {
        }
    }

    private class CompileAction
    extends AbstractAction {
        public CompileAction() {
            this.setEnabled(true);
            this.putValue("Name", Messages.getString((String)"Compile"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("SmallIcon", CompileArb.getIcon((String)"MAKE_ICON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Compiler compiler = Compiler.getCompiler();
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)CodeEditor.getContext((BasicEditorPane)EditorActions.this.text).getNode();
            try {
                EditorActions.this.ihandler.checkSyntax();
                if (EditorActions.this.parser.getExceptions().size() == 0) {
                    calculatedMeasureNode.setCompiled(true);
                    calculatedMeasureNode.logMessage(OLAPArb.format("EXPRESSION_EDITOR_COMPILE_SUCCESS", calculatedMeasureNode.getMeasureName()));
                    calculatedMeasureNode.setLastCompileErrorsList(null);
                    calculatedMeasureNode.setCompiledWithErrors(false);
                    compiler.getOutputLog().log((Object)OLAPArb.format("EXPRESSION_EDITOR_COMPILE_SUCCESS_MSG", calculatedMeasureNode.getMeasureName()));
                } else {
                    calculatedMeasureNode.setCompiledWithErrors(true);
                    calculatedMeasureNode.logError(EditorActions.this.parser.getExceptions());
                    calculatedMeasureNode.setLastCompileErrorsList(new ArrayList<Throwable>(EditorActions.this.parser.getExceptions()));
                    compiler.getOutputLog().log((Object)OLAPArb.format("EXPRESSION_EDITOR_COMPILE_ERRORS_MSG", calculatedMeasureNode.getMeasureName()));
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }
    }

    private class FormatAction
    extends AbstractAction {
        FormatAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 128));
            this.putValue("Category", "Edit");
            EditorActions.this.setActionValues(this, "FORMAT");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2 = EditorActions.this.text.getText().replace("\r\n", "\n");
            if (!string2.equals(string = EditorActions.this.parser.formatSyntax(string2).replace("\r\n", "\n"))) {
                EditorActions.this.ihandler.insertSyntax(new TemplateData(string, TemplateData.Mode.REPLACEALL));
            }
        }
    }

    private class DeleteOuterAction
    extends AbstractAction {
        DeleteOuterAction() {
            EditorActions.this.setActionValues(this, "CLEAR");
            this.putValue("Name", OLAPArb.getString("EXPRESSION_EDITOR.DELETEOUTER"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("Category", "Edit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.calcSel.getInnerExpression() != null) {
                ParseNode parseNode = EditorActions.this.calcSel.getInnerExpression();
                EditorActions.this.text.replaceSelection(parseNode.getFullValue());
            }
        }
    }

    private class ClearAction
    extends AbstractAction {
        ClearAction() {
            EditorActions.this.setActionValues(this, "CLEAR");
            this.putValue("Category", "Edit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditorActions.this.text.getDocument().getLength();
            if (n > 0) {
                try {
                    EditorActions.this.text.getDocument().remove(0, n);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.setEnabled(false);
        }
    }

    private class ViewExceptionAction
    extends AbstractAction {
        ViewExceptionAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
            this.putValue("Category", "Debug");
            EditorActions.this.setActionValues(this, "VIEW_EXCEPTION");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.parser.getExceptions().size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Throwable throwable : EditorActions.this.parser.getExceptions()) {
                    stringBuilder.append(throwable.getLocalizedMessage());
                    stringBuilder.append("\n");
                }
                JOptionPane.showMessageDialog((Component)EditorActions.this.text, stringBuilder, OLAPArb.getString("EXPRESSION_EDITOR.VIEW_EXCEPTION"), 0);
            }
        }
    }

    private class ValidateAction
    extends AbstractAction {
        ValidateAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 128));
            this.putValue("Category", "Debug");
            EditorActions.this.setActionValues(this, "VALIDATE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.text.getCaret().getDot() == EditorActions.this.text.getCaret().getMark()) {
                return;
            }
            boolean bl = EditorActions.this.parser.parseSyntax(EditorActions.this.text.getSelectedText(), null);
            if (bl) {
                JOptionPane.showMessageDialog((Component)EditorActions.this.text, OLAPArb.getString("EXPRESSION_EDITOR.SELECTION_VALID"));
            } else {
                JOptionPane.showMessageDialog((Component)EditorActions.this.text, OLAPArb.getString("EXPRESSION_EDITOR.SELECTION_INVALID"));
            }
        }
    }

    private class CutAction
    extends CopyAction {
        CutAction() {
            this.cut = true;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 128));
            EditorActions.this.setActionValues(this, "CUT");
        }
    }

    private class PasteAction
    extends AbstractAction {
        PasteAction() {
            this.setEnabled(true);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
            EditorActions.this.setActionValues(this, "PASTE");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = (String)EditorActions.this.text.getToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                EditorActions.this.ihandler.insertSyntax(new TemplateData(string));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        boolean cut;

        CopyAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
            EditorActions.this.setActionValues(this, "COPY");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = EditorActions.this.text.getCaret().getDot();
            if (n2 != (n = EditorActions.this.text.getCaret().getMark())) {
                String string = EditorActions.this.text.getSelectedText();
                EditorActions.this.text.getToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                if (this.cut) {
                    EditorActions.this.text.replaceSelection("");
                }
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        RedoAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 128));
            EditorActions.this.setActionValues(this, "REDO");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.undoMan.canRedo()) {
                EditorActions.this.undoMan.redo();
            }
            this.setEnabled(EditorActions.this.undoMan.canRedo());
            EditorActions.this.undoAction.setEnabled(EditorActions.this.undoMan.canUndo() && EditorActions.this.text.isEditable());
            EditorActions.this.clearAction.setEnabled(EditorActions.this.text.getDocument().getLength() > 0 && EditorActions.this.text.isEditable());
        }
    }

    private class UndoAction
    extends AbstractAction {
        UndoAction() {
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 128));
            EditorActions.this.setActionValues(this, "UNDO");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorActions.this.undoMan != null) {
                if (EditorActions.this.undoMan.canUndo()) {
                    EditorActions.this.undoMan.undo();
                }
                this.setEnabled(EditorActions.this.undoMan.canUndo() && EditorActions.this.text.isEditable());
                EditorActions.this.redoAction.setEnabled(EditorActions.this.undoMan.canRedo() && EditorActions.this.text.isEditable());
                EditorActions.this.clearAction.setEnabled(EditorActions.this.text.getDocument().getLength() > 0 && EditorActions.this.text.isEditable());
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            EditorActions.this.setActionValues(this, "SAVE");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            if (path == null) {
                jFileChooser.showOpenDialog((Component)EditorActions.this.text);
                path = jFileChooser.getSelectedFile();
                if (path == null) {
                    return;
                }
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(path);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(EditorActions.this.text.getText());
                bufferedWriter.close();
                outputStreamWriter.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum Type {
        COMPILE,
        RUN,
        UNDO,
        REDO,
        COPY,
        PASTE,
        CUT,
        DELETE_OUTER,
        SAVE,
        CLEAR,
        FORMAT,
        QUICKDOC,
        VALIDATE,
        VIEWEXCEPTION,
        REFRESH_METADATA;

        private final int cmdId = this.name().equals("REFRESH_METADATA") ? IdeActions.getViewRefreshAction().getCommandId() : Ide.createCmdID((String)(((Object)((Object)this)).getClass().getName() + this.name()));

        public int getCommandId() {
            return this.cmdId;
        }

        public static Type fromCommandId(int n) {
            for (Type type : ideActions) {
                if (n != type.cmdId) continue;
                return type;
            }
            return null;
        }
    }
}

