/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.UndoManager;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.editor.popup.HtmlPopup;
import oracle.olap.OLAPArb;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.syntaxbuilder.IconButton;
import oracle.olap.syntaxbuilder.editor.CodeSelectionListener;
import oracle.olap.syntaxbuilder.editor.EditorActions;
import oracle.olap.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.olapihelpers.language.OLAPILanguageModule;
import oracle.olap.syntaxbuilder.shuttle.DropHandler;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;
import oracle.olap.syntaxbuilder.specification.Spec;

public class SyntaxCodeEditor
extends JPanel
implements SyntaxTokenListener,
TreeSelectionListener,
BasicEditorPaneContainer {
    private final JLabel resultLabel = new JLabel();
    private final BasicEditorPane text;
    private JToolBar operatorButtons;
    private final JPopupMenu popMenu = new JPopupMenu();
    private final ParseNode root = new ParseNode();
    private final DefaultTreeModel parseTreeModel = new DefaultTreeModel(this.root);
    private final transient FetchIcon fetchIcon;
    private final transient SyntaxParser parser;
    private final transient EditorActions actions;
    private static final Logger LOG = Logger.getLogger(SyntaxCodeEditor.class.getName());
    private final InsertionHandlerEditorPlugin insertionHandler;
    private final CalcSelectionEditorPlugin selHandler;

    public SyntaxCodeEditor(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, TemplateHandler templateHandler, CalcSelectionEditorPlugin calcSelectionEditorPlugin, SyntaxParser syntaxParser, Spec spec, FetchIcon fetchIcon, Properties properties) {
        super(new BorderLayout());
        this.parser = syntaxParser;
        this.fetchIcon = fetchIcon;
        this.text = EditorFactory.createIdeEditorPane();
        BasicDocument basicDocument = new BasicDocument();
        UndoManager undoManager = new UndoManager();
        basicDocument.addUndoableEditListener((UndoableEditListener)undoManager);
        basicDocument.setLanguageSupport(OLAPILanguageModule.createSupportForFileType((String)"olapexp"));
        this.text.setDocument((Document)basicDocument);
        this.text.putProperty("undo-navigation", (Object)false);
        this.insertionHandler = insertionHandlerEditorPlugin;
        this.text.installPlugin((EditorPlugin)insertionHandlerEditorPlugin);
        this.selHandler = calcSelectionEditorPlugin;
        this.text.installPlugin((EditorPlugin)calcSelectionEditorPlugin);
        this.text.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.text.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.text.installPlugin((EditorPlugin)new HtmlPopup());
        this.text.setDropMode(DropMode.INSERT);
        this.text.setTransferHandler((TransferHandler)new EditorTransferHandler(templateHandler, insertionHandlerEditorPlugin));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        lineGutterPlugin.setShowLineNumbers(1);
        this.text.installPlugin((EditorPlugin)lineGutterPlugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.text, 20, 30);
        jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        this.actions = new EditorActions(this.fetchIcon, insertionHandlerEditorPlugin, calcSelectionEditorPlugin, this.text, spec, this.parser, undoManager, properties.getProperty("CONNECTION_NAME"), "", null);
        this.insertionHandler.addCodeEditorTextListener(new CodeEditorTextListener(){

            @Override
            public void textChanged(String string) {
            }

            @Override
            public void syntaxChecked(String string, boolean bl) {
                SyntaxCodeEditor.this.actions.get(EditorActions.Type.VIEWEXCEPTION).setEnabled(!bl);
                if (bl) {
                    SyntaxCodeEditor.this.resultLabel.setText(OLAPArb.getString("EXPRESSION_EDITOR.RESULT.VALID"));
                } else {
                    SyntaxCodeEditor.this.resultLabel.setText(OLAPArb.getString("EXPRESSION_EDITOR.RESULT.INVALID"));
                }
            }
        });
        basicDocument.addUndoableEditListener((UndoableEditListener)this.actions);
        this.popMenu.add(this.actions.get(EditorActions.Type.UNDO));
        this.popMenu.add(this.actions.get(EditorActions.Type.REDO));
        this.popMenu.addSeparator();
        this.popMenu.add(this.actions.get(EditorActions.Type.CUT));
        this.popMenu.add(this.actions.get(EditorActions.Type.PASTE));
        this.popMenu.add(this.actions.get(EditorActions.Type.COPY));
        this.popMenu.addSeparator();
        this.popMenu.add(this.actions.get(EditorActions.Type.CLEAR));
        this.popMenu.add(this.actions.get(EditorActions.Type.FORMAT));
        this.popMenu.addSeparator();
        this.popMenu.add(this.actions.get(EditorActions.Type.QUICKDOC));
        this.popMenu.addSeparator();
        this.popMenu.add(this.actions.get(EditorActions.Type.VALIDATE));
        this.text.addPopupManager(new PopupManager(){

            public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
                SyntaxCodeEditor.this.popMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            public void hidePopup(BasicEditorPane basicEditorPane) {
                SyntaxCodeEditor.this.popMenu.setVisible(false);
            }
        });
        Toolbar toolbar = new Toolbar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.UNDO)));
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.REDO)));
        toolbar.addSeparator();
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.CUT)));
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.COPY)));
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.PASTE)));
        toolbar.addSeparator();
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.CLEAR)));
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.FORMAT)));
        toolbar.addSeparator();
        toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.VALIDATE)));
        if (properties.getProperty("CONNECTION_NAME") != null) {
            toolbar.addSeparator();
            toolbar.add((Component)new IconButton(this.actions.get(EditorActions.Type.REFRESH_METADATA)));
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)toolbar, "Center");
        JPanel jPanel2 = new JPanel();
        this.resultLabel.setText(OLAPArb.getString("EXPRESSION_EDITOR.RESULT.VALID"));
        jPanel2.add(this.resultLabel);
        jPanel2.add(new IconButton(this.actions.get(EditorActions.Type.VIEWEXCEPTION)));
        jPanel.add((Component)jPanel2, "East");
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
    }

    public void addButton(JButton jButton) {
        if (this.operatorButtons == null) {
            this.operatorButtons = new JToolBar();
            this.operatorButtons.setLayout(new FlowLayout(1));
            this.operatorButtons.setFloatable(false);
            this.operatorButtons.setRollover(true);
            this.add((Component)this.operatorButtons, "South");
        }
        this.operatorButtons.add(jButton);
    }

    public DefaultTreeModel getParseTreeModel() throws SQLException, IOException {
        this.checkSyntax();
        return this.parseTreeModel;
    }

    public void selectNode(ParseNode parseNode) {
        if (parseNode != null && parseNode.getOffset() != -1) {
            this.text.setCaretPosition(parseNode.getOffset());
            this.text.moveCaretPosition(parseNode.getReplaceEnd());
        }
    }

    public boolean isSyntaxValid() throws SQLException, IOException {
        boolean bl = this.checkSyntax();
        boolean bl2 = this.parser.isObjectNamesValid();
        return bl && bl2;
    }

    public boolean checkSyntax() throws SQLException, IOException {
        return this.insertionHandler.checkSyntax();
    }

    public void insertSyntax(TemplateData templateData) {
        this.insertSyntax(templateData, null);
    }

    public void insertSyntax(TemplateData templateData, Point point) {
        this.insertSyntax(templateData, point, true);
    }

    public void insertSyntax(TemplateData templateData, Point point, boolean bl) {
        this.insertionHandler.insertSyntax(templateData, point, bl);
    }

    public void formatText() {
        int n = this.text.getCaretPosition();
        this.text.getCaret().setDot(0);
        this.text.getCaret().moveDot(this.text.getDocument().getLength());
        this.parser.setSyntax(this.getSyntax());
        String string = this.parser.formatSyntax(null);
        this.insertSyntax(new TemplateData(string));
        if (n < this.text.getDocument().getLength()) {
            this.text.setCaretPosition(n);
        } else {
            this.text.setCaretPosition(0);
        }
    }

    public String getSyntax() {
        return this.insertionHandler.getSyntax();
    }

    public String getSelection() {
        return this.insertionHandler.getSelection();
    }

    public void setSelection(int n, int n2) {
        this.text.setCaretPosition(n);
        this.text.moveCaretPosition(n2);
    }

    public void addCodeSelectionListener(CodeSelectionListener codeSelectionListener) {
        this.selHandler.addCodeSelectionListener(codeSelectionListener);
    }

    public void removeCodeSelectionListener(CodeSelectionListener codeSelectionListener) {
        this.selHandler.removeCodeSelectionListener(codeSelectionListener);
    }

    @Override
    public void processToken(String string, String string2, int n) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getPath() != null && treeSelectionEvent.getPath().getLastPathComponent() instanceof ParseNode) {
            ParseNode parseNode = (ParseNode)treeSelectionEvent.getPath().getLastPathComponent();
            if (parseNode == null) {
                return;
            }
            this.selectNode(parseNode);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.text.setEditable(bl);
        this.actions.get(EditorActions.Type.PASTE).setEnabled(bl);
        if (!bl) {
            this.actions.get(EditorActions.Type.UNDO).setEnabled(bl);
            this.actions.get(EditorActions.Type.CLEAR).setEnabled(bl);
            this.text.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        } else {
            this.text.setBackground(UIManager.getColor("TextArea.background"));
        }
    }

    public void addCodeEditorTextListener(CodeEditorTextListener codeEditorTextListener) {
        this.insertionHandler.addCodeEditorTextListener(codeEditorTextListener);
    }

    public void removeCodeEditorTextListener(CodeEditorTextListener codeEditorTextListener) {
        this.insertionHandler.removeCodeEditorTextListener(codeEditorTextListener);
    }

    public EditorActions getActions() {
        return this.actions;
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.text;
    }

    private class EditorTransferHandler
    extends TransferHandler {
        DropHandler dropHandler;

        public EditorTransferHandler(TemplateHandler templateHandler, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin) {
            this.dropHandler = new DropHandler<TransferHandler.TransferSupport>(templateHandler, insertionHandlerEditorPlugin){

                @Override
                protected Object getData(DataFlavor dataFlavor, TransferHandler.TransferSupport transferSupport) {
                    try {
                        return transferSupport.getTransferable().getTransferData(dataFlavor);
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Undable to get Data for Transfer", exception);
                        return null;
                    }
                }

                @Override
                protected boolean isFlavorAvailable(DataFlavor dataFlavor, TransferHandler.TransferSupport transferSupport) {
                    return transferSupport.isDataFlavorSupported(dataFlavor);
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return this.dropHandler.canHandleDrop(transferSupport.getDataFlavors());
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            return this.dropHandler.handleDrop(transferSupport);
        }
    }
}

