/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.syntaxbuilder.DelayedTask;
import oracle.olap.syntaxbuilder.DelayedTimer;
import oracle.olap.syntaxbuilder.editor.CodeSelectionListener;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;

public class CalcSelectionEditorPlugin
implements EditorPlugin {
    private static final Logger LOG = Logger.getLogger(CalcSelectionEditorPlugin.class.getName());
    private BasicEditorPane text;
    private EventListenerList listenerList = new EventListenerList();
    private SyntaxParser parser;
    private Spec spec;
    private DelayedTimer caretTimer;
    private HighlightLayer innerSel;
    private HighlightStyle style;
    private ParseNode innerExpression;

    public CalcSelectionEditorPlugin(Spec spec, SyntaxParser syntaxParser) {
        this.spec = spec;
        this.parser = syntaxParser;
    }

    private String getText(int n, int n2) throws BadLocationException {
        if (n > 0 && n + n2 < this.text.getDocument().getLength()) {
            return this.text.getDocument().getText(n, n2);
        }
        return "";
    }

    public ParseNode getInnerExpression() {
        return this.innerExpression;
    }

    public void install(BasicEditorPane basicEditorPane) {
        long l = System.currentTimeMillis();
        this.caretTimer = new DelayedTimer(new DelayedTask(){

            @Override
            public void doTask() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalcSelectionEditorPlugin.this.checkCaret();
                    }
                });
            }
        }, 800L);
        this.caretTimer.start();
        this.text = basicEditorPane;
        this.innerSel = this.text.createHighlightLayer();
        this.style = this.text.getHighlightRegistry().lookupStyle("syntaxbuilder.inner_selection");
        CustomCaret customCaret = new CustomCaret();
        int n = this.text.getCaret().getBlinkRate();
        customCaret.setBlinkRate(n);
        customCaret.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }
        });
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }
        });
        this.text.setCaret((Caret)((Object)customCaret));
        LOG.finest(String.format("installed calc selection: %s%n", System.currentTimeMillis() - l));
    }

    private void selectionChanged() {
        if (!this.text.isEditable()) {
            return;
        }
        this.innerExpression = null;
        this.caretTimer.requestTask(false);
        this.innerSel.removeAllHighlights();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.caretTimer.cancelTask();
        this.listenerList = new EventListenerList();
        this.text.destroyHighlightLayer(this.innerSel);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void checkCaret() {
        try {
            Object object;
            Object object2 = this.text.getSelectionStart();
            int n = this.text.getSelectionEnd();
            if (n != object2) {
                if (this.parser.isValid()) {
                    object = this.parser.getParseNode((int)object2, n);
                } else {
                    object = new ParseNode();
                    object = this.parser.parseSyntax(this.text.getSelectedText(), (ParseNode)object) && ((DefaultMutableTreeNode)object).getChildCount() > 0 ? ((ParseNode)object).getChildren().get(0) : null;
                }
                if (object != null) {
                    LOG.finest(String.format("ParseNode selected %s,%s, [%s,%s]", ((DefaultMutableTreeNode)object).getUserObject(), ((ParseNode)object).getType(), ((ParseNode)object).getOffset(), ((ParseNode)object).getReplaceEnd()));
                    SpecTreeNode specTreeNode = this.spec.findMatchingNode((ParseNode)object);
                    String string = this.parser.getSyntax();
                    if (specTreeNode != null) {
                        TemplateGUI templateGUI = specTreeNode.getTemplateHelper().getGUI(true);
                        templateGUI.loadParseNode((ParseNode)object, string);
                        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object).breadthFirstEnumeration();
                        if (enumeration.hasMoreElements()) {
                            enumeration.nextElement();
                        }
                        while (enumeration.hasMoreElements()) {
                            ParseNode parseNode = (ParseNode)enumeration.nextElement();
                            if (!"MEASURE".equalsIgnoreCase(parseNode.getParamName()) || Type.MEASURE.toString().equals(parseNode.getType())) continue;
                            this.innerSel.removeAllHighlights();
                            this.innerSel.addHighlight(this.style, parseNode.getReplaceOffset(), parseNode.getReplaceEnd());
                            this.innerExpression = parseNode;
                            break;
                        }
                    }
                    this.fireTokenSelected(string, (int)object2, (ParseNode)object, specTreeNode);
                    return;
                }
            }
            object = this.parser.getTokenBoundaries((int)object2);
            String string = "";
            if (((int[])object).length == 3) {
                string = this.getText(object[0], (int)(object[2] - object[0]));
                object2 = object[0];
            }
            this.fireTokenSelected(string, (int)object2, null, null);
        }
        catch (Exception exception) {
            LOG.log(Level.FINEST, "Issues handling caret changes", exception);
        }
    }

    public void addCodeSelectionListener(CodeSelectionListener codeSelectionListener) {
        this.listenerList.add(CodeSelectionListener.class, codeSelectionListener);
    }

    public void removeCodeSelectionListener(CodeSelectionListener codeSelectionListener) {
        this.listenerList.remove(CodeSelectionListener.class, codeSelectionListener);
    }

    private void fireTokenSelected(String string, int n, ParseNode parseNode, SpecTreeNode specTreeNode) throws SQLException, IOException {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CodeSelectionListener.class) continue;
            ((CodeSelectionListener)objectArray[i + 1]).tokenSelected(string, n, parseNode, specTreeNode);
        }
    }

    private void fireSyntaxClicked(MouseEvent mouseEvent, ParseNode parseNode) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CodeSelectionListener.class) continue;
            ((CodeSelectionListener)objectArray[i + 1]).syntaxClicked(mouseEvent, parseNode);
        }
    }

    private class CustomCaret
    extends BasicCaret {
        int oldPosition = -1;
        boolean unblinking = false;

        private CustomCaret() {
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.unblinking = false;
        }

        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.unblinking = true;
        }

        public boolean isVisible() {
            return this.unblinking || super.isVisible();
        }

        public void mouseClicked(final MouseEvent mouseEvent) {
            ParseNode parseNode;
            boolean bl = true;
            if ((mouseEvent.getClickCount() == 2 || mouseEvent.getClickCount() == 3) && (parseNode = CalcSelectionEditorPlugin.this.parser.getParseNode(this.oldPosition, this.oldPosition)) != null) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    int n;
                    int n2;
                    if (mouseEvent.getClickCount() == 2) {
                        if (this.oldPosition < parseNode.getOffset() || this.oldPosition > parseNode.getEnd()) {
                            return;
                        }
                        n2 = parseNode.getOffset();
                        n = parseNode.getEnd();
                    } else {
                        defaultMutableTreeNode = null;
                        while (parseNode != null && (defaultMutableTreeNode = CalcSelectionEditorPlugin.this.spec.findMatchingNode(parseNode)) == null) {
                            parseNode = (ParseNode)parseNode.getParent();
                        }
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        n2 = parseNode.getOffset();
                        n = parseNode.getReplaceEnd();
                    }
                    bl = false;
                    CalcSelectionEditorPlugin.this.text.setCaretPosition(n2);
                    CalcSelectionEditorPlugin.this.text.moveCaretPosition(n);
                    defaultMutableTreeNode = parseNode;
                    SwingUtilities.invokeLater(new Runnable((ParseNode)defaultMutableTreeNode){
                        final /* synthetic */ ParseNode val$finalNode;
                        {
                            this.val$finalNode = parseNode;
                        }

                        @Override
                        public void run() {
                            CalcSelectionEditorPlugin.this.fireSyntaxClicked(mouseEvent, this.val$finalNode);
                        }
                    });
                    LOG.finest(String.format("Selected parse node %d, [%d,%d,%d]", mouseEvent.getClickCount(), parseNode.getOffset(), parseNode.getEnd(), parseNode.getReplaceEnd()));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
            if (bl && mouseEvent.getClickCount() <= 2) {
                super.mouseClicked(mouseEvent);
            }
            if (mouseEvent.getClickCount() == 1) {
                this.oldPosition = CalcSelectionEditorPlugin.this.text.getCaretPosition();
            }
        }
    }
}

