/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.parsetree.ParseJTree;
import oracle.olap.syntaxbuilder.specification.Spec;

public class CalculatedMeasureDebugPlugin
implements EditorPlugin {
    private Toolbar toolbar;
    private final InsertionHandlerEditorPlugin ihandler;
    private final Spec specParser;
    private final SyntaxParser parser;

    public CalculatedMeasureDebugPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, SyntaxParser syntaxParser) {
        this.ihandler = insertionHandlerEditorPlugin;
        this.specParser = spec;
        this.parser = syntaxParser;
    }

    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.toolbar = codeEditor.getToolbar();
        this.toolbar.add((Action)new AbstractAction("Parse Tree..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final JTextPane jTextPane = new JTextPane();
                jTextPane.setMinimumSize(new Dimension(400, 50));
                final DefaultTreeModel defaultTreeModel = new DefaultTreeModel(CalculatedMeasureDebugPlugin.this.ihandler.getParseRoot());
                final ParseJTree parseJTree = new ParseJTree(defaultTreeModel, CalculatedMeasureDebugPlugin.this.specParser);
                for (int i = 0; i < parseJTree.getRowCount(); ++i) {
                    parseJTree.expandRow(i);
                }
                parseJTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                        if (treePath != null) {
                            ParseNode parseNode = (ParseNode)treePath.getLastPathComponent();
                            jTextPane.setText(String.format("Name=%s  %nType=%s  %nBounds=[%d,%d][%d,%d]%nParamName=%s %nPattern=%s", new Object[]{parseNode.getUserObject(), parseNode.getType(), parseNode.getOffset(), parseNode.getEnd(), parseNode.getReplaceOffset(), parseNode.getReplaceEnd(), parseNode.getParamName(), parseNode.getPatternType()}));
                        }
                    }
                });
                CalculatedMeasureDebugPlugin.this.ihandler.addCodeEditorTextListener(new CodeEditorTextListener(){

                    @Override
                    public void syntaxChecked(String string, boolean bl) {
                        defaultTreeModel.reload();
                        for (int i = 0; i < parseJTree.getRowCount(); ++i) {
                            parseJTree.expandRow(i);
                        }
                    }

                    @Override
                    public void textChanged(String string) {
                    }
                });
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)new JScrollPane(parseJTree), "Center");
                jPanel.add((Component)jTextPane, "South");
                JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
                JDialog jDialog = jOptionPane.createDialog(jPanel, "Calculation Syntax Parse Tree");
                jDialog.setResizable(true);
                jDialog.setSize(500, 500);
                jDialog.setModalityType(Dialog.ModalityType.MODELESS);
                jDialog.setVisible(true);
            }
        });
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

