/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.phighlight.TooltipPlugin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.javatools.db.DBException;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.syntaxparser.SyntaxParserStateListener;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperFactoryImpl;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureEditorHelp;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.navigator.calculatedmeasure.DockableSpecTree;
import oracle.olap.syntaxbuilder.editor.EditorActions;
import oracle.olap.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.CalculatedMeasureDebugPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.CalculatedMeasureDropPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.CalculatedMeasureFoldingPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.CalculatedMeasureToolbar;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.TemplateHandlerEmbedEditorPlugin;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPSpec;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;

public class CalculatedMeasurePluginsFactory
implements EditorPluginsFactory {
    Logger LOG = Logger.getLogger(CalculatedMeasurePluginsFactory.class.getName());
    public static final String CONTEXT = "MEASURE_EXPRESSION";

    public List<?> createPlugins(Context context) {
        long l = System.currentTimeMillis();
        this.LOG.finest("creating plugins?" + context.getNode().getClass().getName());
        if (context.getNode() instanceof CalculatedMeasureNode) {
            Connection connection;
            final CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)context.getNode();
            this.LOG.finest(String.format("creating plugins for: %s.%s", calculatedMeasureNode.getCubeName(), calculatedMeasureNode.getMeasureName()));
            ArrayList<Object> arrayList = new ArrayList<Object>(3);
            final DockableSpecTree dockableSpecTree = DockableSpecTree.getInstance();
            Properties properties = this.buildProperties(calculatedMeasureNode);
            boolean bl = false;
            try {
                connection = Connections.getInstance().getConnection(calculatedMeasureNode.getConnectionName());
            }
            catch (DBException dBException) {
                this.LOG.log(Level.SEVERE, "Error fetching connection for calculated measure plugins.", dBException);
                return Collections.emptyList();
            }
            DatabaseImpl databaseImpl = new DatabaseImpl(connection);
            try {
                Spec spec;
                boolean bl2 = OLAPMetadataCache.hasForConnection(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName());
                final OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), properties);
                InsertionHandlerEditorPlugin insertionHandlerEditorPlugin = new InsertionHandlerEditorPlugin(oLAPISyntaxParser, calculatedMeasureNode, bl2);
                this.LOG.finest(String.format("simple init variables: %s%n", System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                if (dockableSpecTree.hasTreeForURL(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName())) {
                    dockableSpecTree.setURL(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName());
                    spec = dockableSpecTree.getSpec();
                    this.LOG.finest(String.format("reutilizing spec: %s%n", System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                } else {
                    try {
                        bl = true;
                        spec = this.buildSpecParser(properties, oLAPISyntaxParser, databaseImpl, new OLAPFetchIcon(), calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.LOG.log(Level.SEVERE, "Error creating spec parser for calculated measure plugins.", unsupportedEncodingException);
                        return Collections.emptyList();
                    }
                    this.LOG.finest(String.format("built spec for cube %s in %s%n", calculatedMeasureNode.getCubeName(), System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                }
                TemplateHandlerEmbedEditorPlugin templateHandlerEmbedEditorPlugin = new TemplateHandlerEmbedEditorPlugin(insertionHandlerEditorPlugin, spec);
                CalcSelectionEditorPlugin calcSelectionEditorPlugin = new CalcSelectionEditorPlugin(spec, oLAPISyntaxParser);
                EditorActions editorActions = new EditorActions(new OLAPFetchIcon(), insertionHandlerEditorPlugin, calcSelectionEditorPlugin, null, spec, oLAPISyntaxParser, null, calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName());
                editorActions.setView(context.getView());
                this.LOG.finest(String.format("built plugins: %s%n", System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                if (bl) {
                    if (bl2) {
                        spec.initialize();
                        dockableSpecTree.setSpecParser(spec, calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName());
                        this.LOG.finest(String.format("initialized spec: %s%n", System.currentTimeMillis() - l));
                    } else {
                        oLAPISyntaxParser.addSyntaxParserStateListener(new SyntaxParserStateListener(){

                            @Override
                            public void stateChanged(boolean bl) {
                                final 1 var2_2 = this;
                                if (bl) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            oLAPISyntaxParser.removeSyntaxParserStateListener(var2_2);
                                            long l = System.currentTimeMillis();
                                            spec.initialize();
                                            CalculatedMeasurePluginsFactory.this.LOG.finest(String.format("initialized spec in call back: %s%n", System.currentTimeMillis() - l));
                                            dockableSpecTree.setSpecParser(spec, calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName());
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
                l = System.currentTimeMillis();
                arrayList.add(new CalculatedMeasureToolbar(insertionHandlerEditorPlugin, spec, oLAPISyntaxParser, calcSelectionEditorPlugin, editorActions));
                arrayList.add((Object)new CalculatedMeasureDropPlugin(templateHandlerEmbedEditorPlugin, insertionHandlerEditorPlugin));
                arrayList.add(insertionHandlerEditorPlugin);
                arrayList.add(calcSelectionEditorPlugin);
                arrayList.add(templateHandlerEmbedEditorPlugin);
                calculatedMeasureNode.setTemplateHandler(templateHandlerEmbedEditorPlugin);
                dockableSpecTree.setTemplateHandler(templateHandlerEmbedEditorPlugin);
                calcSelectionEditorPlugin.addCodeSelectionListener(templateHandlerEmbedEditorPlugin);
                arrayList.add(new CalculatedMeasureEditorHelp());
                arrayList.add((Object)new CalculatedMeasureFoldingPlugin(oLAPISyntaxParser, insertionHandlerEditorPlugin));
                if (Boolean.parseBoolean(System.getProperty("sqldev.debug", "false"))) {
                    arrayList.add(new CalculatedMeasureDebugPlugin(insertionHandlerEditorPlugin, spec, oLAPISyntaxParser));
                }
                TooltipPlugin tooltipPlugin = new TooltipPlugin();
                arrayList.add(tooltipPlugin);
                tooltipPlugin.addTooltip((TooltipMessage)insertionHandlerEditorPlugin);
                this.LOG.finest(String.format("plugin setup: %s%n", System.currentTimeMillis() - l));
            }
            catch (Throwable throwable) {
                this.LOG.log(Level.SEVERE, String.format("Failed to instantiate plugins for %s", calculatedMeasureNode.getObjectName()));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private Spec buildSpecParser(Properties properties, OLAPISyntaxParser oLAPISyntaxParser, DatabaseImpl databaseImpl, FetchIcon fetchIcon, String string, String string2) throws UnsupportedEncodingException {
        OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
        OLAPResources oLAPResources = new OLAPResources("/oracle/olap/app/calcfactory/ui/calcs.xml");
        InputStreamReader inputStreamReader = new InputStreamReader(CalculatedMeasurePluginsFactory.class.getResourceAsStream("/oracle/olap/measureexpression/OLAPExpressionSpec.xml"), "UTF-8");
        TemplateHelperFactoryImpl templateHelperFactoryImpl = new TemplateHelperFactoryImpl(properties, databaseImpl, string, string2, oLAPISyntaxParser, oLAPResources, fetchIcon);
        OLAPSpec oLAPSpec = new OLAPSpec(properties, inputStreamReader, oLAPISyntaxParser, templateHelperFactoryImpl, oLAPErrorDisplay, oLAPResources, fetchIcon, null);
        return oLAPSpec;
    }

    private Properties buildProperties(CalculatedMeasureNode calculatedMeasureNode) {
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", calculatedMeasureNode.getSchemaName());
        properties.setProperty("CUBE", calculatedMeasureNode.getCubeName());
        properties.setProperty("CONTEXT", CONTEXT);
        return properties;
    }
}

