/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.SyntaxParserStateListener;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.syntaxbuilder.DelayedTask;
import oracle.olap.syntaxbuilder.DelayedTimer;
import oracle.olap.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerHelper;

public class InsertionHandlerEditorPlugin
implements EditorPlugin,
TooltipMessage {
    private static Logger LOG = Logger.getLogger(InsertionHandlerEditorPlugin.class.getName());
    private BasicEditorPane text;
    private final SyntaxParser parser;
    private final CalculatedMeasureNode navNode;
    private DelayedTimer syntaxTimer;
    private final ParseNode parseRoot = new ParseNode();
    private boolean isValid;
    private DocumentListener docListener;
    private EventListenerList listenerList = new EventListenerList();
    private boolean insertingTemplate;
    private HighlightStyle style;
    private HighlightLayer squiglies;
    private boolean checkOnInstall;
    private InsertionHandlerHelper insertHelper;
    private SyntaxParserStateListener parserStateListener = new SyntaxParserStateListener(){

        @Override
        public void stateChanged(boolean bl) {
            if (bl) {
                InsertionHandlerEditorPlugin.this.syntaxTimer.requestTask(false);
            }
        }
    };

    public InsertionHandlerEditorPlugin(SyntaxParser syntaxParser) {
        this(syntaxParser, null, true);
    }

    public InsertionHandlerEditorPlugin(SyntaxParser syntaxParser, CalculatedMeasureNode calculatedMeasureNode, boolean bl) {
        this.parser = syntaxParser;
        this.parser.addSyntaxParserStateListener(this.parserStateListener);
        this.navNode = calculatedMeasureNode;
        this.checkOnInstall = bl;
    }

    public void insertSyntax(TemplateData templateData) {
        this.insertSyntax(templateData, null);
    }

    public String getSelection() {
        String string = this.text.getSelectedText();
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public String getSyntax() {
        String string;
        try {
            string = this.text.getDocument().getText(0, this.text.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            string = "";
        }
        return string;
    }

    public void insertSyntax(TemplateData templateData, Point point) {
        this.insertSyntax(templateData, point, true);
    }

    private void adjustCaret(int n, int n2, Point point) {
        if (point != null && this.text.getCaret().getDot() == this.text.getCaret().getMark()) {
            Point point2 = new Point(point);
            Point point3 = this.text.getLocationOnScreen();
            point2.setLocation(point2.x - point3.x, point2.y - point3.y);
            if (this.text.getBounds().contains(point2)) {
                this.text.setCaretPosition(this.text.viewToModel(point2));
            }
        } else if (n != -1 && n2 != -1) {
            this.text.getCaret().setDot(n);
            this.text.getCaret().moveDot(n + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSyntax(TemplateData templateData, Point point, boolean bl) {
        if (templateData == null) {
            return;
        }
        try {
            this.insertingTemplate = true;
            String string = templateData.getSyntax();
            this.adjustCaret(templateData.getOffset(), templateData.getLength(), point);
            int n = this.text.getCaret().getDot();
            int n2 = this.text.getCaret().getMark();
            TemplateData templateData2 = null;
            int n3 = this.text.getDocument().getLength();
            switch (templateData.getMode()) {
                case CANCEL: {
                    return;
                }
                case APPEND: {
                    string = String.format("%s%n", string);
                    this.text.setCaretPosition(n3);
                    break;
                }
                case REPLACEALL: {
                    n = 0;
                    n2 = n3;
                    this.text.setCaretPosition(n);
                    this.text.moveCaretPosition(n2);
                    break;
                }
                case INSERT: {
                    this.text.setCaretPosition(Math.max(n, n2));
                    n = this.text.getCaretPosition();
                    n2 = this.text.getCaretPosition();
                    templateData2 = this.useInsertHelper(string);
                    break;
                }
                case REPLACE: 
                case WRAP: {
                    templateData2 = this.useInsertHelper(string);
                    break;
                }
                case OK: {
                    if (n == n2) {
                        return;
                    }
                    templateData2 = this.useInsertHelper(string);
                }
            }
            if (templateData2 != null) {
                string = templateData2.getSyntax();
            }
            if (string != null && !string.equals("")) {
                LOG.finest(String.format("replacingText caret=%d, dot = %d, mark = %d, length = %d", this.text.getCaretPosition(), n, n2, n3));
                this.text.replaceSelection(string);
                n = Math.min(n, n2);
                if (templateData.getMode() == TemplateData.Mode.REPLACEALL) {
                    this.text.setCaretPosition(0);
                } else if (templateData2 != null) {
                    int n4 = n + templateData2.getOffset();
                    this.text.setCaretPosition(n4);
                    this.text.moveCaretPosition(n4 + templateData2.getLength());
                } else {
                    this.text.setCaretPosition(n);
                    this.text.moveCaretPosition(n + string.length());
                }
            }
        }
        finally {
            this.insertingTemplate = false;
            this.syntaxTimer.requestTask(true);
            this.fireCodeEditorTextChanged();
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)this.text);
            if (codeEditor != null) {
                EditorManager.getEditorManager().openEditor(new OpenEditorOptions(codeEditor.getContext()));
                codeEditor.updateVisibleActions();
            }
        }
    }

    private TemplateData useInsertHelper(String string) {
        if (this.insertHelper != null && string != null && !string.trim().isEmpty()) {
            return this.insertHelper.preprocessInsertionText(this.text, string);
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.text = basicEditorPane;
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.check();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.check();
            }

            void check() {
                if (!InsertionHandlerEditorPlugin.this.insertingTemplate) {
                    InsertionHandlerEditorPlugin.this.syntaxTimer.requestTask(false);
                    if (CodeEditor.getContext((BasicEditorPane)InsertionHandlerEditorPlugin.this.text) != null) {
                        CodeEditor.getContext((BasicEditorPane)InsertionHandlerEditorPlugin.this.text).getView().updateVisibleActions();
                    }
                    InsertionHandlerEditorPlugin.this.fireCodeEditorTextChanged();
                }
            }
        };
        this.text.getDocument().addDocumentListener(this.docListener);
        this.syntaxTimer = new DelayedTimer(new DelayedTask(){

            @Override
            public void doTask() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InsertionHandlerEditorPlugin.this.checkSyntax();
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                        }
                    }
                });
            }
        }, 700L);
        this.syntaxTimer.start();
        this.style = this.text.getHighlightRegistry().lookupStyle("syntaxbuilder.squiggly");
        this.squiglies = this.text.createHighlightLayer();
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)this.text);
        if (codeEditor != null && this.checkOnInstall) {
            try {
                this.checkSyntax();
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }
        this.deinstallStatusEditorPlugin();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.syntaxTimer.cancelTask();
        basicEditorPane.getDocument().removeDocumentListener(this.docListener);
        this.listenerList = new EventListenerList();
        this.syntaxTimer.endTask();
        this.text.destroyHighlightLayer(this.squiglies);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void fireCodeEditorSyntaxChecked(String string, boolean bl) throws SQLException, IOException {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CodeEditorTextListener.class) continue;
            ((CodeEditorTextListener)objectArray[i + 1]).syntaxChecked(string, bl);
        }
    }

    private void fireCodeEditorTextChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        String string = this.getSyntax();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CodeEditorTextListener.class) continue;
            ((CodeEditorTextListener)objectArray[i + 1]).textChanged(string);
        }
    }

    public void addCodeEditorTextListener(CodeEditorTextListener codeEditorTextListener) {
        this.listenerList.add(CodeEditorTextListener.class, codeEditorTextListener);
    }

    public void removeCodeEditorTextListener(CodeEditorTextListener codeEditorTextListener) {
        this.listenerList.remove(CodeEditorTextListener.class, codeEditorTextListener);
    }

    public ParseNode getParseRoot() {
        return this.parseRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSyntax() throws SQLException, IOException {
        DelayedTimer delayedTimer = this.syntaxTimer;
        synchronized (delayedTimer) {
            String string = this.getSyntax();
            this.syntaxTimer.cancelTask();
            this.parser.setSyntax(string);
            this.parser.tokenize(null);
            this.isValid = this.parser.parseSyntax(this.parseRoot);
            this.updateHighlights(this.parser.getExceptions());
            this.fireCodeEditorSyntaxChecked(string, this.isValid);
            return this.isValid;
        }
    }

    private void updateHighlights(List<Throwable> list) {
        final List<Throwable> list2 = list;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicEditorOverview basicEditorOverview = null;
                String string = "audit-errors";
                HighlightStyle highlightStyle = InsertionHandlerEditorPlugin.this.style;
                CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)InsertionHandlerEditorPlugin.this.text);
                if (codeEditor != null) {
                    basicEditorOverview = codeEditor.getOverview();
                    basicEditorOverview.removeMarks((Object)string);
                }
                InsertionHandlerEditorPlugin.this.squiglies.removeAllHighlights();
                int n = InsertionHandlerEditorPlugin.this.text.getLineCount();
                if (n == 0) {
                    return;
                }
                if (InsertionHandlerEditorPlugin.this.navNode != null) {
                    for (Throwable throwable : list2) {
                        Map<String, Integer> map = InsertionHandlerEditorPlugin.this.navNode.getCompileErrorLocation(throwable);
                        int n2 = map.get("COMPILE_ERROR_LINE_NUMBER");
                        int n3 = map.get("COMPILE_ERROR_COLUMN_NUMBER");
                        if (--n2 < 0) {
                            n2 = 0;
                        } else if (n2 >= n) {
                            n2 = n - 1;
                        }
                        try {
                            int n4 = InsertionHandlerEditorPlugin.this.text.getLineCount();
                            if (n4 < n2) {
                                LOG.log(Level.SEVERE, "Could not highlight: #lines = " + n4 + ", line=" + n2);
                                return;
                            }
                            int n5 = InsertionHandlerEditorPlugin.this.text.getLineStartOffset(n2);
                            int n6 = n5 + n3 - 1;
                            if (n6 < 0) {
                                n6 = 0;
                            }
                            int n7 = InsertionHandlerEditorPlugin.this.getErrorEndOffset(n2, n6);
                            InsertionHandlerEditorPlugin.this.squiglies.addHighlight(highlightStyle, n6, n7);
                            if (basicEditorOverview == null) continue;
                            basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(InsertionHandlerEditorPlugin.this.text, Integer.valueOf(n6), Integer.valueOf(n7), 2.0f, OverviewStatus.ERROR), (Object)string);
                        }
                        catch (Exception exception) {
                            LOG.log(Level.SEVERE, "Could not highlight", exception);
                        }
                    }
                }
                if (basicEditorOverview != null) {
                    OverviewStatus overviewStatus = basicEditorOverview.getStatus();
                    if (0 < list2.size()) {
                        overviewStatus.setColor(OverviewStatus.ERROR);
                    } else {
                        overviewStatus.setColor(OverviewStatus.OK);
                    }
                }
            }
        });
    }

    private int getErrorEndOffset(int n, int n2) {
        int n3 = n2 + 1;
        int n4 = this.text.getLineEndOffset(n);
        String string = null;
        try {
            string = this.text.getText(n2, n4 - n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (string != null) {
            int n5 = string.indexOf(" ");
            int n6 = string.indexOf("\n");
            n3 = n5 > 0 ? n2 + n5 : (n6 > 0 ? n2 + n6 : n4);
        }
        return n3;
    }

    public String getToolTipText(int n) {
        List<Throwable> list = this.parser.getExceptions();
        CalculatedMeasureNode calculatedMeasureNode = this.navNode;
        int n2 = this.text.getLineCount();
        if (n2 == 0) {
            return null;
        }
        if (list != null && 0 < list.size() && calculatedMeasureNode != null) {
            for (Throwable throwable : list) {
                Map<String, Integer> map = calculatedMeasureNode.getCompileErrorLocation(throwable);
                int n3 = map.get("COMPILE_ERROR_LINE_NUMBER");
                int n4 = map.get("COMPILE_ERROR_COLUMN_NUMBER");
                if (--n3 < 0) {
                    n3 = 0;
                } else if (n3 >= n2) {
                    n3 = n2 - 1;
                }
                int n5 = this.text.getLineStartOffset(n3);
                int n6 = n5 + n4 - 1;
                int n7 = this.getErrorEndOffset(n3, n6);
                if (n < n6 || n > n7) continue;
                String[] stringArray = throwable.getLocalizedMessage().split("\n");
                String string = stringArray[0];
                if (stringArray.length > 1) {
                    string = string + "...";
                }
                return string;
            }
        }
        return null;
    }

    private void deinstallStatusEditorPlugin() {
        try {
            Field field = BasicEditorPane.class.getDeclaredField("pluginList");
            field.setAccessible(true);
            ArrayList arrayList = (ArrayList)field.get(this.text);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (!(e instanceof StatusEditorPlugin)) continue;
                this.text.deinstallPlugin((EditorPlugin)e);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void setInsertHelper(InsertionHandlerHelper insertionHandlerHelper) {
        this.insertHelper = insertionHandlerHelper;
    }
}

