/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatedialog.SyntaxListener;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.app.templates.templatedialog.TemplateHelperListener;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandlerPopup;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;

public class TemplateHandlerEmbedEditorPlugin
extends TemplateHandlerPopup
implements EditorPlugin {
    private boolean ignoreTokenSelection = false;
    private static final Logger LOG = Logger.getLogger(TemplateHandlerEmbedEditorPlugin.class.getName());
    private static final TemplateData.Mode[] EMBEDINSERT = new TemplateData.Mode[]{TemplateData.Mode.WRAP};
    private Container bottomMargin;
    private JPanel templatePanel;
    private TemplateGUI gui;
    private TemplateHelper helper;
    private final SyntaxListener listener = new SyntaxListener(){

        @Override
        public void syntaxChanged(String string) {
            TemplateHandlerEmbedEditorPlugin.this.ignoreTokenSelection = true;
            TemplateData templateData = new TemplateData(string, TemplateData.Mode.OK);
            TemplateHandlerEmbedEditorPlugin.this.ihandler.insertSyntax(TemplateHandlerEmbedEditorPlugin.this.formatTemplateData(templateData), null, false);
            TemplateHandlerEmbedEditorPlugin.this.ignoreTokenSelection = false;
        }
    };
    private final TemplateHelperListener reinitListener = new TemplateHelperListener(){

        @Override
        public void helperReinitialized() {
            if (TemplateHandlerEmbedEditorPlugin.this.helper != null) {
                TemplateHandlerEmbedEditorPlugin.this.remove();
                TemplateHandlerEmbedEditorPlugin.this.helper.removeTemplateHelperListener(TemplateHandlerEmbedEditorPlugin.this.reinitListener);
                TemplateHandlerEmbedEditorPlugin.this.helper = null;
            }
            if (TemplateHandlerEmbedEditorPlugin.this.gui != null) {
                TemplateHandlerEmbedEditorPlugin.this.gui.removeSyntaxListener(TemplateHandlerEmbedEditorPlugin.this.listener);
                TemplateHandlerEmbedEditorPlugin.this.gui.dispose();
                TemplateHandlerEmbedEditorPlugin.this.gui = null;
            }
        }
    };

    public TemplateHandlerEmbedEditorPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec) {
        super(insertionHandlerEditorPlugin, spec, (Component)Ide.getMainWindow());
    }

    public TemplateHandlerEmbedEditorPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, Container container) {
        super(insertionHandlerEditorPlugin, spec, (Component)Ide.getMainWindow());
        this.bottomMargin = container;
    }

    @Override
    public void insertNode(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray) {
        if (modeArray.length == 1 && modeArray[0] != TemplateData.Mode.OK) {
            super.insertNode(specTreeNode, modeArray);
        }
    }

    @Override
    public TemplateData callTemplate(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray) throws SQLException, IOException {
        LOG.finest(String.format("Inserting node %s", specTreeNode));
        if (specTreeNode == null || !specTreeNode.isInsertable()) {
            return null;
        }
        TemplateHelper templateHelper = specTreeNode.getTemplateHelper();
        if (templateHelper == null) {
            TemplateData templateData = new TemplateData(specTreeNode.getTemplate());
            return templateData;
        }
        LOG.finest(String.format("Inserting template node %s", specTreeNode));
        TemplateGUI templateGUI = this.getGui(templateHelper);
        templateGUI.setValueMap(this.createValueMap());
        JPanel jPanel = this.templatePanel;
        this.templatePanel = this.buildPanel(templateGUI, templateHelper.getTitle(), modeArray);
        this.displayPanel(jPanel, this.templatePanel);
        TemplateData.Mode[] modeArray2 = templateHelper.availableModes(modeArray);
        TemplateData templateData = modeArray2.length > 0 ? templateGUI.getSyntax(modeArray[0]) : templateGUI.getSyntax(TemplateData.Mode.INSERT);
        return this.formatTemplateData(templateData);
    }

    private void displayPanel(final JPanel jPanel, final JPanel jPanel2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jPanel != null) {
                    TemplateHandlerEmbedEditorPlugin.this.bottomMargin.remove(jPanel);
                }
                TemplateHandlerEmbedEditorPlugin.this.bottomMargin.add((Component)jPanel2, "South");
                TemplateHandlerEmbedEditorPlugin.this.bottomMargin.getParent().validate();
                jPanel2.setVisible(false);
                jPanel2.setVisible(true);
            }
        });
    }

    @Override
    public void syntaxClicked(MouseEvent mouseEvent, ParseNode parseNode) {
    }

    @Override
    public void tokenSelected(String string, int n, ParseNode parseNode, SpecTreeNode specTreeNode) {
        if (parseNode != null && !this.ignoreTokenSelection) {
            TemplateHelper templateHelper;
            SpecTreeNode specTreeNode2;
            SpecTreeNode specTreeNode3 = specTreeNode2 = specTreeNode == null ? this.spec.findMatchingNode(parseNode) : specTreeNode;
            if (specTreeNode2 != null && (templateHelper = specTreeNode2.getTemplateHelper()) != null) {
                TemplateGUI templateGUI = this.getGui(templateHelper);
                try {
                    String string2 = this.ihandler.getSyntax();
                    if (parseNode.getReplaceOffset() == n) {
                        templateGUI.loadParseNode(parseNode, string2);
                    } else if (parseNode.getReplaceOffset() > 0 && parseNode.getReplaceEnd() <= string2.length()) {
                        templateGUI.loadParseNode(parseNode, string2.substring(parseNode.getReplaceOffset(), parseNode.getReplaceEnd()));
                    }
                    this.callTemplate(specTreeNode2, EDITBUTTONS);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, "loadParseNode failed!", throwable);
                }
            }
        } else {
            this.remove();
        }
    }

    private void remove() {
        if (this.templatePanel != null) {
            this.bottomMargin.remove(this.templatePanel);
            if (this.bottomMargin.getParent() != null) {
                this.bottomMargin.getParent().validate();
            }
            this.templatePanel = null;
        }
    }

    @Override
    public void insertNode(SpecTreeNode specTreeNode) {
        this.insertNode(specTreeNode, EMBEDINSERT);
    }

    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.bottomMargin = (Container)codeEditor.getFixedBottomMargin();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private TemplateGUI getGui(TemplateHelper templateHelper) {
        if (templateHelper != this.helper) {
            if (this.helper != null) {
                this.helper.removeTemplateHelperListener(this.reinitListener);
            }
            this.helper = templateHelper;
            this.helper.addTemplateHelperListener(this.reinitListener);
            if (this.gui != null) {
                this.gui.removeSyntaxListener(this.listener);
                this.gui.dispose();
            }
            this.gui = templateHelper.getGUI(false);
            this.gui.addSyntaxListener(this.listener);
        }
        return this.gui;
    }

    private TemplateData formatTemplateData(TemplateData templateData) {
        if (templateData == null || templateData.getSyntax() == null) {
            return null;
        }
        String string = this.spec.getSyntaxParser().formatSyntax(templateData.getSyntax());
        if (this.spec.getSyntaxParser().parseSyntax(string, null)) {
            return new TemplateData(string, templateData);
        }
        return templateData;
    }

    private JPanel buildPanel(final TemplateGUI templateGUI, String string, TemplateData.Mode[] modeArray) {
        String string2 = this.ihandler.getSelection();
        String string3 = this.ihandler.getSyntax();
        if (string3 != null && string3.equals(string2)) {
            string3 = null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("selection", string2);
        hashMap.put("contents", string3);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        font = new Font(font.getFontName(), 1, (int)((double)font.getSize() * 1.2));
        jLabel.setFont(font);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "North");
        Component component = templateGUI.getComponent();
        jPanel.add(component, "Center");
        if (modeArray.length > 1) {
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel.add((Component)jPanel3, "South");
            for (final TemplateData.Mode mode : modeArray) {
                jPanel3.add(new JButton(new AbstractAction(mode.toString()){
                    {
                        super(string);
                        this.putValue("mode", (Object)mode);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            TemplateData.Mode mode2 = (TemplateData.Mode)((Object)this.getValue("mode"));
                            TemplateData templateData = templateGUI.getSyntax(mode2);
                            TemplateHandlerEmbedEditorPlugin.this.ihandler.insertSyntax(TemplateHandlerEmbedEditorPlugin.this.formatTemplateData(templateData));
                            TemplateHandlerEmbedEditorPlugin.this.remove();
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                        }
                    }
                }));
            }
        }
        return jPanel;
    }
}

