/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.Resources;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.app.templates.templatedialog.TemplateHelperFactory;
import oracle.olap.app.templates.templatelist.CalcToTemplate;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.editor.SyntaxCodeEditor;
import oracle.olap.syntaxbuilder.spec.BaseSpecNode;
import oracle.olap.syntaxbuilder.spec.Category;
import oracle.olap.syntaxbuilder.spec.Doc;
import oracle.olap.syntaxbuilder.spec.File;
import oracle.olap.syntaxbuilder.spec.Filter;
import oracle.olap.syntaxbuilder.spec.FilterIterator;
import oracle.olap.syntaxbuilder.spec.Insertable;
import oracle.olap.syntaxbuilder.spec.NodeWithContext;
import oracle.olap.syntaxbuilder.spec.Reserved;
import oracle.olap.syntaxbuilder.spec.Spec;
import oracle.olap.syntaxbuilder.spec.Sql;
import oracle.olap.syntaxbuilder.spec.SqlParam;
import oracle.olap.syntaxbuilder.spec.Unseen;
import oracle.olap.syntaxbuilder.spec.XmlProperty;
import oracle.olap.syntaxbuilder.specification.LazyLoader;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;

public class OLAPSpec
implements oracle.olap.syntaxbuilder.specification.Spec {
    private static final String PACKAGE = "oracle.olap.syntaxbuilder.spec";
    private static final String TRANSFORM_PACKAGE = "oracle.olap.app.templates.templatelist";
    private static final String ERROR_TITLE = "EXPRESSION_EDITOR_SPEC_ERROR_TITLE";
    private static final String ERROR_MESSAGE = "EXPRESSION_EDITOR_SPEC_ERROR_TITLE";
    private static final String SQL_ERROR_MESSAGE = "EXPRESSION_EDITOR_SPEC_SQLERROR_MESSAGE";
    private static final String COL_NAME = "name";
    private static final String COL_TEMPLATE = "template";
    private Charset CHARSET;
    private final Properties props;
    private final ErrorDisplay errorDisplay;
    private static final Logger LOG = Logger.getLogger(OLAPSpec.class.getName());
    private final Resources resources;
    private final String[] context;
    private final HashMap<String, String> docs = new HashMap();
    private final boolean includeTimeTemplates;
    private FetchIcon fetchIcon;
    private SpecTreeNode defaultSelection;
    private SyntaxCodeEditor editor;
    private TemplateHelperFactory thFactory;
    private Reader spec;
    private SyntaxParser syntaxParser;
    private HashMap<String, SpecTreeNode> insertables;
    private ArrayList<SpecTreeNode> flatNodeList;
    private SpecTreeNode root = new SpecTreeNode();
    private ArrayList<SpecTreeNode> buttonNodes = new ArrayList();
    private DBUtil dbUtil;
    private Connection conn;
    private ArrayList<SpecTreeNode> helpers = new ArrayList();
    private final Filter<NodeWithContext> specFilter = new Filter<NodeWithContext>(){

        @Override
        public boolean matches(NodeWithContext nodeWithContext) {
            return OLAPSpec.this.matchesContext(nodeWithContext.getContext());
        }
    };
    private final Filter<Template> tFilter = new Filter<Template>(){

        @Override
        public boolean matches(Template template) {
            return OLAPSpec.this.matchesContext(template.getContext()) && template.getTemplateNameFormat() == null;
        }
    };
    private final Filter<TemplateGroup> groupFilter = new Filter<TemplateGroup>(){

        @Override
        public boolean matches(TemplateGroup templateGroup) {
            if (!OLAPSpec.this.includeTimeTemplates && templateGroup.isTimeTemplate()) {
                return false;
            }
            return !templateGroup.isContainer() || OLAPSpec.this.matchesContext(templateGroup.getContext());
        }
    };

    private boolean matchesContext(String string) {
        if (this.context == null || string == null) {
            return true;
        }
        for (String string2 : this.context) {
            String string3 = string;
            int n = string3.indexOf(string2);
            int n2 = n + string2.length();
            if (n == -1 || n != 0 && string3.charAt(n - 1) != '|' || n2 != string3.length() && string3.charAt(n2) != '|') continue;
            return true;
        }
        return false;
    }

    public OLAPSpec(Properties properties, Reader reader, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, ErrorDisplay errorDisplay, Resources resources, FetchIcon fetchIcon, Connection connection) {
        this.props = properties;
        this.spec = reader;
        this.errorDisplay = errorDisplay;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        if (connection != null) {
            this.dbUtil = DBUtil.getInstance((Connection)connection);
            this.conn = connection;
        }
        this.thFactory = templateHelperFactory;
        if (Charset.isSupported("UTF-8")) {
            try {
                this.CHARSET = Charset.forName("UTF-8");
            }
            catch (Exception exception) {
                this.CHARSET = Charset.defaultCharset();
            }
        } else {
            this.CHARSET = Charset.defaultCharset();
        }
        this.includeTimeTemplates = Boolean.parseBoolean(properties.getProperty("IS_TIME_CUBE", Boolean.toString(true)));
        this.syntaxParser = syntaxParser;
        this.context = properties.getProperty("CONTEXT") != null ? properties.getProperty("CONTEXT").split("\\|") : null;
    }

    @Override
    public SpecTreeNode initialize() {
        if (this.spec != null) {
            this.root = this.parseReader(this.root, this.spec);
            this.spec = null;
            return this.root;
        }
        return null;
    }

    @Override
    public SpecTreeNode parseReader(SpecTreeNode specTreeNode, Reader reader) {
        return this.parseReader(specTreeNode, reader, PACKAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpecTreeNode parseReader(SpecTreeNode specTreeNode, Reader reader, String string) {
        try {
            Object object = string.equals(TRANSFORM_PACKAGE) ? JavaXMLBind.BindToJavaStr(CalcToTemplate.transform(new StreamSource(reader)), string, null) : JavaXMLBind.BindToJava(reader, string, null);
            this.processObject(specTreeNode, object);
            SpecTreeNode specTreeNode2 = specTreeNode;
            return specTreeNode2;
        }
        catch (Exception exception) {
            this.errorDisplay.show(exception, this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), this.editor);
            LOG.log(Level.SEVERE, this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), exception);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private SpecTreeNode parseString(SpecTreeNode specTreeNode, String string) {
        try {
            Object object = JavaXMLBind.BindToJavaStr(string, PACKAGE, null);
            this.processObject(specTreeNode, object);
            return specTreeNode;
        }
        catch (Exception exception) {
            this.errorDisplay.show(exception, this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), this.editor);
            LOG.log(Level.SEVERE, this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), exception);
            return null;
        }
    }

    private void processObject(SpecTreeNode specTreeNode, Object object) {
        if (object instanceof Spec) {
            this.processBase(specTreeNode, (BaseSpecNode)object);
        } else if (object instanceof TemplateList) {
            this.processTemplateList(specTreeNode, (TemplateList)object);
        }
    }

    private void processBase(SpecTreeNode specTreeNode, BaseSpecNode baseSpecNode) {
        this.processXmlProperties(specTreeNode, baseSpecNode.getXmlProperties());
        this.processCategories(specTreeNode, baseSpecNode.getCategories());
        this.processInsertables(specTreeNode, baseSpecNode.getInsertables());
        this.processSqls(specTreeNode, baseSpecNode.getSqls());
        this.processFiles(specTreeNode, baseSpecNode.getFiles());
        this.processDocs(baseSpecNode.getDocs());
        this.processUnseens(specTreeNode, baseSpecNode.getUnseen());
    }

    private void processTemplateList(SpecTreeNode specTreeNode, TemplateList templateList) {
        this.processTemplateGroups(specTreeNode, templateList.getTemplateGroups());
        this.processTemplates(specTreeNode, templateList.getTemplatesOnly(), null);
    }

    private void processTemplateGroups(SpecTreeNode specTreeNode, List<TemplateGroup> list) {
        for (TemplateGroup templateGroup : new FilterIterator<TemplateGroup>(list, this.groupFilter)) {
            TemplateHelper templateHelper;
            Object object;
            if (templateGroup.isContainer()) {
                object = new SpecTreeNode(templateGroup.getName(), null, null, false, null, null);
                specTreeNode.add((MutableTreeNode)object);
                this.processTemplates((SpecTreeNode)object, templateGroup.getTemplatesOnly(), templateGroup);
                this.processTemplateGroups((SpecTreeNode)object, templateGroup.getTemplateGroups());
                continue;
            }
            object = "undefined";
            String string = "undefined";
            String string2 = "undefined";
            Icon icon = null;
            SpecTreeNode specTreeNode2 = new SpecTreeNode(templateGroup.getName(), (String)object, string, true, string2, icon);
            specTreeNode.add(specTreeNode2);
            if (this.thFactory == null || (templateHelper = this.thFactory.getInstance(templateGroup)) == null) continue;
            specTreeNode2.setTemplateHelper(templateHelper);
            this.addHelper(specTreeNode2);
        }
    }

    private void processTemplates(SpecTreeNode specTreeNode, List<Template> list, TemplateGroup templateGroup) {
        for (Template template : new FilterIterator<Template>(list, this.tFilter)) {
            TemplateHelper templateHelper;
            SpecTreeNode specTreeNode2 = new SpecTreeNode(template.getName(), template.getExpression(), template.getType(), true, template.getDoc(), this.fetchIcon.getIcon(template.getIcon()));
            if (this.thFactory != null && (templateHelper = this.thFactory.getInstance(template, templateGroup)) != null) {
                specTreeNode2.setTemplateHelper(templateHelper);
                this.addHelper(specTreeNode2);
            }
            specTreeNode.add(specTreeNode2);
            if (template.isButton()) {
                this.buttonNodes.add(specTreeNode2);
            }
            if (!template.isDefault()) continue;
            this.defaultSelection = specTreeNode2;
        }
    }

    private void processXmlProperties(SpecTreeNode specTreeNode, List<XmlProperty> list) {
        for (XmlProperty xmlProperty : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            String string = this.props.getProperty(xmlProperty.getProperty());
            if (string == null) continue;
            this.parseString(specTreeNode, string);
        }
    }

    private void processCategories(SpecTreeNode specTreeNode, List<Category> list) {
        for (Category category : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            SpecTreeNode specTreeNode2 = new SpecTreeNode(category.getName(), null, null, false, category.getDoc(), this.fetchIcon.getIcon(category.getIcon()));
            specTreeNode.add(specTreeNode2);
            this.processBase(specTreeNode2, category);
        }
    }

    private void processInsertables(SpecTreeNode specTreeNode, List<Insertable> list) {
        for (Insertable insertable : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            String string = insertable.getName();
            if (string == null) {
                string = insertable.getSyntax();
            }
            SpecTreeNode specTreeNode2 = new SpecTreeNode(string, insertable.getSyntax(), insertable.getType(), true, insertable.getDoc(), this.fetchIcon.getIcon(insertable.getIcon()));
            specTreeNode.add(specTreeNode2);
            this.processBase(specTreeNode2, insertable);
            if (insertable.isButton()) {
                this.buttonNodes.add(specTreeNode2);
            }
            if (!insertable.isDefault()) continue;
            this.defaultSelection = specTreeNode2;
        }
    }

    private void processUnseens(SpecTreeNode specTreeNode, List<Unseen> list) {
        for (Unseen unseen : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            specTreeNode = new SpecTreeNode();
            this.processBase(specTreeNode, unseen);
            this.processReserved(unseen.getReserved());
        }
    }

    private void processDocs(List<Doc> list) {
        for (Doc doc : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            URL uRL = OLAPSpec.class.getResource(doc.getPath());
            this.docs.put(doc.getName(), uRL.toExternalForm());
        }
    }

    private void processFiles(SpecTreeNode specTreeNode, List<File> list) {
        for (File file : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            InputStream inputStream = SyntaxBuilderPanel.class.getResourceAsStream(file.getPath());
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.CHARSET);
                this.parseReader(specTreeNode, inputStreamReader, file.getPackage());
                continue;
            }
            LOG.log(Level.SEVERE, file.getPath());
        }
    }

    private void processSqls(SpecTreeNode specTreeNode, List<Sql> list) {
        for (Sql sql : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            specTreeNode.setLazy(true, new SqlLazyLoader(sql));
        }
    }

    public void setConn(Connection connection) {
        this.conn = connection;
        this.dbUtil = DBUtil.getInstance((Connection)connection);
    }

    private void addHelper(SpecTreeNode specTreeNode) {
        this.helpers.add(specTreeNode);
    }

    private void processReserved(List<Reserved> list) {
        if (this.syntaxParser == null) {
            return;
        }
        for (Reserved reserved : new FilterIterator<NodeWithContext>(list, this.specFilter)) {
            this.syntaxParser.addReservedWord(reserved.getName());
        }
    }

    @Override
    public SpecTreeNode getDefaultSelection() {
        return this.defaultSelection;
    }

    @Override
    public String getDocumentation(String string) {
        return this.docs.get(string);
    }

    @Override
    public SyntaxParser getSyntaxParser() {
        return this.syntaxParser;
    }

    @Override
    public TemplateHelperFactory getTemplateHelperFactory() {
        return this.thFactory;
    }

    @Override
    public SpecTreeNode findMatchingNode(ParseNode parseNode) {
        int n = 0;
        int n2 = 0;
        SpecTreeNode specTreeNode = null;
        for (SpecTreeNode specTreeNode2 : this.helpers) {
            n2 = specTreeNode2.matchesPattern(parseNode);
            if (n2 <= n) continue;
            specTreeNode = specTreeNode2;
            n = n2;
        }
        LOG.finest(String.format("Matching SpecTreeNode: %s", specTreeNode));
        return specTreeNode;
    }

    @Override
    public SpecTreeNode findByTemplateType(String string) {
        this.getFullInsertableList();
        return this.insertables.get(string);
    }

    @Override
    public SpecTreeNode getRootNode() {
        return this.root;
    }

    @Override
    public List<SpecTreeNode> getFullInsertableList() {
        if (this.insertables == null) {
            this.insertables = new HashMap();
            this.flatNodeList = new ArrayList();
            Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                SpecTreeNode specTreeNode = (SpecTreeNode)enumeration.nextElement();
                if (!specTreeNode.isInsertable()) continue;
                this.insertables.put(specTreeNode.getType(), specTreeNode);
                this.flatNodeList.add(specTreeNode);
            }
        }
        return this.flatNodeList;
    }

    @Override
    public List<SpecTreeNode> getButtonNodes() {
        return this.buttonNodes;
    }

    class SqlLazyLoader
    implements LazyLoader {
        private Sql s;

        SqlLazyLoader(Sql sql) {
            this.s = sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLazyLoad(SpecTreeNode specTreeNode) {
            if (!Connections.getInstance().lock(OLAPSpec.this.conn)) {
                OLAPSpec.this.errorDisplay.show(null, OLAPSpec.this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), OLAPSpec.this.resources.getString(OLAPSpec.SQL_ERROR_MESSAGE), null);
                specTreeNode.setLazy(false, this);
                return;
            }
            ResultSetWrapper resultSetWrapper = null;
            try {
                resultSetWrapper = OLAPSpec.this.dbUtil.executeQuery(this.s.getQuery().getText(), this.buildParams(specTreeNode));
                ResultSet resultSet = resultSetWrapper.getResultSet();
                resultSet.setFetchSize(100);
                boolean bl = false;
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    if (!resultSet.getMetaData().getColumnName(i).equalsIgnoreCase(OLAPSpec.COL_TEMPLATE)) continue;
                    bl = true;
                    break;
                }
                Icon icon = OLAPSpec.this.fetchIcon.getIcon(this.s.getIcon());
                while (resultSet.next()) {
                    SpecTreeNode specTreeNode2 = null;
                    specTreeNode2 = bl ? new SpecTreeNode(resultSet.getString(OLAPSpec.COL_NAME), resultSet.getString(OLAPSpec.COL_TEMPLATE), icon) : new SpecTreeNode(resultSet.getString(OLAPSpec.COL_NAME), resultSet.getString(OLAPSpec.COL_NAME), icon);
                    specTreeNode.add(specTreeNode2);
                    OLAPSpec.this.processBase(specTreeNode2, this.s);
                }
            }
            catch (SQLException sQLException) {
                OLAPSpec.this.errorDisplay.show(sQLException, OLAPSpec.this.resources.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), OLAPSpec.this.resources.getString(OLAPSpec.SQL_ERROR_MESSAGE), null);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(OLAPSpec.this.conn);
            }
            specTreeNode.setLazy(false, null);
        }

        private List<?> buildParams(SpecTreeNode specTreeNode) throws SQLException {
            ArrayList<String> arrayList = new ArrayList<String>(this.s.getSqlParams().size());
            for (int i = 0; i < this.s.getSqlParams().size(); ++i) {
                arrayList.add(null);
            }
            for (SqlParam sqlParam : this.s.getSqlParams()) {
                SpecTreeNode specTreeNode2 = specTreeNode;
                if (OLAPSpec.this.props.getProperty(sqlParam.getName()) == null) {
                    for (int i = 0; i < sqlParam.getDepth(); ++i) {
                        specTreeNode2 = (SpecTreeNode)specTreeNode2.getParent();
                    }
                    arrayList.set(sqlParam.getId() - 1, (String)specTreeNode2.getUserObject());
                    continue;
                }
                arrayList.set(sqlParam.getId() - 1, OLAPSpec.this.props.getProperty(sqlParam.getName()));
            }
            return arrayList;
        }
    }
}

