/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.CubeModel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateHelperFactory;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperFactoryImpl;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerHelper;
import oracle.olap.syntaxbuilder.olapihelpers.NonLazyFetchIcon;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPSpec;
import oracle.olap.syntaxbuilder.spec.Category;
import oracle.olap.syntaxbuilder.spec.File;
import oracle.olap.syntaxbuilder.spec.Insertable;
import oracle.olap.syntaxbuilder.spec.Spec;
import oracle.olap.util.OLAPErrorDisplay;

public class SyntaxBuilderLauncher {
    private static final Logger LOG = Logger.getLogger(SyntaxBuilderLauncher.class.getName());
    public static final String WINDOW_SIZE = "WINDOW_SIZE";
    private static final String CUBES = "CUBES";
    private static final String DIMENSIONS = "DIMENSIONS";

    public static String generateDimensionsXmlProperty(oracle.olap.cube.model.Cube cube) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        Spec spec = new Spec();
        for (int i = 0; i < cube.getDimensions().length; ++i) {
            Insertable insertable = new Insertable();
            spec.addInsertable(insertable);
            insertable.setName(cube.getDimensions()[i].getName());
            insertable.setIcon("OLAPDIMENSION_ICON");
            File file = new File();
            file.setPackage(file.getClass().getPackage().getName());
            file.setPath("/oracle/olap/measureexpression/dimensions.xml");
            insertable.addFile(file);
        }
        spec.toXml(stringBuilder);
        return stringBuilder.toString();
    }

    public static String generateCubeXmlProperty(Schema schema) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        Spec spec = new Spec();
        for (Cube cube : schema.getCubes()) {
            Insertable insertable = new Insertable();
            spec.addInsertable(insertable);
            insertable.setName(cube.getName());
            insertable.setIcon("OLAPCUBE_ICON");
            Category category = new Category();
            insertable.addCategory(category);
            category.setName(OLAPArb.getString("EXPRESSION_EDITOR_MEASURES"));
            category.setIcon("OLAPMEASURE_FOLDER_ICON");
            for (Measure measure : cube.getMeasures()) {
                if (measure.isDerived()) continue;
                Object object = new Insertable();
                category.addInsertable((Insertable)object);
                ((Category)object).setName(measure.getName());
                ((Category)object).setIcon("OLAPMEASURE_ICON");
            }
            Category category2 = new Category();
            insertable.addCategory(category2);
            category2.setName(OLAPArb.getString("EXPRESSION_EDITOR_CALC_MEASURES"));
            category2.setIcon("OLAPCALCMEASURE_FOLDER_ICON");
            for (Object object : cube.getMeasures()) {
                if (!((Measure)object).isDerived()) continue;
                Insertable insertable2 = new Insertable();
                category2.addInsertable(insertable2);
                insertable2.setName(((NamedObject)object).getName());
                category2.setIcon("OLAPCALCMEASURE_ICON");
                Category category3 = new Category();
                insertable2.addCategory(category3);
                category3.setName(OLAPArb.getString("EXPRESSION_EDITOR_EXPRESSION"));
                Insertable insertable3 = new Insertable();
                category3.addInsertable(insertable3);
                insertable3.setText(((Measure)object).getExpression());
            }
        }
        spec.toXml(stringBuilder);
        return stringBuilder.toString();
    }

    public static Schema populateSchema(Schema schema, Properties properties, oracle.olap.cube.model.Cube cube, Database database) {
        if (schema == null) {
            schema = new Schema(properties.getProperty("SCHEMA"));
        }
        OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(database, schema);
        boolean bl = Boolean.parseBoolean(properties.getProperty("SKIP_CUBE_VIEW_COLUMNS", Boolean.FALSE.toString()));
        oLAPMetadataReader.setSkipCubeViewColumns(bl);
        try {
            oLAPMetadataReader.loadMetadata();
            if (cube != null) {
                SyntaxBuilderLauncher.updateSchemaWithCube(schema, properties, cube);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(SyntaxBuilderLauncher.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return schema;
    }

    public static Schema populateCube(Schema schema, Properties properties, oracle.olap.cube.model.Cube cube, Object object) {
        if (schema == null) {
            schema = new Schema(properties.getProperty("SCHEMA"));
        }
        try {
            Schema schema2 = new Schema(schema.getName());
            CubeModel.getCube(schema2, cube, object);
            for (oracle.olap.app.olapmetadata.Dimension dimension : schema2.getDimensions()) {
                if (schema.findDimension(dimension.getName()) != null) continue;
                schema.addDimension(dimension);
            }
            SyntaxBuilderLauncher.updateSchemaWithCube(schema, properties, cube);
        }
        catch (Exception exception) {
            Logger.getLogger(SyntaxBuilderLauncher.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return schema;
    }

    public static Schema updateSchemaWithCube(Schema schema, Properties properties, oracle.olap.cube.model.Cube cube) {
        block8: {
            try {
                if (cube != null) {
                    int n;
                    Cube cube2 = new Cube(schema, cube.getAnalyticWorkspace(), cube.getName(), null, "", true);
                    for (CubeDimensionality cubeDimensionality : cube.getDimensions()) {
                        oracle.olap.app.olapmetadata.Dimension dimension = schema.findDimension(cubeDimensionality.getName());
                        if (dimension == null) continue;
                        cube2.addDimension(dimension);
                        if (!dimension.isTime()) continue;
                        properties.setProperty("IS_TIME_CUBE", "true");
                    }
                    for (n = 0; n < cube.getMeasures().length; ++n) {
                        CubeMeasure cubeMeasure = cube.getMeasures()[n];
                        cube2.addMeasure(cubeMeasure.getName(), cubeMeasure.getDescription(), cubeMeasure.getDataType(), cubeMeasure.getMapExpression());
                    }
                    for (n = 0; n < cube.getCalculatedMeasures().length; ++n) {
                        CubeCalculatedMeasure cubeCalculatedMeasure = cube.getCalculatedMeasures()[n];
                        cube2.addMeasure(cubeCalculatedMeasure.getName(), cubeCalculatedMeasure.getDescription(), "DERIVED", cubeCalculatedMeasure.getMeasureExpression());
                    }
                    Cube cube3 = schema.findCube(cube2.getName());
                    if (cube3 != null) {
                        schema.getCubes().remove(cube3);
                    }
                    schema.addCube(cube2);
                    break block8;
                }
                String string = properties.getProperty("CUBE");
                if (string == null) break block8;
                for (oracle.olap.app.olapmetadata.Dimension dimension : ((Cube)schema.getNamedObject(string)).getDimensions()) {
                    if (!dimension.isTime()) continue;
                    properties.setProperty("IS_TIME_CUBE", "true");
                    break;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(SyntaxBuilderLauncher.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return schema;
    }

    public static SyntaxBuilderPanel createPanelForCube(Properties properties, oracle.olap.cube.model.Cube cube, Connection connection) throws SQLException, IOException {
        return SyntaxBuilderLauncher.createPanelForCube(properties, cube, connection, null);
    }

    public static SyntaxBuilderPanel createPanelForCube(Properties properties, oracle.olap.cube.model.Cube cube, Connection connection, Reader reader) throws SQLException, IOException {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(connection);
        Schema schema = SyntaxBuilderLauncher.populateSchema(null, properties, cube, databaseImpl);
        return SyntaxBuilderLauncher.createPanelForCube(properties, cube, connection, databaseImpl, schema, null, null, null, reader);
    }

    public static SyntaxBuilderPanel createPanelForCube(Properties properties, oracle.olap.cube.model.Cube cube, Connection connection, Database database, Schema schema, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, oracle.olap.syntaxbuilder.specification.Spec spec, Reader reader) throws SQLException, IOException {
        return SyntaxBuilderLauncher.createPanelForCube(properties, cube, connection, database, schema, syntaxParser, templateHelperFactory, spec, reader, null);
    }

    public static SyntaxBuilderPanel createPanelForCube(Properties properties, oracle.olap.cube.model.Cube cube, Connection connection, Database database, Schema schema, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, oracle.olap.syntaxbuilder.specification.Spec spec, Reader reader, InsertionHandlerHelper insertionHandlerHelper) throws SQLException, IOException {
        OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
        NonLazyFetchIcon nonLazyFetchIcon = new NonLazyFetchIcon();
        OLAPResources oLAPResources = new OLAPResources("/oracle/olap/app/calcfactory/ui/calcs.xml");
        if (cube != null) {
            properties.setProperty(DIMENSIONS, SyntaxBuilderLauncher.generateDimensionsXmlProperty(cube));
            properties.setProperty(CUBES, SyntaxBuilderLauncher.generateCubeXmlProperty(schema));
        }
        if (syntaxParser == null) {
            syntaxParser = spec.getSyntaxParser() != null ? spec.getSyntaxParser() : new OLAPISyntaxParser(schema, properties);
        }
        if (templateHelperFactory == null) {
            templateHelperFactory = new TemplateHelperFactoryImpl(properties, database, schema, syntaxParser, oLAPResources, nonLazyFetchIcon);
        }
        if (spec == null) {
            try {
                if (reader == null) {
                    reader = new InputStreamReader(SyntaxBuilderPanel.class.getResourceAsStream("/oracle/olap/measureexpression/OLAPExpressionSpec.xml"), "UTF-8");
                }
                spec = new OLAPSpec(properties, reader, syntaxParser, templateHelperFactory, oLAPErrorDisplay, oLAPResources, nonLazyFetchIcon, connection);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                oLAPErrorDisplay.show(unsupportedEncodingException, OLAPArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), OLAPArb.getString("EXPRESSIONBUILDER_SPEC_ERROR_MESSAGE"), (Component)Ide.getMainWindow());
                return null;
            }
        }
        SyntaxBuilderPanel syntaxBuilderPanel = new SyntaxBuilderPanel(properties, spec, nonLazyFetchIcon, oLAPErrorDisplay, insertionHandlerHelper);
        return syntaxBuilderPanel;
    }

    public static String spawnDialog(final SyntaxBuilderPanel syntaxBuilderPanel) {
        Dimension dimension = new Dimension(900, 500);
        syntaxBuilderPanel.setPreferredSize(dimension);
        syntaxBuilderPanel.setMinimumSize(dimension);
        HelpSystem.getHelpSystem().registerTopic((JComponent)syntaxBuilderPanel, "olap_expression_editor");
        final JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)syntaxBuilderPanel, (String)OLAPArb.getString("EXPRESSION_EDITOR.TITLE"), null, (int)6);
        jEWTDialog.addCustomButton((Component)new JButton(new AbstractAction(OLAPArb.getString("EXPRESSION_EDITOR.OK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (syntaxBuilderPanel.isSyntaxValid()) {
                        jEWTDialog.closeDialog(false);
                    } else {
                        JOptionPane.showMessageDialog(syntaxBuilderPanel, OLAPArb.getString("EXPRESSION_EDITOR_RESULT_PLEASE_CORRECT"), OLAPArb.getString("EXPRESSION_EDITOR.RESULT.INVALID"), 0);
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }));
        jEWTDialog.setMinimumSize(dimension);
        boolean bl = jEWTDialog.runDialog();
        if (bl) {
            return syntaxBuilderPanel.getSyntax();
        }
        return null;
    }
}

