/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseException;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olapi.syntax.BinaryOperatorExpression;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.BuildItem;
import oracle.olapi.syntax.BuildProcess;
import oracle.olapi.syntax.BuildSpecification;
import oracle.olapi.syntax.CaseExpression;
import oracle.olapi.syntax.ClearCommand;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.GroupCommand;
import oracle.olapi.syntax.KeywordArgument;
import oracle.olapi.syntax.ListComparisonCondition;
import oracle.olapi.syntax.LoadCommand;
import oracle.olapi.syntax.NullExpression;
import oracle.olapi.syntax.NumberExpression;
import oracle.olapi.syntax.OLAPDMLCommand;
import oracle.olapi.syntax.OLAPDMLExpression;
import oracle.olapi.syntax.OLAPFunctionExpression;
import oracle.olapi.syntax.PLSQLCommand;
import oracle.olapi.syntax.QDRExpression;
import oracle.olapi.syntax.Qualifier;
import oracle.olapi.syntax.RowFunctionExpression;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SearchedCase;
import oracle.olapi.syntax.SearchedCaseExpression;
import oracle.olapi.syntax.SimpleCase;
import oracle.olapi.syntax.SimpleCaseExpression;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SolveCommand;
import oracle.olapi.syntax.StringExpression;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SymmetricConditionElement;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

public class SyntaxVisitor
extends SyntaxObjectVisitor
implements SyntaxTokenListener {
    private static final Logger LOG = Logger.getLogger(SyntaxVisitor.class.getName());
    private static final String RESERVED_WORD_ELSE = "ELSE";
    private static final String RESERVED_WORD_WHEN = "WHEN";
    private static final String RESERVED_WORD_THEN = "THEN";
    private static final String RESERVED_WORD_CASE = "CASE";
    private static final String RESERVED_WORD_NULL = "NULL";
    private static final String RESERVED_WORD_LEVELS = "LEVELS";
    private static final String RESERVED_WORD_WHERE = "WHERE";
    private static final String RESERVED_WORD_NOT = "NOT";
    private static final String RESERVED_WORD_IN = "IN";
    private static final String RESERVED_WORD_BUILD = "BUILD";
    private static final String RESERVED_WORD_CLEAR = "CLEAR";
    private static final String RESERVED_WORD_LOAD = "LOAD";
    private static final String RESERVED_WORD_SOLVE = "SOLVE";
    private static final String RESERVED_WORD_SYNCH = "SYNCH";
    private static final String RESERVED_WORD_FROM = "FROM";
    private static final String RESERVED_WORD_NO = "NO";
    private static final String RESERVED_WORD_EXECUTE = "EXECUTE";
    private static final String RESERVED_WORD_OLAP = "OLAP";
    private static final String RESERVED_WORD_DML = "DML";
    private static final String RESERVED_WORD_PLSQL = "PLSQL";
    private static final String RESERVED_WORD_FOR = "FOR";
    private static final String RESERVED_WORD_MEASURES = "MEASURES";
    private static final String OLAP_DML_EXPRESSION = "OLAP_DML_EXPRESSION";
    private static final String FUNCTION_NAME_AVG = "AVG";
    private static final String FUNCTION_NAME_MIN = "MIN";
    private static final String FUNCTION_NAME_MAX = "MAX";
    private static final String FUNCTION_NAME_SUM = "SUM";
    private static final String FUNCTION_NAME_RANK = "RANK";
    private static final String FUNCTION_NAME_DENSE_RANK = "DENSE_RANK";
    private static final String FUNCTION_NAME_AVERAGE_RANK = "AVERAGE_RANK";
    private String syntax;
    private int offset;
    private final HashSet reserved = new HashSet();
    private Schema schema;
    private List<Throwable> badNames = new LinkedList<Throwable>();
    private List<Token> tokenList = new ArrayList<Token>();

    private int findOffset(List<Token> list, int n) {
        int n2 = Collections.binarySearch(list, new Token(null, n));
        return n2;
    }

    private ParseNode fixBounds(ParseNode parseNode, int n, int n2) {
        parseNode.setReplaceBounds(n, n2, this.syntax);
        this.extendOnParenthesis(parseNode);
        return parseNode;
    }

    public void setSyntax(String string) {
        this.syntax = string;
        this.offset = 0;
        this.badNames.clear();
        this.tokenList = new LinkedList<Token>();
    }

    public List<Throwable> getBadNames() {
        return this.badNames;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void addReservedWord(String string) {
        this.reserved.add(string);
    }

    Type calculateType(String string) {
        if (string.equalsIgnoreCase(Type.MEASURE.toString())) {
            return Type.MEASURE;
        }
        if (string.equalsIgnoreCase("dimension.hierarchy")) {
            return Type.HIERARCHY;
        }
        if (string.equalsIgnoreCase("dimension.level")) {
            return Type.LEVEL;
        }
        if (this.schema != null) {
            NamedObjectWithDesc namedObjectWithDesc;
            IdentifierElement identifierElement = new IdentifierElement(string);
            string = string.replaceAll("\"", "");
            boolean bl = false;
            int n = string.indexOf(46);
            String string2 = string;
            if (identifierElement.getCount() > 0 && identifierElement.get(0).equalsIgnoreCase(this.schema.getName())) {
                string2 = string.substring(n + 1);
                bl = true;
            }
            if ((namedObjectWithDesc = this.schema.getNamedObject(string2)) == null) {
                Dimension dimension;
                int n2 = 0;
                if (identifierElement.getCount() == 3 && bl) {
                    n2 = 1;
                }
                if ((dimension = this.schema.findDimension(identifierElement.get(n2))) != null && identifierElement.getCount() > n2 + 1) {
                    if (identifierElement.get(n2 + 1).equals("DIM_KEY")) {
                        return Type.ATTRIBUTE;
                    }
                    namedObjectWithDesc = dimension.findAttribute(identifierElement.get(n2 + 1));
                }
            }
            if (namedObjectWithDesc != null) {
                if (namedObjectWithDesc instanceof Measure) {
                    return Type.MEASURE;
                }
                if (namedObjectWithDesc instanceof Dimension) {
                    return Type.DIMENSION;
                }
                if (namedObjectWithDesc instanceof DimensionLevel) {
                    return Type.LEVEL;
                }
                if (namedObjectWithDesc instanceof DimensionHierarchy) {
                    return Type.HIERARCHY;
                }
                if (namedObjectWithDesc instanceof DimensionAttribute) {
                    return Type.ATTRIBUTE;
                }
                if (namedObjectWithDesc instanceof Cube) {
                    return Type.CUBE;
                }
            }
        }
        if (this.reserved.contains(string)) {
            return Type.RESERVED;
        }
        return Type.BAD_NAME;
    }

    protected ParseNode processLiteral(String string, Object object) {
        return this.processLiteral(string, this.calculateType(string), object, false);
    }

    protected ParseNode processLiteral(String string, Type type, Object object) {
        return this.processLiteral(string, type, object, false);
    }

    protected ParseNode processLiteral(String string, Type type, Object object, boolean bl) {
        int n = 0;
        Token token = this.insensitiveIndexOf(this.syntax, string, this.offset, 1, 0);
        if (token == null) {
            n = -1;
        } else {
            n = token.offset;
            string = token.token;
        }
        this.offset = n + string.length();
        if (n == -1) {
            LOG.finest(String.format("Creating BAD ParseNode for %s of type %s on offset %d", string, type.toString(), this.offset));
        }
        ParseNode parseNode = new ParseNode(string, type.toString(), bl, n, this.offset);
        if (type == Type.BAD_NAME) {
            this.badNames.add(new ParseException(OLAPArb.format("EXPRESSION_EDITOR_RESULT_INVALID_NAME", string), parseNode.getOffset(), string));
        }
        ((ParseNode)object).add(parseNode);
        return parseNode;
    }

    private int insensitiveIndexOf(String string, String string2, int n) {
        return this.insensitiveIndexOf(string, string2, n, 1);
    }

    private int insensitiveIndexOf(String string, String string2, int n, int n2) {
        Token token = this.insensitiveIndexOf(string, string2, n, n2, 0);
        if (token != null) {
            return token.offset;
        }
        return -1;
    }

    private Token insensitiveIndexOf(String string, String string2, int n, int n2, int n3) {
        try {
            if (n >= string.length()) {
                return null;
            }
            Token token = null;
            int n4 = this.findOffset(this.tokenList, n);
            n4 = n4 < 0 ? (n4 + 1) * -1 : n4;
            List<Token> list = this.tokenList;
            token = list.get(n4);
            while (n3 == 0 || n2 == 1 && token.offset < n3 || n2 == -1 && token.offset > n3) {
                if (this.tokensMatch(string2, token.token)) {
                    return token;
                }
                if ((n4 += n2) < list.size() && n4 > 0) {
                    token = list.get(n4);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, String.format("Issue finding token %s starting at index %d in direction %d", string2, n, n2));
        }
        return null;
    }

    private boolean tokensMatch(String string, String string2) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < string2.length()) {
            char c = Character.toUpperCase(string.charAt(n));
            if (this.shouldSkip(c)) {
                ++n;
                continue;
            }
            char c2 = Character.toUpperCase(string2.charAt(n2));
            if (this.shouldSkip(c2)) {
                ++n2;
                continue;
            }
            if (c != c2) {
                bl = false;
                break;
            }
            ++n2;
            ++n;
        }
        while (bl && n < string.length()) {
            bl = this.shouldSkip(string.charAt(n++));
        }
        while (bl && n2 < string2.length()) {
            bl = this.shouldSkip(string2.charAt(n2++));
        }
        return bl;
    }

    private boolean shouldSkip(char c) {
        return c == '\'' || c == '\"';
    }

    private ParseNode extendOnParenthesis(ParseNode parseNode) {
        Type type = Type.valueFrom(parseNode.getType());
        switch (type) {
            case FUNCTION: 
            case BUILDPROCESS: 
            case RANK: 
            case AGGREGATE: 
            case OPERATOR: {
                int n = 0;
                int n2 = 0;
                int n3 = parseNode.getReplaceOffset();
                int n4 = parseNode.getReplaceEnd();
                List<Token> list = this.tokenList;
                int n5 = this.findOffset(list, n3);
                n5 = n5 < 0 ? n5 * -1 : n5;
                Token token = list.get(n5);
                int n6 = n5;
                while (token.offset >= n3 && token.offset < parseNode.getReplaceEnd()) {
                    if (token.token.equals("(")) {
                        ++n;
                    } else if (token.token.equals(")")) {
                        if (n > 0) {
                            --n;
                        } else {
                            ++n2;
                        }
                    }
                    if (++n5 >= list.size()) break;
                    token = list.get(n5);
                }
                int n7 = n5;
                if (n != 0 || n2 != 0) {
                    for (n5 = n7; n > 0 && n5 < list.size() && n5 >= 0; ++n5) {
                        token = list.get(n5);
                        if (!token.token.equals(")")) continue;
                        --n;
                        n4 = token.offset + 1;
                    }
                    for (n5 = n6 - 1; n2 > 0 && n5 < list.size() && n5 >= 0; --n5) {
                        token = list.get(n5);
                        if (!token.token.equals("(")) continue;
                        --n2;
                        n3 = token.offset;
                    }
                }
                parseNode.setReplaceBounds(n3, n4, this.syntax);
                break;
            }
        }
        return parseNode;
    }

    private void loopArgs(FunctionArgument[] functionArgumentArray, Object object) {
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            ((SyntaxObject)functionArgumentArray[i]).visit((SyntaxObjectVisitor)this, object);
        }
    }

    public Object visitSyntaxObject(SyntaxObject syntaxObject, Object object) {
        if (object != null) {
            this.processLiteral(syntaxObject.toSyntax(), object);
        }
        return super.visitSyntaxObject(syntaxObject, object);
    }

    public Object visitBinaryOperatorExpression(BinaryOperatorExpression binaryOperatorExpression, Object object) {
        String string = binaryOperatorExpression.getOperator();
        TypedExpression[] typedExpressionArray = binaryOperatorExpression.getArguments();
        ParseNode parseNode = new ParseNode(string, Type.OPERATOR.toString(), true);
        typedExpressionArray[0].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(string, Type.OPERATOR, object, true);
        parseNode2.add(parseNode.getChildren().get(0));
        parseNode = parseNode2;
        typedExpressionArray[1].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        int n = parseNode3.getReplaceOffset();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        int n2 = parseNode4.getReplaceEnd();
        parseNode = this.fixBounds(parseNode, n, n2);
        return parseNode;
    }

    public Object visitRowFunctionExpression(RowFunctionExpression rowFunctionExpression, Object object) {
        ParseNode parseNode = new ParseNode(rowFunctionExpression.getFunctionName(), Type.FUNCTION.toString());
        ((ParseNode)object).add(parseNode);
        this.loopArgs(rowFunctionExpression.getArguments(), parseNode);
        parseNode.setOffset(((ParseNode)parseNode.getFirstChild()).getOffset());
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        return this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
    }

    public Object visitOLAPFunctionExpression(OLAPFunctionExpression oLAPFunctionExpression, Object object) {
        Type type = Type.FUNCTION;
        if (oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_SUM) || oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_AVG) || oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_MIN) || oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_MAX)) {
            type = Type.AGGREGATE;
        }
        if (oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_RANK) || oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_AVERAGE_RANK) || oLAPFunctionExpression.getFunctionName().equals(FUNCTION_NAME_DENSE_RANK)) {
            type = Type.RANK;
        }
        ParseNode parseNode = this.processLiteral(oLAPFunctionExpression.getFunctionName(), type, object, true);
        this.loopArgs(oLAPFunctionExpression.getArguments(), parseNode);
        if (oLAPFunctionExpression.hasHierarchyClause()) {
            this.loopArgs(oLAPFunctionExpression.getHierarchyClauseArguments(), parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        return parseNode;
    }

    public Object visitKeywordArgument(KeywordArgument keywordArgument, Object object) {
        return this.processLiteral(keywordArgument.getName(), Type.KEYWORD, object, true);
    }

    public Object visitDimensionArgument(DimensionArgument dimensionArgument, Object object) {
        return this.processLiteral(dimensionArgument.getDimensionID(), this.calculateType(dimensionArgument.getDimensionID()), object);
    }

    public Object visitQDRExpression(QDRExpression qDRExpression, Object object) {
        ParseNode parseNode = (ParseNode)object;
        ParseNode parseNode2 = new ParseNode("QDR", Type.QDR.toString());
        parseNode.add(parseNode2);
        qDRExpression.getBaseExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        for (Qualifier qualifier : qDRExpression.getQualifiers()) {
            qualifier.visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        }
        if (parseNode2.getChildCount() > 0) {
            ParseNode parseNode3 = (ParseNode)parseNode2.getFirstChild();
            parseNode2.setOffset(parseNode3.getOffset());
            parseNode2.setEnd(parseNode3.getReplaceEnd());
            parseNode2.setReplaceBounds(parseNode2.getOffset(), this.insensitiveIndexOf(this.syntax, "]", this.offset) + 1, this.syntax);
        }
        return parseNode;
    }

    public Object visitQualifier(Qualifier qualifier, Object object) {
        String string = qualifier.getDimensionID();
        ParseNode parseNode = this.processLiteral(string, this.calculateType(string), object);
        TypedExpression typedExpression = qualifier.getExpression();
        typedExpression.visit((SyntaxObjectVisitor)this, object);
        return parseNode;
    }

    public Object visitStringExpression(StringExpression stringExpression, Object object) {
        return this.processLiteral(stringExpression.getValue().toString(), Type.STRING, object);
    }

    public Object visitNumberExpression(NumberExpression numberExpression, Object object) {
        return this.processLiteral(numberExpression.getValue().toString(), Type.NUMBER, object);
    }

    public Object visitCaseExpression(CaseExpression caseExpression, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_ELSE, Type.RESERVED, object);
        caseExpression.getElseExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        return parseNode;
    }

    public Object visitSimpleCase(SimpleCase simpleCase, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_WHEN, Type.RESERVED, object);
        simpleCase.getWhenExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_THEN, Type.RESERVED, object);
        simpleCase.getThenExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        return parseNode;
    }

    public Object visitSimpleCaseExpression(SimpleCaseExpression simpleCaseExpression, Object object) {
        SimpleCase[] simpleCaseArray;
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CASE, Type.RESERVED, object);
        simpleCaseExpression.getSwitchExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        for (SimpleCase simpleCase : simpleCaseArray = simpleCaseExpression.getCases()) {
            simpleCase.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        return super.visitSimpleCaseExpression(simpleCaseExpression, (Object)parseNode);
    }

    public Object visitSearchedCase(SearchedCase searchedCase, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_WHEN, Type.RESERVED, object);
        searchedCase.getWhenCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_THEN, Type.RESERVED, parseNode);
        searchedCase.getThenExpression().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        return super.visitSearchedCase(searchedCase, null);
    }

    public Object visitSearchedCaseExpression(SearchedCaseExpression searchedCaseExpression, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CASE, Type.RESERVED, object);
        SearchedCase[] searchedCaseArray = searchedCaseExpression.getCases();
        for (int i = 0; i < searchedCaseArray.length; ++i) {
            searchedCaseArray[i].visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        return super.visitSearchedCaseExpression(searchedCaseExpression, (Object)parseNode);
    }

    public Object visitValueComparisonCondition(ValueComparisonCondition valueComparisonCondition, Object object) {
        ParseNode parseNode = new ParseNode(valueComparisonCondition.getOperator(), Type.OPERATOR.toString());
        ((ParseNode)object).add(parseNode);
        valueComparisonCondition.getLhsArgument().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        valueComparisonCondition.getRhsArgument().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        parseNode.setOffset(((ParseNode)parseNode.getFirstChild()).getOffset());
        parseNode.setReplaceEnd(((ParseNode)parseNode.getLastChild()).getReplaceEnd(), this.syntax);
        return parseNode;
    }

    public Object visitColumnExpression(ColumnExpression columnExpression, Object object) {
        return this.processLiteral(columnExpression.toSyntax(), this.calculateType(columnExpression.toSyntax()), object);
    }

    public Object visitSimpleCommand(SimpleCommand simpleCommand, Object object) {
        return this.processLiteral(simpleCommand.toSyntax(), Type.SIMPLE_COMMAND, object, true);
    }

    public Object visitGroupCommand(GroupCommand groupCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_FOR, Type.RESERVED, object, true);
        groupCommand.getWhereCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_MEASURES, Type.RESERVED, parseNode, true);
        for (String string : groupCommand.getMeasureIDs()) {
            this.processLiteral(string, parseNode2);
        }
        ParseNode parseNode3 = this.processLiteral(RESERVED_WORD_BUILD, Type.BUILDPROCESS, parseNode);
        for (SimpleCommand simpleCommand : groupCommand.getCommands()) {
            simpleCommand.visit((SyntaxObjectVisitor)this, (Object)parseNode3);
        }
        ParseNode parseNode4 = (ParseNode)parseNode3.getLastChild();
        this.fixBounds(parseNode3, parseNode3.getOffset(), parseNode4.getReplaceEnd());
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode3.getReplaceEnd());
        return parseNode;
    }

    public Object visitSymmetricCondition(SymmetricCondition symmetricCondition, Object object) {
        for (SymmetricConditionElement symmetricConditionElement : symmetricCondition.getElements()) {
            symmetricConditionElement.visit((SyntaxObjectVisitor)this, object);
        }
        return super.visitSymmetricCondition(symmetricCondition, null);
    }

    public Object visitSymmetricConditionElement(SymmetricConditionElement symmetricConditionElement, Object object) {
        ParseNode parseNode = this.processLiteral(symmetricConditionElement.getDimensionID(), object);
        if (symmetricConditionElement.getCondition() != null) {
            ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_WHERE, Type.KEYWORD, parseNode);
            symmetricConditionElement.getCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
        } else if (symmetricConditionElement.getQualifier() != null) {
            this.processLiteral(symmetricConditionElement.getQualifier(), Type.KEYWORD, parseNode);
        } else {
            ParseNode parseNode3 = this.processLiteral(RESERVED_WORD_LEVELS, Type.KEYWORD, parseNode, true);
            for (String string : symmetricConditionElement.getLevelIDs()) {
                this.processLiteral(string, Type.LEVEL, parseNode3);
            }
        }
        return parseNode;
    }

    public Object visitListComparisonCondition(ListComparisonCondition listComparisonCondition, Object object) {
        listComparisonCondition.getLhsArgument().visit((SyntaxObjectVisitor)this, object);
        if (listComparisonCondition.getOperator().equals("!=")) {
            this.processLiteral(RESERVED_WORD_NOT, object);
        }
        this.processLiteral(RESERVED_WORD_IN, object);
        for (TypedExpression typedExpression : listComparisonCondition.getList()) {
            typedExpression.visit((SyntaxObjectVisitor)this, object);
        }
        return super.visitListComparisonCondition(listComparisonCondition, null);
    }

    public Object visitNullExpression(NullExpression nullExpression, Object object) {
        this.processLiteral(RESERVED_WORD_NULL, Type.RESERVED, object);
        return super.visitNullExpression(nullExpression, null);
    }

    public Object visitOLAPDMLExpression(OLAPDMLExpression oLAPDMLExpression, Object object) {
        ParseNode parseNode = this.processLiteral(OLAP_DML_EXPRESSION, Type.FUNCTION, object);
        oLAPDMLExpression.getOlapDML().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        oLAPDMLExpression.getSQLDataType().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        return super.visitOLAPDMLExpression(oLAPDMLExpression, null);
    }

    public Object visitSQLDataType(SQLDataType sQLDataType, Object object) {
        this.processLiteral(sQLDataType.getSQLText(), Type.RESERVED, object);
        return super.visitSQLDataType(sQLDataType, null);
    }

    public Object visitBuildSpecification(BuildSpecification buildSpecification, Object object) {
        BuildCommand[] buildCommandArray = buildSpecification.getCommands();
        ParseNode parseNode = null;
        if (buildSpecification.getName() == null) {
            parseNode = (ParseNode)object;
        } else {
            parseNode = this.processLiteral(buildSpecification.getName(), Type.BUILDSPEC, object, false);
            ((ParseNode)object).add(parseNode);
        }
        for (BuildCommand buildCommand : buildCommandArray) {
            buildCommand.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        return super.visitBuildSpecification(buildSpecification, null);
    }

    public Object visitClearCommand(ClearCommand clearCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CLEAR, Type.SIMPLE_COMMAND, object, true);
        this.processLiteral(clearCommand.getClearTarget(), Type.KEYWORD, parseNode);
        String string = clearCommand.getParallelismOption();
        if (string != null && string.length() > 0) {
            ParseNode parseNode2 = this.processLiteral(clearCommand.getParallelismOption(), Type.KEYWORD, parseNode);
            parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        }
        return parseNode;
    }

    public Object visitLoadCommand(LoadCommand loadCommand, Object object) {
        ParseNode parseNode;
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_LOAD, Type.SIMPLE_COMMAND, object, true);
        String string = loadCommand.getLoadOption();
        if (string != null && string.length() > 0) {
            int n = this.insensitiveIndexOf(string, RESERVED_WORD_SYNCH, 0);
            if (n != -1) {
                if (!loadCommand.isSynch()) {
                    this.processLiteral(RESERVED_WORD_NO, Type.KEYWORD, parseNode2, true);
                }
                parseNode = this.processLiteral(RESERVED_WORD_SYNCH, Type.KEYWORD, parseNode2, true);
                parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
            } else {
                parseNode = this.processLiteral(string, Type.KEYWORD, parseNode2, true);
                parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
            }
        }
        if (loadCommand.getCubeMapName() != null) {
            this.processLiteral(RESERVED_WORD_FROM, Type.KEYWORD, parseNode2, true);
            parseNode = this.processLiteral(loadCommand.getCubeMapName(), Type.KEYWORD, parseNode2, true);
            parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
        }
        if (loadCommand.getWhereCondition() != null) {
            loadCommand.getWhereCondition().visit((SyntaxObjectVisitor)this, (Object)parseNode2);
            parseNode = (ParseNode)parseNode2.getLastChild();
            parseNode2.setReplaceEnd(parseNode.getReplaceEnd(), this.syntax);
        }
        return parseNode2;
    }

    public Object visitOLAPDMLCommand(OLAPDMLCommand oLAPDMLCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_EXECUTE, Type.SIMPLE_COMMAND, object, true);
        this.processLiteral(RESERVED_WORD_OLAP, Type.SIMPLE_COMMAND, parseNode, true);
        this.processLiteral(RESERVED_WORD_DML, Type.SIMPLE_COMMAND, parseNode, true);
        ParseNode parseNode2 = this.processLiteral(oLAPDMLCommand.getDML(), Type.STRING, parseNode, false);
        if (oLAPDMLCommand.getOption() != null && oLAPDMLCommand.getOption().length() > 0) {
            ParseNode parseNode3 = this.processLiteral(oLAPDMLCommand.getOption(), Type.KEYWORD, parseNode, true);
            parseNode.setReplaceEnd(parseNode3.getReplaceEnd(), this.syntax);
        } else {
            parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        }
        return parseNode;
    }

    public Object visitPLSQLCommand(PLSQLCommand pLSQLCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_EXECUTE, Type.SIMPLE_COMMAND, object, true);
        this.processLiteral(RESERVED_WORD_PLSQL, Type.SIMPLE_COMMAND, parseNode, true);
        ParseNode parseNode2 = this.processLiteral(pLSQLCommand.getPLSQL(), Type.STRING, parseNode, false);
        parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        return parseNode;
    }

    public Object visitSolveCommand(SolveCommand solveCommand, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_SOLVE, Type.SIMPLE_COMMAND, object, true);
        if (solveCommand.getParallelismOption() != null && solveCommand.getParallelismOption().length() > 0) {
            ParseNode parseNode2 = this.processLiteral(solveCommand.getParallelismOption(), Type.KEYWORD, parseNode, true);
            parseNode.setReplaceEnd(parseNode2.getReplaceEnd(), this.syntax);
        }
        return parseNode;
    }

    public Object visitBuildItem(BuildItem buildItem, Object object) {
        ParseNode parseNode = this.processLiteral(buildItem.getBuildObjectID(), object);
        buildItem.getInlineBuildSpecification().visit((SyntaxObjectVisitor)this, (Object)parseNode);
        ((ParseNode)object).add(parseNode);
        return super.visitBuildItem(buildItem, null);
    }

    public Object visitBuildProcess(BuildProcess buildProcess, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_BUILD, Type.BUILDPROCESS, object);
        for (BuildItem buildItem : buildProcess.getBuildItems()) {
            buildItem.visit((SyntaxObjectVisitor)this, (Object)parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        return parseNode;
    }

    @Override
    public void processToken(String string, String string2, int n) {
        Type type = Type.valueFrom(string2);
        if (type != Type.BLOCK_COMMENT && type != Type.LINE_COMMENT && type != Type.NEWLINE && type != Type.WHITESPACE) {
            this.tokenList.add(new Token(string, n));
        }
    }

    private static class Token
    implements Comparable<Token> {
        final String token;
        final int offset;

        Token(String string, int n) {
            this.token = string;
            this.offset = n;
        }

        @Override
        public int compareTo(Token token) {
            if (token.offset > this.offset) {
                return -1;
            }
            if (token.offset < this.offset) {
                return 1;
            }
            return 0;
        }
    }
}

