/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.qdr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.olap.app.table.Queries;
import oracle.olap.syntaxbuilder.qdr.DimensionMemberPanel;

public class DimensionMemberModel
extends AbstractTreeTableModel {
    private static final String[] COLUMNS = new String[]{"DIM_KEY", "DESCRIPTION"};
    private static final int DIM_KEY = 0;
    private static final int DESCRIPTION = 1;
    private String[] filters = new String[]{"", ""};
    private final String hierarchy;
    private final String dimension;
    private ArrayList<String> levelList = new ArrayList();
    private DBUtil dbUtil;
    private Connection conn;
    private Logger LOG = Logger.getLogger(DimensionMemberPanel.class.getName());
    private String firstLevel;
    private String nextLevel;
    private String nullLevel;
    private Vector<TreeNode> EMPTY = new Vector();
    static final String RS_COLUMN_NAME = "COLUMN_NAME";
    static final String RS_LONG_DESCRIPTION = "LONG_DESCRIPTION";
    static final String RS_SHORT_DESCRIPTION = "SHORT_DESCRIPTION";
    static final String RS_DIM_KEY = "DIM_KEY";
    static final String RS_DESCRIPTION = "DESCRIPTION";
    static final String RS_LEVEL_NAME = "LEVEL_NAME";
    static final String OWNER = "OWNER";
    static final String VIEW_NAME = "VIEW_NAME";
    static final String DIMENSION = "DIMENSION";
    static final String HIERARCHY = "HIERARCHY";
    static final String LEVEL = "LVL";
    static final String PARENT = "PARENT";

    public DimensionMemberModel(String string, String string2, String string3, String string4, Queries queries, Connection connection) {
        super(null);
        this.root = new TreeNode(string2, string3);
        this.hierarchy = string3;
        this.dimension = string2;
        this.dbUtil = DBUtil.getInstance((Connection)connection);
        this.conn = connection;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(VIEW_NAME, string4);
        hashMap.put(OWNER, string);
        List list = this.dbUtil.executeReturnList(queries.getSQL(Steps.LONG_OR_SHORT.name()), hashMap);
        boolean bl = false;
        boolean bl2 = false;
        for (Object object2 : list) {
            if (object2.get(RS_COLUMN_NAME).equals(RS_LONG_DESCRIPTION)) {
                bl = true;
            }
            if (!object2.get(RS_COLUMN_NAME).equals(RS_SHORT_DESCRIPTION)) continue;
            bl2 = true;
        }
        Object object = RS_DIM_KEY;
        if (bl2) {
            object = RS_SHORT_DESCRIPTION;
        } else if (bl) {
            object = RS_LONG_DESCRIPTION;
        }
        this.firstLevel = String.format(queries.getSQL(Steps.FIRST_LEVEL.name()), object, string, string4);
        this.nextLevel = String.format(queries.getSQL(Steps.NEXT_LEVEL.name()), object, string, string4);
        this.nullLevel = String.format(queries.getSQL(Steps.NULL_LEVEL.name()), object, string, string4);
        if (string3 != null) {
            Object object2;
            hashMap = new HashMap(3);
            hashMap.put(DIMENSION, string2);
            hashMap.put(HIERARCHY, string3);
            hashMap.put(OWNER, string);
            object2 = this.dbUtil.executeReturnList(queries.getSQL(Steps.HIERARCHY_LEVELS.name()), hashMap);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                this.levelList.add(String.valueOf(map.get(RS_LEVEL_NAME)));
            }
        } else {
            this.levelList.add(null);
        }
    }

    public void setFilter(int n, String string) {
        if (n >= this.filters.length) {
            return;
        }
        this.filters[n] = string;
    }

    public String getFilter(int n) {
        return this.filters[n];
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    public String toString() {
        return this.hierarchy == null ? this.dimension : this.hierarchy;
    }

    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    public Object getValueAt(Object object, int n) {
        if (n == 0) {
            return ((TreeNode)object).getDimkey();
        }
        if (n == 1) {
            return ((TreeNode)object).getDescription();
        }
        return null;
    }

    public Object getChild(Object object, int n) {
        return ((TreeNode)object).getChildren().get(n);
    }

    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    public static enum Steps {
        HIERARCHIES,
        DIM_VIEW,
        HIERARCHY_LEVELS,
        NULL_LEVEL,
        FIRST_LEVEL,
        NEXT_LEVEL,
        LONG_OR_SHORT;

    }

    public class TreeNode {
        private Vector<TreeNode> children = null;
        private Vector<TreeNode> filteredChildren = new Vector();
        private String dimkey;
        private String description;
        private Steps step;
        private int level;
        private String[] currentFilter = new String[]{"", ""};

        public TreeNode(String string, String string2) {
            this(string, string2, 0);
            if (string2 == null) {
                this.step = Steps.NULL_LEVEL;
            }
        }

        public TreeNode(String string, String string2, int n) {
            this.dimkey = string;
            this.description = string2;
            this.step = n == 0 ? Steps.FIRST_LEVEL : Steps.NEXT_LEVEL;
            this.level = n;
        }

        private boolean staleFilter() {
            for (int i = 0; i < DimensionMemberModel.this.filters.length; ++i) {
                if (DimensionMemberModel.this.filters[i].equals(this.currentFilter[i])) continue;
                return true;
            }
            return false;
        }

        private void updateFilter() {
            for (int i = 0; i < DimensionMemberModel.this.filters.length; ++i) {
                this.currentFilter[i] = DimensionMemberModel.this.filters[i];
            }
        }

        private boolean matchesFilter(TreeNode treeNode) {
            return !(this.currentFilter[1].length() != 0 && treeNode.getDescription().indexOf(this.currentFilter[1]) == -1 || this.currentFilter[0].length() != 0 && treeNode.getDimkey().indexOf(this.currentFilter[0]) == -1);
        }

        private boolean validFilter() {
            for (int i = 0; i < DimensionMemberModel.this.filters.length; ++i) {
                if (DimensionMemberModel.this.filters[i].length() <= 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Vector<TreeNode> getChildren() {
            if (DimensionMemberModel.this.levelList.size() == this.level) {
                this.children = DimensionMemberModel.this.EMPTY;
            }
            if (this.children == null) {
                ResultSetWrapper resultSetWrapper = null;
                if (Connections.getInstance().lock(DimensionMemberModel.this.conn)) {
                    try {
                        if (this.step == Steps.NULL_LEVEL) {
                            resultSetWrapper = DimensionMemberModel.this.dbUtil.executeQuery(DimensionMemberModel.this.nullLevel, Collections.emptyList());
                        } else {
                            HashMap<String, Object> object = new HashMap<String, Object>(2);
                            object.put(DimensionMemberModel.LEVEL, DimensionMemberModel.this.levelList.get(this.level));
                            if (this.level > 0) {
                                object.put(DimensionMemberModel.PARENT, this.dimkey);
                            }
                            resultSetWrapper = this.step == Steps.FIRST_LEVEL ? DimensionMemberModel.this.dbUtil.executeQuery(DimensionMemberModel.this.firstLevel, object) : DimensionMemberModel.this.dbUtil.executeQuery(DimensionMemberModel.this.nextLevel, object);
                        }
                        if (resultSetWrapper == null) {
                            throw DimensionMemberModel.this.dbUtil.getLastException();
                        }
                        ResultSet sQLException = resultSetWrapper.getResultSet();
                        this.children = new Vector();
                        while (sQLException.next()) {
                            this.children.add(new TreeNode(sQLException.getString(DimensionMemberModel.RS_DIM_KEY), sQLException.getString(DimensionMemberModel.RS_DESCRIPTION), this.level + 1));
                        }
                    }
                    catch (SQLException sQLException) {
                        DimensionMemberModel.this.LOG.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    }
                    finally {
                        if (resultSetWrapper != null) {
                            resultSetWrapper.close();
                        }
                        Connections.getInstance().unlock(DimensionMemberModel.this.conn);
                    }
                }
            }
            if (this.validFilter()) {
                if (this.staleFilter()) {
                    this.updateFilter();
                    this.filteredChildren.clear();
                    for (TreeNode treeNode : this.children) {
                        if (!this.matchesFilter(treeNode)) continue;
                        this.filteredChildren.add(treeNode);
                    }
                }
                return this.filteredChildren;
            }
            return this.children;
        }

        public boolean isLeaf() {
            if (DimensionMemberModel.this.levelList.size() == this.level) {
                return true;
            }
            return this.children != null && this.children.size() == 0 || this.validFilter() && !this.staleFilter() && this.filteredChildren.size() == 0;
        }

        public TreeNode getChildAt(int n) {
            return this.getChildren().get(n);
        }

        public int getChildCount() {
            return this.getChildren().size();
        }

        public String toString() {
            return this.description == null ? this.dimkey : this.description;
        }

        public String getDimkey() {
            return this.dimkey;
        }

        public String getDescription() {
            return this.description;
        }

        public void setCurrentFilter(String[] stringArray) {
            this.currentFilter = stringArray;
        }

        public String[] getCurrentFilter() {
            return this.currentFilter;
        }
    }
}

