/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.qdr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.ui.builders.BreadcrumbsTableBuilder;
import oracle.javatools.ui.builders.BuiltBreadcrumbsTable;
import oracle.javatools.ui.ghost.GhostBuilder;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.treetable.NodeTableModelAdapter;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.olap.OLAPArb;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.syntaxbuilder.qdr.DimensionMemberModel;

public class DimensionMemberPanel
extends JPanel {
    private transient BuiltBreadcrumbsTable<DimensionMemberModel.TreeNode> builtTable;
    private JTree tree;
    private String dimension;
    private transient Queries queries;
    private boolean useTable = true;
    private transient Logger LOG = Logger.getLogger(DimensionMemberPanel.class.getName());
    private static final String XMLFILE = "QDRQueries.xml";
    private static final String PACK = Queries.class.getPackage().getName();
    static final String HIERARCHY_NAME = "HIERARCHY_NAME";
    static final String VIEW_NAME = "VIEW_NAME";

    public DimensionMemberPanel(String string, String string2, Connection connection) {
        super(new BorderLayout());
        Object object;
        String string3;
        try {
            string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr(string3, PACK, this);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.dimension = string2;
        string3 = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("DIMENSION", string2);
        hashMap.put("OWNER", string);
        List list = string3.executeReturnList(this.queries.getSQL(DimensionMemberModel.Steps.HIERARCHIES.name()), hashMap);
        Vector<DimensionMemberModel> vector = new Vector<DimensionMemberModel>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (Map)object2.next();
            vector.add(new DimensionMemberModel(string, string2, String.valueOf(object.get(HIERARCHY_NAME)), String.valueOf(object.get(VIEW_NAME)), this.queries, connection));
        }
        if (vector.size() == 0 && (object2 = string3.executeReturnOneCol(this.queries.getSQL(DimensionMemberModel.Steps.DIM_VIEW.name()), hashMap)) != null) {
            vector.add(new DimensionMemberModel(string, string2, null, (String)object2, this.queries, connection));
        }
        object2 = new JComboBox(vector);
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)new JLabel(OLAPArb.getString("DIMENSION_MEMBER_SELECTOR_HIERARCHY")), "West");
        ((Container)object).add((Component)object2, "Center");
        ((JComboBox)object2).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DimensionMemberModel dimensionMemberModel = (DimensionMemberModel)((Object)itemEvent.getItem());
                    DimensionMemberModel.TreeNode treeNode = (DimensionMemberModel.TreeNode)DimensionMemberPanel.this.builtTable.getModel().getRoot();
                    DimensionMemberPanel.this.builtTable.setBreadcrumbPath(new TreePath(treeNode));
                    DimensionMemberPanel.this.builtTable.setSelectedNode((Object)treeNode);
                    treeNode = (DimensionMemberModel.TreeNode)dimensionMemberModel.getRoot();
                    DimensionMemberPanel.this.builtTable.setModel((TreeTableModel)dimensionMemberModel, (Object)treeNode);
                    DimensionMemberPanel.this.builtTable.setBreadcrumbPath(new TreePath(treeNode));
                    DimensionMemberPanel.this.builtTable.setSelectedNode((Object)treeNode);
                }
            }
        });
        if (this.useTable) {
            BreadcrumbsTableBuilder breadcrumbsTableBuilder = new BreadcrumbsTableBuilder();
            breadcrumbsTableBuilder.setModel((TreeTableModel)vector.get(0));
            breadcrumbsTableBuilder.setShowColumnSelector(false);
            this.builtTable = breadcrumbsTableBuilder.build();
            this.builtTable.getTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.popup(mouseEvent);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.popup(mouseEvent);
                }

                private void popup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        final int n = DimensionMemberPanel.this.builtTable.getTable().columnAtPoint(mouseEvent.getPoint());
                        int n2 = DimensionMemberPanel.this.builtTable.getTable().getColumnModel().getColumn(n).getWidth();
                        NodeTableModelAdapter nodeTableModelAdapter = (NodeTableModelAdapter)DimensionMemberPanel.this.builtTable.getTable().getModel();
                        final DimensionMemberModel dimensionMemberModel = (DimensionMemberModel)nodeTableModelAdapter.getTreeTableModel();
                        EnumSet<GhostBuilder.Features> enumSet = EnumSet.of(GhostBuilder.Features.LOOK_LIGHT, GhostBuilder.Features.GO_BUTTON);
                        final JTextField jTextField = new JTextField(dimensionMemberModel.getFilter(n));
                        GhostBuilder.GhostBuiltPalette ghostBuiltPalette = GhostBuilder.build(enumSet, (JComponent)jTextField, (String)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_FILTER"));
                        FocusAdapter focusAdapter = new FocusAdapter((GhostPalette)ghostBuiltPalette){
                            final /* synthetic */ GhostPalette val$ghost;
                            {
                                this.val$ghost = ghostPalette;
                            }

                            @Override
                            public void focusLost(FocusEvent focusEvent) {
                                DimensionMemberPanel.this.setFilter(jTextField.getText(), n, dimensionMemberModel);
                                this.val$ghost.hidePanel();
                            }
                        };
                        jTextField.addFocusListener(focusAdapter);
                        jTextField.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                DimensionMemberPanel.this.setFilter(jTextField.getText(), n, dimensionMemberModel);
                            }
                        });
                        ghostBuiltPalette.setHideOnLoseFocus(true);
                        ghostBuiltPalette.addFocusListener((FocusListener)focusAdapter);
                        jTextField.setBackground(ghostBuiltPalette.getBackground());
                        ghostBuiltPalette.setSize(n2, 60);
                        ghostBuiltPalette.setPreferredSize(new Dimension(n2, 60));
                        Point point = DimensionMemberPanel.this.builtTable.getTable().getLocationOnScreen();
                        Point point2 = DimensionMemberPanel.this.getLocationOnScreen();
                        ghostBuiltPalette.setLocation(point.x - point2.x + n2 * n, point.y - point2.y);
                        ghostBuiltPalette.show(false, true);
                    }
                }
            });
            this.add((Component)this.builtTable.getGUI(), "Center");
        } else {
            this.tree = new JTree((TreeModel)vector.get(0));
            this.tree.setShowsRootHandles(true);
            this.add((Component)new JScrollPane(this.tree), "Center");
        }
        this.add((Component)object, "North");
    }

    private void setFilter(String string, int n, DimensionMemberModel dimensionMemberModel) {
        dimensionMemberModel.setFilter(n, string);
        TreePath treePath = this.builtTable.getBreadcrumbPath();
        this.builtTable.setBreadcrumbPath(treePath);
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    public QDRData getSelectedValue() {
        if (this.useTable) {
            if (this.builtTable.getSelectedRow() != -1) {
                DimensionMemberModel.TreeNode treeNode = ((DimensionMemberModel.TreeNode)this.builtTable.getSelectedNode()).getChildAt(this.builtTable.getSelectedRow());
                return new QDRData(this.dimension, treeNode.getDimkey(), treeNode.getDescription());
            }
        } else {
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath != null) {
                DimensionMemberModel.TreeNode treeNode = (DimensionMemberModel.TreeNode)treePath.getLastPathComponent();
                return new QDRData(this.dimension, treeNode.getDimkey(), treeNode.getDescription());
            }
        }
        return null;
    }
}

