/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.qdr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.table.Queries;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyViewerDialog;
import oracle.olap.syntaxbuilder.TableCellButtonWrapper;
import oracle.olap.syntaxbuilder.qdr.QDRTableModel;
import oracle.olap.util.OLAPErrorDisplay;

public class QDRPanel
extends JPanel {
    private transient Logger LOG = Logger.getLogger(QDRPanel.class.getName());
    private final QDRTableModel model;
    private transient Connection conn;
    private final String owner;
    private static final String XMLFILE = "QDRQueries.xml";
    private static final String PACK = "oracle.olap.app.table";
    private transient Queries queries;
    private Schema schema;

    public QDRPanel(Connection connection, Vector<QDRData> vector, String string) {
        super(new BorderLayout());
        this.conn = connection;
        this.owner = string;
        try {
            this.queries = (Queries)JavaXMLBind.BindToJava(this.getClass().getResource(XMLFILE), PACK, null);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olap_select_qdr");
        JTable jTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add((Component)jScrollPane, "Center");
        this.model = new QDRTableModel(vector);
        jTable.setModel(this.model);
        TableColumn tableColumn = jTable.getColumn(QDRTableModel.COLUMNS[1]);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        jComboBox.addItem("");
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        SearchButton searchButton = new SearchButton(defaultCellEditor);
        SearchButton searchButton2 = new SearchButton(new DefaultTableCellRenderer());
        tableColumn.setCellEditor(searchButton);
        tableColumn.setCellRenderer(searchButton2);
    }

    class SearchButton
    extends TableCellButtonWrapper {
        SearchButton(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer, OracleIcons.getIcon((String)"edit.png"));
        }

        SearchButton(TableCellEditor tableCellEditor) {
            super(tableCellEditor, OracleIcons.getIcon((String)"edit.png"));
        }

        @Override
        public void buttonPress() {
            Object object;
            Object object2;
            String string = (String)QDRPanel.this.model.getValueAt(this.getRow(), 0);
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            String string2 = OLAPArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
            OLAPResources oLAPResources = new OLAPResources();
            DBUtil dBUtil = DBUtil.getInstance((Connection)QDRPanel.this.conn);
            String string3 = dBUtil.getConnectionResolver().getConnectionName(QDRPanel.this.conn);
            try {
                QDRPanel.this.schema = OLAPMetadataCache.getUpdatedSchema(string3, QDRPanel.this.owner);
            }
            catch (Exception exception) {
                QDRPanel.this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
            }
            oracle.olap.app.olapmetadata.Dimension dimension = QDRPanel.this.schema.findDimension(string);
            ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
            if (!dimension.isFlat()) {
                object2 = dimension.getHierarchies();
                Iterator<DimensionHierarchy> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    try {
                        arrayList.add(new HierarchyET(QDRPanel.this.conn, dimension, (DimensionHierarchy)object));
                    }
                    catch (SQLException sQLException) {
                        QDRPanel.this.LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
                    }
                    catch (IOException iOException) {
                        QDRPanel.this.LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                    }
                }
            } else {
                try {
                    arrayList.add(new HierarchyET(QDRPanel.this.conn, dimension, null));
                }
                catch (SQLException sQLException) {
                    QDRPanel.this.LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
                }
                catch (IOException iOException) {
                    QDRPanel.this.LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                }
            }
            if (arrayList.size() > 0) {
                try {
                    HierarchyViewerDialog hierarchyViewerDialog = new HierarchyViewerDialog((Window)ideMainWindow, string2, arrayList, null, oLAPResources, "SELECT_DIMENSION_MEMBERS_MODE");
                    hierarchyViewerDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    object2 = new Dimension(350, 400);
                    hierarchyViewerDialog.setPreferredSize((Dimension)object2);
                    hierarchyViewerDialog.setSize((Dimension)object2);
                    hierarchyViewerDialog.setVisible(true);
                    boolean bl = hierarchyViewerDialog.isOKSelected();
                    if (bl && (object = hierarchyViewerDialog.getTree().getSelectionPath()) != null) {
                        Object object3 = ((TreePath)object).getLastPathComponent();
                        DefaultNode defaultNode = (DefaultNode)object3;
                        HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                        QDRData qDRData = new QDRData(string, hierarchyNodeData.dimKey, hierarchyNodeData.desc);
                        QDRPanel.this.model.setRowValue(qDRData, this.getRow());
                    }
                }
                catch (Exception exception) {
                    oLAPErrorDisplay.show(exception, OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR"), OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), QDRPanel.this);
                    QDRPanel.this.LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            } else {
                MessageDialog.error((Component)QDRPanel.this, (Object)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), null);
            }
        }
    }

    class DeleteButton
    extends TableCellButtonWrapper {
        DeleteButton(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer, OracleIcons.getIcon((String)"delete.png"));
        }

        DeleteButton(TableCellEditor tableCellEditor) {
            super(tableCellEditor, OracleIcons.getIcon((String)"delete.png"));
        }

        @Override
        public void buttonPress() {
            QDRPanel.this.model.setValueAt(null, this.getRow(), this.getColumn());
        }
    }
}

