/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.shuttle;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.olap.OLAPArb;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.app.templates.templatedialog.TemplateHelper;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;
import oracle.olap.util.OLAPErrorDisplay;

public class TemplateHandlerPopup
implements TemplateHandler {
    private static final Logger LOG = Logger.getLogger(TemplateHandlerPopup.class.getName());
    protected final InsertionHandlerEditorPlugin ihandler;
    protected final Spec spec;
    private Component parentComponent;
    private ParseNode selectedNode;

    public TemplateHandlerPopup(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, Component component) {
        this.ihandler = insertionHandlerEditorPlugin;
        this.spec = spec;
        this.parentComponent = component;
    }

    @Override
    public void insertNode(SpecTreeNode specTreeNode) {
        this.insertNode(specTreeNode, INSERTBUTTONS);
    }

    @Override
    public void insertNode(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray) {
        if (specTreeNode == null || !specTreeNode.isInsertable()) {
            return;
        }
        try {
            this.ihandler.insertSyntax(this.callTemplate(specTreeNode, modeArray));
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            new OLAPErrorDisplay().show(exception, OLAPArb.getString("EXPRESSION_EDITOR_ERROR_SHOWING_TEMPLATE_TITLE"), OLAPArb.getString("EXPRESSION_EDITOR_ERROR_SHOWING_TEMPLATE"), this.parentComponent);
        }
    }

    @Override
    public TemplateData callTemplate(String string, TemplateData.Mode[] modeArray) throws SQLException, IOException {
        SpecTreeNode specTreeNode = this.spec.findByTemplateType(string);
        if (specTreeNode != null) {
            return this.callTemplate(specTreeNode, modeArray);
        }
        return null;
    }

    @Override
    public TemplateData callTemplate(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray) throws SQLException, IOException {
        if (specTreeNode.getTemplateHelper() != null) {
            TemplateHelper templateHelper = specTreeNode.getTemplateHelper();
            TemplateGUI templateGUI = templateHelper.getGUI(true);
            templateGUI.setValueMap(this.createValueMap());
            JOptionPane jOptionPane = new JOptionPane(templateGUI.getComponent(), -1, 2, null, (Object[])templateHelper.availableModes(modeArray));
            String string = templateHelper.getTitle();
            JDialog jDialog = jOptionPane.createDialog(this.parentComponent, string);
            jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            jDialog.setVisible(true);
            TemplateData.Mode mode = TemplateData.Mode.CANCEL;
            if (jOptionPane.getValue() instanceof TemplateData.Mode) {
                mode = (TemplateData.Mode)((Object)jOptionPane.getValue());
            }
            TemplateData templateData = templateGUI.getSyntax(mode);
            String string2 = this.spec.getSyntaxParser().formatSyntax(templateData.getSyntax());
            if (this.selectedNode != null) {
                int n = this.selectedNode.getOffset();
                int n2 = this.selectedNode.getReplaceEnd();
                this.selectedNode = null;
                return new TemplateData(string2, templateData.getMode(), n, n2 - n);
            }
            return new TemplateData(string2, templateData);
        }
        return new TemplateData(specTreeNode.getTemplate());
    }

    @Override
    public void addEditorButtons(List<SpecTreeNode> list) {
    }

    @Override
    public void syntaxClicked(MouseEvent mouseEvent, ParseNode parseNode) {
        SpecTreeNode specTreeNode;
        if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (specTreeNode = this.spec.findMatchingNode(parseNode)) != null) {
            specTreeNode.getTemplateHelper().getGUI(true).loadParseNode(parseNode, this.ihandler.getSyntax());
            this.selectedNode = parseNode;
            this.insertNode(specTreeNode, EDITBUTTONS);
        }
    }

    @Override
    public void tokenSelected(String string, int n, ParseNode parseNode, SpecTreeNode specTreeNode) {
    }

    protected Map<String, String> createValueMap() {
        String string = this.ihandler.getSelection();
        String string2 = this.ihandler.getSyntax();
        if (string2 != null && string2.equals(string)) {
            string2 = null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        if (string != null) {
            hashMap.put("selection", string);
        }
        if (string2 != null) {
            hashMap.put("contents", string2);
        }
        return hashMap;
    }
}

