/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.util.Namespace;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.db.CubeSQL;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.timegen.TimeDimensionGenerator;
import oracle.olap.timegen.model.TimeGenAttribute;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Time;
import oracle.olap.timegen.timexml.TimeColumn;
import oracle.olap.timegen.timexml.TimeLevel;

public class TimeDimensionGeneratorDDL
implements TimeDimensionGenerator {
    @Override
    public boolean generateTimeDimension(Time time, Namespace namespace) throws Exception {
        boolean bl = true;
        CubeDimension cubeDimension = new CubeDimension();
        String string = (String)namespace.get("ANALYTIC_WORKSPACE");
        cubeDimension.setAnalyticWorkspace(string);
        String string2 = (String)namespace.get("SCHEMA");
        Schema schema = new Schema(string2);
        cubeDimension.setSchema(schema);
        String string3 = (String)namespace.get("DIMENSION_NAME");
        cubeDimension.setName(string3);
        cubeDimension.generateDescriptions();
        cubeDimension.setHierarchyConsistencyRule("CONSISTENT");
        cubeDimension.setAddUniqueKeys(true);
        cubeDimension.setDimensionType("TIME");
        this.createAttributes(cubeDimension, time, namespace);
        this.createDimLevelsAndMap(cubeDimension, time, namespace);
        DBObject dBObject = (DBObject)namespace.get("DBOBJECT");
        Database database = dBObject.getDatabase();
        DDLGenerator dDLGenerator = database.getDDLGenerator();
        oracle.javatools.db.DBObject[] dBObjectArray = new oracle.javatools.db.DBObject[]{cubeDimension};
        DDL dDL = dDLGenerator.getCreateDDL(new DDLOptions(), dBObjectArray);
        Collection collection = dDL.getStatements();
        boolean bl2 = false;
        CubeSQL cubeSQL = new CubeSQL((DDLDatabase)database, bl2, null, (SystemObject)cubeDimension, collection, true);
        String string4 = cubeSQL.execute();
        if (database instanceof AbstractDatabase) {
            AbstractDatabase abstractDatabase = (AbstractDatabase)database;
            SystemObject[] systemObjectArray = new SystemObject[]{null};
            SystemObject[] systemObjectArray2 = new SystemObject[]{cubeDimension};
            Difference difference = database.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            abstractDatabase.finishUpdates(difference);
        }
        return bl;
    }

    private void createAttributes(CubeDimension cubeDimension, Time time, Namespace namespace) {
        List<TimeLevel> list = time.getTimeLevels();
        List list2 = (List)namespace.get("LEVELS");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : list2) {
                if (!string.equalsIgnoreCase(timeGenLevel.getName()) || !timeGenLevel.isSelected().booleanValue()) continue;
                List<TimeColumn> list3 = timeLevel.getTimeColumns();
                for (TimeColumn timeColumn : list3) {
                    String string2 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list4 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list4) {
                        if (!string2.equalsIgnoreCase(timeGenAttribute.getType()) || !timeGenAttribute.isSelected().booleanValue() || arrayList.contains(string2) || string2.equalsIgnoreCase("ID")) continue;
                        arrayList.add(string2);
                        String string3 = timeColumn.getAttributeDescription();
                        CubeDimensionAttribute cubeDimensionAttribute = new CubeDimensionAttribute(string2);
                        cubeDimensionAttribute.setOriginalAttributeName(string2);
                        cubeDimension.addAttribute(cubeDimensionAttribute);
                        if (string2.equalsIgnoreCase("LONG_DESCRIPTION") || string2.equalsIgnoreCase("SHORT_DESCRIPTION") || string2.equalsIgnoreCase("TIME_SPAN") || string2.equalsIgnoreCase("END_DATE")) {
                            cubeDimensionAttribute.setAttributeVisibleForAll(true);
                        } else {
                            cubeDimensionAttribute.setAttributeVisibleForAll(false);
                        }
                        cubeDimensionAttribute.setDescription(string3);
                        cubeDimensionAttribute.setLongDescription(string3);
                        cubeDimensionAttribute.setShortDescription(string3);
                        cubeDimensionAttribute.setIndex(true);
                        cubeDimensionAttribute.setDataType(timeColumn.getDataType());
                        if (string2.equalsIgnoreCase("LONG_DESCRIPTION")) {
                            cubeDimensionAttribute.setRole("LONG_DESCRIPTION");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("SHORT_DESCRIPTION")) {
                            cubeDimensionAttribute.setRole("SHORT_DESCRIPTION");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("TIME_SPAN")) {
                            cubeDimensionAttribute.setRole("TIME_SPAN");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("END_DATE")) {
                            cubeDimensionAttribute.setRole("END_DATE");
                            cubeDimensionAttribute.setPersistedOrSpecial(true);
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("ID")) continue;
                    }
                }
            }
        }
    }

    private void createDimLevelsAndMap(CubeDimension cubeDimension, Time time, Namespace namespace) {
        String string = (String)namespace.get("TABLE_NAME");
        List<TimeLevel> list = time.getTimeLevels();
        List list2 = (List)namespace.get("LEVELS");
        String string2 = (String)namespace.get("HIERARCHY_NAME");
        CubeDimensionHierarchy cubeDimensionHierarchy = new CubeDimensionHierarchy(string2);
        cubeDimensionHierarchy.generateDescriptions();
        cubeDimensionHierarchy.setHierarchyDefault(true);
        cubeDimensionHierarchy.setNotRagged(true);
        cubeDimensionHierarchy.setNotSkipLevel(true);
        cubeDimension.addHierarchy(cubeDimensionHierarchy);
        ArrayList<CubeDimensionHierarchyLevel> arrayList = new ArrayList<CubeDimensionHierarchyLevel>();
        for (TimeLevel timeLevel : list) {
            String string3 = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : list2) {
                if (!string3.equalsIgnoreCase(timeGenLevel.getName()) || !timeGenLevel.isSelected().booleanValue()) continue;
                if (!timeGenLevel.isShared().booleanValue()) {
                    string3 = String.format("%s_%s", string2, string3);
                }
                CubeDimensionLevel cubeDimensionLevel = new CubeDimensionLevel(string3);
                cubeDimensionLevel.generateDescriptions();
                cubeDimension.addLevel(cubeDimensionLevel);
                CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = new CubeDimensionHierarchyLevel(cubeDimensionHierarchy, cubeDimensionLevel);
                arrayList.add(cubeDimensionHierarchyLevel);
                List<TimeColumn> list3 = timeLevel.getTimeColumns();
                for (TimeColumn timeColumn : list3) {
                    String string4 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list4 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list4) {
                        String[] stringArray;
                        AbstractChildDBObject abstractChildDBObject;
                        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
                        if ((!string4.equalsIgnoreCase(timeGenAttribute.getType()) || !timeGenAttribute.isSelected().booleanValue()) && !string4.equalsIgnoreCase("ID")) continue;
                        String string5 = timeColumn.getColumn();
                        string5 = string + "." + string5;
                        if (string4.equalsIgnoreCase("ID")) {
                            abstractChildObjectWithDesc = cubeDimensionHierarchyLevel;
                            if (abstractChildObjectWithDesc == null) continue;
                            abstractChildDBObject = ((CubeDimensionHierarchyLevel)abstractChildObjectWithDesc).getMap();
                            if (abstractChildDBObject == null) {
                                abstractChildDBObject = new CubeDimensionMap(cubeDimension);
                            }
                            abstractChildDBObject.setKeyExpression(string5);
                            stringArray = string5.split("\\.");
                            abstractChildDBObject.setMapQuery(stringArray[0]);
                            if (abstractChildDBObject == null) continue;
                            ((CubeDimensionHierarchyLevel)abstractChildObjectWithDesc).setMap((CubeDimensionMap)abstractChildDBObject);
                            continue;
                        }
                        abstractChildObjectWithDesc = cubeDimension.findAttribute(string4);
                        if (!(string4.equalsIgnoreCase("LONG_DESCRIPTION") || string4.equalsIgnoreCase("SHORT_DESCRIPTION") || string4.equalsIgnoreCase("TIME_SPAN") || string4.equalsIgnoreCase("END_DATE"))) {
                            cubeDimensionHierarchyLevel.addVisibleAttribute((CubeDimensionAttribute)abstractChildObjectWithDesc);
                            ((CubeDimensionAttribute)abstractChildObjectWithDesc).setAttributeVisibleForAll(false);
                        }
                        if ((abstractChildDBObject = cubeDimensionHierarchyLevel) == null) continue;
                        stringArray = abstractChildDBObject.getMap();
                        CubeDimensionAttributeMap cubeDimensionAttributeMap = stringArray.findAttributeMap(string4);
                        if (stringArray == null) continue;
                        if (cubeDimensionAttributeMap == null && string5 != null) {
                            cubeDimensionAttributeMap = new CubeDimensionAttributeMap((CubeDimensionAttribute)abstractChildObjectWithDesc, string5);
                            stringArray.addAttributeMap(cubeDimensionAttributeMap);
                        }
                        if (cubeDimensionAttributeMap != null && string5 != null) {
                            cubeDimensionAttributeMap.setMapExpression(string5);
                        }
                        if (cubeDimensionAttributeMap == null || string5 != null) continue;
                        stringArray.removeAttributeMap(cubeDimensionAttributeMap);
                    }
                }
            }
        }
        cubeDimensionHierarchy.setHierarchyLevels(arrayList.toArray(new CubeDimensionHierarchyLevel[arrayList.size()]));
    }
}

