/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.Namespace;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.Database;
import oracle.olap.timegen.BaseTimeTableGenerator;
import oracle.olap.timegen.model.TimeGenAttribute;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Time;
import oracle.olap.timegen.timexml.TimeColumn;
import oracle.olap.timegen.timexml.TimeLevel;

public class TimeTableGeneratorXML
extends BaseTimeTableGenerator {
    private Time time;

    public TimeTableGeneratorXML(Database database) {
        super(database);
    }

    public TimeTableGeneratorXML(Time time, Namespace namespace) {
        super(namespace);
        this.time = time;
    }

    public void addTime(Time time) {
        this.time = time;
    }

    @Override
    public String getTimeTableSQL() {
        String string;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "drop table " + this.getTableName();
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        if (this.time == null) {
            try {
                object = "time.xml";
                string = JavaXMLBind.LoadDocument(TimeTableGeneratorXML.class, (String)object);
                JavaXMLBind.BindToJavaStr(string, "oracle.olap.timegen.timexml", this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = this.time.getTimeLevels();
        stringBuffer.append(this.getCreateTableSQL((List<TimeLevel>)object));
        stringBuffer.append("\n");
        string = this.getInsertIntoTableSQL((List<TimeLevel>)object);
        String string3 = new SimpleDateFormat("yyyy-MM-dd").format(this.startDate);
        string3 = "'" + string3 + "'";
        String string4 = Integer.toString(this.numOfYears);
        string = string.replaceAll(":13", string3);
        string = string.replaceAll(":12", string4);
        string = string.replaceAll(":11", string3);
        string = string.replaceAll(":10", string3);
        string = string.replaceAll(":9", string4);
        string = string.replaceAll(":8", string3);
        string = string.replaceAll(":7", string3);
        string = string.replaceAll(":6", string3);
        string = string.replaceAll(":5", string3);
        string = string.replaceAll(":4", string3);
        string = string.replaceAll(":3", string3);
        string = string.replaceAll(":2", string3);
        string = string.replaceAll(":1", string3);
        stringBuffer.append(string);
        String string5 = stringBuffer.toString();
        return string5;
    }

    @Override
    public void generateTimeTable() throws Exception {
        Object object;
        String string;
        if (this.time == null) {
            string = "time.xml";
            object = JavaXMLBind.LoadDocument(TimeTableGeneratorXML.class, string);
            JavaXMLBind.BindToJavaStr((String)object, "oracle.olap.timegen.timexml", this);
        }
        string = "drop table " + this.getTableName();
        System.out.println(string);
        try {
            this.database.executeSQL(string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        object = this.time.getTimeLevels();
        String string2 = this.getCreateTableSQL((List<TimeLevel>)object);
        String string3 = this.getInsertIntoTableSQL((List<TimeLevel>)object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string4 = new SimpleDateFormat("yyyy-MM-dd").format(this.startDate);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(new Integer(this.numOfYears));
        arrayList.add(string4);
        arrayList.add(string4);
        arrayList.add(new Integer(this.numOfYears));
        arrayList.add(string4);
        Object[] objectArray = arrayList.toArray();
        this.database.executeSQL(string2);
        System.out.println(string3);
        this.database.executeSQL(string3, objectArray);
    }

    private String getCreateTableSQL(List<TimeLevel> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create table " + this.getTableName() + " (\n");
        block0: for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : this.levels) {
                String string2 = timeGenLevel.getName();
                boolean bl = timeGenLevel.isSelected();
                if (!string2.equalsIgnoreCase(string) || !bl) continue;
                block2: for (TimeColumn timeColumn : timeLevel.getTimeColumns()) {
                    String string3 = timeColumn.getColumn();
                    String string4 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list2 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list2) {
                        String string5 = timeGenAttribute.getName();
                        boolean bl2 = timeGenAttribute.isSelected();
                        if ((!string5.equalsIgnoreCase(string3) || !bl2) && !string4.equalsIgnoreCase("ID")) continue;
                        stringBuffer.append("    " + string3);
                        stringBuffer.append(" " + timeColumn.getDataType() + ",\n");
                        continue block2;
                    }
                }
                continue block0;
            }
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        return string;
    }

    private String getInsertIntoTableSQL(List<TimeLevel> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into " + this.getTableName() + "\n");
        stringBuffer.append("  select \n");
        block0: for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : this.levels) {
                String string2 = timeGenLevel.getName();
                boolean bl = timeGenLevel.isSelected();
                if (!string2.equalsIgnoreCase(string) || !bl) continue;
                block2: for (TimeColumn timeColumn : timeLevel.getTimeColumns()) {
                    String string3 = timeColumn.getColumn();
                    String string4 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list2 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list2) {
                        String string5 = timeGenAttribute.getName();
                        boolean bl2 = timeGenAttribute.isSelected();
                        if ((!string5.equalsIgnoreCase(string3) || !bl2) && !string4.equalsIgnoreCase("ID")) continue;
                        String string6 = timeGenAttribute.getFormat();
                        String string7 = timeColumn.getSelectColumn();
                        if (string6 != null && string6.length() > 0) {
                            string7 = string7.replaceAll("\\$\\{FORMAT\\}", string6);
                        }
                        stringBuffer.append("    " + string7 + " " + string3 + ",\n");
                        continue block2;
                    }
                }
                continue block0;
            }
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        stringBuffer.append("  from \n    ");
        stringBuffer.append(this.time.getTimeSQL().getSQL());
        stringBuffer.append("\n  ");
        stringBuffer.append(this.time.getOrderBy().getSQL());
        String string = stringBuffer.toString();
        string = string.replaceAll("hierarchy_prefix", "CAL");
        return string;
    }
}

