/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.olap.OLAPArb;
import oracle.olap.timegen.ui.wizard.TimeGenLevelModel;
import oracle.olap.timegen.ui.wizard.TimeGenTableCheckBoxCellRenderer;
import oracle.olap.timegen.ui.wizard.TimeGenWizardPanel;

public class TimeGenLevelsPanel
extends TimeGenWizardPanel {
    private TimeGenLevelModel timeGenLevelModel = new TimeGenLevelModel();
    private JTable levelsTable;

    public TimeGenLevelsPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("TIME_GEN_WIZARD_LEVELS_STEP_INSTRUCTION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)multiLineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 9;
        JPanel jPanel = this.getLevelsPanel();
        this.add(jPanel, gridBagConstraints);
    }

    private JPanel getLevelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("levelsPanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.levelsTable = new JTable((TableModel)((Object)this.timeGenLevelModel));
        this.levelsTable.setName("levelsTable");
        TableColumn tableColumn = this.levelsTable.getColumnModel().getColumn(this.timeGenLevelModel.SHARED_COLUMN);
        tableColumn.setCellRenderer(new TimeGenTableCheckBoxCellRenderer());
        this.timeGenLevelModel.setTable(this.levelsTable);
        this.timeGenLevelModel.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane(this.levelsTable);
        jScrollPane.setName("tablePane");
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void initializeData(TraversableContext traversableContext) {
        List list = (List)traversableContext.get("LEVELS");
        Boolean bl = (Boolean)traversableContext.get("CREATE_DIMENSION");
        this.timeGenLevelModel.setIsCreateHierarchy(bl);
        this.timeGenLevelModel.setRowList(list);
    }

    @Override
    public void setContext(TraversableContext traversableContext) {
        List list = this.timeGenLevelModel.getRowList();
        traversableContext.put("LEVELS", (Object)list);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initializeData(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateFields(traversableContext);
        this.setContext(traversableContext);
    }

    public Object getExitTransition() {
        return "ATTRIBUTES";
    }

    @Override
    public void validateFields(TraversableContext traversableContext) {
    }
}

