/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.Resources;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.app.util.TextViewerDialog;
import oracle.olap.db.AWListRunnable;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.timegen.TimeDimensionGeneratorDDL;
import oracle.olap.timegen.TimeTableGenerator;
import oracle.olap.timegen.TimeTableGeneratorXML;
import oracle.olap.timegen.model.TimeGenAttribute;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Time;
import oracle.olap.timegen.timexml.TimeColumn;
import oracle.olap.timegen.timexml.TimeFormat;
import oracle.olap.timegen.timexml.TimeLevel;
import oracle.olap.timegen.ui.wizard.TimeGenAttrsPanel;
import oracle.olap.timegen.ui.wizard.TimeGenGeneralPanel;
import oracle.olap.timegen.ui.wizard.TimeGenLevelsPanel;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;

public class TimeGenWizMain {
    static final String STATE_LEVELS = "StateLevels";
    static final String TRANSITION_LEVELS = "LEVELS";
    static final String STATE_ATTRIBUTES = "StateAttributes";
    static final String TRANSITION_ATTRIBUTES = "ATTRIBUTES";
    public static final String DBOBJECT = "DBOBJECT";
    public static final String DATABASE = "DATABASE";
    public static final String SCHEMA = "SCHEMA";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String START_DATE = "START_DATE";
    public static final String NUMBER_OF_YEARS = "NUMBER_OF_YEARS";
    public static final String DIMENSION_NAME = "DIMENSION_NAME";
    public static final String HIERARCHY_NAME = "HIERARCHY_NAME";
    public static final String LEVELS = "LEVELS";
    public static final String CREATE_DIMENSION = "CREATE_DIMENSION";
    public static final String TIME_DIMENSIONS = "TIME_DIMENSIONS";
    public static final String ANALYTIC_WORKSPACES = "ANALYTIC_WORKSPACES";
    public static final String ANALYTIC_WORKSPACE = "ANALYTIC_WORKSPACE";
    private static final String DEFAULT_DIMENSION_NAME = "TIME";
    private static final String DEFAULT_TABLE_NAME = "TIME_SOURCE";
    private static final String DEFAULT_HIERARCHY_NAME = "CALENDAR";
    private static TimeGenWizMain INSTANCE;
    private static final Logger LOGGER;
    private Time time;
    private boolean success;
    private boolean refreshTree = false;

    private TimeGenWizMain() {
    }

    public static TimeGenWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TimeGenWizMain();
        }
        return INSTANCE;
    }

    public void launchWizard(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getSchemaName();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string2 = null;
        string2 = CubeAWUtil.getAnalyticWorkspaceName(dBObject);
        FSM fSM = TimeGenWizMain.getFSM();
        final Namespace namespace = new Namespace();
        try {
            DatabaseImpl databaseImpl = new DatabaseImpl();
            databaseImpl.setConnection(connection);
            namespace.put(DBOBJECT, (Object)dBObject);
            namespace.put(DATABASE, (Object)databaseImpl);
            namespace.put(SCHEMA, (Object)string);
            this.loadTimeXMLDocument();
            namespace.put(CREATE_DIMENSION, (Object)true);
            namespace.put(DIMENSION_NAME, (Object)DEFAULT_DIMENSION_NAME);
            namespace.put(TABLE_NAME, (Object)DEFAULT_TABLE_NAME);
            namespace.put(HIERARCHY_NAME, (Object)DEFAULT_HIERARCHY_NAME);
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            int n2 = 0;
            int n3 = 1;
            calendar.set(n, n2, n3);
            Date date = calendar.getTime();
            namespace.put(START_DATE, (Object)date);
            namespace.put(NUMBER_OF_YEARS, (Object)1);
            List<TimeGenLevel> list = this.getLevelList();
            namespace.put("LEVELS", list);
            List<Object> list2 = new ArrayList<String>();
            if (string2 != null) {
                list2.add(string2);
            } else {
                list2 = this.getAnalyticWorkspaces(connection, string);
            }
            namespace.put(ANALYTIC_WORKSPACES, list2);
            namespace.put(ANALYTIC_WORKSPACE, list2.get(0));
            List<String> list3 = TimeGenWizMain.getTimeDimensions(databaseImpl, string, (String)list2.get(0));
            namespace.put(TIME_DIMENSIONS, list3);
            FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
            String string3 = OLAPArb.get("TIME_GEN_WIZARD_CREATE_TIME_DIMENSION");
            fSMWizard.setWizardTitle(string3);
            fSMWizard.setRoadmapVisible(true);
            final WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
            Dimension dimension = fSMWizard.getPreferredSize();
            int n4 = (int)dimension.getHeight() + 500;
            int n5 = (int)dimension.getWidth() + 500;
            wizardDialog.setSize(n5, n4);
            wizardDialog.setPreferredSize(new Dimension(n5, n4));
            JButton jButton = new JButton(OLAPArb.get("TIME_GEN_WIZARD_SHOW_SQL"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TextViewerDialog textViewerDialog = new TextViewerDialog((JDialog)wizardDialog, OLAPArb.get("TIME_GEN_WIZARD_SHOW_SQL"), true, TimeGenWizMain.this.getSQL(namespace), false, (Resources)new OLAPResources(), (FetchIcon)new OLAPFetchIcon(), (ErrorDisplay)new OLAPErrorDisplay(), Logger.getLogger(this.getClass().getName()));
                    textViewerDialog.setVisible(true);
                }
            });
            fSMWizard.addCustomButton((Component)jButton);
            if (WizardLauncher.runDialog((JDialog)wizardDialog)) {
                Object object;
                Object object2;
                boolean bl;
                boolean bl2 = true;
                String string4 = (String)namespace.get(TABLE_NAME);
                String string5 = "select count(*) from user_tables where table_name = :TABLENAME";
                String string6 = "0";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TABLENAME", string4);
                string6 = dBUtil.executeOracleReturnOneCol(string5, hashMap);
                boolean bl3 = string6.equalsIgnoreCase("1");
                if (bl3 && (bl = JOptionPane.showConfirmDialog((Component)wizardDialog, object2 = OLAPArb.format("TIME_GEN_WIZARD_TABLE_EXISTS_CONFIRM_MSG", string4), (String)(object = OLAPArb.get("TIME_GEN_WIZARD_CREATE_TIME_TABLE")), 0))) {
                    bl2 = false;
                }
                if (bl2) {
                    object2 = null;
                    object = null;
                    object2 = new TimeTableGeneratorXML(this.time, namespace);
                    object = new TimeDimensionGeneratorDDL();
                    bl = (Boolean)namespace.get(CREATE_DIMENSION);
                    this.success = false;
                    boolean bl4 = bl;
                    Namespace namespace2 = namespace;
                    Object object3 = object2;
                    Object object4 = object;
                    DatabaseImpl databaseImpl2 = databaseImpl;
                    final String string7 = string4;
                    RaptorTask raptorTask = new RaptorTask(OLAPArb.get("TIME_GEN_WIZARD_CREATING_TIME"), true, IRaptorTaskRunMode.MODAL, (TimeTableGenerator)object3, databaseImpl2, bl4, namespace2, (TimeDimensionGeneratorDDL)object4){
                        final /* synthetic */ TimeTableGenerator val$tg2;
                        final /* synthetic */ Database val$database2;
                        final /* synthetic */ boolean val$createTimeDim2;
                        final /* synthetic */ Namespace val$initialData2;
                        final /* synthetic */ TimeDimensionGeneratorDDL val$tdg2;
                        {
                            this.val$tg2 = timeTableGenerator;
                            this.val$database2 = database;
                            this.val$createTimeDim2 = bl2;
                            this.val$initialData2 = namespace;
                            this.val$tdg2 = timeDimensionGeneratorDDL;
                            super(string, bl, iRaptorTaskRunMode);
                        }

                        protected Object doWork() throws TaskException {
                            Boolean bl = Boolean.TRUE;
                            try {
                                this.setMessage(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_TABLE", string7));
                                this.val$tg2.generateTimeTable();
                                this.val$database2.executeSQL("commit");
                                if (this.val$createTimeDim2) {
                                    String string = (String)this.val$initialData2.get(TimeGenWizMain.DIMENSION_NAME);
                                    this.setMessage(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION", string));
                                    TimeGenWizMain.this.success = this.val$tdg2.generateTimeDimension(TimeGenWizMain.this.time, this.val$initialData2);
                                }
                            }
                            catch (Exception exception) {
                                bl = Boolean.FALSE;
                                throw new TaskException((Throwable)exception);
                            }
                            return bl;
                        }

                        protected void tearDown() {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_TABLE_SUCCESS", string7));
                            Boolean bl = (Boolean)this.val$initialData2.get(TimeGenWizMain.CREATE_DIMENSION);
                            if (TimeGenWizMain.this.success) {
                                String string = (String)this.val$initialData2.get(TimeGenWizMain.DIMENSION_NAME);
                                String string2 = (String)this.val$initialData2.get(TimeGenWizMain.HIERARCHY_NAME);
                                stringBuffer.append("\n");
                                stringBuffer.append(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION_SUCCESS", string));
                                stringBuffer.append("\n");
                                stringBuffer.append(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION_HIERARCHY_SUCCESS", string2));
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringBuffer.toString());
                                TimeGenWizMain.this.refreshTree = true;
                            } else if (!TimeGenWizMain.this.success && bl.booleanValue()) {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.get("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION_FAILURE"));
                                TimeGenWizMain.this.refreshTree = false;
                            } else {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringBuffer.toString());
                                TimeGenWizMain.this.refreshTree = false;
                            }
                        }
                    };
                    raptorTask.setCancellable(false);
                    raptorTask.setPausable(false);
                    RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
                    raptorTaskManager.addTask(raptorTask);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            String string8 = null;
            String string9 = exception.getLocalizedMessage();
            if (string9 == null || string9.length() == 0) {
                string9 = exception.getClass().toString();
            }
            String string10 = OLAPArb.get("TIME_GEN_ERROR_DLG_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string9, (String)string10, string8);
        }
    }

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TITLE"), TimeGenGeneralPanel.class, "olap_time_gen_general");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"LEVELS", (Object)STATE_LEVELS);
        Step step2 = new Step(OLAPArb.get("TIME_GEN_WIZARD_LEVELS_STEP_TITLE"), TimeGenLevelsPanel.class, "olap_time_gen_select_levels");
        fSMBuilder.newState((Object)STATE_LEVELS, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_ATTRIBUTES, (Object)STATE_ATTRIBUTES);
        Step step3 = new Step(OLAPArb.get("TIME_GEN_WIZARD_ATTRIBUTES_STEP_TITLE"), TimeGenAttrsPanel.class, "olap_time_gen_select_attributes");
        fSMBuilder.newFinalState((Object)STATE_ATTRIBUTES, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public String getSQL(Namespace namespace) {
        TimeTableGeneratorXML timeTableGeneratorXML = null;
        timeTableGeneratorXML = new TimeTableGeneratorXML(null, namespace);
        String string = timeTableGeneratorXML.getTimeTableSQL();
        return string;
    }

    public void addTime(Time time) {
        this.time = time;
    }

    private List<String> getAnalyticWorkspaces(Connection connection, String string) {
        List<String> list = null;
        try {
            AWListRunnable aWListRunnable = new AWListRunnable(connection, string);
            String string2 = OLAPArb.get("AW.FETCH.TITLE");
            string2 = MessageFormat.format(string2, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)aWListRunnable, true);
            progressBar.setCancelable(false);
            aWListRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("AW.FETCH.LIST"), null);
            if (aWListRunnable.getException() != null) {
                throw aWListRunnable.getException();
            }
            list = aWListRunnable.getAnalyticWorkspaces();
        }
        catch (Exception exception) {
            String string3 = null;
            String string4 = exception.getLocalizedMessage();
            if (string4 == null || string4.length() == 0) {
                string4 = exception.getClass().toString();
            }
            String string5 = OLAPArb.get("AW.FETCH.TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string3);
        }
        return list;
    }

    private void loadTimeXMLDocument() throws Exception {
        String string = "time.xml";
        String string2 = JavaXMLBind.LoadDocument(TimeTableGeneratorXML.class, string);
        JavaXMLBind.BindToJavaStr(string2, "oracle.olap.timegen.timexml", this);
    }

    private List<TimeGenLevel> getLevelList() {
        ArrayList<TimeGenLevel> arrayList = new ArrayList<TimeGenLevel>();
        List<TimeLevel> list = this.time.getTimeLevels();
        for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            TimeGenLevel timeGenLevel = new TimeGenLevel(string);
            timeGenLevel.setType(string);
            ArrayList<TimeGenAttribute> arrayList2 = new ArrayList<TimeGenAttribute>();
            List<TimeColumn> list2 = timeLevel.getTimeColumns();
            for (TimeColumn timeColumn : list2) {
                String string2 = timeColumn.getAttribute();
                String string3 = timeColumn.getColumn();
                String string4 = timeColumn.getFormat();
                if (string2.equalsIgnoreCase("ID")) continue;
                TimeGenAttribute timeGenAttribute = new TimeGenAttribute(string3);
                timeGenAttribute.setFormat(string4);
                timeGenAttribute.setType(string2);
                arrayList2.add(timeGenAttribute);
            }
            timeGenLevel.setAttributes(arrayList2);
            List<TimeFormat> list3 = timeLevel.getTimeFormats();
            timeGenLevel.setFormats(list3);
            arrayList.add(timeGenLevel);
        }
        return arrayList;
    }

    public static List<String> getTimeDimensions(Database database, String string, String string2) throws Exception {
        String string3 = "SELECT SYS.DBMS_CUBE_ADVISE_SEC.GET_MVNAME(?, ?) DIMHIER_MVNAME from dual";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct dimension_name ");
        stringBuffer.append("from all_cube_dimensions ");
        stringBuffer.append("where owner=? and dimension_type='TIME' and aw_name=?");
        stringBuffer.append("order by dimension_name");
        List<Object> list = new ArrayList();
        list = database.executeSQL(stringBuffer.toString(), new Object[]{string, string2});
        for (Object object : list) {
            arrayList2.add(object.get(0));
        }
        for (Object object : arrayList2) {
            List<List<String>> list2 = database.executeSQL(string3, new Object[]{string, object});
            for (List<String> list3 : list2) {
                String string4 = list3.get(0);
                if (string4 == null) {
                    arrayList.add((String)object);
                    continue;
                }
                if (string4 == null || !string4.equalsIgnoreCase("")) continue;
                arrayList.add((String)object);
            }
        }
        return arrayList;
    }

    static {
        LOGGER = Logger.getLogger(TimeGenWizMain.class.getName());
    }
}

