/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.tools.pivot;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.tools.pivot.MeasureDimension;
import oracle.olap.tools.pivot.PivotingDialog;
import oracle.olap.util.OLAPHelpProvider;
import oracle.olap.util.SourceMetadata;

public class PivotToolController
implements Controller {
    private Connection connection;
    private Resources resources = new OLAPResources();
    private static final String XMLFILE = "sourcequeries.xml";

    public boolean handleEvent(IdeAction ideAction, Context context) {
        MeasureDimension measureDimension = new MeasureDimension();
        OLAPHelpProvider oLAPHelpProvider = new OLAPHelpProvider();
        SourceMetadata sourceMetadata = new SourceMetadata(XMLFILE);
        String string = Connections.getActiveConnectionName();
        if (string != null) {
            try {
                this.connection = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                Logger.severe(PivotToolController.class, (Throwable)dBException);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Cannot establish a connection", "Error getting a connection", 0);
                ideAction.setEnabled(false);
                return true;
            }
        } else {
            ideAction.setEnabled(false);
            return true;
        }
        sourceMetadata.setConnection(this.connection);
        PivotingDialog pivotingDialog = new PivotingDialog((Frame)Ide.getMainWindow(), sourceMetadata, measureDimension, oLAPHelpProvider);
        pivotingDialog.setVisible(true);
        while (!pivotingDialog.isCancel()) {
            String string22;
            String string3 = "";
            String string4 = measureDimension.getCreateFactViewSql();
            DatabaseImpl databaseImpl = new DatabaseImpl();
            databaseImpl.setConnection(this.connection);
            try {
                String[] stringArray = string4.split(";");
                for (String string22 : Arrays.asList(stringArray)) {
                    databaseImpl.executeSQL(string22);
                }
                string3 = string3 + this.resources.getString("PIVOT_TOOL_CONTROLLER_RESULT_1", pivotingDialog.getViewName()) + "\n";
                if (pivotingDialog.createMeasureDimTable()) {
                    string4 = measureDimension.getDropDimensionTableSql() + measureDimension.getCreateDimensionTableSql() + measureDimension.getInsertMeasureColumnSql();
                    stringArray = string4.split(";");
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            string22 = stringArray[i];
                            if (string22.length() <= 5) continue;
                            databaseImpl.executeSQL(string22);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            if (i == 0) continue;
                            throw sQLException;
                        }
                    }
                    string3 = string3 + this.resources.getString("PIVOT_TOOL_CONTROLLER_RESULT_2", pivotingDialog.getTableName()) + "\n";
                    string3 = string3 + this.resources.getString("PIVOT_TOOL_CONTROLLER_RESULT_3", Integer.toString(measureDimension.getSelectedColumns().size()), pivotingDialog.getTableName());
                }
                databaseImpl.commit();
                pivotingDialog.dispose();
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string3, this.resources.getString("PIVOT_TOOL_CONTROLLER_RESULTS"), 1);
                break;
            }
            catch (SQLException sQLException) {
                Object object = sQLException.getMessage();
                if (object == null || ((String)object).length() == 0) {
                    object = sQLException.getClass().toString();
                }
                string22 = this.resources.getString("PIVOT_TOOL_CONTROLLER_ERROR");
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), object, string22, 0);
                pivotingDialog.setVisible(true);
            }
            catch (IOException iOException) {
                Logger.severe(PivotToolController.class, (Throwable)iOException);
            }
        }
        ideAction.setEnabled(true);
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        String string = Connections.getActiveConnectionName();
        if (string != null && Connections.getInstance().isConnectionOpenFast(string)) {
            ideAction.setEnabled(true);
            return true;
        }
        ideAction.setEnabled(false);
        return true;
    }
}

