/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.app.db.Synonym;
import oracle.olap.app.db.Table;
import oracle.olap.app.db.View;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.view.OtherUsersFolder;
import oracle.olap.db.view.SchemaNode;
import oracle.olap.db.view.SynonymNode;
import oracle.olap.db.view.TableNode;
import oracle.olap.db.view.ViewNode;
import oracle.olap.util.SelectionTree;
import oracle.olap.util.SelectionTreeModel;
import oracle.olap.util.SourceMetadata;
import oracle.olap.util.SourceObjectTree;
import oracle.olap.util.TreePicker;
import oracle.olap.util.UISettings;

public class ColumnSelectionDialog
extends JDialog
implements SearchListener {
    private Object value;
    private String objectName;
    private String objectType;
    private String defaultSchema;
    private boolean singleSelection;
    private JTextArea descriptionText;
    private JLabel filterLabel;
    private SearchField searchField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private SourceMetadata sourceMetadata;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private Shuttle shuttle;
    private SourceObjectTree objectTree;
    private SelectionTree selectionTree;
    private TreePicker fromPicker;
    private TreePicker toPicker;
    private HelpProvider helpProvider;
    private JPanel panel;
    static final int COL_INCLUDE = 0;
    static final int TABLE_NAME = 1;
    static final int COL_NAME = 2;
    static final int COL_DATATYPE = 3;
    private String GET_TABLE_FROM_SYNONYM = "GET_TABLE_FROM_SYNONYM";

    public ColumnSelectionDialog(Window window, SourceMetadata sourceMetadata, HelpProvider helpProvider) {
        super(window);
        this.sourceMetadata = sourceMetadata;
        this.helpProvider = helpProvider;
        this.objectTree = new SourceObjectTree(null);
        this.setName("ColumnSelectionDialog");
        this.setModal(true);
        this.setIconImage(OLAPImagesArb.getImage("COLUMN_ICON"));
        String string = System.getProperty("os.name");
        int n = 700;
        int n2 = 380;
        if (string.startsWith("Windows")) {
            this.setSize(n + 50, n2 + 50);
            this.setMinimumSize(new Dimension(n + 50, n2 + 50));
        } else {
            this.setSize(n, n2);
            this.setMinimumSize(new Dimension(n, n2));
        }
        this.setLocationRelativeTo(window);
        this.setTitle(OLAPArb.getString("COLUMN_SELECTION_DIALOG_TITLE"));
        this.layoutCompoments();
    }

    public Object getValue() {
        return this.value;
    }

    public void setSingleSelection(boolean bl) {
        this.singleSelection = bl;
    }

    public void setDefaultSchema(String string) {
        this.defaultSchema = string;
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public void init(List<DatabaseObject> list) {
        this.initializeShuttle();
        this.initSelection(list);
        this.expandSchemaNode();
    }

    public List<String> findMissingSources(List<String> list) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        List<String> list2 = list;
        List<String> list3 = null;
        TreeModel treeModel = this.selectionTree.getModel();
        if (treeModel instanceof SelectionTreeModel) {
            serializable = (SelectionTreeModel)treeModel;
            for (String object4 : list) {
                object3 = new IdentifierElement(object4);
                if (((IdentifierElement)object3).getCount() != 2 || ((String)(object2 = ((IdentifierElement)object3).getFirst())).equals(this.defaultSchema)) continue;
                object = (DefaultMutableTreeNode)((DefaultTreeModel)serializable).getRoot();
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object).children();
                block1: while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!(defaultMutableTreeNode instanceof OtherUsersFolder)) continue;
                    this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                    Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode.children();
                    while (enumeration2.hasMoreElements()) {
                        String string;
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration2.nextElement();
                        if (!(defaultMutableTreeNode2 instanceof SchemaNode) || !((String)object2).equals(string = defaultMutableTreeNode2.getUserObject().toString())) continue;
                        this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                        Enumeration<TreeNode> enumeration3 = defaultMutableTreeNode2.children();
                        while (enumeration3.hasMoreElements()) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration3.nextElement();
                            this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
                        }
                        continue block1;
                    }
                }
            }
            list3 = list2 = ((SelectionTreeModel)serializable).findMissingSources(this.defaultSchema, list);
        }
        if ((serializable = (DefaultMutableTreeNode)(treeModel = this.objectTree.getModel()).getRoot()) != null) {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)serializable).children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                object3 = defaultMutableTreeNode.getUserObject();
                if (!(object3 instanceof DatabaseObject)) continue;
                object2 = (DatabaseObject)object3;
                object = object2.getSchemaName() + "." + object2.getName();
                if (object2.getSchemaName().equals(this.defaultSchema)) {
                    object = object2.getName();
                }
                if (list3.indexOf(object) < 0) continue;
                list3.remove(object);
            }
        }
        return list3;
    }

    private void expandSchemaNode() {
        TreeModel treeModel = this.selectionTree.getModel();
        if (treeModel instanceof SelectionTreeModel) {
            SelectionTreeModel selectionTreeModel = (SelectionTreeModel)treeModel;
            for (DefaultMutableTreeNode defaultMutableTreeNode : selectionTreeModel.getDefaultNodes()) {
                this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    private void layoutCompoments() {
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColumnSelectionDialog.this.getSelectedColumns() == null || ColumnSelectionDialog.this.getSelectedColumns().size() < 1) {
                    JOptionPane.showMessageDialog(ColumnSelectionDialog.this, OLAPArb.getString("SOURCE_SELECTION_DIALOG_WARNING_SELECTION"), OLAPArb.getString("SOURCE_SELECTION_DIALOG_WARNING_MESSAGE"), -1);
                    return;
                }
                ColumnSelectionDialog.this.value = ColumnSelectionDialog.this.getSelectedColumns();
                ColumnSelectionDialog.this.setVisible(false);
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnSelectionDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnSelectionDialog.this.showHelp();
            }
        };
        String string = OLAPArb.getString("COLUMN_SELECTION_DIALOG_DESC");
        if (this.singleSelection) {
            string = OLAPArb.getString("COLUMN_SELECTION_DIALOG_DESC_SINGLE");
        }
        this.descriptionText = new JTextArea(string);
        this.descriptionText.setName("descriptionText");
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(null);
        this.descriptionText.setBorder(null);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setName("searchField");
        this.searchField.setAllowEmptySearch(true);
        this.searchField.addSearchListener((SearchListener)this);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)OLAPArb.getString("SOURCE_SELECTION_DIALOG_FILTER_LABEL"));
        this.okButton = new JButton();
        this.okButton.setName("okButton");
        this.cancelButton = new JButton();
        this.cancelButton.setName("cancelButton");
        this.helpButton = new JButton();
        this.helpButton.setName("helpButton");
        this.shuttle = new Shuttle();
        this.shuttle.setName("shuttle");
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(StringUtils.stripMnemonic((String)OLAPArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.okButton.setAction(this.okAction);
        this.okButton.setText(OLAPArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.cancelButton.setAction(this.cancelAction);
        this.cancelButton.setText(OLAPArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.panel = new JPanel();
        this.panel.setName("panel");
        this.getContentPane().add(this.panel);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.gridwidth = 3;
        this.panel.add((Component)this.descriptionText, gridBagConstraints);
        gridBagConstraints.ipady = 120;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.panel.add((Component)this.shuttle, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.filterLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel.add((Component)this.searchField, gridBagConstraints);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panel.add((Component)dialogButtonBar, gridBagConstraints);
        this.registerKeyboardActions();
    }

    private List<DatabaseObject> getSelectedColumns() {
        return this.objectTree.getList();
    }

    public void addColumnsToDisplay(DatabaseObject databaseObject) {
        try {
            if (databaseObject.getColumns() == null) {
                Object object;
                String string = databaseObject.getSchemaName();
                String string2 = databaseObject.getName();
                if (databaseObject instanceof Synonym) {
                    object = new HashMap<String, String>();
                    object.put("OWNER", databaseObject.getSchemaName());
                    object.put("OBJECT", databaseObject.getName());
                    List<List<String>> list = this.sourceMetadata.executeQueryByName(this.GET_TABLE_FROM_SYNONYM, (Map<String, String>)object);
                    for (List<String> list2 : list) {
                        if (list2 == null || list2.size() != 2) continue;
                        string = list2.get(1);
                        string2 = list2.get(0);
                    }
                }
                object = this.sourceMetadata.getObjectColumns(string, string2);
                databaseObject.setColumns((List<Column>)object);
            }
        }
        catch (SQLException sQLException) {
            Logger.severe(ColumnSelectionDialog.class, (Throwable)sQLException);
        }
    }

    public List<Column> getColumnsToDisplay(DatabaseObject databaseObject) {
        try {
            Object object;
            String string = databaseObject.getSchemaName();
            String string2 = databaseObject.getName();
            if (databaseObject instanceof Synonym) {
                object = new HashMap<String, String>();
                object.put("OWNER", databaseObject.getSchemaName());
                object.put("OBJECT", databaseObject.getName());
                List<List<String>> list = this.sourceMetadata.executeQueryByName(this.GET_TABLE_FROM_SYNONYM, (Map<String, String>)object);
                for (List<String> list2 : list) {
                    if (list2 == null || list2.size() != 2) continue;
                    string = list2.get(0);
                    string2 = list2.get(1);
                }
            }
            object = this.sourceMetadata.getObjectColumns(string, string2);
            return object;
        }
        catch (SQLException sQLException) {
            Logger.severe(ColumnSelectionDialog.class, (Throwable)sQLException);
            return null;
        }
    }

    private void initializeShuttle() {
        this.shuttle.setButtonsShown(5);
        this.initializeFromPicker();
        this.initializeToPicker();
    }

    private void initializeFromPicker() {
        JScrollPane jScrollPane = new JScrollPane();
        this.selectionTree = new SelectionTree(this.sourceMetadata, this.defaultSchema, this.objectName, this.objectType);
        this.selectionTree.setModel(new SelectionTreeModel(new DefaultMutableTreeNode(), new JTextField(), this.sourceMetadata));
        if (this.singleSelection) {
            this.selectionTree.getSelectionModel().setSelectionMode(1);
        }
        jScrollPane.getViewport().add(this.selectionTree);
        this.fromPicker = new TreePicker(this.selectionTree, jScrollPane, this, this.singleSelection);
        this.shuttle.setFromPicker((ItemPicker)this.fromPicker);
        this.shuttle.updateUI();
    }

    private void initializeToPicker() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.objectTree);
        this.toPicker = new TreePicker(this.objectTree, jScrollPane, this);
        this.shuttle.setToPicker((ItemPicker)this.toPicker);
        this.shuttle.updateUI();
    }

    public TreePicker getFromPicker() {
        return this.fromPicker;
    }

    public TreePicker getToPicker() {
        return this.toPicker;
    }

    private List<DefaultMutableTreeNode> buildInitialNodes(List<DatabaseObject> list) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (DatabaseObject databaseObject : list) {
            DatabaseObject databaseObject2;
            if (databaseObject instanceof Table) {
                databaseObject2 = new Table(databaseObject.getSchemaName(), databaseObject.getName());
                ((Table)databaseObject2).setColumns(databaseObject.getColumns());
                arrayList.add(new TableNode((Table)databaseObject2));
                continue;
            }
            if (databaseObject instanceof View) {
                databaseObject2 = new View(databaseObject.getSchemaName(), databaseObject.getName());
                ((View)databaseObject2).setColumns(databaseObject.getColumns());
                arrayList.add(new ViewNode((View)databaseObject2));
                continue;
            }
            if (!(databaseObject instanceof Synonym)) continue;
            databaseObject2 = new Synonym(databaseObject.getSchemaName(), databaseObject.getName());
            ((Synonym)databaseObject2).setColumns(databaseObject.getColumns());
            arrayList.add(new SynonymNode((Synonym)databaseObject2));
        }
        return arrayList;
    }

    private void initSelection(List<DatabaseObject> list) {
        if (list != null && list.size() > 0) {
            List<DefaultMutableTreeNode> list2 = this.buildInitialNodes(list);
            ((TreePicker)this.shuttle.getToPicker()).addInitialSelection(list2);
            for (DefaultMutableTreeNode defaultMutableTreeNode : list2) {
                this.selectionTree.addSelectionNode(defaultMutableTreeNode);
            }
        }
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(156, 0), 1);
        jRootPane.registerKeyboardAction(this.okAction, KeyStroke.getKeyStroke(10, 0), 1);
        jRootPane.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void showHelp() {
        this.helpProvider.showHelp(this.panel, "olap_column_selection");
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = searchEvent.getSearchText();
        this.selectionTree.filter(string);
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    public static Object showDialog(Window window, SourceMetadata sourceMetadata, List<DatabaseObject> list, String string, String string2, String string3, HelpProvider helpProvider) {
        ColumnSelectionDialog columnSelectionDialog = new ColumnSelectionDialog(window, sourceMetadata, helpProvider);
        columnSelectionDialog.setDefaultSchema(string);
        columnSelectionDialog.setObjectName(string2);
        columnSelectionDialog.setObjectType(string3);
        columnSelectionDialog.init(list);
        columnSelectionDialog.setVisible(true);
        return columnSelectionDialog.value;
    }

    public static Object showDialog(Window window, SourceMetadata sourceMetadata, List<DatabaseObject> list, String string, String string2, String string3, boolean bl, HelpProvider helpProvider) {
        ColumnSelectionDialog columnSelectionDialog = new ColumnSelectionDialog(window, sourceMetadata, helpProvider);
        columnSelectionDialog.setDefaultSchema(string);
        columnSelectionDialog.setObjectName(string2);
        columnSelectionDialog.setObjectType(string3);
        columnSelectionDialog.setSingleSelection(bl);
        columnSelectionDialog.init(list);
        columnSelectionDialog.setVisible(true);
        return columnSelectionDialog.value;
    }

    class DatabaseRenderer
    extends DefaultListCellRenderer {
        private Hashtable iconTable = new Hashtable();

        DatabaseRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Table) {
                Icon icon = OLAPImagesArb.getIcon("TABLE_ICON");
                jLabel.setIcon(icon);
            } else if (object instanceof View) {
                Icon icon = OLAPImagesArb.getIcon("VIEW_ICON");
                jLabel.setIcon(icon);
            } else if (object instanceof Synonym) {
                Icon icon = OLAPImagesArb.getIcon("SYNONYM_ICON");
                jLabel.setIcon(icon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }

    class CWCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border border = new EmptyBorder(1, 2, 1, 2);

        public CWCheckBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Boolean) {
                this.setSelected((Boolean)object);
                this.setEnabled(jTable.isCellEditable(n, n2));
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                }
            } else {
                return null;
            }
            return this;
        }
    }

    class CheckBoxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JCheckBox checkBox = new JCheckBox();

        public CheckBoxCellEditor() {
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setBackground(Color.white);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CheckBoxCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            boolean bl2 = false;
            if (object != null) {
                bl2 = (Boolean)object;
            }
            this.checkBox.setSelected(bl2);
            return this.checkBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkBox.isSelected();
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }
}

