/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.completion.CompletionTextFieldWithDrop;
import oracle.olap.util.CompletionStringMatchProvider;

public class CompletionCellEditor
extends DefaultCellEditor {
    private static final String COMPLETE_ACTION = "completeInsight";

    public CompletionCellEditor(final CompletionTextField completionTextField, final CompletionStringMatchProvider completionStringMatchProvider) {
        super((JTextField)completionTextField);
        Object object;
        CompletionPopupHandler completionPopupHandler = completionTextField.getPopupHandler();
        JComponent jComponent = completionPopupHandler.getInsightList();
        if (jComponent instanceof JList) {
            JList jList = (JList)jComponent;
            object = new ListSingleClickListener();
            jList.addMouseListener((MouseListener)object);
        }
        this.editorComponent = new CompletionTextFieldWithDrop(completionTextField);
        for (int i = 0; i < this.editorComponent.getComponentCount(); ++i) {
            object = this.editorComponent.getComponent(i);
            if (!(object instanceof JButton)) continue;
            JButton jButton = (JButton)object;
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    completionStringMatchProvider.setFilter(false);
                }
            });
        }
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                completionTextField.setText(object != null ? object.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return completionTextField.getText();
            }
        };
        completionTextField.addActionListener((ActionListener)this.delegate);
    }

    private class ListSingleClickListener
    extends MouseAdapter {
        private ListSingleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                JList jList;
                int n;
                Object object;
                Component component = CompletionCellEditor.this.getComponent();
                CompletionTextField completionTextField = null;
                CompletionPopupHandler completionPopupHandler = null;
                if (component instanceof CompletionTextField) {
                    completionTextField = (CompletionTextField)component;
                }
                if (component instanceof CompletionTextFieldWithDrop) {
                    object = (CompletionTextFieldWithDrop)component;
                    for (int i = 0; i < object.getComponentCount(); ++i) {
                        Component component2 = object.getComponent(i);
                        if (!(component2 instanceof CompletionTextField)) continue;
                        completionTextField = (CompletionTextField)component2;
                        break;
                    }
                }
                if ((object = (completionPopupHandler = completionTextField.getPopupHandler()).getInsightList()) instanceof JList && (n = (jList = (JList)object).locationToIndex(mouseEvent.getPoint())) != -1) {
                    ActionMap actionMap = completionPopupHandler.getTextComponent().getActionMap();
                    Action action = actionMap.get(CompletionCellEditor.COMPLETE_ACTION);
                    action.actionPerformed(new ActionEvent(completionTextField, 0, CompletionCellEditor.COMPLETE_ACTION));
                    completionPopupHandler.getTextComponent().requestFocusInWindow();
                    CompletionCellEditor.this.stopCellEditing();
                }
            }
        }
    }
}

