/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.olap.db.IdentifierElement;
import oracle.olap.util.ListSeparatorsRenderer;

public class CompletionStringMatchProvider
implements CompletionProvider<String> {
    private List<String> strings = new ArrayList<String>();
    private boolean filter = true;
    public final ListCellRenderer renderer;

    public CompletionStringMatchProvider(JList jList, Collection<String> collection) {
        this(jList);
        this.strings.addAll(collection);
    }

    public CompletionStringMatchProvider(JComponent jComponent, Collection<String> collection) {
        this((JList)jComponent);
        this.strings.addAll(collection);
    }

    public CompletionStringMatchProvider(JList jList) {
        this.renderer = new ListSeparatorsRenderer(jList.getCellRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList jList, Object object, int n) {
                Object object2 = null;
                if (n + 1 < jList.getModel().getSize()) {
                    object2 = jList.getModel().getElementAt(n + 1);
                }
                if (object2 != null) {
                    IdentifierElement identifierElement = new IdentifierElement(object2.toString());
                    IdentifierElement identifierElement2 = new IdentifierElement(object.toString());
                    if (identifierElement.getCount() == 2 && identifierElement2.getCount() == 2) {
                        boolean bl = identifierElement.getFirst().equals(identifierElement2.getFirst());
                        return !bl;
                    }
                }
                return false;
            }
        };
    }

    public void setStrings(Collection<String> collection) {
        this.filter = true;
        this.strings.clear();
        this.strings.addAll(collection);
    }

    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public String[] getInsightData(Document document, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = document.getText(0, n).toLowerCase();
            if (string.trim().length() == 0) {
                this.filter = false;
            }
            for (String string2 : this.strings) {
                if (this.filter) {
                    int n2 = string2.toLowerCase().indexOf(string.toLowerCase());
                    if (n2 < 0) continue;
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string2);
            }
            if (arrayList.size() == 1 && ((String)arrayList.get(0)).equalsIgnoreCase(string)) {
                arrayList.clear();
                arrayList.addAll(this.strings);
            }
            if (arrayList.size() == 0) {
                arrayList.addAll(this.strings);
            }
            this.filter = true;
        }
        catch (BadLocationException badLocationException) {
            return new String[0];
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void completeInsight(Document document, int n, String string) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

