/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;

public class OLAPNameValidator {
    private static final String AW_LIST_SQL = "select aw from all_olap2_aws where owner = :OWNER and sf_version not like '10%' order by aw";

    public static boolean isNameValid(String string, int n) {
        int n2;
        boolean bl = true;
        if (string == null || string.length() == 0 || string.length() > n) {
            bl = false;
        }
        if (bl) {
            n2 = string.charAt(0);
            boolean bl2 = bl = !Character.isDigit((char)n2) && n2 != 95;
        }
        if (bl) {
            for (n2 = 0; n2 < string.length() && bl; ++n2) {
                char c = string.charAt(n2);
                bl = Character.isDigit(c) || Character.isLetter(c) || c == '_';
            }
        }
        return bl;
    }

    public static boolean isAWNameUnique(String string, DBUtil dBUtil, String string2) {
        List<String> list = OLAPNameValidator.getAWs(dBUtil, string2);
        return !list.contains(string);
    }

    private static List<String> getAWs(DBUtil dBUtil, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        List list = dBUtil.executeReturnList(AW_LIST_SQL, hashMap);
        for (Map map : list) {
            String string2 = (String)map.get("AW");
            string2 = string2.toUpperCase();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean isObjectNameUnique(String string, String string2, DBUtil dBUtil) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string2);
        hashMap.put("object_name", string);
        dBUtil.setRaiseError(false);
        String string3 = "select count(object_name) from all_objects where owner = :owner and object_name = :object_name  and object_type in('CUBE','CUBE DIMENSION','MEASURE FOLDER','CUBE BUILD PROCESS','TYPE','MATERIALIZED VIEW','PACKAGE','FUNCTION','PROCEDURE','SYNONYM','SEQUENCE','VIEW','TABLE')";
        String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
        return Integer.valueOf(string4) == 0;
    }
}

