/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.app.tree.view.JTree2;
import oracle.olap.app.tree.view.NodeIcon;
import oracle.olap.db.view.ColumnNode;
import oracle.olap.db.view.FolderNode;
import oracle.olap.db.view.SynonymFolderNode;
import oracle.olap.db.view.SynonymNode;
import oracle.olap.db.view.TableFolderNode;
import oracle.olap.db.view.TableNode;
import oracle.olap.db.view.ViewFolderNode;
import oracle.olap.db.view.ViewNode;
import oracle.olap.util.SourceMetadata;

public class SelectionTree
extends JTree2
implements TreeWillExpandListener {
    SourceMetadata sourceMetadata;
    String owner;
    String object;
    String type;
    private final String TABLE = "TABLE";
    private final String VIEW = "VIEW";
    private final String SYNONYM = "SYNONYM";
    private List<String> filters;
    private List<DefaultMutableTreeNode> selectedNodes;

    public SelectionTree(SourceMetadata sourceMetadata, String string, String string2, String string3) {
        this.sourceMetadata = sourceMetadata;
        this.owner = string;
        this.object = string2;
        this.type = string3;
        this.filters = new ArrayList<String>();
        this.selectedNodes = new ArrayList<DefaultMutableTreeNode>();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new DatabaseObjectRenderer());
        this.addTreeWillExpandListener(this);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        FolderNode folderNode;
        if (treeExpansionEvent.getPath().getLastPathComponent() instanceof FolderNode && (folderNode = (FolderNode)treeExpansionEvent.getPath().getLastPathComponent()).getNodes() == null) {
            this.loadChildren(folderNode);
        }
    }

    private void loadChildren(FolderNode folderNode) {
        if (folderNode != null) {
            String string = "GET_OBJECTS_BY_TYPE";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.setSearchType(hashMap, folderNode);
            List<List<String>> list = this.sourceMetadata.executeQueryByName(string, hashMap);
            LinkedList<List<String>> linkedList = new LinkedList<List<String>>();
            List<String> list2 = this.getETViews();
            boolean bl = false;
            for (List<String> list3 : list) {
                String string2 = list3.get(0);
                if (list2.indexOf(string2) != -1) continue;
                linkedList.add(list3);
            }
            folderNode.createChildNodes(linkedList);
            this.update(folderNode);
        }
    }

    private List<String> getETViews() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (this.owner == null || this.object == null || this.type == null) {
            return arrayList;
        }
        if (this.type.equalsIgnoreCase("CUBE")) {
            string = "GET_ETVIEW_NAME_FOR_CUBE";
        } else if (this.type.equalsIgnoreCase("CUBE DIMENSION")) {
            string = "GET_ETVIEW_NAME_FOR_DIMENSION";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", this.owner);
        hashMap.put("OBJECT", this.object);
        List<List<String>> list = this.sourceMetadata.executeQueryByName(string, hashMap);
        for (List<String> list2 : list) {
            arrayList.add(list2.get(0));
        }
        if (this.type.equalsIgnoreCase("CUBE DIMENSION")) {
            string = "GET_ETVIEW_NAMES_FOR_DIMENSION_HIERARCHIES";
        }
        list = this.sourceMetadata.executeQueryByName(string, hashMap);
        for (List<String> list2 : list) {
            arrayList.add(list2.get(0));
        }
        return arrayList;
    }

    private void setSearchType(Map<String, String> map, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = null;
        if (defaultMutableTreeNode instanceof TableFolderNode) {
            string = "TABLE";
        } else if (defaultMutableTreeNode instanceof ViewFolderNode) {
            string = "VIEW";
        } else if (defaultMutableTreeNode instanceof SynonymFolderNode) {
            string = "SYNONYM";
        }
        map.put("OWNER", defaultMutableTreeNode.getParent() != null ? defaultMutableTreeNode.getParent().toString() : "");
        map.put("TYPE", string);
    }

    private void update(FolderNode folderNode) {
        for (DefaultMutableTreeNode defaultMutableTreeNode : folderNode.getNodes()) {
            if (this.selectedNodes.contains(defaultMutableTreeNode)) continue;
            if (this.filters.size() > 0) {
                if (!this.passFilter(defaultMutableTreeNode)) continue;
                folderNode.add(defaultMutableTreeNode);
                continue;
            }
            folderNode.add(defaultMutableTreeNode);
        }
    }

    private boolean passFilter(DefaultMutableTreeNode defaultMutableTreeNode) {
        DatabaseObject databaseObject = (DatabaseObject)defaultMutableTreeNode.getUserObject();
        String string = databaseObject.getName().toUpperCase();
        for (String string2 : this.filters) {
            if (!((string2 = string2.trim().toUpperCase()).endsWith("%") ? string.startsWith(string2.substring(0, string2.length() - 1)) : (string2.startsWith("%") ? string.endsWith(string2.substring(1)) : string.contains(string2)))) continue;
            return true;
        }
        return false;
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (!this.isNodeChild(defaultMutableTreeNode) && (defaultMutableTreeNode2 = this.findOwnerNode(defaultMutableTreeNode, treeNode = (TreeNode)this.getModel().getRoot())) != null) {
            this.addNode(defaultMutableTreeNode, defaultMutableTreeNode2);
        }
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        block3: {
            block5: {
                block4: {
                    if (!(defaultMutableTreeNode instanceof TableNode)) break block4;
                    defaultMutableTreeNode.setAllowsChildren(false);
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                        if (!(defaultMutableTreeNode2 instanceof TableFolderNode)) continue;
                        defaultMutableTreeNode2.add(defaultMutableTreeNode);
                        break block3;
                    }
                    break block3;
                }
                if (!(defaultMutableTreeNode instanceof ViewNode)) break block5;
                defaultMutableTreeNode.setAllowsChildren(false);
                for (int i = 0; i < treeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                    if (!(defaultMutableTreeNode3 instanceof ViewFolderNode)) continue;
                    defaultMutableTreeNode3.add(defaultMutableTreeNode);
                    break block3;
                }
                break block3;
            }
            if (!(defaultMutableTreeNode instanceof SynonymNode)) break block3;
            defaultMutableTreeNode.setAllowsChildren(false);
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                if (!(defaultMutableTreeNode4 instanceof SynonymFolderNode)) continue;
                defaultMutableTreeNode4.add(defaultMutableTreeNode);
                break;
            }
        }
    }

    private boolean isNodeChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            if (defaultMutableTreeNode2 != null) {
                for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                    if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private DefaultMutableTreeNode findOwnerNode(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        DatabaseObject databaseObject = (DatabaseObject)defaultMutableTreeNode.getUserObject();
        TreeNode treeNode2 = treeNode.getChildAt(0);
        if (treeNode2.toString().equalsIgnoreCase(databaseObject.getSchemaName())) {
            return (DefaultMutableTreeNode)treeNode2;
        }
        TreeNode treeNode3 = treeNode.getChildAt(1);
        for (int i = 0; i < treeNode3.getChildCount(); ++i) {
            TreeNode treeNode4 = treeNode3.getChildAt(i);
            if (!treeNode4.toString().equalsIgnoreCase(databaseObject.getSchemaName())) continue;
            return (DefaultMutableTreeNode)treeNode4;
        }
        return null;
    }

    private boolean isFolderNode(Object object) {
        return object instanceof FolderNode;
    }

    public void filter(String string) {
        this.filters = Arrays.asList(string.split(","));
        Object object = this.getModel().getRoot();
        this.walk(this.getModel(), object);
    }

    protected void walk(TreeModel treeModel, Object object) {
        boolean bl = false;
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (this.isFolderNode(object2)) {
                FolderNode folderNode = (FolderNode)object2;
                folderNode.removeAllChildren();
                if (folderNode.getNodes() == null) continue;
                bl = false;
                for (DefaultMutableTreeNode defaultMutableTreeNode : folderNode.getNodes()) {
                    if (!this.passFilter(defaultMutableTreeNode) || this.selectedNodes.contains(defaultMutableTreeNode)) continue;
                    folderNode.add(defaultMutableTreeNode);
                    bl = true;
                }
                if (bl) {
                    ((DefaultTreeModel)treeModel).reload(folderNode);
                }
                if (this.isExpanded(new TreePath(folderNode.getPath())) && folderNode.getChildCount() == 0) {
                    this.collapsePath(new TreePath(folderNode.getPath()));
                    continue;
                }
                if (!this.isCollapsed(new TreePath(folderNode.getPath())) || folderNode.getChildCount() <= 0) continue;
                this.expandPath(new TreePath(folderNode.getPath()));
                continue;
            }
            this.walk(treeModel, object2);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void addSelectionNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!this.selectedNodes.contains(defaultMutableTreeNode)) {
            this.selectedNodes.add(defaultMutableTreeNode);
        }
    }

    public boolean removeSelectionNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        return this.selectedNodes.remove(defaultMutableTreeNode);
    }

    class DatabaseObjectRenderer
    extends DefaultTreeCellRenderer {
        NodeIcon nodeIcon;

        public DatabaseObjectRenderer() {
            this.nodeIcon = new NodeIcon(){

                @Override
                public Icon getIcon(Object object) {
                    if (object instanceof TableNode) {
                        return OLAPImagesArb.getIcon("TABLE_ICON");
                    }
                    if (object instanceof ViewNode) {
                        return OLAPImagesArb.getIcon("VIEW_ICON");
                    }
                    if (object instanceof SynonymNode) {
                        return OLAPImagesArb.getIcon("SYNONYM_ICON");
                    }
                    if (object instanceof ColumnNode) {
                        return OLAPImagesArb.getIcon("COLUMN_ICON");
                    }
                    if (object instanceof TableFolderNode) {
                        return OLAPImagesArb.getIcon("TABLE_FOLDER_ICON");
                    }
                    if (object instanceof ViewFolderNode) {
                        return OLAPImagesArb.getIcon("VIEW_FOLDER_ICON");
                    }
                    if (object instanceof SynonymFolderNode) {
                        return OLAPImagesArb.getIcon("SYNONYM_FOLDER_ICON");
                    }
                    return OLAPImagesArb.getIcon("FOLDER");
                }

                @Override
                public Icon getDisabledIcon(Object object) {
                    if (object instanceof TableNode) {
                        return OLAPImagesArb.getIcon("TABLE_ICON");
                    }
                    if (object instanceof ViewNode) {
                        return OLAPImagesArb.getIcon("VIEW_ICON");
                    }
                    if (object instanceof SynonymNode) {
                        return OLAPImagesArb.getIcon("SYNONYM_ICON");
                    }
                    if (object instanceof ColumnNode) {
                        return OLAPImagesArb.getIcon("COLUMN_ICON");
                    }
                    return OLAPImagesArb.getIcon("FOLDER");
                }
            };
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(this.nodeIcon.getIcon(object));
            return this;
        }
    }
}

