/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.preferences.OLAPAdvancedPreferenceSettings;
import oracle.olap.util.SourceMetadata;
import oracle.olap.util.UISettings;

public class TableSelectionDialog
extends JDialog
implements SearchListener {
    public static String TABLES = "TABLES";
    public static String VIEWS = "VIEWS";
    public static String SYNONYMS = "SYNONYMS";
    private static TableSelectionDialog dialog;
    private static Object value;
    private JTextArea descriptionText;
    private JLabel objectTypeLabel;
    private JLabel schemaLabel;
    private JLabel filterLabel;
    private JComboBox schemaComboBox;
    private SearchField searchField;
    private JLabel availableSourcesLabel;
    private JList objectList;
    private JScrollPane objectScrollPane;
    private DefaultListModel objectModel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private SourceMetadata connAccess;
    private List<String> options;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private ButtonGroup btnGroup;
    private HelpProvider helpProvider;
    private JPanel panel;
    Resources resources = new OLAPResources();

    public static Object showDialog(Window window, SourceMetadata sourceMetadata, List<String> list, HelpProvider helpProvider) {
        value = null;
        dialog = new TableSelectionDialog(window, sourceMetadata, list, helpProvider);
        dialog.setVisible(true);
        return value;
    }

    private void setValue(Object object) {
        value = object;
    }

    public TableSelectionDialog(Window window, SourceMetadata sourceMetadata, List<String> list, HelpProvider helpProvider) {
        super(window);
        this.connAccess = sourceMetadata;
        this.options = list;
        this.helpProvider = helpProvider;
        this.setModal(true);
        this.setIconImage(OLAPImagesArb.getImage("TABLE_ICON"));
        String string = System.getProperty("os.name");
        int n = 350;
        int n2 = 320;
        if (string.startsWith("Windows")) {
            this.setSize(n + 50, n2 + 50);
            this.setMinimumSize(new Dimension(n + 50, n2 + 50));
        } else {
            this.setSize(n, n2);
            this.setMinimumSize(new Dimension(n, n2));
        }
        this.setLocationRelativeTo(window);
        this.setTitle(this.resources.getString("SOURCE_SELECTION_DIALOG_TITLE"));
        this.layoutComponents();
        this.populateFields();
    }

    private void layoutComponents() {
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)TableSelectionDialog.this.schemaComboBox.getSelectedItem();
                String string2 = (String)TableSelectionDialog.this.objectList.getSelectedValue();
                if (string2 == null) {
                    JOptionPane.showMessageDialog(TableSelectionDialog.this, TableSelectionDialog.this.resources.getString("SOURCE_SELECTION_DIALOG_WARNING_SELECTION"), TableSelectionDialog.this.resources.getString("SOURCE_SELECTION_DIALOG_WARNING_MESSAGE"), -1);
                    return;
                }
                TableSelectionDialog.this.setValue(string + "." + string2);
                TableSelectionDialog.this.setVisible(false);
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSelectionDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSelectionDialog.this.showHelp();
            }
        };
        String string = this.resources.getString("TABLE_SELECTION_DIALOG_DESC");
        this.descriptionText = new JTextArea(string);
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(null);
        this.descriptionText.setBorder(null);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.objectTypeLabel = new JLabel(this.resources.getString("SOURCE_SELECTION_DIALOG_OBJECT_LABEL"));
        this.schemaLabel = new JLabel();
        this.schemaComboBox = new JComboBox();
        ResourceUtils.resLabel((JLabel)this.schemaLabel, (Component)this.schemaComboBox, (String)this.resources.getString("SOURCE_SELECTION_DIALOG_SCHEMA_LABEL"));
        this.filterLabel = new JLabel();
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setAllowEmptySearch(true);
        this.searchField.addSearchListener((SearchListener)this);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)this.resources.getString("SOURCE_SELECTION_DIALOG_FILTER_LABEL"));
        this.availableSourcesLabel = new JLabel(this.resources.getString("SOURCE_SELECTION_DIALOG_AVAILABLE_SOURCES"));
        this.objectList = new JList();
        this.objectList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 2) {
                    TableSelectionDialog.this.okAction.actionPerformed(null);
                }
            }
        });
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        ListSelectionModel listSelectionModel = this.objectList.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(StringUtils.stripMnemonic((String)this.resources.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.okButton.setAction(this.okAction);
        this.okButton.setText(this.resources.getString("DIALOG_OK_BUTTON_TEXT"));
        this.cancelButton.setAction(this.cancelAction);
        this.cancelButton.setText(this.resources.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.objectModel = new DefaultListModel();
        this.objectList.setModel(this.objectModel);
        this.objectScrollPane = new JScrollPane();
        this.objectScrollPane.getViewport().add(this.objectList);
        this.panel = new JPanel();
        this.getContentPane().add(this.panel);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.gridwidth = 3;
        this.panel.add((Component)this.descriptionText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.gridwidth = 1;
        this.panel.add((Component)this.objectTypeLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = UISettings.getTextFieldWeightX();
        this.panel.add((Component)this.addRadioButtons(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        this.panel.add((Component)this.schemaLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = UISettings.getTextFieldWeightX();
        this.panel.add((Component)this.schemaComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        this.panel.add((Component)this.filterLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = UISettings.getTextFieldWeightX();
        this.panel.add((Component)this.searchField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        this.panel.add((Component)this.availableSourcesLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        this.panel.add((Component)this.objectScrollPane, gridBagConstraints);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panel.add((Component)dialogButtonBar, gridBagConstraints);
        this.registerKeyboardActions();
    }

    private boolean defaultTableLoading() {
        Preferences preferences = Preferences.getPreferences();
        OLAPAdvancedPreferenceSettings oLAPAdvancedPreferenceSettings = OLAPAdvancedPreferenceSettings.getInstance((PropertyStorage)preferences);
        Boolean bl = oLAPAdvancedPreferenceSettings.getEnableTableDefaultLoading();
        return bl == false;
    }

    private void populateFields() {
        try {
            List<String> list = this.connAccess.getSchemas();
            for (String string : list) {
                this.schemaComboBox.addItem(string);
            }
            if (this.defaultTableLoading()) {
                this.fetchFilteredSourceResults("");
            }
        }
        catch (Exception exception) {
            Logger.severe(TableSelectionDialog.class, (Throwable)exception);
        }
    }

    private JPanel addRadioButtons() {
        JPanel jPanel = new JPanel();
        this.btnGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 1;
        if (this.options.contains(TABLES)) {
            this.createRadioButton(jPanel, gridBagConstraints, this.resources.getString("SELECTION_DIALOG_OPTIONS_TABLES"), TABLES, n);
            ++n;
        }
        if (this.options.contains(VIEWS)) {
            this.createRadioButton(jPanel, gridBagConstraints, this.resources.getString("SELECTION_DIALOG_OPTIONS_VIEWS"), VIEWS, n);
            ++n;
        }
        if (this.options.contains(SYNONYMS)) {
            this.createRadioButton(jPanel, gridBagConstraints, this.resources.getString("SELECTION_DIALOG_OPTIONS_SYNONYMS"), SYNONYMS, n);
            ++n;
        }
        return jPanel;
    }

    private void createRadioButton(JPanel jPanel, GridBagConstraints gridBagConstraints, String string, String string2, int n) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setActionCommand(string2);
        jRadioButton.setText(StringUtils.stripMnemonic((String)string));
        jRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = UISettings.getTextFieldWeightX();
        if (n == 1) {
            jRadioButton.setSelected(true);
        }
        this.btnGroup.add(jRadioButton);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
    }

    private String getQuery(String string) {
        if (string.equals(TABLES)) {
            return "GET_TABLES_BY_NAME";
        }
        if (string.equals(VIEWS)) {
            return "GET_VIEWS_BY_NAME";
        }
        if (string.equals(SYNONYMS)) {
            return "GET_SYNONYMS_BY_NAME";
        }
        return null;
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = searchEvent.getSearchText();
        this.fetchFilteredSourceResults(string);
        searchEvent.getSearchProgress().finish();
    }

    private void fetchFilteredSourceResults(String string) {
        String string2;
        String string3 = this.btnGroup.getSelection().getActionCommand();
        String string4 = this.getQuery(string3);
        if (string4 != null && (string2 = (String)this.schemaComboBox.getSelectedItem()) != null && string != null) {
            if (string.equals("")) {
                string = "%";
            } else if (!string.contains("%")) {
                string = string.concat("%");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string2);
            hashMap.put("OBJECT", string);
            List<List<String>> list = this.connAccess.executeQueryByName(string4, hashMap);
            this.objectModel.clear();
            for (List<String> list2 : list) {
                for (String string5 : list2) {
                    this.objectModel.addElement(string5);
                }
            }
        }
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(156, 0), 1);
        jRootPane.registerKeyboardAction(this.okAction, KeyStroke.getKeyStroke(10, 0), 1);
        jRootPane.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void showHelp() {
        this.helpProvider.showHelp(this.panel, "olap_source_selection");
    }

    static {
        value = null;
    }
}

