/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.commands.scriptrunner.task;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.TaskProgressViewer;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.AbstractWorksheetTaskResultPanel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.dbtools.worksheet.commands.scriptrunner.api.AStatementRunnerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.extension.ScriptRunnerHook;
import oracle.dbtools.worksheet.commands.scriptrunner.task.CommandRunnerScope;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ConsumerManagerTask;
import oracle.dbtools.worksheet.commands.scriptrunner.task.RunScriptPanel;
import oracle.dbtools.worksheet.commands.scriptrunner.task.StatementRunnerTask;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.olap.worksheet.commands.scriptrunner.OLAPConsumerManager;
import oracle.olap.worksheet.commands.scriptrunner.task.OLAPDBCommandRunnerTask;

public class OLAPScriptRunnerTask
extends OLAPDBCommandRunnerTask {
    protected static final String SCRIPTRUNNER_TASKNAME = Messages.getString((String)"ScriptRunnerTask.0");
    BufferedOutputStream m_out = null;
    IScriptConsumer m_consumer = this.getConsumerManager().getAvailableConsumer(true);
    AStatementRunnerTask m_statementRunner = null;

    public OLAPScriptRunnerTask(WorksheetContext worksheetContext, OLAPConsumerManager oLAPConsumerManager, String string, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(worksheetContext, oLAPConsumerManager, string, iRaptorTaskRunMode, OLAPScriptRunnerTask.getTaskName());
        this.getScriptRunnerContext().setTopLevel(true);
        this.getScriptRunnerContext().setOutputComponenet((Object)this.m_consumer.getPanel());
        this.getScriptRunnerContext().setTaskProgressUpdater(this.getRaptorTaskProgressUpdater());
    }

    protected static String getTaskName() {
        return SCRIPTRUNNER_TASKNAME;
    }

    @Override
    protected void handleNoSelection(CommandRunnerScope commandRunnerScope) {
        String string;
        this.beforeLoopProcessing();
        this.getScriptRunnerContext().setScriptText(-1, -1);
        String string2 = string = this.getScriptRunnerContext().getScriptText();
        this.runCommand(string2);
        this.afterLoopProcessing();
    }

    @Override
    protected void runCommand(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\n", ";");
        string = "begin dbms_aw.execute('" + string + "');end;";
        SQLCommand sQLCommand = new SQLCommand(string);
        sQLCommand.setOrigStartLine(0);
        sQLCommand.setOrigEndLine(1);
        sQLCommand.setResultsType(SQLCommand.StmtResultType.G_R_NONE);
        sQLCommand.setStmtSubType(SQLCommand.StmtSubType.G_S_BEGIN);
        sQLCommand.setStmtType(SQLCommand.StmtType.G_C_PLSQL);
        sQLCommand.setExecutable(true);
        sQLCommand.setRunnable(true);
        sQLCommand.setModifiedSQL(string);
        this.beforeLoopProcessing();
        this.runCommand((ISQLCommand)sQLCommand, false, false, 1);
        this.afterLoopProcessing();
    }

    @Override
    protected void tailoredRunCommand(ISQLCommand iSQLCommand, boolean bl, boolean bl2, int n) {
        if (!bl2) {
            this.disableTheTaskPause();
        }
        if (this.getWorksheetContext().isStatementRunner() && iSQLCommand.getResultsType() == SQLCommand.StmtResultType.G_R_QUERY) {
            iSQLCommand.setRunnable(false);
            this.m_statementRunner = ScriptRunnerHook.getStatementExecutorTask((ISQLCommand)iSQLCommand, (BufferedOutputStream)this.getOutputStream(), (ScriptRunnerContext)this.getScriptRunnerContext(), (Connection)this.getCurrentConnection());
            this.runTaskInThisThread(this.m_statementRunner);
            iSQLCommand.setRunnable(true);
            this.releaseSchedulingRule();
            boolean bl3 = false;
            if (bl && (n > 1 || bl2)) {
                bl3 = true;
            }
            if (!this.getScriptRunnerContext().getExited()) {
                AbstractWorksheetTaskResultPanel abstractWorksheetTaskResultPanel = StatementRunnerTask.openStmtRunnerResultsPanel((boolean)bl3, (ISQLCommand)iSQLCommand, (WorksheetContext)this.getWorksheetContext(), (RaptorTaskDescriptor)this.getDescriptor());
                this.acquireSchedulingRule();
                String string = this.getDataGridTabLabel(abstractWorksheetTaskResultPanel);
                this.runPrompt(string, iSQLCommand);
            }
        } else {
            this.m_statementRunner = ScriptRunnerHook.getStatementExecutorTask((ISQLCommand)iSQLCommand, (BufferedOutputStream)this.getOutputStream(), (ScriptRunnerContext)this.getScriptRunnerContext(), (Connection)this.getCurrentConnection());
            this.runTaskInThisThread(this.m_statementRunner);
        }
        this.rememberHistory(iSQLCommand);
    }

    private void runPrompt(String string, ISQLCommand iSQLCommand) {
        try {
            String string2 = ">>Query Run In:" + string;
            this.getOutputStream().write(string2.getBytes("UTF-8"));
            this.getOutputStream().write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getDataGridTabLabel(AbstractWorksheetTaskResultPanel abstractWorksheetTaskResultPanel) {
        if (abstractWorksheetTaskResultPanel.getState() != WorksheetState.OPENED || abstractWorksheetTaskResultPanel.getState() != WorksheetState.PINNED) {
            int n = 0;
            while (abstractWorksheetTaskResultPanel.getState() != WorksheetState.OPENED && abstractWorksheetTaskResultPanel.getState() != WorksheetState.PINNED && n < 4) {
                ++n;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    this.m_logger.log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
                }
            }
        }
        String string = Messages.getString((String)"RunQueryPanel.0");
        if (abstractWorksheetTaskResultPanel.getState() == WorksheetState.OPENED || abstractWorksheetTaskResultPanel.getState() != WorksheetState.PINNED) {
            string = abstractWorksheetTaskResultPanel.getTabLabel();
        }
        return string;
    }

    private void disableTheTaskPause() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ITaskUI iTaskUI = OLAPScriptRunnerTask.this.getWorksheetContext().getTaskViewer().getTaskUI(OLAPScriptRunnerTask.this.getDescriptor());
                    if (iTaskUI != null) {
                        iTaskUI.setPausable(false);
                    }
                    if ((iTaskUI = OLAPScriptRunnerTask.this.getInitialConsumer().getPanel().getTaskViewer().getTaskUI(OLAPScriptRunnerTask.this.getDescriptor())) != null) {
                        iTaskUI.setPausable(false);
                    }
                    if ((iTaskUI = TaskProgressViewer.getInstance().getTaskUI(OLAPScriptRunnerTask.this.getDescriptor())) != null) {
                        iTaskUI.setPausable(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private BufferedOutputStream getOutputStream() {
        if (this.m_out == null) {
            PipedInputStream pipedInputStream = new PipedInputStream();
            try {
                this.m_out = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
            }
            catch (IOException iOException) {
                this.m_logger.log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
            ConsumerManagerTask consumerManagerTask = new ConsumerManagerTask(pipedInputStream, this.getConsumer(), this.getScriptRunnerContext());
            this.runTaskInNewThread((Thread)consumerManagerTask);
        }
        return this.m_out;
    }

    public IScriptConsumer getConsumer() {
        return this.m_consumer;
    }

    @Override
    public void afterLoopProcessing() {
        CommandRegistry.fireEndScriptListeners((Connection)this.getCurrentConnection(), (ScriptRunnerContext)this.getScriptRunnerContext());
        this.saveHistory();
    }

    @Override
    public void beforeLoopProcessing() {
        CommandRegistry.fireBeginScriptListeners((Connection)this.getCurrentConnection(), (ScriptRunnerContext)this.getScriptRunnerContext());
        if (!this.getWorksheetContext().isTemporaryFile()) {
            String string = this.m_worksheetContext.getFileURL().toString();
            SqlEditorHistory.getInstance();
            SqlEditorHistory.saveSql((String)string, (String)Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.m_connection)), (String)SqlEditorHistory.TYPE_SCRIPT_HISTORY, (float)((float)this.getDescriptor().getElapsedTime() / 1000.0f));
        }
    }

    @Override
    protected void startup() {
        ((RunScriptPanel)this.m_consumer.getPanel()).getTextPane().setFocusable(false);
    }

    @Override
    public void cleanup() {
        if (this.getCurrentConnection() != null && !this.isInterupted() && this.getScriptRunnerContext().getCloseConnection()) {
            this.getScriptRunnerContext().writeDisconnectWarning();
        }
        if (this.getCurrentConnection() != null) {
            this.closeAnyIntermediateConnection();
        }
        this.closeThePipeStream(this.getOutputStream());
        this.reinitializeTheScriptRunnerContext();
        if ((RunScriptPanel)this.m_consumer.getPanel() != null && ((RunScriptPanel)this.m_consumer.getPanel()).getTextPane() != null) {
            ((RunScriptPanel)this.m_consumer.getPanel()).getTextPane().setFocusable(true);
        }
    }

    @Override
    protected IScriptConsumer getInitialConsumer() {
        return this.getConsumerManager().getAvailableConsumer(false);
    }

    public boolean cancel() {
        this.m_statementRunner.cancel();
        this.m_isCanceled = true;
        return true;
    }
}

