/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistryEntry;
import oracle.ide.db.DefaultDBTypeRegistry;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.icons.OracleIcons;

public final class DBTypeDisplayRegistry {
    public static final String CONNECTIONS_TYPE = "Connections";
    private static List<DBTypeDisplayRegistryEntry> s_registries = new ArrayList<DBTypeDisplayRegistryEntry>();
    private static HashMap<String, Icon> s_generatedFolderIcons = new HashMap();

    private DBTypeDisplayRegistry() {
    }

    public static void addDBTypeRegistry(DBTypeDisplayRegistryEntry registry) {
        s_registries.add(0, registry);
    }

    public static Icon getFolderIcon(String type) {
        Icon retval = null;
        if (retval != null || type == null) {
            return retval;
        }
        for (DBTypeDisplayRegistryEntry reg : s_registries) {
            retval = reg.getFolderIcon(type);
            if (retval == null) continue;
            return retval;
        }
        if (DBTypeDisplayRegistry.getNodeIcon(type) != null) {
            retval = new FolderIcon(type);
            s_generatedFolderIcons.put(type, retval);
            return retval;
        }
        return null;
    }

    public static Icon getNodeIcon(String type) {
        Icon icon;
        block1: {
            DBTypeDisplayRegistryEntry reg;
            icon = null;
            if (type == null) break block1;
            Iterator<DBTypeDisplayRegistryEntry> i$ = s_registries.iterator();
            while (i$.hasNext() && (icon = (reg = i$.next()).getNodeIcon(type)) == null) {
            }
        }
        return icon;
    }

    public static Icon getNodeIcon(DBObject object) {
        Icon retval = null;
        if (object instanceof Constraint) {
            retval = DBTypeDisplayRegistry.getNodeIcon(((Constraint)object).getConstraintType());
        } else if (object != null) {
            String type = object.getType();
            if ("PlSqlSubProgram".equals(type)) {
                type = ((PlSqlSubProgram)object).getReturnTypeReference() == null ? "PROCEDURE" : "FUNCTION";
            }
            retval = DBTypeDisplayRegistry.getNodeIcon(type);
        }
        return retval;
    }

    public static String getDisplayName(String type) {
        String name = null;
        if (type != null) {
            DBTypeDisplayRegistryEntry reg;
            Iterator<DBTypeDisplayRegistryEntry> i$ = s_registries.iterator();
            while (i$.hasNext() && ((name = (reg = i$.next()).getDisplayName(type)) == null || name.equals(type))) {
            }
            if (name == null || name.equals(type)) {
                name = DisplayNames.getTypePluralName((String)type);
            }
        }
        return name;
    }

    public static String getSingularDisplayName(String type) {
        String name = null;
        if (type != null) {
            DBTypeDisplayRegistryEntry reg;
            Iterator<DBTypeDisplayRegistryEntry> i$ = s_registries.iterator();
            while (i$.hasNext() && ((name = (reg = i$.next()).getSingularDisplayName(type)) == null || name.equals(type))) {
            }
            if (name == null || name.equals(type)) {
                name = DisplayNames.getTypeDisplayName((String)type);
            }
        }
        return name;
    }

    public static String getNewMenuItemText(String type) {
        String text = null;
        if (type != null) {
            DBTypeDisplayRegistryEntry reg;
            Iterator<DBTypeDisplayRegistryEntry> i$ = s_registries.iterator();
            while (i$.hasNext() && (text = (reg = i$.next()).getNewMenuItemText(type)) == null) {
            }
            if (text == null) {
                text = UIBundle.format("NEW_MENU_TEMPLATE", DBTypeDisplayRegistry.getSingularDisplayName(type));
            }
        }
        return text;
    }

    static {
        DBTypeDisplayRegistry.addDBTypeRegistry(new DefaultDBTypeRegistry());
    }

    private static class FolderIcon
    extends IconWithSmallOverlay {
        public FolderIcon(String type) {
            super(OracleIcons.getIcon((String)"folder.png"), DBTypeDisplayRegistry.getNodeIcon(type));
        }
    }
}

