/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;

public final class DBURLFactory {
    private static List<Helper> s_helpers;

    private DBURLFactory() {
    }

    @Deprecated
    public static void registerHelper(Helper h) {
        DBURLFactory.registerTemporaryHelper(h);
    }

    public static synchronized void registerTemporaryHelper(Helper h) {
        if (s_helpers == null) {
            s_helpers = new ArrayList<Helper>();
        }
        s_helpers.add(0, h);
    }

    public static synchronized void removeHelper(Helper h) {
        if (s_helpers != null) {
            s_helpers.remove(h);
            if (s_helpers.isEmpty()) {
                s_helpers = null;
            }
        }
    }

    private static Iterable<Helper> getHelpers(String type) {
        DatabaseExtensionHook hook = DatabaseExtensionHook.getHook();
        Collection<Helper> retval = null;
        if (hook == null) {
            retval = s_helpers;
        } else {
            retval = hook.getURLFactoryHelpers(type);
            if (s_helpers != null) {
                retval.addAll(s_helpers);
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    public static URL getURL(DBObjectProvider pro, SystemObject obj) {
        URL retval = null;
        if (pro != null && obj != null && obj.getName() != null) {
            for (Helper h : DBURLFactory.getHelpers(pro.getProviderType())) {
                try {
                    if (!(h instanceof URLHelper ? (retval = ((URLHelper)h).createURL(pro, obj)) != null : obj instanceof SchemaObject && (retval = h.createURL(pro, (SchemaObject)obj, null)) != null)) continue;
                    break;
                }
                catch (Exception e) {
                    DBURLFactory.logHelperFailure(h, e);
                }
            }
        }
        return retval;
    }

    public static URL getURL(DBObjectProvider pro) {
        URL retval = null;
        for (Helper h : DBURLFactory.getHelpers(pro.getProviderType())) {
            try {
                if (!(h instanceof URLHelper) || (retval = ((URLHelper)h).createProviderURL(pro)) == null) continue;
                break;
            }
            catch (Exception e) {
                DBURLFactory.logHelperFailure(h, e);
            }
        }
        return retval;
    }

    private static void logHelperFailure(Helper h, Exception e) {
        DBLog.getLogger(DBURLFactory.class).log(Level.SEVERE, h.getClass() + " failure: " + e.getMessage(), e);
    }

    @Deprecated
    public static URL getURL(DBObjectProvider pro, SchemaObject obj, String subType) {
        return DBURLFactory.getURL(pro, (SystemObject)obj);
    }

    public static abstract class URLHelper
    implements Helper {
        public abstract URL createURL(DBObjectProvider var1, SystemObject var2);

        public abstract URL createProviderURL(DBObjectProvider var1);

        @Override
        @Deprecated
        public final boolean canCreateURL(DBObjectProvider pro) {
            return true;
        }

        @Override
        @Deprecated
        public final URL createURL(DBObjectProvider pro, SchemaObject obj, String subType) {
            return this.createURL(pro, (SystemObject)obj);
        }
    }

    @Deprecated
    public static interface Helper {
        public boolean canCreateURL(DBObjectProvider var1);

        public URL createURL(DBObjectProvider var1, SchemaObject var2, String var3);
    }
}

