/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public final class ProviderOperator {
    private final DBObjectProvider m_pro;
    private final Context m_context;

    public ProviderOperator(DBObjectProvider pro) {
        this(pro, null);
    }

    public ProviderOperator(DBObjectProvider pro, Context context) {
        this.m_pro = pro;
        this.m_context = context;
    }

    public Difference difference(SystemObject[] orig, SystemObject[] upd) {
        if (orig == null) {
            if (upd != null) {
                orig = new SystemObject[upd.length];
            }
        } else if (upd == null) {
            upd = new SystemObject[orig.length];
        }
        return this.m_pro.getDiffEngine().difference((Object)orig, (Object)upd);
    }

    public boolean createObjects(SystemObject[] objs) {
        boolean retval = false;
        if (objs != null && objs.length > 0) {
            if (objs.length == 1) {
                DBEditorConfig config = DBEditorConfig.newCreateConfig(this.m_pro, (DBObject)objs[0]);
                retval = this.updateObjects(config);
            } else {
                DBObjectTransaction txn = new DBObjectTransaction(this.m_pro);
                txn.includeListDifference(this.difference(null, objs));
                retval = this.updateObjects(txn, null);
            }
        }
        return retval;
    }

    public boolean updateObjects(SystemObject[] old, SystemObject[] updateObjs) {
        boolean retval = false;
        if (old != null && old.length > 0) {
            if (old.length == 1 && updateObjs[0] != null) {
                DBEditorConfig config;
                if (old[0] == null) {
                    config = DBEditorConfig.newCreateConfig(this.m_pro, (DBObject)updateObjs[0]);
                } else {
                    config = DBEditorConfig.newEditConfig(this.m_pro, (DBObject)old[0]);
                    config.setUpdatedObject(updateObjs[0]);
                }
                retval = this.updateObjects(config);
            } else {
                DBObjectTransaction txn = new DBObjectTransaction(this.m_pro);
                txn.includeListDifference(this.difference(old, updateObjs));
                retval = this.updateObjects(txn, null);
            }
        }
        return retval;
    }

    public boolean updateObjects(DBEditorConfig config) {
        SystemObject newObject = config.getUpdatedObject();
        SystemObject oldObject = config.getOriginalObject();
        DBObjectProvider pro = config.getProvider();
        if (newObject == null) {
            throw new IllegalArgumentException("cannot create/edit without an object");
        }
        if (pro != this.m_pro) {
            throw new IllegalArgumentException("config and operator have different providers");
        }
        if (config.isCommitToProvider() && CascadeConfirmDialog.confirmReplace(config)) {
            try {
                Schema newSchema = DBUtil.getSchema((DBObject)newObject);
                if (newSchema != null) {
                    Schema existingSchema = pro.getSchema(newSchema.getName());
                    if (existingSchema == null) {
                        pro.createSchema(newSchema, false);
                    } else if (newObject instanceof SchemaObject) {
                        ((SchemaObject)newObject).setSchema(existingSchema);
                    }
                }
                DBObjectTransaction txn = new DBObjectTransaction(pro);
                txn.addParameter((Object)config);
                txn.setCascade(true);
                txn.setReplace(true);
                txn.includeUpdate(oldObject, newObject);
                this.updateObjects(txn, config);
            }
            catch (DBException ex) {
                config.setException(ex);
                config.setResult(DBEditorConfig.Result.FAILED);
                DBMessageDialog.showErrorDialog((Exception)((Object)ex), this, Level.SEVERE, null, ProviderOperator.getTitle(config), null);
            }
        } else {
            if (oldObject != null) {
                DifferenceApplier applier = new DifferenceApplier(pro);
                applier.apply(oldObject, newObject);
            }
            config.setResult(DBEditorConfig.Result.SUCCESS);
        }
        return config.getResult() == DBEditorConfig.Result.SUCCESS;
    }

    public void commitTransaction(DBObjectTransaction txn) {
        this.updateObjects(txn, null);
    }

    private boolean updateObjects(final DBObjectTransaction txn, final DBEditorConfig config) {
        final Holder retval = new Holder((Object)false);
        if (DBMessageDialog.useDialog() && SwingUtilities.isEventDispatchThread()) {
            final ProgressBar pbar = new ProgressBar(DBMessageDialog.getDialogParent(), this.getTitle(txn, config), null, true);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        retval.set((Object)ProviderOperator.this.updateObjectsImpl(txn, config));
                    }
                    finally {
                        pbar.setDoneStatus();
                    }
                }
            };
            pbar.setRunnable(r);
            pbar.setCancelable(false);
            pbar.setDialogName("Transaction Commit:" + DBUtil.createUUID());
            pbar.start(UIBundle.format("DBOBJECT_UPDATING_TEXT", txn.getProvider().getDescription()), null, 1500);
        } else {
            retval.set((Object)this.updateObjectsImpl(txn, config));
        }
        return (Boolean)retval.get();
    }

    private boolean updateObjectsImpl(DBObjectTransaction txn, DBEditorConfig config) {
        boolean retval = false;
        try {
            if (config != null && config.getEditorType() == DBEditorFactory.EditorType.EDIT_FLAT) {
                txn.setRefactorUpdatedObject(true);
            }
            if (this.m_context != null) {
                txn.addParameter((Object)this.m_context);
            }
            txn.commit();
            retval = true;
            if (config != null) {
                config.setResult(DBEditorConfig.Result.SUCCESS);
            }
        }
        catch (DBException dbe) {
            if (config != null) {
                config.setResult(DBEditorConfig.Result.FAILED);
                config.setException(dbe);
            }
            this.processException(dbe, config);
        }
        catch (Exception e) {
            if (config != null) {
                config.setResult(DBEditorConfig.Result.FAILED);
                config.setException(new DBException((DBObject)config.getUpdatedObject(), (Throwable)e));
            }
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Commit of txn threw unexepcted error", e);
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processException(DBException dbe, DBEditorConfig config) {
        boolean done;
        block15: {
            DBObjectProvider pro;
            done = false;
            if (config != null && (pro = config.getProvider()) instanceof Database) {
                SystemObject oldObject = config.getOriginalObject();
                SystemObject newObject = config.getUpdatedObject();
                SystemObject newOldObj = null;
                try {
                    Object originalTimestamp;
                    if (oldObject != null) {
                        originalTimestamp = oldObject.getProperty("Timestamp");
                        DBUtil.clearCachedTimestamp((DBObjectProvider)pro, (SystemObject)oldObject);
                        newOldObj = (SystemObject)DBUtil.getProviderDefinition((DBObject)oldObject, (DBObjectProvider)pro);
                        if (newOldObj == null && !DBUtil.areNamesAndTypesEqual((DBObject)oldObject, (DBObject)newObject)) {
                            newOldObj = (SystemObject)DBUtil.getProviderDefinition((DBObject)newObject, (DBObjectProvider)pro);
                        }
                    } else {
                        originalTimestamp = null;
                        newOldObj = (SystemObject)DBUtil.getProviderDefinition((DBObject)newObject, (DBObjectProvider)pro);
                    }
                    Object newTimestamp = newOldObj == null ? null : newOldObj.getProperty("Timestamp");
                    String warningMessage = null;
                    if (oldObject != null && newOldObj == null) {
                        warningMessage = UIBundle.get("DBOBJECT_WAS_DROPPED_WARNING");
                    } else if (oldObject == null && newOldObj != null) {
                        warningMessage = UIBundle.get("DBOBJECT_WAS_CREATED_WARNING");
                    } else if (oldObject != null && originalTimestamp != null && ModelUtil.areDifferent((Object)originalTimestamp, (Object)newTimestamp)) {
                        warningMessage = UIBundle.get("DBOBJECT_HAD_CHILDREN_DROPPED_WARNING");
                    }
                    DBMessageDialog.showErrorDialog((Exception)((Object)dbe), this, Level.SEVERE, warningMessage, ProviderOperator.getTitle(config), null);
                    done = true;
                    newObject.setProperty("Timestamp", newTimestamp);
                    config.setOriginalObject(newOldObj);
                    if (newOldObj == null) break block15;
                    if (oldObject == null) {
                        config.setReplaceAlwaysAllowed(true);
                    } else if (originalTimestamp == null && newTimestamp != null) {
                        // empty if block
                    }
                }
                catch (DBException e) {
                    DBLog.getLogger().warning("Error determining if old object should be updated: " + e.getMessage());
                }
            }
        }
        if (!done) {
            DBMessageDialog.showErrorDialog((Exception)((Object)dbe), (Object)this, Level.SEVERE);
        }
    }

    private String getTitle(DBObjectTransaction txn, DBEditorConfig config) {
        String retval = config != null ? ProviderOperator.getTitle(config) : UIBundle.get("DBOBJECT_UPDATING_TITLE");
        return retval;
    }

    public static String getTitle(DBEditorConfig config) {
        String typeDisplay = DBTypeDisplayRegistry.getSingularDisplayName(config.getObjectType());
        String key = config.getOriginalObject() == null ? "DBOBJECT_CREATE_TITLE" : "DBOBJECT_EDIT_TITLE";
        return UIBundle.format(key, typeDisplay);
    }
}

