/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectDescriptor {
    private transient SystemObject m_obj;
    private String m_name;
    private String m_type;
    private String m_schema;
    private String m_dbName;
    private String m_otherName;

    private SchemaObjectDescriptor() {
    }

    public SchemaObjectDescriptor(String name, String type, String schema) {
        this.m_name = name;
        this.m_type = type;
        this.m_schema = schema;
    }

    public SchemaObjectDescriptor(SystemObject obj) {
        if (obj != null) {
            DBObjectID id;
            this.m_name = obj.getName();
            this.m_type = obj.getType();
            if (obj instanceof SchemaObject) {
                Schema schema = ((SchemaObject)obj).getSchema();
                this.m_schema = schema.getName();
            }
            if ((id = obj.getID()) instanceof BaseObjectID) {
                this.m_dbName = ((BaseObjectID)id).getDatabaseName();
            }
        }
        this.m_obj = obj;
    }

    public String getName() {
        return this.m_name;
    }

    @Deprecated
    public String getOriginalName() {
        return this.getName();
    }

    public String getType() {
        return this.m_type;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getDatabaseName() {
        return this.m_dbName;
    }

    public SystemObject getObject() {
        return this.m_obj;
    }

    public String getOtherName() {
        return this.m_otherName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setDatabaseName(String dbName) {
        this.m_dbName = dbName;
    }

    @Deprecated
    public void setOriginalName(String name) {
        this.setName(name);
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setOtherName(String name) {
        this.m_otherName = name;
    }

    public boolean matches(BaseObjectID id) {
        return id != null && ModelUtil.areEqual((Object)this.getName(), (Object)id.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)id.getType()) && ModelUtil.areEqual((Object)this.getSchema(), (Object)id.getSchemaName());
    }

    public boolean equals(Object obj) {
        return obj instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)obj, false);
    }

    protected boolean equalsImpl(SchemaObjectDescriptor obj, boolean strict) {
        return ModelUtil.areEqual((Object)this.getName(), (Object)obj.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)obj.getType()) && ModelUtil.areEqual((Object)this.getSchema(), (Object)obj.getSchema()) && (!strict || ModelUtil.areEqual((Object)this.m_name, (Object)obj.m_name));
    }

    public boolean equals(Object obj, boolean strict) {
        return obj instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)obj, strict);
    }

    public Object copyTo(Object obj) {
        SchemaObjectDescriptor copy = obj == null ? new SchemaObjectDescriptor() : (SchemaObjectDescriptor)obj;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(SchemaObjectDescriptor copy) {
        copy.m_name = this.m_name;
        copy.m_schema = this.m_schema;
        copy.m_type = this.m_type;
        copy.m_dbName = this.m_dbName;
        copy.m_otherName = this.m_otherName;
    }

    public String toString() {
        return this.getName() + " (" + this.getSchema() + ")";
    }

    public int hashCode() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.m_type).append(".").append(this.m_name);
        return buf.toString().hashCode();
    }

    public DBObjectCriteria createCriteria() {
        DBObjectCriteria crit = DBObjectCriteria.createSingleObjectCriteria((String)this.getType(), (String)this.getDatabaseName(), (String)this.getSchema(), (String)this.getName());
        return crit;
    }

    public SystemObject findObject(DBObjectProvider pro) throws DBException {
        SystemObject retval = this.m_obj;
        if (pro != null) {
            DBObjectID id;
            if (!(retval == null || (id = retval.getID()) instanceof BaseObjectID && ((BaseObjectID)id).getProvider() == pro)) {
                retval = null;
            }
            if (retval == null) {
                this.m_obj = pro.getObject(this.createCriteria());
            }
        }
        if (this.m_obj == null && retval != null) {
            this.m_obj = retval;
        }
        return this.m_obj;
    }

    @Deprecated
    public SchemaObject unwrapDescriptor(DBObjectProvider source) throws DBException {
        SystemObject obj = this.findObject(source);
        return obj instanceof SchemaObject ? (SchemaObject)obj : null;
    }

    @Deprecated
    public SystemObject unwrapSystemObjectDescriptor(DBObjectProvider source) throws DBException {
        return this.findObject(source);
    }

    public static SystemObject[] findObjects(DBObjectProvider source, SchemaObjectDescriptor ... descs) throws DBException {
        SystemObject[] retval;
        if (descs == null) {
            retval = new SystemObject[]{};
        } else {
            retval = new SystemObject[descs.length];
            for (int i = 0; i < descs.length; ++i) {
                retval[i] = descs[i].findObject(source);
            }
        }
        return retval;
    }

    @Deprecated
    public static SchemaObject[] unwrapDescriptors(SchemaObjectDescriptor[] descs, DBObjectProvider source) throws DBException {
        SystemObject[] objs = SchemaObjectDescriptor.findObjects(source, descs);
        SchemaObject[] schobjs = new SchemaObject[objs.length];
        for (int i = 0; i < schobjs.length; ++i) {
            if (!(objs[i] instanceof SchemaObject)) continue;
            schobjs[i] = (SchemaObject)objs[i];
        }
        return schobjs;
    }

    @Deprecated
    public static SystemObject[] unwrapSystemObjectDescriptors(SchemaObjectDescriptor[] descs, DBObjectProvider source) throws DBException {
        return SchemaObjectDescriptor.findObjects(source, descs);
    }

    public static SchemaObjectDescriptor[] createDescriptors(SystemObject[] objs, boolean saveObj) {
        if (objs != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                if (saveObj) {
                    retval[i] = new SchemaObjectDescriptor(objs[i]);
                    continue;
                }
                String schema = null;
                if (objs[i] instanceof SchemaObject) {
                    schema = ((SchemaObject)objs[i]).getSchema().getName();
                }
                retval[i] = new SchemaObjectDescriptor(objs[i].getName(), objs[i].getType(), schema);
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SystemObject[] objs) {
        return SchemaObjectDescriptor.createDescriptors(objs, true);
    }

    public static SchemaObjectDescriptor[] createDescriptors(DBObjectID[] ids) {
        if (ids != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                try {
                    DBObject obj;
                    if (ids[i] == null || (obj = ids[i].resolveID()) == null || !(obj instanceof SystemObject)) continue;
                    retval[i] = new SchemaObjectDescriptor((SystemObject)obj);
                    continue;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            return retval;
        }
        return null;
    }
}

