/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

public final class ComponentContext {
    private DBObject m_originalObject;
    private DBObject m_updatedObject;
    private boolean m_inTable;
    private PropertyInfo m_propInfo;
    private final String m_propName;
    private String m_basePath;
    private Namespace m_dataContext;
    private ComponentContext m_parentComponentContext;
    private final String m_owningPanelName;

    ComponentContext(String propName, DBObject originalObject, DBObject updatedObject, Namespace dataContext, String owningPanelName) {
        this.m_propName = propName;
        this.m_originalObject = originalObject;
        this.m_updatedObject = updatedObject;
        this.m_dataContext = dataContext;
        this.m_owningPanelName = owningPanelName;
        if (this.m_originalObject == null && this.m_updatedObject == null) {
            DBEditorConfig editorConfig = this.getEditorConfig();
            this.m_originalObject = editorConfig.getChildObject();
            this.m_updatedObject = editorConfig.getChildObject();
        }
    }

    public DBObject getOriginalObject() {
        return this.m_originalObject;
    }

    public void setUpdatedObject(DBObject updatedObject) {
        this.m_updatedObject = updatedObject;
        this.m_originalObject = null;
        if (updatedObject != null) {
            DBObjectID id = updatedObject.getID();
            if (id instanceof TemporaryObjectID) {
                this.m_originalObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)id));
            } else if (id != null) {
                throw new IllegalStateException("updatedObject must have a TemopraryObjectID");
            }
        }
    }

    public DBObject getUpdatedObject() {
        return this.m_updatedObject;
    }

    public SystemObject getUpdatedSystemObject() {
        return this.getEditorConfig().getUpdatedObject();
    }

    public SystemObject getOriginalSystemObject() {
        return this.getEditorConfig().getOriginalObject();
    }

    public boolean isInFlatEditor() {
        return this.getEditorConfig().isInFlatEditor();
    }

    public void setInTable(boolean inTable) {
        this.m_inTable = inTable;
    }

    public boolean isInTable() {
        return this.m_inTable;
    }

    public PropertyInfo getPropertyInfo() {
        if (this.m_propInfo == null) {
            PropertyManager pm = this.getProvider().getPropertyManager();
            SystemObject parent = this.getUpdatedSystemObject();
            this.m_propInfo = parent == null ? pm.findPropertyInfo(this.getUpdatedObject().getClass(), this.getPropertyName()) : pm.findPropertyInfo(parent.getClass(), this.getFullPropertyPath());
        }
        return this.m_propInfo;
    }

    public DBEditorConfig getEditorConfig() {
        return (DBEditorConfig)this.m_dataContext.find(DBEditorConfig.class);
    }

    void setDataContext(Namespace dataContext) {
        this.m_dataContext = dataContext;
    }

    public Namespace getDataContext() {
        return this.m_dataContext;
    }

    public ComponentContext getParentComponentContext() {
        return this.m_parentComponentContext;
    }

    public void setParentComponentContext(ComponentContext parentComponentContext) {
        this.m_parentComponentContext = parentComponentContext;
    }

    public DBObjectProvider getProvider() {
        return this.getEditorConfig().getProvider();
    }

    public String getOwningPanelName() {
        if (this.m_owningPanelName != null) {
            return this.m_owningPanelName;
        }
        if (this.m_parentComponentContext != null) {
            return this.m_parentComponentContext.getOwningPanelName();
        }
        return null;
    }

    public String getPropertyName() {
        return this.m_propName;
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public void setBasePath(String basePath) {
        this.m_basePath = basePath;
    }

    public String getFullPropertyPath() {
        String basePath = this.getBasePath();
        String retval = this.getPropertyName();
        if (ModelUtil.hasLength((String)basePath)) {
            retval = Property.createPath((String[])new String[]{basePath, retval});
        }
        return retval;
    }
}

