/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.Holder;

public abstract class ComponentWrapper<T extends Component> {
    private static final String DEBUG_DISABLED = "ComponentWrapper.DEBUG_DISABLED";
    private Collection<PropertyChangeListener> m_listeners;
    private Collection<VetoableChangeListener> m_vetoListeners;
    private final T m_activeComponent;
    private Component m_component;
    private boolean m_active;
    private boolean m_readOnly;
    private boolean m_committing;
    private boolean m_settingValue;
    private ComponentContext m_componentContext;
    private boolean m_isSupported = true;
    private Boolean m_volatile = null;
    private JLabel m_label = null;
    private String m_displayName;

    public ComponentWrapper(T activeComponent) {
        this.m_activeComponent = activeComponent;
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    public final void initialise(ComponentContext ctxt) {
        this.m_componentContext = ctxt;
        this.initialiseComponent();
        T comp = this.getActiveComponent();
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty(ComponentContext.class, ctxt);
        }
        this.initialiseComponentListener();
    }

    public boolean refreshObject(DBObject refreshedObject) {
        boolean retval = false;
        ComponentContext cc = this.getComponentContext();
        if (refreshedObject != cc.getUpdatedObject()) {
            retval = true;
            this.getComponentContext().setUpdatedObject(refreshedObject);
        }
        if (refreshedObject != null) {
            this.setComponentValueFromObject();
        } else {
            this.setPropertyValueDirectly(null);
        }
        return retval;
    }

    private void setComponentValueFromObject() {
        if (this.getUpdatedObject() != null) {
            PropertyHelper helper = this.getPropertyHelper();
            Object value = helper.getPropertyValue((Object)this.getUpdatedObject(), this.getPropertyName());
            this.setPropertyValueDirectly(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyValueDirectly(Object value) {
        this.m_settingValue = true;
        try {
            this.setPropertyValue(value);
        }
        finally {
            this.m_settingValue = false;
        }
    }

    public final void setActive(boolean active) {
        if (this.m_active != active) {
            if (active) {
                this.setComponentValueFromObject();
            }
            this.m_active = active;
            this.setActiveImpl(active);
        }
    }

    public final boolean isActive() {
        return this.m_active;
    }

    protected void setActiveImpl(boolean active) {
    }

    public final boolean isVolatile() {
        if (this.m_volatile == null) {
            ComponentContext context;
            PropertyManager pm = this.getProvider().getPropertyManager();
            this.m_volatile = !pm.getRestrictingProperties((context = this.getComponentContext()).getUpdatedSystemObject().getClass(), context.getFullPropertyPath()).isEmpty();
        }
        return this.m_volatile;
    }

    public final T getActiveComponent() {
        return this.m_activeComponent;
    }

    protected Component createComponentForLayout() {
        return this.getActiveComponent();
    }

    public final Component getComponent() {
        if (this.m_component == null) {
            this.m_component = this.createComponentForLayout();
        }
        return this.m_component;
    }

    public Component getDefaultFocusComponent() {
        return this.getActiveComponent();
    }

    public void setValidationStatus(Collection<ValidationException> ves, DBValidationHandler handler) {
        Component c = this.getDefaultValidationComponent();
        if (c != null) {
            handler.processValidation(c, this, ves);
        }
    }

    protected Component getDefaultValidationComponent() {
        return this.getDefaultFocusComponent();
    }

    public abstract Object getPropertyValue();

    public abstract void setPropertyValue(Object var1);

    public final void resetPropertyValue(Object newValue) {
        if (!this.m_committing) {
            this.setDBObjectPropertyValue(newValue);
            this.setPropertyValueDirectly(newValue);
        }
    }

    public void setEnabled(boolean enabled) {
        T c = this.getActiveComponent();
        if (ComponentWrapper.isDebug() && ComponentWrapper.isDebugDisabled(c)) {
            return;
        }
        ((Component)c).setEnabled(enabled);
        JLabel label = this.getLabel();
        if (label != null) {
            label.setEnabled(enabled);
        }
    }

    public void setVisible(boolean visible) {
        T c = this.getActiveComponent();
        JLabel label = this.getLabel();
        if (!visible && ComponentWrapper.isDebug()) {
            ComponentWrapper.setDebugEnabled(c, label, false);
        } else {
            if (ComponentWrapper.isDebug()) {
                ComponentWrapper.setDebugEnabled(c, label, true);
            }
            this.setVisibleImpl((Component)c, this.getComponent(), visible);
            if (label != null) {
                this.getLabel().setVisible(visible);
            }
        }
    }

    private void setVisibleImpl(Component c, Component top, boolean visible) {
        Container par;
        c.setVisible(visible);
        if (c != top && (par = c.getParent()) != null) {
            this.setVisibleImpl(par, top, visible);
        }
    }

    public final String getPropertyName() {
        return this.getComponentContext().getPropertyName();
    }

    public JLabel getLabel() {
        if (this.m_label == null) {
            this.m_label = new JLabel(this.getPropertyDisplayName());
        }
        return this.m_label;
    }

    public String getPropertyDisplayName() {
        if (this.m_displayName == null) {
            this.m_displayName = PropertyDisplayRegistry.getDisplayName(this.getPropertyName(), this.getProvider(), this.getUpdatedObject());
        }
        return this.m_displayName;
    }

    public void setPropertyDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    protected abstract void initialiseComponentListener();

    protected void initialiseComponent() {
    }

    public final synchronized void addListener(PropertyChangeListener listener) {
        if (listener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
            }
            if (!this.m_listeners.contains(listener)) {
                this.m_listeners.add(listener);
            }
        }
    }

    public final synchronized void addVetoListener(VetoableChangeListener listener) {
        if (listener != null) {
            if (this.m_vetoListeners == null) {
                this.m_vetoListeners = new CopyOnWriteArrayList<VetoableChangeListener>();
            }
            if (!this.m_vetoListeners.contains(listener)) {
                this.m_vetoListeners.add(listener);
            }
        }
    }

    public final void removeListener(PropertyChangeListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    public final void removeVetoListener(VetoableChangeListener listener) {
        if (this.m_vetoListeners != null) {
            this.m_vetoListeners.remove(listener);
        }
    }

    public void processComponent(boolean editable, boolean allowRecreate) {
        ComponentContext context = this.getComponentContext();
        if (context == null) {
            throw new IllegalStateException("Cannot call processComponents before initialise");
        }
        PropertyManager pm = this.getProvider().getPropertyManager();
        SystemObject originalObject = context.getOriginalSystemObject();
        SystemObject updatedObject = context.getUpdatedSystemObject();
        DBObject updatedContextObject = this.getUpdatedObject();
        this.m_isSupported = this.checkPropertyIsSupported();
        if (this.m_isSupported) {
            boolean disable;
            boolean bl = disable = !editable || updatedContextObject == null;
            if (!disable) {
                PropertyAction.Type actionType;
                String fullPropPath = context.getFullPropertyPath();
                PropertyAction action = pm.canChangeProperty(originalObject, updatedObject, fullPropPath);
                PropertyAction.Type type = actionType = action == null ? null : action.getType();
                if (originalObject == null) {
                    if (actionType != PropertyAction.Type.CREATE) {
                        disable = true;
                    }
                } else if (actionType != PropertyAction.Type.ALTER) {
                    if (actionType == PropertyAction.Type.REPLACE) {
                        this.getLogger().fine("will need replace for: " + this.getPropertyName());
                        disable = !allowRecreate;
                    } else {
                        disable = true;
                    }
                }
            }
            this.setVisible(true);
            this.setEnabled(!disable);
        } else if (updatedObject == null) {
            this.m_isSupported = true;
        } else {
            this.setVisible(false);
        }
        if (context.getFullPropertyPath().contains("attributeValues")) {
            this.setVisible(true);
        }
    }

    protected boolean checkPropertyIsSupported() {
        PropertyManager pm = this.getProvider().getPropertyManager();
        SystemObject updatedObject = this.getComponentContext().getUpdatedSystemObject();
        boolean childPropSupported = true;
        DBObject updatedContextObject = this.getUpdatedObject();
        if (updatedContextObject != null && updatedContextObject != updatedObject) {
            childPropSupported = pm.supportsProperty(updatedContextObject.getClass(), this.getPropertyName());
        }
        String fullPropPath = this.getComponentContext().getFullPropertyPath();
        boolean fullPropSupported = false;
        if (updatedObject != null) {
            if (!pm.supportsProperty(updatedObject.getClass(), fullPropPath)) {
                JLabel comp = this.getLabel();
                if (comp == null) {
                    comp = this.getActiveComponent();
                }
                DBUIMnemonicBuilder.setIgnoreComponent(comp, true);
                fullPropSupported = false;
            } else {
                fullPropSupported = pm.canCreateProperty(updatedObject, fullPropPath);
            }
        }
        return childPropSupported && fullPropSupported;
    }

    protected final Object getExistingPropertyValue() {
        PropertyInfo info;
        Object retval = null;
        DBObject obj = this.getUpdatedObject();
        if (obj != null && (info = this.getComponentContext().getPropertyInfo()) != null) {
            String propPath = this.getPropertyName();
            PropertyHelper helper = this.getPropertyHelper();
            retval = helper.getPropertyValue((Object)obj, propPath);
        }
        return retval;
    }

    private void setDBObjectPropertyValue(Object newValue) {
        PropertyInfo info;
        DBObject obj = this.getUpdatedObject();
        if (obj != null && (info = this.getComponentContext().getPropertyInfo()) != null) {
            String propPath = this.getPropertyName();
            PropertyHelper helper = this.getPropertyHelper();
            try {
                helper.setPropertyValueOrFail((Object)obj, propPath, newValue);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, this.getPropertyName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        if (this.m_active && !this.m_committing && !this.m_settingValue && this.m_isSupported) {
            this.m_committing = true;
            try {
                if (this.m_readOnly) {
                    this.setComponentValueFromObject();
                } else {
                    Object oldValue = this.getExistingPropertyValue();
                    Object newValue = this.getPropertyValue();
                    PropertyChangeEvent event = new PropertyChangeEvent(this.getActiveComponent(), "value", oldValue, newValue);
                    boolean veto = false;
                    if (this.m_vetoListeners != null && this.m_vetoListeners.size() > 0) {
                        for (VetoableChangeListener vetoableChangeListener : this.m_vetoListeners) {
                            try {
                                vetoableChangeListener.vetoableChange(event);
                            }
                            catch (PropertyVetoException pve) {
                                this.setPropertyValue(oldValue);
                                veto = true;
                                String message = pve.getMessage();
                                if (message == null) break;
                                DBMessageDialog.showErrorDialog(message, (Object)this, Level.SEVERE);
                                break;
                            }
                            catch (Exception e) {
                                this.logListenerException(e, vetoableChangeListener);
                            }
                        }
                    }
                    if (!veto) {
                        this.setDBObjectPropertyValue(newValue);
                        if (this.m_listeners != null && this.m_listeners.size() > 0) {
                            for (PropertyChangeListener propertyChangeListener : this.m_listeners) {
                                try {
                                    propertyChangeListener.propertyChange(event);
                                }
                                catch (Exception e) {
                                    this.logListenerException(e, propertyChangeListener);
                                }
                            }
                        }
                    }
                }
            }
            finally {
                this.m_committing = false;
            }
        }
    }

    private void logListenerException(Exception e, Object listener) {
        this.getLogger().log(Level.SEVERE, listener.getClass().getName(), e);
    }

    protected final PropertyHelper getPropertyHelper() {
        return BaseEditorPanel.getPropertyHelper(this.getComponentContext().getDataContext(), this.getProvider());
    }

    protected final DBObjectProvider getProvider() {
        return this.getComponentContext().getProvider();
    }

    protected final DBObject getUpdatedObject() {
        return this.getComponentContext().getUpdatedObject();
    }

    protected final DBObject getOriginalObject() {
        return this.getComponentContext().getOriginalObject();
    }

    public final boolean isSupported() {
        return this.m_isSupported;
    }

    public final ComponentContext getComponentContext() {
        return this.m_componentContext;
    }

    public Component getCellEditorComponent() {
        return this.getActiveComponent();
    }

    private static boolean isDebugDisabled(Component c) {
        return c instanceof JComponent && ((JComponent)c).getClientProperty(DEBUG_DISABLED) != null;
    }

    private static void setDebugEnabled(Component c, JLabel label, boolean enabled) {
        c.setEnabled(enabled);
        if (label != null) {
            label.setEnabled(enabled);
        }
        if (c instanceof JComponent) {
            if (enabled) {
                Holder holder = (Holder)((JComponent)c).getClientProperty(DEBUG_DISABLED);
                if (holder != null) {
                    ((JComponent)c).setBorder((Border)holder.get());
                    ((JComponent)c).putClientProperty(DEBUG_DISABLED, null);
                }
            } else {
                ((JComponent)c).putClientProperty(DEBUG_DISABLED, new Holder((Object)((JComponent)c).getBorder()));
                ((JComponent)c).setBorder(BorderFactory.createLineBorder(Color.PINK, 2));
            }
        }
    }

    private static boolean isDebug() {
        return Boolean.valueOf(System.getProperty("ide.db.debugWrappers"));
    }

    public final void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        this.setUIReadOnly(readOnly);
    }

    protected void setUIReadOnly(boolean readOnly) {
    }
}

