/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public final class DBObjectChooser
extends JPanel
implements ListCellRenderer {
    private static final String s_getFullList = UIBundle.get("CHOOSER_LOAD_FULL_LIST");
    private static final String s_selectConn = UIBundle.get("CHOOSER_SELECT_CONNECTION");
    private static final String s_selectConnHtml = UIBundle.get("CHOOSER_SELECT_CONNECTION_HTML");
    private static WeakReference<Database> s_lastDBRef = null;
    private final List<Pair<ChangeListener, Boolean>> m_listeners = new ArrayList<Pair<ChangeListener, Boolean>>();
    private final Map<DBObjectID, List<DBObjectID>> m_contextToIDListMap = new HashMap<DBObjectID, List<DBObjectID>>();
    private final Map<String, DBObjectID> m_textToIDMap = new HashMap<String, DBObjectID>();
    private final Set<DBObjectID> m_extraIDs = new HashSet<DBObjectID>();
    private final DBObjectProviderPicker.PickerConfiguration m_pickerConfig = new DBObjectProviderPicker.PickerConfiguration();
    private final DBUIResourceHelper m_helper = new DBUIResourceHelper("ComboChooserDelegate");
    private final DefaultListCellRenderer m_renDelegate = new DefaultListCellRenderer();
    private final DBObjectProviderListener m_proListener = new ProviderListener();
    private final DBObjectChooser m_theChooser = this;
    private String[] m_types;
    private DBObjectProvider m_destProv;
    private DBObjectProvider m_srcProv;
    private Boolean m_showIcon;
    private String m_nullText;
    private DBObjectChooser m_child;
    private DBObjectChooser m_parent;
    private DBObjectID m_contextID;
    private DBObjectID m_id;
    private Boolean m_enabled;
    private Boolean m_editable;
    private boolean m_childObjects = false;
    private boolean m_schemaObjects = false;
    private boolean m_nonSchemaSystemObjects = false;
    private boolean m_typeSupported = true;
    private DBObjectFilter m_filter = null;
    private CustomJComboBox m_cmb;
    private JButton m_butt;
    private ActionListener m_listener = null;
    private boolean m_gotModel = false;
    private boolean m_inMenuWillBecomeVisible = false;
    private boolean m_menuVisible = false;
    private boolean m_subsetLoaded = false;
    private boolean m_showDBLinkButton = false;
    private DBObjectID m_databaseLinkID = null;
    private boolean m_isDatabaseLinkChooser = false;
    private JButton m_addButton;
    private JButton m_editButton;
    private boolean m_showEditButton = false;
    private boolean m_showAddButton = false;
    private NewObjectProcessor m_addObjectProcessor;
    private DBObjectCriteria<SystemObject> m_criteria;
    private DBObjectLister m_lister;
    private DBObjectCriteria<SystemObject> m_listCriteria;

    public DBObjectChooser(String ... types) {
        this((DBObjectChooser)null, types);
    }

    public DBObjectChooser(DBObjectChooser parent, String ... types) {
        this(parent, (DBObjectLister)null, (DBObjectCriteria<SystemObject>)null, types);
    }

    public DBObjectChooser(DBObjectChooser parent, DBObjectLister lister, DBObjectCriteria<SystemObject> criteria, String ... types) {
        for (String type : types) {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (Index.class == clz) {
                this.m_childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clz)) {
                this.m_schemaObjects = true;
                continue;
            }
            if (ChildDBObject.class.isAssignableFrom(clz)) {
                this.m_childObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            this.m_nonSchemaSystemObjects = true;
        }
        if ((this.m_childObjects ? 1 : 0) + (this.m_schemaObjects ? 1 : 0) + (this.m_nonSchemaSystemObjects ? 1 : 0) != 1) {
            throw new IllegalArgumentException("Incompatible list of types");
        }
        if (lister != null || criteria != null) {
            if (lister == null || criteria == null) {
                throw new IllegalArgumentException("both lister and criteria must be null or not null");
            }
            this.m_lister = lister;
            this.m_listCriteria = criteria;
        }
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.m_child = this;
        }
        this.m_types = types;
        this.setLayout(new GridBagLayout());
    }

    public final void setShowIcon(boolean showIcon) {
        this.m_showIcon = showIcon;
    }

    public final void setNullText(String nullText) {
        this.m_nullText = nullText;
    }

    public DBObjectCriteria<SystemObject> getDBObjectCriteria() {
        return this.m_criteria;
    }

    public final void addIDToList(DBObjectID id) {
        this.m_extraIDs.add(id);
    }

    public void setShowDBLinkButton(boolean showDBLinkButton) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowDBLinkButton() before setProvider()");
        }
        if (showDBLinkButton && (this.m_types.length != 1 || !this.m_types[0].equals("SCHEMA"))) {
            throw new IllegalStateException("DB Link button only allowed for Schema choser");
        }
        this.m_showDBLinkButton = showDBLinkButton;
    }

    public void setShowAddButton(boolean showAddButton) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowAddButton() before setProvider()");
        }
        this.m_showAddButton = showAddButton;
    }

    public void setAddButtonProcessor(NewObjectProcessor processor) {
        this.m_addObjectProcessor = processor;
    }

    public void setShowEditButton(boolean showEditButton) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowEditButton() before setProvider()");
        }
        this.m_showEditButton = showEditButton;
    }

    public final void setProvider(DBObjectProvider prov) {
        if (this.m_child != null) {
            this.m_child.setProvider(prov);
        }
        this.m_destProv = prov;
        this.setSourceProvider(prov);
        if (this.m_cmb == null) {
            if (this.m_showIcon == null) {
                this.m_showIcon = this.m_types.length > 1;
            }
            this.initialiseUI();
            this.buildMaintainID();
            this.setDelegateName();
            this.setEnabled(this.isEnabled());
            if (this.m_editable != null) {
                this.m_cmb.setEditable(this.m_editable);
            }
        }
    }

    public final void enableProviderListener(boolean enable) {
        if (this.m_destProv == null) {
            throw new IllegalStateException("Cannot call enableProviderListener() before setProvider()");
        }
        if (this.m_srcProv == null) {
            return;
        }
        this.m_srcProv.removeProviderListener(this.m_proListener);
        if (enable) {
            this.m_srcProv.addProviderListener(this.m_proListener);
        }
    }

    public final void resetCaches() {
        this.m_textToIDMap.clear();
        this.m_contextToIDListMap.clear();
        this.m_gotModel = false;
    }

    public final void setContextDBObjectID(DBObjectID id) {
        this.m_contextID = id;
        if (this.m_cmb != null) {
            this.contextChanged();
        }
    }

    public final DBObjectID getDBObjectID() {
        Object obj;
        DBObjectID id = this.m_id;
        if (this.m_cmb != null && this.m_cmb.isEditable() && this.m_cmb.getEditor() != null && (obj = this.m_cmb.getEditor().getItem()) instanceof String) {
            id = this.getIDFromString((String)obj);
        }
        return this.fixProvider(id);
    }

    public final void setDBObjectID(DBObjectID id) {
        this.updateID(id);
        if (this.m_cmb != null) {
            this.showID();
        }
    }

    public final DBObject getDBObject() {
        DBObject obj = null;
        DBObjectID id = this.getDBObjectID();
        if (id != null) {
            try {
                obj = id.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return obj;
    }

    public final void setDBObject(DBObject obj) {
        DBObjectID id = null;
        if (obj != null && (id = obj.getID()) == null) {
            id = TemporaryObjectID.createID((DBObject)obj);
        }
        this.setDBObjectID(id);
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        this.setDelegateName();
    }

    private void setDelegateName() {
        if (this.m_cmb != null) {
            this.m_cmb.setName(this.getName() + "-delegate");
        }
    }

    public String getDelegateName() {
        return this.m_cmb == null ? null : this.m_cmb.getName();
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnabledImpl(this.m_cmb, enabled);
        this.setEnabledImpl(this.m_butt, enabled);
        this.setEnabledImpl(this.m_addButton, enabled);
        this.enableEditButton();
    }

    private void setEnabledImpl(Component comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
        }
    }

    @Override
    public final boolean isEnabled() {
        if (this.m_cmb != null) {
            return this.m_cmb.isEnabled();
        }
        return this.m_enabled == null ? true : this.m_enabled;
    }

    public final void setEditable(boolean editable) {
        this.m_editable = editable;
        if (this.m_cmb != null) {
            this.m_cmb.setEditable(editable);
        }
    }

    public final boolean isEditable() {
        if (this.m_cmb != null) {
            return this.m_cmb.isEditable();
        }
        return this.m_editable == null ? false : this.m_editable;
    }

    public DBObject getOrCreateDBObject() {
        DBObject obj = this.getDBObject();
        DBObjectID id = this.getDBObjectID();
        if (obj == null && id instanceof BaseObjectID && id.getType().equals("SCHEMA")) {
            obj = new Schema(((BaseObjectID)id).getName());
        }
        return obj;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.addChangeListener(listener, false);
    }

    public final void addChangeListener(ChangeListener listener, boolean notifyKeyTyped) {
        this.removeChangeListener(listener);
        Pair pair = new Pair((Object)listener, (Object)notifyKeyTyped);
        this.m_listeners.add((Pair<ChangeListener, Boolean>)pair);
    }

    public final void removeChangeListener(ChangeListener listener) {
        Pair<ChangeListener, Boolean> pairToRemove = null;
        for (Pair<ChangeListener, Boolean> pair : this.m_listeners) {
            if (pair.getFirst() != listener) continue;
            pairToRemove = pair;
            break;
        }
        if (pairToRemove != null) {
            this.m_listeners.remove(pairToRemove);
        }
    }

    public final String[] getTypes() {
        return this.m_types;
    }

    final boolean getShowIcon() {
        return this.m_showIcon == null ? false : this.m_showIcon;
    }

    final String getNullText() {
        return this.m_nullText;
    }

    public void setFilter(DBObjectFilter filter) {
        this.m_filter = filter;
    }

    public DBObjectFilter getFilter() {
        return this.m_filter;
    }

    private DBObjectChooser getParentChooser() {
        return this.m_parent;
    }

    private DBObjectChooser getChildChooser() {
        return this.m_child;
    }

    private void updateID(DBObjectID id) {
        if (id != null && !id.equals(this.m_id, false) || id == null && this.m_id != null) {
            this.m_id = id;
            if (this.m_child != null) {
                this.m_child.setContextDBObjectID(id);
            }
            for (Pair<ChangeListener, Boolean> pair : this.m_listeners) {
                ((ChangeListener)pair.first).chooserChanged(this, this.m_id);
            }
        }
        this.enableEditButton();
    }

    private boolean supportsObjectType(String type) {
        Class clz = Metadata.getInstance().getObjectClass(type);
        if (SystemObject.class.isAssignableFrom(clz)) {
            return this.getProvider().supportsObjectType(type);
        }
        for (String owningType : Metadata.getInstance().getOwnerTypes(type)) {
            if (!this.supportsObjectType(owningType)) continue;
            return true;
        }
        return false;
    }

    private final DBObjectProvider getProvider() {
        return this.m_destProv;
    }

    private void setSourceProvider(DBObjectProvider prov) {
        this.m_srcProv = prov;
        this.resetCaches();
        if (!this.m_childObjects) {
            this.m_criteria = DBObjectCriteria.createTypeCriteria((String[])this.getTypes());
            if ("SCHEMA".equals(this.getTypes()[0]) && prov instanceof Database) {
                this.m_criteria.setUserOnly(true);
            } else {
                this.m_criteria.setUserOnly(false);
            }
        }
        if (this.getChildChooser() != null) {
            this.getChildChooser().setSourceProvider(prov);
        }
    }

    private final DBObjectProvider getSourceProvider() {
        return this.m_srcProv;
    }

    private final String getStringFromID(DBObjectID id) {
        String text;
        String string = text = id == null ? this.getNullText() : DBUtil.getDBObjectName((DBObjectID)id);
        if (id != null && ModelUtil.hasLength((String)text) && this.internaliseNames()) {
            text = this.m_destProv.getExternalName(text);
        }
        if (id instanceof BaseObjectID && ((BaseObjectID)id).getDatabaseName() != null) {
            text = text + "@" + ((BaseObjectID)id).getDatabaseName();
        }
        return text == null ? "" : text;
    }

    private Collection<SystemObject> listObjects() throws DBException {
        if (this.m_lister == null) {
            return this.getSourceProvider().listObjects(this.m_criteria);
        }
        ArrayList<SystemObject> ret = new ArrayList<SystemObject>();
        for (DBObjectLister.ObjectInfo info : this.m_lister.listObjects(this.m_listCriteria)) {
            SchemaObject obj = this.getSourceProvider().getObject(info.getType(), info.getSchema(), info.getName());
            ret.add((SystemObject)obj);
        }
        return ret;
    }

    private final DBObjectID getIDFromString(String text) {
        ReferenceID id = null;
        if (text != null && text.length() > 0) {
            if (this.getNullText() != null && text.equals(this.getNullText())) {
                return null;
            }
            if (this.internaliseNames()) {
                text = this.m_destProv.getInternalName(text);
            }
            if (this.m_textToIDMap == null || this.m_textToIDMap.size() == 0) {
                this.populateIDMap(false);
            }
            if (this.m_textToIDMap != null && this.m_textToIDMap.containsKey(text)) {
                return this.m_textToIDMap.get(text);
            }
            String type = this.m_types.length == 1 ? this.m_types[0] : "UNSPECIFIED_TYPE";
            id = new ReferenceID(type, null, text, null, null);
            String schemaName = null;
            DBObjectID parentID = this.getContextDBObjectID();
            Class clz = Metadata.getInstance().getObjectClass(this.m_types[0]);
            if (clz != null && SchemaObject.class.isAssignableFrom(clz)) {
                schemaName = this.getStringFromID(parentID);
                parentID = null;
            }
            id.setParent(parentID);
            id.setSchemaName(schemaName);
            if (this.m_id instanceof ReferenceID) {
                id.setChildObjectNames(((ReferenceID)this.m_id).getChildObjectNames());
            }
        }
        return id;
    }

    private boolean internaliseNames() {
        return !this.getTypes()[0].equals("XML SCHEMA") && !this.getTypes()[0].equals("XMLSchemaElement");
    }

    private DBObjectID getContextDBObjectID() {
        DBObject obj;
        DBObjectID ctxID = this.m_contextID;
        if (ctxID instanceof ReferenceID && (obj = this.resolveInProvider((ReferenceID)ctxID)) != null) {
            ctxID = obj.getID();
        }
        return ctxID;
    }

    private DBObject resolveInProvider(ReferenceID refID) {
        SystemObject retval = null;
        try {
            DBObject parent;
            String type = refID.getType();
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (clz != null && SystemObject.class.isAssignableFrom(clz)) {
                DBObjectCriteria crit = new DBObjectCriteria(clz, new String[0]);
                crit.setName(refID.getName());
                crit.setSchemaName(refID.getSchemaName());
                retval = this.getProvider().getObject(crit);
            } else if (clz != null && ChildDBObject.class.isAssignableFrom(clz) && refID.getParent() instanceof ReferenceID && (parent = this.resolveInProvider((ReferenceID)refID.getParent())) != null) {
                retval = parent.findOwnedObject(refID.getType(), refID.getName());
            }
        }
        catch (DBException e) {
            retval = null;
        }
        return retval;
    }

    private void setTypeSupported(boolean typeSupported) {
        this.m_typeSupported = typeSupported;
        if (this.getChildChooser() != null && !typeSupported) {
            this.getChildChooser().setTypeSupported(false);
            this.getChildChooser().setEditable(true);
            this.getChildChooser().setSourceProvider(null);
        }
    }

    private boolean isTypeSupported() {
        if (this.getChildChooser() != null && !this.getChildChooser().isTypeSupported()) {
            return false;
        }
        return this.m_typeSupported;
    }

    private final void initialiseUI() {
        if (!(this.getProvider() instanceof Database)) {
            if ("TABLESPACE".equals(this.getTypes()[0])) {
                this.m_editable = true;
            }
            boolean anySupported = false;
            for (String type : this.getTypes()) {
                if (!this.supportsObjectType(type)) continue;
                anySupported = true;
                break;
            }
            this.setTypeSupported(anySupported);
        }
        if (!this.isTypeSupported()) {
            this.m_editable = true;
        }
        if (this.m_editable == null) {
            this.m_editable = false;
        }
        this.m_cmb = new CustomJComboBox();
        this.m_cmb.setEditable(this.m_editable);
        this.add((Component)this.m_cmb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_cmb.setRenderer(this);
        this.m_cmb.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (!DBObjectChooser.this.m_gotModel && !DBObjectChooser.this.m_inMenuWillBecomeVisible) {
                    DBObjectChooser.this.updateComboModel(false);
                    JComboBox list = (JComboBox)e.getSource();
                    DBObjectChooser.this.m_inMenuWillBecomeVisible = true;
                    try {
                        list.getUI().setPopupVisible(list, true);
                    }
                    finally {
                        DBObjectChooser.this.m_inMenuWillBecomeVisible = false;
                    }
                }
                DBObjectChooser.this.m_menuVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DBObjectChooser.this.m_menuVisible = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                DBObjectChooser.this.m_menuVisible = false;
            }
        });
        if (this.getParentChooser() == null && !this.isTypeSupported()) {
            this.m_butt = new JButton();
            this.m_butt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectChooser.this.showDBPickerDialog();
                }
            });
            this.m_butt.setIcon(OracleIcons.getIcon((String)"database.png"));
            IconicButtonUI.install((AbstractButton)this.m_butt);
            this.m_butt.setToolTipText(s_selectConnHtml);
            if (ModelUtil.hasLength((String)s_selectConn)) {
                this.m_butt.setMnemonic(StringUtils.getMnemonicKeyCode((String)s_selectConn));
            }
            JLabel hiddenLabel = new JLabel();
            this.m_helper.resLabel(hiddenLabel, this.m_butt, s_selectConn, "hiddenLabel");
            hiddenLabel.setVisible(false);
            this.add((Component)hiddenLabel, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_butt, new GridBagConstraints(100, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_pickerConfig.setContext(Context.newIdeContext());
            this.m_pickerConfig.setProviderTypes("db");
            this.m_pickerConfig.setShowDetails(true);
            this.m_pickerConfig.setAllowNull(true);
            Database lastDB = null;
            if (s_lastDBRef != null) {
                lastDB = (Database)s_lastDBRef.get();
            }
            if (lastDB == null && this.getSourceProvider() instanceof Database) {
                lastDB = (Database)this.getSourceProvider();
            }
            this.m_pickerConfig.setDefaultProviderID(lastDB == null ? null : new DBObjectProviderID((DBObjectProvider)lastDB));
            if (lastDB != null) {
                this.setSourceProvider((DBObjectProvider)lastDB);
            }
        } else if (this.m_showDBLinkButton && this.getProvider().supportsObjectType("DATABASE LINK") && this.getParentChooser() == null) {
            this.m_butt = new JButton();
            this.m_butt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectChooser.this.showDBLinkDialog();
                }
            });
            this.m_butt.setIcon(OracleIcons.getIcon((String)"link.png"));
            IconicButtonUI.install((AbstractButton)this.m_butt);
            this.m_butt.setToolTipText(UIBundle.get("CHOOSER_SELECT_DBLINK_HTML"));
            if (ModelUtil.hasLength((String)UIBundle.get("CHOOSER_SELECT_DBLINK"))) {
                this.m_butt.setMnemonic(StringUtils.getMnemonicKeyCode((String)UIBundle.get("CHOOSER_SELECT_DBLINK")));
            }
            JLabel hiddenLabel = new JLabel();
            this.m_helper.resLabel(hiddenLabel, this.m_butt, UIBundle.get("CHOOSER_SELECT_DBLINK"), "hiddenLabel");
            hiddenLabel.setVisible(false);
            this.add((Component)hiddenLabel, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_butt, new GridBagConstraints(100, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        if (this.m_showAddButton && this.isTypeSupported()) {
            final String type = this.m_types[0];
            this.m_addButton = new JButton();
            this.add((Component)this.m_addButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_helper.setName(this.m_addButton, "AddButton");
            this.m_addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
            this.m_addButton.setToolTipText(UIBundle.format("IDPANEL_ADD_BUTTON_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(type)));
            IconicButtonUI.install((AbstractButton)this.m_addButton);
            this.m_addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectProvider pro = DBObjectChooser.this.getProvider();
                    Class clz = Metadata.getInstance().getObjectClass(type);
                    SystemObject so = (SystemObject)pro.getObjectFactory().newObject(clz);
                    if (DBObjectChooser.this.m_addObjectProcessor != null) {
                        DBObjectChooser.this.m_addObjectProcessor.initialise(so);
                    }
                    DBEditorConfig config = DBEditorConfig.newCreateConfig(pro, (DBObject)so);
                    config.setCommitToProvider(false);
                    DBEditorFactory fac = DBEditorFactoryRegistry.getCreateFactory(config);
                    boolean launch = true;
                    while (launch) {
                        launch = false;
                        fac.launchDialog(config);
                        if (config.getResult() != DBEditorConfig.Result.SUCCESS) continue;
                        ProviderOperator pop = new ProviderOperator(pro);
                        pop.createObjects(new SystemObject[]{so});
                        DBObjectChooser.this.setDBObject((DBObject)so);
                    }
                }
            });
        }
        if (this.m_showEditButton && this.isTypeSupported()) {
            this.m_editButton = new JButton();
            this.add((Component)this.m_editButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_helper.setName(this.m_editButton, "EditButton");
            this.m_editButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
            IconicButtonUI.install((AbstractButton)this.m_editButton);
            this.m_editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectID id = DBObjectChooser.this.getDBObjectID();
                    if (id instanceof BaseObjectID) {
                        DBEditorFactory fac;
                        DBEditorConfig config = null;
                        try {
                            config = DBEditorConfig.newEditConfig((BaseObjectID)id, false);
                        }
                        catch (DBException dbe) {
                            DBLog.getLogger((Object)this).warning(dbe.getMessage());
                        }
                        if (config != null && (fac = DBEditorFactoryRegistry.getEditFactory(config)) != null) {
                            fac.launchDialog(config);
                        }
                    }
                }
            });
        }
    }

    private void enableEditButton() {
        if (this.m_editButton != null) {
            boolean enabled;
            String tooltip = null;
            boolean bl = enabled = this.isEnabled() && this.m_id instanceof BaseObjectID && !(this.m_id instanceof ReferenceID);
            if (enabled) {
                BaseObjectID bid = (BaseObjectID)this.m_id;
                tooltip = UIBundle.format("IDPANEL_EDIT_BUTTON_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(bid.getType()), bid.getName());
            }
            this.m_editButton.setToolTipText(tooltip);
            this.m_editButton.setEnabled(enabled);
        }
    }

    private void showDBPickerDialog() {
        String name;
        DBObjectProvider pro = DBObjectProviderPicker.chooseProvider(this.m_pickerConfig, DialogUtil.getAncestorDialog((Component)this), StringUtils.stripMnemonic((String)s_selectConn), null, "f1_odbchooserconn_html");
        this.resetCaches();
        if (pro instanceof Database) {
            this.setSourceProvider(pro);
            s_lastDBRef = new WeakReference<Database>((Database)pro);
        } else {
            this.setSourceProvider(this.m_destProv);
            s_lastDBRef = null;
        }
        if (this.m_nonSchemaSystemObjects) {
            try {
                this.setDBObject((DBObject)this.m_srcProv.getDefaultSchema());
            }
            catch (DBException e) {}
        } else if (this.m_schemaObjects && this.m_parent == null && this.m_contextID != null && (name = DBUtil.getDBObjectName((DBObjectID)this.m_contextID)) != null && "SCHEMA".equals(this.m_contextID.getType())) {
            DBObjectID newContext = null;
            try {
                Schema newSchema = this.m_srcProv.getSchema(name);
                if (newSchema != null) {
                    newContext = newSchema.getID();
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            if (newContext == null) {
                newContext = TemporaryObjectID.createID((DBObject)new Schema(name));
            }
            this.setContextDBObjectID(newContext);
        }
    }

    private void showDBLinkDialog() {
        Schema defaultSchema;
        try {
            defaultSchema = this.m_destProv.getDefaultSchema();
        }
        catch (DBException dbe) {
            DBLog.getLogger((Object)this).warning(dbe.getMessage());
            return;
        }
        DefaultTraversablePanel panel = new DefaultTraversablePanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        JLabel label = new JLabel();
        final DBObjectChooser chooser = new DBObjectChooser("DATABASE LINK");
        chooser.m_isDatabaseLinkChooser = true;
        chooser.setNullText(UIBundle.get("CHOOSER_NO_DATABASE_LINK"));
        chooser.setProvider(this.m_destProv);
        chooser.setContextDBObjectID(defaultSchema.getID());
        chooser.setDBObjectID(this.m_databaseLinkID);
        this.m_helper.resLabel(label, chooser, UIBundle.get("CHOOSER_SELECT_DBLINK_LABEL"), "dblinkChooser");
        panel.add((Component)label, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 8, 0), 0, 0));
        panel.add((Component)chooser, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 8, 8, 0), 0, 0));
        panel.setHelpID("f1_dbselectdblink_html");
        Namespace data = new Namespace();
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("CHOOSER_SELECT_DBLINK_TITLE"), (Traversable)panel, data);
        JEWTDialog dialog = launcher.initDialog();
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setName("ChooserDBLinkDialog");
        dialog.setButtonMask(7);
        dialog.setPreferredSize(new Dimension(360, 120));
        VetoableChangeListener list = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    DatabaseLink link = (DatabaseLink)chooser.getDBObject();
                    String linkName = link == null ? null : link.getName();
                    DBObjectChooser.this.m_databaseLinkID = link == null ? null : link.getID();
                    DBObjectChooser.this.setContextDBObjectID(DBObjectChooser.this.m_databaseLinkID);
                    if (link == null) {
                        DBObjectChooser.this.setDBObject((DBObject)defaultSchema);
                    } else if (DBObjectChooser.this.m_destProv instanceof DatabaseLink.DefaultSchemaFinder) {
                        Schema s = ((DatabaseLink.DefaultSchemaFinder)DBObjectChooser.this.m_destProv).findDefaultSchema(link);
                        DBObjectChooser.this.setDBObjectID(s == null ? null : s.getID());
                    } else {
                        DBObjectChooser.this.setDBObjectID(null);
                    }
                    DBObjectChooser.this.m_criteria.setDatabaseName(linkName);
                }
            }
        };
        dialog.addVetoableChangeListener(list);
        boolean ok = launcher.showDialog();
    }

    private boolean isInContext(DBObjectID id) {
        boolean retval = true;
        if (this.m_contextID != null) {
            if ("SCHEMA".equals(this.m_contextID.getType())) {
                retval = ModelUtil.areEqual((Object)DBUtil.getDBObjectName((DBObjectID)this.m_contextID), (Object)DBUtil.getSchemaName((DBObjectID)id));
            } else if (id instanceof TemporaryObjectID) {
                if (this.m_contextID instanceof TemporaryObjectID) {
                    try {
                        DBObject contextObj = this.m_contextID.resolveID();
                        DBObject obj = id.resolveID();
                        retval = contextObj == obj.getParent();
                    }
                    catch (DBException dBException) {}
                } else {
                    retval = false;
                }
            } else {
                retval = !this.m_contextID.equals(id) && DBUtil.isSameOrChildOf((DBObjectID)id, (DBObjectID)this.m_contextID, (boolean)true);
            }
        }
        return retval;
    }

    private void populateIDMap(boolean forceFull) {
        String nullText;
        boolean loadsubset = !forceFull && this.subsetAvailable();
        List<DBObjectID> list = null;
        if (this.m_filter == null) {
            list = this.m_contextToIDListMap.get(this.getContextDBObjectID());
        }
        if (list == null) {
            list = this.getEntries(loadsubset);
            for (DBObjectID id : this.m_extraIDs) {
                TemporaryObjectID tempId;
                DBObjectID origId;
                if (!this.isInContext(id)) continue;
                if (id instanceof TemporaryObjectID && list.contains(origId = TemporaryObjectID.findOriginalID((TemporaryObjectID)(tempId = (TemporaryObjectID)id)))) {
                    list.remove(origId);
                }
                list.add(id);
            }
            if (!loadsubset) {
                this.m_contextToIDListMap.put(this.getContextDBObjectID(), list);
            }
        }
        if ((nullText = this.getNullText()) != null) {
            this.m_textToIDMap.put(nullText, null);
        }
        if (list != null) {
            for (DBObjectID id : list) {
                String str = this.getStringFromID(id);
                if (!ModelUtil.hasLength((String)str)) continue;
                this.m_textToIDMap.put(str, id);
            }
        }
    }

    private void updateComboModel(boolean forceFull) {
        boolean loadsubset;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        String curVal = this.getStringFromID(this.getDBObjectID());
        int setIdx = -1;
        int idx = 0;
        this.populateIDMap(forceFull);
        Collection<DBObjectID> list = this.m_textToIDMap.values();
        if (list != null) {
            ArrayList<String> keys = new ArrayList<String>();
            String nullTextToInsert = null;
            for (DBObjectID id : list) {
                if (id == null && nullTextToInsert == null) {
                    nullTextToInsert = this.getNullText();
                    continue;
                }
                String str = this.getStringFromID(id);
                if (!ModelUtil.hasLength((String)str)) continue;
                keys.add(str);
            }
            Collections.sort(keys);
            if (nullTextToInsert != null) {
                keys.add(0, nullTextToInsert);
            }
            for (String key : keys) {
                model.addElement(key);
                if (key.equals(curVal)) {
                    setIdx = idx;
                }
                ++idx;
            }
        }
        if (setIdx == -1 && this.getDBObjectID() != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (curVal.compareTo((String)model.getElementAt(i)) >= 0) continue;
                model.insertElementAt(curVal, i);
                setIdx = i;
                break;
            }
            if (setIdx == -1) {
                model.addElement(curVal);
                setIdx = idx;
            }
            this.m_textToIDMap.put(curVal, this.getDBObjectID());
            ++idx;
        }
        boolean bl = loadsubset = !forceFull && this.subsetAvailable();
        if (loadsubset) {
            this.m_subsetLoaded = true;
            model.addElement(s_getFullList);
            ++idx;
        }
        model.setSelectedItem(null);
        this.m_cmb.setModel((ComboBoxModel)model);
        this.m_cmb.setSelectedIndex(setIdx);
        this.m_gotModel = true;
        Logger logger = Logger.getLogger("oracle.abbot.test");
        if (logger != null) {
            logger.log(Level.FINE, "AbstractComboBasedChooser.updateComboModel.DONE");
        }
    }

    private boolean subsetAvailable() {
        String schemaName = this.getStringFromID(this.getContextDBObjectID());
        return this.m_schemaObjects && "SYS".equals(schemaName) && this.getTypes().length == 1 && this.getTypes()[0].equals("TYPE") && this.getSourceProvider() instanceof Database;
    }

    private void buildMaintainID() {
        if (this.m_listener == null) {
            this.m_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean done = false;
                    if (DBObjectChooser.this.m_editable != null && DBObjectChooser.this.m_editable.booleanValue()) {
                        Object o = DBObjectChooser.this.m_cmb.getEditor().getItem();
                        if (DBObjectChooser.this.m_subsetLoaded && s_getFullList.equals(o)) {
                            DBObjectChooser.this.updateComboModel(true);
                        } else if (o instanceof String) {
                            DBObjectID id = DBObjectChooser.this.getIDFromString((String)o);
                            if (!DBObjectChooser.this.m_gotModel) {
                                DBObjectChooser.this.updateComboModel(false);
                            }
                            if (id instanceof ReferenceID && DBObjectChooser.this.m_textToIDMap.get(((ReferenceID)id).getName()) != null) {
                                id = (DBObjectID)DBObjectChooser.this.m_textToIDMap.get(((ReferenceID)id).getName());
                            }
                            DBObjectChooser.this.setDBObjectID(id);
                            done = true;
                        }
                    } else {
                        Object o = DBObjectChooser.this.m_cmb.getSelectedItem();
                        if (DBObjectChooser.this.m_subsetLoaded && s_getFullList.equals(o)) {
                            DBObjectChooser.this.updateComboModel(true);
                        } else if (o instanceof String) {
                            DBObjectID id = (DBObjectID)DBObjectChooser.this.m_textToIDMap.get(o);
                            DBObjectChooser.this.updateID(id);
                            done = true;
                        }
                    }
                    if (!done) {
                        DBObjectChooser.this.updateID(null);
                    }
                }
            };
        }
        this.m_cmb.addActionListener(this.m_listener);
    }

    private void showID() {
        DBObjectID id = this.fixProvider(this.m_id);
        String text = this.getNullText();
        if (id != null) {
            String fromID = this.getStringFromID(id);
            if (ModelUtil.hasLength((String)fromID)) {
                text = fromID;
            }
        } else if (this.m_editable != null && this.m_editable.booleanValue()) {
            this.m_cmb.getEditor().setItem(text);
            return;
        }
        this.m_cmb.removeActionListener(this.m_listener);
        if (this.m_textToIDMap.containsKey(text)) {
            this.m_cmb.setSelectedItem(text);
        } else {
            this.m_gotModel = false;
            int idx = -1;
            this.m_textToIDMap.clear();
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            if (id == null && this.getNullText() != null) {
                model.addElement(this.getNullText());
                this.m_textToIDMap.put(text, id);
                idx = 0;
            } else if (id != null) {
                model.addElement(text);
                this.m_textToIDMap.put(text, id);
                idx = 0;
            }
            this.m_cmb.setModel((ComboBoxModel)model);
            this.m_cmb.setSelectedIndex(idx);
        }
        if (this.m_cmb.isEditable()) {
            this.m_cmb.getEditor().setItem(text);
        }
        this.m_cmb.addActionListener(this.m_listener);
    }

    private void contextChanged() {
        this.m_gotModel = false;
        DBObjectID id = null;
        if (this.m_editable != null && this.m_editable.booleanValue()) {
            String val = (String)this.m_cmb.getEditor().getItem();
            id = this.getIDFromString(val);
        } else {
            this.m_cmb.setModel((ComboBoxModel)new DefaultComboBoxModel());
        }
        this.setDBObjectID(id);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String type;
        String text;
        DBObjectID id;
        JLabel label = (JLabel)this.m_renDelegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof String && s_getFullList.equals(value)) {
            label.setBorder(new BevelBorder(1));
        } else if (value instanceof String && this.m_showDBLinkButton && ((String)value).startsWith("...@")) {
            label.setIcon(DBTypeDisplayRegistry.getNodeIcon("DATABASE LINK"));
        } else if (value instanceof String && this.m_srcProv instanceof Database && !(this.m_destProv instanceof Database) && this.m_types[0].equals("SCHEMA")) {
            label.setIcon(OracleIcons.getIcon((String)"database.png"));
        } else if (this.getShowIcon() && value instanceof String && (id = this.m_textToIDMap.get(text = (String)value)) != null && (type = id.getType()) != null) {
            label.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
        }
        return label;
    }

    private List<DBObjectID> getEntries(boolean loadsubset) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        if (this.getSourceProvider() != null) {
            DBObjectFilter filter = this.getFilter();
            try {
                if (this.m_nonSchemaSystemObjects) {
                    if (this.m_showDBLinkButton && this.m_id instanceof BaseObjectID) {
                        this.m_criteria.setDatabaseName(((BaseObjectID)this.m_id).getDatabaseName());
                    }
                    for (SystemObject sysOb : this.listObjects()) {
                        if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                        DBObjectID id = sysOb.getID();
                        if (id == null) {
                            id = TemporaryObjectID.createID((DBObject)sysOb);
                        }
                        retval.add(id);
                    }
                } else if (this.m_schemaObjects) {
                    if (loadsubset && this.subsetAvailable()) {
                        this.m_criteria.setSchemaName("SYS");
                        DBObjectID id = this.getContextDBObjectID();
                        DBObject obj = id.resolveID();
                        if (obj instanceof Schema) {
                            DBObjectSet sortedSet = new DBObjectSet();
                            Collection types = this.getSourceProvider().getDescriptor().listBuiltInObjects(this.m_criteria);
                            for (SystemObject dt : types) {
                                sortedSet.add(dt);
                            }
                            for (SystemObject dt : sortedSet) {
                                retval.add(dt.getID());
                            }
                        }
                    } else {
                        BaseObjectID bid;
                        DBObjectID cid = this.getContextDBObjectID();
                        String dbName = null;
                        String schemaName = null;
                        if (cid instanceof TemporaryObjectID) {
                            DBObject co = cid.resolveID();
                            if (co instanceof Schema) {
                                schemaName = co.getName();
                            }
                        } else if (cid instanceof BaseObjectID && "SCHEMA".equals((bid = (BaseObjectID)cid).getType())) {
                            dbName = bid.getDatabaseName();
                            schemaName = DBUtil.getDBObjectName((DBObjectID)bid);
                        }
                        this.m_criteria.setDatabaseName(dbName);
                        this.m_criteria.setSchemaName(schemaName);
                        for (SystemObject sysOb : this.listObjects()) {
                            if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                            DBObjectID id = sysOb.getID();
                            if (id == null) {
                                id = TemporaryObjectID.createID((DBObject)sysOb);
                            }
                            retval.add(id);
                        }
                        if (this.m_isDatabaseLinkChooser) {
                            DBObjectCriteria pubLinkCrit = DBObjectCriteria.createCriteria((String)"DATABASE LINK", (String)"PUBLIC", null);
                            for (SystemObject sysOb : this.getSourceProvider().listObjects(pubLinkCrit)) {
                                if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                                DBObjectID id = sysOb.getID();
                                if (id == null) {
                                    id = TemporaryObjectID.createID((DBObject)sysOb);
                                }
                                retval.add(id);
                            }
                        }
                    }
                } else if (this.m_childObjects && this.getContextDBObjectID() != null) {
                    DBObject contextObject = null;
                    contextObject = this.getContextDBObjectID().resolveID();
                    if (contextObject != null) {
                        for (DBObject kid : contextObject.getOwnedObjects(this.getTypes())) {
                            if (filter != null && !filter.accept(kid)) continue;
                            retval.add(kid.getID());
                        }
                    }
                }
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        return retval;
    }

    private DBObjectID fixProvider(DBObjectID id) {
        if (this.getProvider() != this.getSourceProvider() && (id instanceof NameBasedID || id instanceof IdentifierBasedID)) {
            BaseObjectID bid = (BaseObjectID)id;
            ReferenceID refId = new ReferenceID(bid.getType(), bid.getSchemaName(), bid.getName());
            refId.setParent(this.fixProvider(bid.getParent()));
            refId.setProvider(this.getProvider());
            return refId;
        }
        return id;
    }

    public Component getEditorComponent() {
        if (this.m_cmb != null) {
            return this.m_cmb.getEditor().getEditorComponent();
        }
        return null;
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmb;
    }

    public static abstract class NewObjectProcessor {
        public abstract void initialise(SystemObject var1);
    }

    private class ProviderListener
    extends DBObjectProviderListener {
        private ProviderListener() {
        }

        private void resetCachesIfApplicable(Collection<? extends DBObject> objs) {
            for (DBObject dBObject : objs) {
                if (!Arrays.asList(DBObjectChooser.this.getTypes()).contains(dBObject.getType())) continue;
                DBObjectChooser.this.resetCaches();
                break;
            }
        }

        public void objectUpdated(DBObjectChange change) {
            if (DBObjectChooser.this.m_childObjects && change.getDBObject().getID().equals(DBObjectChooser.this.m_contextID, false)) {
                this.resetCachesIfApplicable(change.getOwnedObjectsAdded());
                this.resetCachesIfApplicable(change.getOwnedObjectsRemoved());
            } else {
                this.resetCachesIfApplicable(Collections.singletonList(change.getDBObject()));
            }
        }

        public void systemObjectsAdded(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
            this.resetCachesIfApplicable(objs);
        }

        public void schemaObjectsRemoved(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
            this.resetCachesIfApplicable(objs);
        }

        public void schemaObjectsAdded(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
            this.resetCachesIfApplicable(objs);
        }

        public void systemObjectsRemoved(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
            this.resetCachesIfApplicable(objs);
        }
    }

    private class CustomJTextField
    extends JTextField {
        public CustomJTextField() {
            super("", 9);
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CustomJTextField.this.notifyListeners();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CustomJTextField.this.notifyListeners();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CustomJTextField.this.notifyListeners();
                }
            });
        }

        private void notifyListeners() {
            if (DBObjectChooser.this.m_listeners.size() > 0) {
                DBObjectID id = DBObjectChooser.this.getIDFromString(this.getText());
                for (Pair pair : DBObjectChooser.this.m_listeners) {
                    if (!((Boolean)pair.second).booleanValue()) continue;
                    ((ChangeListener)pair.first).chooserChanged(DBObjectChooser.this.m_theChooser, id);
                }
            }
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (!DBObjectChooser.this.m_menuVisible) {
                super.processFocusEvent(e);
            }
        }
    }

    private class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private CustomComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            return new CustomJTextField();
        }
    }

    private class CustomJComboBox
    extends JComboBox {
        private boolean m_settingModel = false;

        public CustomJComboBox() {
            this.setEditor(new CustomComboBoxEditor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setModel(ComboBoxModel model) {
            try {
                this.m_settingModel = true;
                super.setModel(model);
            }
            finally {
                this.m_settingModel = false;
            }
        }

        @Override
        public void revalidate() {
            if (!this.m_settingModel) {
                super.revalidate();
            }
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (!DBObjectChooser.this.m_menuVisible) {
                super.processFocusEvent(e);
            }
        }
    }

    public static interface ChangeListener {
        public void chooserChanged(DBObjectChooser var1, DBObjectID var2);
    }
}

