/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.controls.MultiProviderPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectProviderPicker {
    private Collection<PickerListener> m_pickerListeners;

    public abstract Component getComponent();

    public final void setProvider(DBObjectProvider provider) {
        if (provider == null) {
            this.setProvider(null, null);
        } else {
            this.setProvider(provider.getProviderType(), provider.getProviderIdentifier());
        }
    }

    public void setRelatedPicker(DBObjectProviderPicker other) {
    }

    public abstract void setProvider(String var1, Object var2);

    public DBObjectProvider getProvider() throws DBException {
        DBObjectProvider retval = null;
        DBObjectProviderID id = this.getProviderID();
        if (id != null) {
            retval = id.resolveID();
        }
        return retval;
    }

    public abstract DBObjectProviderID getProviderID();

    public boolean hasDBObjectProvider() {
        DBObjectProviderID id = this.getProviderID();
        return id != null && id.isValid();
    }

    protected String getDefaultProviderType(PickerConfiguration config) {
        DBObjectProviderID defProvID = config.getDefaultProviderID();
        String retval = defProvID == null ? null : defProvID.getType();
        return retval;
    }

    protected abstract boolean isAvailable(PickerConfiguration var1);

    protected abstract void init(PickerConfiguration var1);

    protected abstract void addImplementationListener();

    protected abstract void removeImplementationListener();

    public final void addPickerListener(PickerListener pickerListener) {
        if (pickerListener != null) {
            if (this.m_pickerListeners == null) {
                this.m_pickerListeners = new HashSet<PickerListener>();
                this.addImplementationListener();
            }
            this.m_pickerListeners.add(pickerListener);
        }
    }

    public final void removePickerListener(PickerListener pickerListener) {
        if (pickerListener != null && this.m_pickerListeners != null) {
            this.m_pickerListeners.remove(pickerListener);
            if (this.m_pickerListeners.isEmpty()) {
                this.m_pickerListeners = null;
                this.removeImplementationListener();
            }
        }
    }

    protected final void firePickerChanged(DBObjectProviderID providerID) {
        if (this.m_pickerListeners != null) {
            for (PickerListener pickerListener : this.m_pickerListeners) {
                try {
                    pickerListener.providerChanged(providerID);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "PickerListener failed", e);
                }
            }
        }
    }

    public static DBObjectProviderPicker getPicker(PickerConfiguration config) {
        DBObjectProviderPicker retval = null;
        DatabaseUIExtensionHook hook = DatabaseUIExtensionHook.getHook();
        Collection<DatabaseUIExtensionHook.ProviderPickerHash> pphash = hook.getDBObjectProviderPickers();
        ArrayList<DatabaseUIExtensionHook.ProviderPickerHash> viableTypes = new ArrayList<DatabaseUIExtensionHook.ProviderPickerHash>();
        List<String> requestedTypes = config.getProviderTypes() == null ? null : Arrays.asList(config.getProviderTypes());
        for (DatabaseUIExtensionHook.ProviderPickerHash pp : pphash) {
            DBObjectProviderPicker picker;
            String providerType = pp.getProviderType();
            if (requestedTypes != null && !requestedTypes.isEmpty() && !requestedTypes.contains(providerType) || (picker = pp.getProviderPicker()) == null || !picker.isAvailable(config)) continue;
            viableTypes.add(pp);
        }
        if (viableTypes.size() == 0) {
            DBLog.getLogger(DBObjectProviderPicker.class).log(Level.SEVERE, "No DBObjectProviderPicker found");
        } else {
            retval = viableTypes.size() == 1 ? ((DatabaseUIExtensionHook.ProviderPickerHash)((Object)viableTypes.get(0))).getProviderPicker() : new MultiProviderPicker(viableTypes);
        }
        if (retval != null) {
            retval.init(config);
            retval.addPickerListener(config.getPickerListener());
            DBObjectProviderID defaultPro = config.getDefaultProviderID();
            if (defaultPro != null && defaultPro.isValid()) {
                retval.setProvider(defaultPro.getType(), defaultPro.getIdentifier());
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectProvider chooseProvider(PickerConfiguration config, Component parent, String title, String prompt, String helpID) {
        final Holder retval = new Holder();
        final DBObjectProviderPicker picker = DBObjectProviderPicker.getPicker(config);
        if (picker != null) {
            JPanel panel = new JPanel();
            panel.setName("DBObjectProviderPickerPanel");
            HelpUtils.setHelpID((JComponent)panel, (String)helpID);
            panel.setLayout(new BorderLayout(0, 15));
            if (ModelUtil.hasLength((String)prompt)) {
                JWrappedLabel label = new JWrappedLabel(prompt);
                panel.add((Component)label, "North");
            }
            panel.add(picker.getComponent(), "Center");
            panel.add(Box.createHorizontalStrut(400), "South");
            int buttonMask = 3;
            if (helpID != null) {
                buttonMask |= 4;
            }
            final JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)title, (int)buttonMask);
            dialog.setName("DBObjectProviderPickerDialog");
            dialog.setContent((Component)panel);
            dialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        try {
                            DBObjectProvider pro = picker.getProvider();
                            retval.set((Object)pro);
                        }
                        catch (DBException dbe) {
                            DBExceptionDialog.showErrorDialog((Component)dialog, null, dbe);
                            throw new PropertyVetoException(dbe.getMessage(), evt);
                        }
                    }
                }
            });
            try {
                dialog.runDialog();
            }
            finally {
                dialog.dispose();
            }
        }
        return (DBObjectProvider)retval.get();
    }

    public static class PickerConfiguration {
        private Context m_context;
        private boolean m_forceGlobal;
        private boolean m_showDetails;
        private boolean m_onlyShowProjectDependencies;
        private boolean m_allowCreateProject;
        private boolean m_allowCreate = true;
        private boolean m_allowNull;
        private boolean m_controlEnable;
        private ActionListener m_controlEnableListener;
        private String m_label;
        private String[] m_providerTypes;
        private Map<String, Boolean> m_canBeGlobalProvider;
        private DBObjectProviderID m_defaultProviderID;
        private PickerListener m_pickerListener;
        private DBObjectProvider m_otherProvider;

        public Context getContext() {
            return this.m_context;
        }

        public void setContext(Context context) {
            this.m_context = context;
        }

        public boolean getForceGlobal() {
            return this.m_forceGlobal;
        }

        public boolean canBeGlobal(String providerType) {
            boolean retval = this.m_forceGlobal;
            if (!retval && this.m_canBeGlobalProvider != null) {
                retval = Boolean.TRUE.equals(this.m_canBeGlobalProvider.get(providerType));
            }
            return retval;
        }

        public void setForceGlobal(boolean val) {
            this.m_forceGlobal = val;
        }

        public boolean getShowDetails() {
            return this.m_showDetails;
        }

        public void setShowDetails(boolean val) {
            this.m_showDetails = val;
        }

        public void setAllowCreateProject(boolean val) {
            this.m_allowCreateProject = val;
        }

        public boolean getAllowCreateProject() {
            return this.m_allowCreateProject;
        }

        public void setOnlyShowProjectDependencies(boolean val) {
            this.m_onlyShowProjectDependencies = val;
        }

        public boolean getOnlyShowProjectDependencies() {
            return this.m_onlyShowProjectDependencies;
        }

        public boolean getAllowCreate() {
            return this.m_allowCreate;
        }

        public void setAllowCreate(boolean val) {
            this.m_allowCreate = val;
        }

        public boolean getControlEnable() {
            return this.m_controlEnable;
        }

        public void setControlEnable(boolean val) {
            this.m_controlEnable = val;
        }

        public boolean getAllowNull() {
            return this.m_allowNull;
        }

        public void setAllowNull(boolean val) {
            this.m_allowNull = val;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public String[] getProviderTypes() {
            return this.m_providerTypes;
        }

        public void setProviderTypes(String ... providerTypes) {
            this.m_providerTypes = providerTypes;
        }

        public void setCanBeGlobal(String providerType, boolean value) {
            if (this.m_canBeGlobalProvider == null) {
                this.m_canBeGlobalProvider = new HashMap<String, Boolean>();
            }
            this.m_canBeGlobalProvider.put(providerType, value);
        }

        public DBObjectProviderID getDefaultProviderID() {
            return this.m_defaultProviderID;
        }

        public void setDefaultProviderID(DBObjectProviderID defaultProviderID) {
            this.m_defaultProviderID = defaultProviderID;
        }

        public void setControlEnableListener(ActionListener controlEnableListener) {
            this.m_controlEnableListener = controlEnableListener;
        }

        public ActionListener getControlEnableListener() {
            return this.m_controlEnableListener;
        }

        public PickerListener getPickerListener() {
            return this.m_pickerListener;
        }

        public void setPickerListener(PickerListener pickerListener) {
            this.m_pickerListener = pickerListener;
        }

        public DBObjectProvider getOtherProvider() {
            return this.m_otherProvider;
        }

        public void setOtherProvider(DBObjectProvider otherProvider) {
            this.m_otherProvider = otherProvider;
        }
    }

    public static interface PickerListener {
        public void providerChanged(DBObjectProviderID var1);
    }
}

