/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public final class ListButtons {
    private static final String ADD = "ButtonAdd";
    private static final String REMOVE = "ButtonRemove";
    private static final String TOP = "ButtonTop";
    private static final String UP = "ButtonUp";
    private static final String DOWN = "ButtonDown";
    private static final String BOTTOM = "ButtonBottom";
    private final SelectableComponent m_selectableComponent;
    private final Controller m_controller;
    private final Map<String, AbstractButton> m_toolButtons = new LinkedHashMap<String, AbstractButton>();
    private JPanel m_panel;
    private JLabel m_listLabel;
    private JScrollPane m_listScrollPane;
    private ControlBar m_toolbar;
    private ComponentWithTitlebar m_compTitleBar;
    private AbstractButton m_addButton;
    private AbstractButton m_removeButton;
    private JPanel m_sidePanel;
    private int m_buttonIndex = 0;
    private JButton m_upButton;
    private JButton m_downButton;
    private JButton m_topButton;
    private JButton m_bottomButton;

    public ListButtons(JList list, Controller controller) {
        this(SelectableComponent.createSelectableComponent(list), controller);
    }

    public ListButtons(JTree tree, Controller controller) {
        this(SelectableComponent.createSelectableComponent(tree), controller);
    }

    public ListButtons(SelectableComponent sc, Controller controller) {
        if (sc == null) {
            throw new IllegalArgumentException("SelectableComponent must not be null");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Controller must not be null");
        }
        this.m_controller = controller;
        this.m_controller.m_selectableComponent = sc;
        this.m_selectableComponent = sc;
        this.m_selectableComponent.addSelectionListener(new SelectableComponent.SelectionListener(){

            @Override
            public void valueChanged(SelectableComponent.SelectionEvent event) {
                if (ListButtons.this.m_panel != null && ListButtons.this.m_panel.isEnabled()) {
                    ListButtons.this.enableButtons();
                }
            }
        });
    }

    public JLabel getLabel() {
        return this.m_compTitleBar == null ? null : this.m_compTitleBar.getLabel();
    }

    public JComponent getComponent() {
        if (this.m_panel == null) {
            ComponentWithTitlebar compToAdd;
            this.m_toolbar = new ControlBar();
            this.m_panel = new JPanel();
            this.m_panel.setLayout(new GridBagLayout());
            if (this.m_controller.includeAddRemoveButtons()) {
                if (this.m_addButton == null) {
                    String atttext = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_ADD") : this.m_controller.getAddTooltipText();
                    this.m_addButton = this.createButton(OracleIcons.getIcon((String)"add.png"), atttext, ADD);
                }
                if (this.m_removeButton == null) {
                    String rtttext = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_REMOVE") : this.m_controller.getRemoveTooltipText();
                    this.m_removeButton = this.createButton(OracleIcons.getIcon((String)"delete.png"), rtttext, REMOVE);
                    this.m_removeButton.setEnabled(false);
                }
                this.m_toolbar.add((Component)this.m_addButton);
                this.m_toolbar.add((Component)this.m_removeButton);
            } else {
                this.m_addButton = null;
                this.m_removeButton = null;
            }
            for (AbstractButton customButton : this.m_toolButtons.values()) {
                this.m_toolbar.add((Component)customButton);
            }
            if (this.m_controller.includeReorderButtons()) {
                String ttttext = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_TOP") : this.m_controller.getTopTooltipText();
                this.m_topButton = this.createButton(OracleIcons.getIcon((String)"first.png"), ttttext, TOP);
                String utttext = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_UP") : this.m_controller.getUpTooltipText();
                this.m_upButton = this.createButton(OracleIcons.getIcon((String)"previous.png"), utttext, UP);
                String dtttext = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_DOWN") : this.m_controller.getDownTooltipText();
                this.m_downButton = this.createButton(OracleIcons.getIcon((String)"next.png"), dtttext, DOWN);
                String btttext = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_BOTTOM") : this.m_controller.getBottomTooltipText();
                this.m_bottomButton = this.createButton(OracleIcons.getIcon((String)"last.png"), btttext, BOTTOM);
                this.m_sidePanel = new JPanel();
                this.m_sidePanel.setLayout(new GridBagLayout());
                this.addSideButton(this.m_sidePanel, this.m_topButton);
                this.addSideButton(this.m_sidePanel, this.m_upButton);
                this.addSideButton(this.m_sidePanel, this.m_downButton);
                this.addSideButton(this.m_sidePanel, this.m_bottomButton);
                this.m_panel.add((Component)this.m_sidePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 0, 0), 0, 0));
            } else {
                this.m_sidePanel = null;
                this.m_topButton = null;
                this.m_upButton = null;
                this.m_downButton = null;
                this.m_bottomButton = null;
            }
            Object selComp = this.m_selectableComponent.getComponent();
            String label = this.m_controller.getListLabel();
            if (label == null) {
                this.m_listLabel = null;
            } else {
                this.m_listLabel = new JLabel();
                ResourceUtils.resLabel((JLabel)this.m_listLabel, selComp, (String)label);
            }
            this.m_listScrollPane = new JScrollPane((Component)selComp);
            this.m_compTitleBar = new ComponentWithTitlebar((JComponent)this.m_listScrollPane, this.m_listLabel, this.m_toolbar);
            if (this.m_controller.useResizeComponent()) {
                ResizeComponent resizeComp = new ResizeComponent((JComponent)this.m_compTitleBar);
                Dimension size = new Dimension(100, 300);
                resizeComp.setMinimumSize(size);
                resizeComp.setPreferredSize(size);
                compToAdd = resizeComp;
            } else {
                compToAdd = this.m_compTitleBar;
            }
            this.m_panel.add((Component)compToAdd, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.m_panel.add(Box.createHorizontalStrut(160), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_panel.add(Box.createVerticalStrut(60), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.m_panel;
    }

    public SelectableComponent getSelectableComponent() {
        return this.m_selectableComponent;
    }

    private void addSideButton(JPanel sidePanel, JButton button) {
        IconicButtonUI.install((AbstractButton)button);
        int gapAbove = this.m_buttonIndex > 0 ? 5 : 0;
        sidePanel.add((Component)button, new GridBagConstraints(0, this.m_buttonIndex++, 1, 1, 0.0, 0.0, 11, 0, new Insets(gapAbove, 0, 0, 0), 0, 0));
    }

    public void setAddButton(AbstractButton button) {
        if (this.m_addButton != null) {
            throw new IllegalStateException("Cannot set button more than once, or after layout");
        }
        this.m_addButton = button;
    }

    public void setRemoveButton(AbstractButton button) {
        if (this.m_removeButton != null) {
            throw new IllegalStateException("Cannot set button more than once, or after layout");
        }
        this.m_removeButton = button;
    }

    public final void addCustomButton(Icon icon, String text, String buttonName) {
        JButton button = this.createButton(icon, text, buttonName);
        this.m_toolButtons.put(buttonName, button);
        if (this.m_toolbar != null) {
            this.m_toolbar.add((Component)button);
        }
    }

    public void enableButtons() {
        boolean addEnabled;
        boolean downEnabled;
        boolean upEnabled;
        boolean removeEnabled;
        block9: {
            int[] selection;
            block10: {
                removeEnabled = false;
                upEnabled = false;
                downEnabled = false;
                boolean bottomEnabled = false;
                boolean topEnabled = false;
                addEnabled = true;
                selection = this.m_selectableComponent.getSelectedIndices();
                if (selection == null) break block9;
                if (selection.length != 1) break block10;
                int sel = selection[0];
                Object val = this.m_selectableComponent.get(sel);
                if (val == null) break block9;
                boolean bl = removeEnabled = this.m_controller == null || this.m_controller.canRemove() && this.m_controller.canRemove(val);
                if (this.m_controller != null && !this.m_controller.canReorder()) break block9;
                if (this.m_controller == null || this.m_controller.canMoveUp(val)) {
                    int previous = this.m_selectableComponent.getPreviousIndex(sel);
                    int first = this.m_selectableComponent.getFirstIndex(sel);
                    upEnabled = previous >= 0;
                    boolean bl2 = topEnabled = first >= 0;
                }
                if (this.m_controller != null && !this.m_controller.canMoveDown(val)) break block9;
                int next = this.m_selectableComponent.getNextIndex(sel);
                int last = this.m_selectableComponent.getLastIndex(sel);
                downEnabled = next > 0;
                bottomEnabled = last > 0;
                break block9;
            }
            if (selection.length > 1) {
                removeEnabled = true;
                if (this.m_controller != null && this.m_controller.canRemove()) {
                    for (int i = 0; removeEnabled && i < selection.length; ++i) {
                        Object rem = this.m_selectableComponent.get(selection[i]);
                        removeEnabled = this.m_controller.canRemove(rem);
                    }
                }
            }
        }
        if (this.m_controller != null) {
            Integer max = this.m_controller.getMaxListSize();
            boolean bl = addEnabled = this.m_controller.canAdd() && (max == null || max > this.m_selectableComponent.size());
        }
        if (this.m_upButton != null) {
            this.m_topButton.setEnabled(upEnabled);
            this.m_upButton.setEnabled(upEnabled);
            this.m_downButton.setEnabled(downEnabled);
            this.m_bottomButton.setEnabled(downEnabled);
        }
        if (this.m_addButton != null) {
            this.m_addButton.setEnabled(addEnabled);
            this.m_removeButton.setEnabled(removeEnabled);
        }
        if (this.m_controller != null) {
            for (Map.Entry<String, AbstractButton> entry : this.m_toolButtons.entrySet()) {
                String command = entry.getKey();
                entry.getValue().setEnabled(this.m_controller.isButtonEnabled(command));
            }
        }
    }

    private Object swap(int i1, int i2) {
        Object retval = this.m_selectableComponent.get(i1);
        if (!this.m_selectableComponent.swap(i1, i2)) {
            retval = null;
        }
        return retval;
    }

    private JButton createButton(Icon icon, String text, final String command) {
        String baseName;
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListButtons.this.handleButton(command);
            }
        };
        action.putValue("SmallIcon", icon);
        action.putValue("ShortDescription", text);
        JButton button = new JButton(action);
        String string = baseName = this.m_controller == null ? "ListButtons" : this.m_controller.getBaseName();
        if (!baseName.endsWith(".")) {
            baseName = baseName + ".";
        }
        button.setName(baseName + command);
        return button;
    }

    private void handleButton(String command) {
        if (this.m_controller != null) {
            if (ModelUtil.areEqual((Object)command, (Object)ADD)) {
                this.m_controller.addToList();
            } else if (ModelUtil.areEqual((Object)command, (Object)REMOVE)) {
                this.m_controller.removeFromList();
                if (this.m_selectableComponent.size() > 0) {
                    this.m_removeButton.requestFocusInWindow();
                } else if (this.m_addButton != null) {
                    this.m_addButton.requestFocusInWindow();
                }
            } else if (ModelUtil.areEqual((Object)command, (Object)UP)) {
                int sel = this.m_selectableComponent.getSelectedIndex();
                if (sel > 0) {
                    Object obj = this.m_selectableComponent.get(sel);
                    if (this.m_selectableComponent.moveUp(sel)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(obj));
                        this.m_controller.objectMovedUp(obj);
                    }
                }
            } else if (ModelUtil.areEqual((Object)command, (Object)DOWN)) {
                int sel = this.m_selectableComponent.getSelectedIndex();
                if (sel < this.m_selectableComponent.size() - 1) {
                    Object obj = this.m_selectableComponent.get(sel);
                    if (this.m_selectableComponent.moveDown(sel)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(obj));
                        this.m_controller.objectMovedDown(obj);
                    }
                }
            } else if (ModelUtil.areEqual((Object)command, (Object)TOP)) {
                int sel = this.m_selectableComponent.getSelectedIndex();
                if (sel > 0) {
                    Object obj = this.m_selectableComponent.get(sel);
                    this.m_selectableComponent.setSelectedIndices(new int[0]);
                    if (this.m_selectableComponent.moveFirst(sel)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(obj));
                        this.m_controller.objectMovedUp(obj);
                    }
                }
            } else if (ModelUtil.areEqual((Object)command, (Object)BOTTOM)) {
                int sel = this.m_selectableComponent.getSelectedIndex();
                if (sel < this.m_selectableComponent.size() - 1) {
                    this.m_selectableComponent.setSelectedIndices(new int[0]);
                    Object obj = this.m_selectableComponent.get(sel);
                    if (this.m_selectableComponent.moveLast(sel)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(obj));
                        this.m_controller.objectMovedDown(obj);
                    }
                }
            } else {
                this.m_controller.customButtonPressed(command);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.m_panel.setEnabled(enabled);
        if (this.m_listLabel != null) {
            this.m_listLabel.setEnabled(enabled);
        }
        if (enabled) {
            this.enableButtons();
        } else {
            for (AbstractButton button : this.m_toolButtons.values()) {
                button.setEnabled(false);
            }
            if (this.m_addButton != null) {
                this.m_addButton.setEnabled(false);
            }
            if (this.m_removeButton != null) {
                this.m_removeButton.setEnabled(false);
            }
            if (this.m_topButton != null) {
                this.m_topButton.setEnabled(false);
                this.m_bottomButton.setEnabled(false);
                this.m_upButton.setEnabled(false);
                this.m_downButton.setEnabled(false);
            }
        }
    }

    @Deprecated
    public static abstract class HelperAdapter
    extends Controller
    implements Helper {
    }

    @Deprecated
    public static interface Helper {
        public boolean includeAddRemoveButtons();

        public boolean includeReorderButtons();

        public boolean canRemove();

        public boolean canRemove(Object var1);

        public boolean canAdd();

        public boolean canReorder();

        public boolean canMoveUp(Object var1);

        public boolean canMoveDown(Object var1);

        public String getUpTooltipText();

        public String getDownTooltipText();

        public String getAddTooltipText();

        public String getRemoveTooltipText();

        public void addToList();

        public void removeFromList();

        public void objectMovedUp(Object var1);

        public void objectMovedDown(Object var1);
    }

    public static abstract class Controller {
        private SelectableComponent m_selectableComponent;

        protected final SelectableComponent getSelectableComponent() {
            return this.m_selectableComponent;
        }

        public abstract void addToList();

        public void removeFromList() {
            SelectableComponent sc = this.getSelectableComponent();
            int[] selection = sc.getSelectedIndices();
            if (selection != null && selection.length > 0) {
                Arrays.sort(selection);
                for (int i = selection.length - 1; i >= 0; --i) {
                    int index = selection[i];
                    sc.remove(index);
                }
                int last = selection[selection.length - 1] - selection.length + 1;
                int size = sc.size();
                if (last < 0 || last >= size) {
                    last = size - 1;
                }
                if (last >= 0) {
                    sc.setSelectedIndices(last);
                }
            }
        }

        public String getBaseName() {
            return "ListButtons";
        }

        public String getListLabel() {
            return null;
        }

        public boolean useResizeComponent() {
            return false;
        }

        public void customButtonPressed(String buttonName) {
            DBLog.getLogger((Object)this).warning("Unhandled button " + buttonName);
        }

        public boolean isButtonEnabled(String buttonName) {
            return true;
        }

        public boolean includeAddRemoveButtons() {
            return true;
        }

        public boolean includeReorderButtons() {
            return true;
        }

        public boolean canRemove(Object val) {
            return true;
        }

        public boolean canRemove() {
            return true;
        }

        public boolean canAdd() {
            return true;
        }

        public Integer getMaxListSize() {
            return null;
        }

        public boolean canMoveUp(Object val) {
            return true;
        }

        public boolean canMoveDown(Object val) {
            return true;
        }

        public boolean canReorder() {
            return true;
        }

        public String getAddTooltipText() {
            return UIBundle.get("LIST_BUTTONS_ADD");
        }

        public String getRemoveTooltipText() {
            return UIBundle.get("LIST_BUTTONS_REMOVE");
        }

        public String getUpTooltipText() {
            return UIBundle.get("LIST_BUTTONS_UP");
        }

        public String getDownTooltipText() {
            return UIBundle.get("LIST_BUTTONS_DOWN");
        }

        public String getTopTooltipText() {
            return UIBundle.get("LIST_BUTTONS_TOP");
        }

        public String getBottomTooltipText() {
            return UIBundle.get("LIST_BUTTONS_BOTTOM");
        }

        public void objectMovedUp(Object obj) {
        }

        public void objectMovedDown(Object obj) {
        }
    }
}

