/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public class NameAndSchemaAdvancedEditor<T extends SchemaObject>
extends NameAndSchemaEditor<T> {
    protected static final String SIMPLE = "Simple";
    private JCheckBox m_advanced;
    private boolean m_enteredOnce = false;
    private PanelLibrary m_panels;

    @Override
    protected void layoutComponents(DBUILayoutHelper layout) {
        block5: {
            this.m_panels = (PanelLibrary)this.getDataContext().find(PanelLibrary.class);
            super.layoutComponents(layout);
            if (!this.isInFlatEditor() && !this.isEditing() && ModelUtil.hasNonNullElement((Object[])this.getSimpleNavigables())) {
                this.m_advanced = new JCheckBox();
                this.m_advanced.setSelected(false);
                this.getComponentFactory().getResourceHelper().resButton(this.m_advanced, UIBundle.get("TABLE_INFO_ADVANCED"), "Advanced");
                layout.add(this.m_advanced);
                layout.getConstraints((Component)this.m_advanced).gridy = 0;
                this.m_advanced.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NameAndSchemaAdvancedEditor.this.advancedChange();
                    }
                });
                if (this.getAdvancedPreference()) {
                    this.m_advanced.setSelected(true);
                } else {
                    this.m_advanced.setSelected(false);
                    try {
                        this.showSimplePanel();
                    }
                    catch (TraversalException te) {
                        DBLog.getLogger().log(Level.WARNING, "traversal exception on init", te);
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError((Object)te.getMessage());
                    }
                }
            }
        }
    }

    protected void showSimplePanel() throws TraversalException {
        this.changePanels(this.getSimpleNavigables());
    }

    protected final Navigable[] getSimpleNavigables() {
        List<Navigable> navs = this.getPanelLibrary().getSimpleNavigables();
        return navs == null ? new Navigable[]{} : navs.toArray(new Navigable[navs.size()]);
    }

    protected void showAdvancedPanel() throws TraversalException {
        this.changePanels(null);
    }

    protected boolean isAdvancedLayout() {
        return this.m_advanced != null && this.m_advanced.isSelected();
    }

    protected PanelLibrary getPanelLibrary() {
        if (this.m_panels == null) {
            throw new IllegalStateException("can't get panel library until onEntry has been called");
        }
        return this.m_panels;
    }

    private void advancedChange() {
        if (this.m_advanced.isSelected()) {
            try {
                this.showAdvancedPanel();
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)((Object)this));
                this.m_advanced.setSelected(false);
            }
        } else {
            try {
                this.showSimplePanel();
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)((Object)this));
                this.m_advanced.setSelected(true);
            }
        }
    }

    private boolean getAdvancedPreference() {
        DatabaseIdePreferences prefs = DatabaseIdePreferences.getPreferences();
        if (prefs != null) {
            return prefs.isAdvancedView(this.getPanelLibrary().getType());
        }
        return false;
    }

    @Override
    public void validatePanelChange(TraversableContext data) throws TraversalException {
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        DatabaseIdePreferences prefs = DatabaseIdePreferences.getPreferences();
        if (prefs != null && this.m_advanced != null) {
            prefs.setAdvancedView(this.getPanelLibrary().getType(), this.m_advanced.isSelected());
        }
    }
}

