/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.NameEditor;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.Metadata;

public class NameAndSchemaEditor<T extends SchemaObject>
extends NameEditor<T> {
    private JCheckBox m_chkPlsqlLowerCase;
    private Schema m_lastSchema;
    private Schema m_lastNotPublicSchema;
    private Schema m_publicSchema;

    @Override
    protected void layoutComponents(DBUILayoutHelper layout) {
        if (this.getProvider().getPropertyManager().supportsProperty(this.getEditorConfig().getObjectType(), "public")) {
            ComponentWrapper publicWrapper = this.getOrCreateWrapper("public");
            publicWrapper.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    NameAndSchemaEditor.this.setSchema(evt.getNewValue(), true);
                }
            });
            this.getComponentFactory().getResourceHelper().setName((Component)publicWrapper.getActiveComponent(), "Public");
            layout.add(publicWrapper);
            layout.nextRow();
        }
        ComponentWrapper schemaWrapper = this.getOrCreateWrapper("schema");
        schemaWrapper.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NameAndSchemaEditor.this.checkSchema((Schema)evt.getNewValue());
            }
        });
        this.getComponentFactory().getResourceHelper().setName((Component)schemaWrapper.getActiveComponent(), "Schema");
        layout.add(schemaWrapper.getLabel());
        layout.add(schemaWrapper.getComponent(), 1, 1, true, false);
        layout.nextRow();
        super.layoutComponents(layout);
        if (!this.isInFlatEditor() && this.getUpdatedObject() instanceof PlSqlSourceObject) {
            layout.nextRow();
            this.m_chkPlsqlLowerCase = new JCheckBox();
            this.getComponentFactory().getResourceHelper().resButton(this.m_chkPlsqlLowerCase, UIBundle.get("LABEL_LOWERCASE"), "PlSqlLowercase");
            layout.add(this.m_chkPlsqlLowerCase, 2, 1, false, false);
        }
    }

    private void setLastSchema(Schema lastSchema) {
        if (lastSchema != null) {
            this.m_lastSchema = lastSchema;
            if (!DBUtil.areNamesAndTypesEqual((DBObject)lastSchema, (DBObject)this.getPublicSchema())) {
                this.m_lastNotPublicSchema = lastSchema;
            }
        }
    }

    private void checkSchema(Schema newSchema) {
        SchemaObject obj = (SchemaObject)this.getUpdatedObject();
        if (newSchema != null && !DBUtil.areNamesAndTypesEqual((DBObject)this.m_lastSchema, (DBObject)newSchema) && !this.isEditing() && obj.getName().equals(this.getInitialName())) {
            String newName = this.getUniqueNameWithinSchema(newSchema);
            obj.setName(newName);
            ((JTextField)this.getOrCreateWrapper("name").getActiveComponent()).setText(newName);
            this.setInitialName(newName);
            this.setLastSchema(newSchema);
        }
    }

    private String getUniqueNameWithinSchema(Schema schema) {
        Class clz = Metadata.getInstance().getObjectClass(((SchemaObject)this.getUpdatedObject()).getType());
        DBObject retval = null;
        if (SchemaObject.class.isAssignableFrom(clz)) {
            retval = this.getProvider().getObjectFactory().newObject(clz, (DBObject)schema);
        }
        return retval == null ? null : retval.getName();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.setLastSchema(((SchemaObject)this.getUpdatedObject()).getSchema());
        if (this.m_chkPlsqlLowerCase != null) {
            this.m_chkPlsqlLowerCase.setSelected(GlobalSettings.getInstance().isNewPlSqlLowerCase());
            this.m_chkPlsqlLowerCase.setEnabled(this.isEditable());
        }
    }

    private void setSchema(Object isPublicModel, boolean changeModel) {
        Schema newSchema;
        boolean isPublic = Boolean.TRUE.equals(isPublicModel);
        ComponentWrapper schemaWrapper = this.getOrCreateWrapper("schema");
        Schema schema = newSchema = isPublic ? this.getPublicSchema() : this.m_lastNotPublicSchema;
        if (newSchema == null) {
            try {
                newSchema = this.getProvider().getDefaultSchema();
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
            }
        }
        if (changeModel) {
            ((SchemaObject)this.getUpdatedObject()).setSchema(newSchema);
        }
        schemaWrapper.setPropertyValue(newSchema);
        this.checkSchema(newSchema);
        this.setLastSchema(newSchema);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.m_chkPlsqlLowerCase != null) {
            GlobalSettings.getInstance().setNewPlSqlLowerCase(this.m_chkPlsqlLowerCase.isSelected());
        }
    }

    private Schema getPublicSchema() {
        if (this.m_publicSchema == null) {
            try {
                this.m_publicSchema = this.getProvider().getSchema(this.getPublicSchemaName());
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Error finding PUBLIC schema" + dbe.getMessage());
            }
            if (this.m_publicSchema == null) {
                this.m_publicSchema = new Schema(this.getPublicSchemaName());
            }
        }
        return this.m_publicSchema;
    }

    private String getPublicSchemaName() {
        return this.getProvider().getDescriptor().getPublicSchemaName();
    }
}

