/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.javatools.db.DBLog;

public abstract class SelectableComponent<T extends Component> {
    private final T m_component;
    private Collection<SelectionListener> m_listeners;
    private boolean m_useEquals;

    protected SelectableComponent(T component) {
        this.m_component = component;
    }

    public final T getComponent() {
        return this.m_component;
    }

    public final void addSelectionListener(SelectionListener listener) {
        if (listener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new LinkedHashSet<SelectionListener>();
            }
            this.m_listeners.add(listener);
        }
    }

    public final void removeSelectionListener(SelectionListener listener) {
        if (listener != null && this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    protected final void fireSelectionEvent() {
        if (this.m_listeners != null) {
            SelectionEvent event = new SelectionEvent(this);
            for (SelectionListener listener : this.m_listeners) {
                try {
                    listener.valueChanged(event);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "SelectionListener error", e);
                }
            }
        }
    }

    public abstract void clear();

    public abstract int size();

    public abstract Object get(int var1);

    public abstract Object[] getChildren(Object var1);

    public abstract Object getParent(Object var1);

    public abstract boolean swap(int var1, int var2);

    public abstract void setSelectedIndices(int ... var1);

    public abstract int[] getSelectedIndices();

    public int getNextIndex(int i) {
        int retval = -1;
        if (i >= 0 && i < this.size() - 1) {
            retval = i + 1;
        }
        return retval;
    }

    public int getPreviousIndex(int i) {
        int retval = -1;
        if (i > 0 && i < this.size()) {
            retval = i - 1;
        }
        return retval;
    }

    public int getFirstIndex(int i) {
        return i > 0 ? 0 : -1;
    }

    public int getLastIndex(int i) {
        int last = this.size() - 1;
        return i < last ? last : -1;
    }

    public int getSelectedIndex() {
        int retval = -1;
        int[] selection = this.getSelectedIndices();
        if (selection != null && selection.length == 1) {
            retval = selection[0];
        }
        return retval;
    }

    public int indexOf(Object obj) {
        int retval = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != obj) continue;
            retval = i;
            break;
        }
        return retval;
    }

    public abstract boolean add(Object var1);

    public boolean add(int index, Object obj) {
        return this.add(index, obj, Placement.Sibling);
    }

    public abstract boolean add(int var1, Object var2, Placement var3);

    public abstract boolean remove(Object var1);

    public abstract Object remove(int var1);

    public boolean moveUp(int index) {
        boolean retval = false;
        int previous = this.getPreviousIndex(index);
        if (previous >= 0) {
            retval = this.swap(index, previous);
        }
        return retval;
    }

    public boolean moveDown(int index) {
        boolean retval = false;
        int next = this.getNextIndex(index);
        if (next >= 0) {
            retval = this.swap(index, next);
        }
        return retval;
    }

    public boolean moveFirst(int index) {
        Object obj;
        boolean retval = false;
        int first = this.getFirstIndex(index);
        if (first >= 0 && (obj = this.remove(index)) != null) {
            retval = this.add(first, obj);
            this.modelChanged();
        }
        return retval;
    }

    public boolean moveLast(int index) {
        Object obj;
        boolean retval = false;
        int last = this.getLastIndex(index);
        if (last >= 0 && (obj = this.remove(index)) != null) {
            retval = this.add(last, obj);
            this.modelChanged();
        }
        return retval;
    }

    protected void modelChanged() {
    }

    public static SelectableComponent<JTree> createSelectableComponent(JTree tree) {
        return new TreeSC(tree);
    }

    public static SelectableComponent<JList> createSelectableComponent(JList list) {
        return new ListSC(list);
    }

    public static SelectableComponent<JComboBox> createSelectableComponent(JComboBox combo) {
        return new ComboSC(combo);
    }

    static class ComboSC
    extends SelectableComponent<JComboBox> {
        public ComboSC(JComboBox combo) {
            super(combo);
            ComboBoxModel model = combo.getModel();
            if (!(model instanceof DefaultComboBoxModel)) {
                throw new IllegalStateException("JComboBox must have a DefaultComboBoxModel to be used inSelectableComponent");
            }
            combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ComboSC.this.fireSelectionEvent();
                    }
                }
            });
        }

        private DefaultComboBoxModel getModel() {
            return (DefaultComboBoxModel)((JComboBox)this.getComponent()).getModel();
        }

        @Override
        public int size() {
            return this.getModel().getSize();
        }

        @Override
        public Object get(int index) {
            return this.getModel().getElementAt(index);
        }

        @Override
        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        @Override
        public Object getParent(Object child) {
            return null;
        }

        @Override
        public int[] getSelectedIndices() {
            return new int[]{((JComboBox)this.getComponent()).getSelectedIndex()};
        }

        @Override
        public void setSelectedIndices(int ... selection) {
            if (selection != null && selection.length == 1) {
                ((JComboBox)this.getComponent()).setSelectedIndex(selection[0]);
            } else if (selection == null || selection.length == 0) {
                ((JComboBox)this.getComponent()).setSelectedIndex(-1);
            } else {
                throw new UnsupportedOperationException("Attempt to multi-select in a combo box");
            }
        }

        @Override
        public boolean swap(int index1, int index2) {
            throw new UnsupportedOperationException("Attempt to reorder in a combo box");
        }

        @Override
        public boolean add(Object obj) {
            this.getModel().addElement(obj);
            return true;
        }

        @Override
        public boolean add(int index, Object obj, Placement placement) {
            this.getModel().addElement(obj);
            return true;
        }

        @Override
        public Object remove(int index) {
            this.getModel().removeElementAt(index);
            return true;
        }

        @Override
        public boolean remove(Object obj) {
            this.getModel().removeElement(obj);
            return true;
        }

        @Override
        public void clear() {
            this.getModel().removeAllElements();
        }
    }

    static class ListSC
    extends SelectableComponent<JList> {
        public ListSC(JList list) {
            super(list);
            ListModel model = list.getModel();
            if (!(model instanceof DefaultListModel)) {
                throw new IllegalStateException("JList must have a DefaultListModel to be used in SelectableComponent");
            }
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ListSC.this.fireSelectionEvent();
                    }
                }
            });
        }

        private DefaultListModel getModel() {
            return (DefaultListModel)((JList)this.getComponent()).getModel();
        }

        @Override
        public int size() {
            return this.getModel().getSize();
        }

        @Override
        public Object get(int index) {
            return this.getModel().getElementAt(index);
        }

        @Override
        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        @Override
        public Object getParent(Object child) {
            return null;
        }

        @Override
        public int[] getSelectedIndices() {
            return ((JList)this.getComponent()).getSelectedIndices();
        }

        @Override
        public void setSelectedIndices(int ... selection) {
            if (selection != null && selection.length == 1) {
                ((JList)this.getComponent()).setSelectedIndex(selection[0]);
            } else {
                ((JList)this.getComponent()).setSelectedIndices(selection);
            }
        }

        @Override
        public boolean swap(int index1, int index2) {
            DefaultListModel model = this.getModel();
            Object o1 = model.getElementAt(index1);
            Object o2 = model.getElementAt(index2);
            model.setElementAt(o1, index2);
            model.setElementAt(o2, index1);
            return true;
        }

        @Override
        public boolean add(Object obj) {
            this.getModel().addElement(obj);
            return true;
        }

        @Override
        public boolean add(int index, Object obj, Placement placement) {
            boolean retval = false;
            if (index >= 0) {
                if (index >= this.size()) {
                    retval = this.add(obj);
                } else {
                    this.getModel().add(index, obj);
                    retval = true;
                }
            }
            return retval;
        }

        @Override
        public Object remove(int index) {
            Object retval = this.getModel().get(index);
            if (retval != null) {
                this.getModel().removeElementAt(index);
            }
            return retval;
        }

        @Override
        public boolean remove(Object obj) {
            this.getModel().removeElement(obj);
            return true;
        }

        @Override
        public void clear() {
            this.getModel().clear();
        }
    }

    static class TreeSC
    extends SelectableComponent<JTree> {
        public TreeSC(JTree tree) {
            super(tree);
            TreeModel model = tree.getModel();
            if (!(model instanceof DefaultTreeModel)) {
                throw new IllegalStateException("JTree must have a DefaultTreeModel to be used in SelectableComponent");
            }
            Object root = model.getRoot();
            if (!(root instanceof DefaultMutableTreeNode)) {
                throw new IllegalStateException("JTree must have a root DefaultMutableTreeNode to be used in SelectableComponent");
            }
            tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreeSC.this.fireSelectionEvent();
                }
            });
        }

        DefaultTreeModel getModel() {
            return (DefaultTreeModel)((JTree)this.getComponent()).getModel();
        }

        DefaultMutableTreeNode getRoot() {
            return (DefaultMutableTreeNode)this.getModel().getRoot();
        }

        private Enumeration nodes() {
            Enumeration<TreeNode> nodes = this.getRoot().preorderEnumeration();
            if (!((JTree)this.getComponent()).isRootVisible() && nodes.hasMoreElements()) {
                nodes.nextElement();
            }
            return nodes;
        }

        @Override
        protected void modelChanged() {
            this.modelChanged(null);
        }

        private void modelChanged(TreeNode node) {
            if (node != null) {
                this.getModel().reload(node);
            } else {
                this.getModel().reload();
            }
        }

        @Override
        public int size() {
            int i = 0;
            Enumeration e = this.nodes();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++i;
            }
            return i;
        }

        private int indexOfNode(DefaultMutableTreeNode node) {
            int i = 0;
            int retval = -1;
            Enumeration e = this.nodes();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
                if (node == next) {
                    retval = i;
                    break;
                }
                ++i;
            }
            return retval;
        }

        @Override
        public int indexOf(Object obj) {
            int i = 0;
            int retval = -1;
            Enumeration e = this.nodes();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                if (node.getUserObject() == obj) {
                    retval = i;
                    break;
                }
                ++i;
            }
            return retval;
        }

        @Override
        public boolean add(int index, Object obj, Placement placement) {
            if (placement == null) {
                placement = Placement.Sibling;
            }
            int i = 0;
            Enumeration e = this.nodes();
            DefaultMutableTreeNode afterMe = this.getRoot();
            if (this.size() != 0) {
                while (e.hasMoreElements()) {
                    Object n = e.nextElement();
                    if (index == 0) {
                        afterMe = (DefaultMutableTreeNode)n;
                        break;
                    }
                    if (i == index - 1) {
                        afterMe = (DefaultMutableTreeNode)n;
                        break;
                    }
                    ++i;
                }
            }
            boolean retval = false;
            if (afterMe != null) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(obj);
                DefaultMutableTreeNode parent = placement == Placement.Sibling ? (DefaultMutableTreeNode)afterMe.getParent() : afterMe;
                int localIndex = TreeNodeMaker.indexOfNode(afterMe, parent);
                if (localIndex >= 0 && localIndex < parent.getChildCount()) {
                    parent.insert(newNode, localIndex + 1);
                } else {
                    parent.add(newNode);
                }
                this.modelChanged(parent);
                retval = true;
            }
            return retval;
        }

        @Override
        public boolean add(Object obj) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
            this.getRoot().add(node);
            this.modelChanged();
            return true;
        }

        @Override
        public Object get(int index) {
            DefaultMutableTreeNode node = this.getNode(index);
            return node == null ? null : node.getUserObject();
        }

        @Override
        public Object[] getChildren(Object parent) {
            DefaultMutableTreeNode parentNode = this.getNode(this.indexOf(parent));
            if (parentNode == null) {
                parentNode = (DefaultMutableTreeNode)((JTree)this.getComponent()).getModel().getRoot();
            }
            if (parentNode != null) {
                Object[] ret = new Object[parentNode.getChildCount()];
                int index = 0;
                Enumeration<TreeNode> kids = parentNode.children();
                while (kids.hasMoreElements()) {
                    ret[index++] = ((DefaultMutableTreeNode)kids.nextElement()).getUserObject();
                }
                return ret;
            }
            return new Object[0];
        }

        @Override
        public Object getParent(Object child) {
            DefaultMutableTreeNode node = this.getNode(this.indexOf(child));
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            return parent != null ? parent.getUserObject() : null;
        }

        private DefaultMutableTreeNode getNode(int index) {
            DefaultMutableTreeNode retval = null;
            int i = 0;
            Enumeration e = this.nodes();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                if (i == index) {
                    retval = (DefaultMutableTreeNode)obj;
                    break;
                }
                ++i;
            }
            return retval;
        }

        @Override
        public int[] getSelectedIndices() {
            int[] retval = null;
            TreePath[] paths = ((JTree)this.getComponent()).getSelectionModel().getSelectionPaths();
            if (paths != null) {
                ArrayList<Integer> indicies = new ArrayList<Integer>();
                for (TreePath path : paths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    int index = this.indexOfNode(node);
                    if (index < 0) continue;
                    indicies.add(index);
                }
                retval = new int[indicies.size()];
                for (int i = 0; i < retval.length; ++i) {
                    retval[i] = (Integer)indicies.get(i);
                }
            }
            return retval;
        }

        @Override
        public Object remove(int index) {
            Object retval = false;
            DefaultMutableTreeNode node = this.getNode(index);
            if (node != null) {
                retval = node.getUserObject();
                TreeNode parent = node.getParent();
                node.removeFromParent();
                this.modelChanged(parent);
            }
            return retval;
        }

        @Override
        public boolean remove(Object obj) {
            boolean retval = false;
            DefaultMutableTreeNode node = TreeNodeMaker.findNode(obj, this.getRoot());
            if (node != null) {
                TreeNode parent = node.getParent();
                node.removeFromParent();
                this.modelChanged(parent);
                retval = true;
            }
            return retval;
        }

        @Override
        public void setSelectedIndices(int ... selection) {
            TreeSelectionModel sm = ((JTree)this.getComponent()).getSelectionModel();
            if (selection == null || selection.length == 0) {
                sm.clearSelection();
            } else {
                ArrayList<TreePath> paths = new ArrayList<TreePath>();
                for (int i = 0; i < selection.length; ++i) {
                    DefaultMutableTreeNode node = this.getNode(selection[i]);
                    if (node == null) continue;
                    paths.add(new TreePath(node.getPath()));
                }
                sm.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
            }
        }

        @Override
        public boolean swap(int index1, int index2) {
            DefaultMutableTreeNode n1 = this.getNode(index1);
            DefaultMutableTreeNode n2 = this.getNode(index2);
            boolean retval = false;
            if (n1 != null && n2 != null && n1 != n2) {
                DefaultMutableTreeNode p1 = (DefaultMutableTreeNode)n1.getParent();
                DefaultMutableTreeNode p2 = (DefaultMutableTreeNode)n2.getParent();
                if (p1 != null && p1 == p2) {
                    int i1 = TreeNodeMaker.indexOfNode(n1, p1);
                    int i2 = TreeNodeMaker.indexOfNode(n2, p2);
                    n1.removeFromParent();
                    n2.removeFromParent();
                    if (i1 > i2) {
                        p2.insert(n1, i2);
                        p1.insert(n2, i1);
                    } else {
                        p1.insert(n2, i1);
                        p2.insert(n1, i2);
                    }
                    retval = true;
                    this.modelChanged();
                }
            }
            return retval;
        }

        @Override
        public int getFirstIndex(int i) {
            DefaultMutableTreeNode parent;
            int retval = -1;
            DefaultMutableTreeNode node = this.getNode(i);
            if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                DefaultMutableTreeNode first = null;
                Enumeration<TreeNode> kids = parent.children();
                if (kids.hasMoreElements()) {
                    first = (DefaultMutableTreeNode)kids.nextElement();
                }
                if (first != null && first != node) {
                    retval = this.indexOfNode(first);
                }
            }
            return retval;
        }

        @Override
        public int getLastIndex(int i) {
            DefaultMutableTreeNode parent;
            int retval = -1;
            DefaultMutableTreeNode node = this.getNode(i);
            if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                Enumeration<TreeNode> kids = parent.children();
                DefaultMutableTreeNode last = null;
                while (kids.hasMoreElements()) {
                    last = (DefaultMutableTreeNode)kids.nextElement();
                }
                if (last != null && last != node) {
                    retval = this.indexOfNode(last);
                }
            }
            return retval;
        }

        @Override
        public int getNextIndex(int i) {
            DefaultMutableTreeNode parent;
            int retval = -1;
            DefaultMutableTreeNode node = this.getNode(i);
            if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                Enumeration<TreeNode> kids = parent.children();
                boolean found = false;
                DefaultMutableTreeNode next = null;
                while (kids.hasMoreElements()) {
                    DefaultMutableTreeNode kid = (DefaultMutableTreeNode)kids.nextElement();
                    if (kid == node) {
                        found = true;
                        continue;
                    }
                    if (!found || next != null) continue;
                    next = kid;
                    break;
                }
                if (next != null) {
                    retval = this.indexOfNode(next);
                }
            }
            return retval;
        }

        @Override
        public int getPreviousIndex(int i) {
            DefaultMutableTreeNode parent;
            int retval = -1;
            DefaultMutableTreeNode node = this.getNode(i);
            if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                DefaultMutableTreeNode kid;
                Enumeration<TreeNode> kids = parent.children();
                boolean found = false;
                DefaultMutableTreeNode previous = null;
                while (kids.hasMoreElements() && (kid = (DefaultMutableTreeNode)kids.nextElement()) != node) {
                    previous = kid;
                }
                if (previous != null) {
                    retval = this.indexOfNode(previous);
                }
            }
            return retval;
        }

        @Override
        public boolean moveLast(int index) {
            DefaultMutableTreeNode parent;
            boolean retval = false;
            DefaultMutableTreeNode node = this.getNode(index);
            if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                parent.remove(node);
                parent.add(node);
                retval = true;
                this.modelChanged(parent);
            }
            return retval;
        }

        @Override
        public boolean moveFirst(int index) {
            DefaultMutableTreeNode parent;
            boolean retval = false;
            DefaultMutableTreeNode node = this.getNode(index);
            if (node != null && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
                parent.remove(node);
                parent.insert(node, 0);
                retval = true;
                this.modelChanged(parent);
            }
            return retval;
        }

        @Override
        public void clear() {
            this.getRoot().removeAllChildren();
            this.modelChanged();
        }
    }

    public static final class SelectionEvent {
        private final SelectableComponent m_sc;

        private SelectionEvent(SelectableComponent sc) {
            this.m_sc = sc;
        }

        public SelectableComponent getSelectableComponent() {
            return this.m_sc;
        }
    }

    public static abstract class SelectionListener {
        public abstract void valueChanged(SelectionEvent var1);
    }

    public static enum Placement {
        Sibling,
        Child;

    }
}

