/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.dialogs.AbstractDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.editors.DBObjectOverviewEditor;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.panels.TraversableProxy;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.ideimpl.db.validate.ModalValidationManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.dialogs.MessageDialog;

public class BaseDBEditorFactory
extends AbstractDBEditorFactory {
    private static final String CREATE_CONTEXT_PROP = "BaseDBEditorFactory.CREATE_CONTEXT";
    private final Map<String, PanelLibrary> m_libraries = new HashMap<String, PanelLibrary>();
    private final Map<String, Class<? extends PanelLibrary>> m_libraryClasses = new HashMap<String, Class<? extends PanelLibrary>>();

    protected BaseDBEditorFactory() {
    }

    public PanelLibrary getPanelLibrary(String dbObjectType) {
        PanelLibrary retval = this.m_libraries.get(dbObjectType);
        if (retval == null && (retval = this.createLibrary(dbObjectType)) != null) {
            this.initializeLibrary(retval);
            this.m_libraries.put(dbObjectType, retval);
        }
        return retval;
    }

    protected PanelLibrary createLibrary(String dbObjectType) {
        PanelLibrary retval = null;
        Class<? extends PanelLibrary> clz = this.m_libraryClasses.get(dbObjectType);
        if (clz != null) {
            try {
                retval = clz.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Couldn't init library", e);
            }
        }
        return retval;
    }

    protected void initializeLibrary(PanelLibrary lib) {
    }

    private boolean purgeLibraryCache() {
        this.m_libraries.clear();
        return true;
    }

    protected void registerLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        this.m_libraryClasses.put(dbObjectType, libClass);
    }

    protected void unregisterLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        Class<? extends PanelLibrary> clz = this.m_libraryClasses.get(dbObjectType);
        if (clz != null) {
            if (clz.equals(libClass)) {
                this.m_libraryClasses.remove(dbObjectType);
                this.m_libraries.remove(dbObjectType);
            } else {
                DBLog.getLogger((Object)this).warning("Cannot remove library for " + dbObjectType + " as libClass doesn't match.");
            }
        }
    }

    @Override
    public String[] listSupportedTypes() {
        Collection<String> types = this.listSupportedTypesImpl();
        return types.toArray(new String[types.size()]);
    }

    protected Collection<String> listSupportedTypesImpl() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(this.m_libraryClasses.keySet());
        return retval;
    }

    @Override
    public boolean isCreateSupported(String dbObjectType) {
        return this.listSupportedTypesImpl().contains(dbObjectType);
    }

    @Override
    public boolean canCreateDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        return this.isCreateSupported(dbObjectType) && this.supportsObjectType(dbObjectType, pro);
    }

    protected boolean supportsObjectType(String dbObjectType, DBObjectProvider pro) {
        return pro.supportsObjectType(dbObjectType);
    }

    private void throwConfigException(DBEditorConfig config, String missing) {
        throw new IllegalArgumentException("DBEditorConfig is missing: " + missing);
    }

    private void showUnsupportedError(String type, String name) {
        DBMessageDialog.showErrorDialog(UIBundle.format("DBOBJECT_EDIT_OBJ_UNSUPPORTED", DBTypeDisplayRegistry.getSingularDisplayName(type), name), this, Level.SEVERE, UIBundle.get("DBOBJECT_EDIT_ERROR_TITLE"), null);
    }

    private void showInvalidTemplateError(String type, String schemaDotName) {
        String[] names = schemaDotName.split("\\.");
        String name = names[names.length - 1];
        DBMessageDialog.showErrorDialog(UIBundle.format("DBOBJECT_CREATE_INVALID_TEMPLATE", DBTypeDisplayRegistry.getSingularDisplayName(type), name), this, Level.SEVERE, UIBundle.get("DBOBJECT_EDIT_ERROR_TITLE"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void launchDialog(DBEditorConfig config) {
        String type = config.getObjectType();
        PanelLibrary lib = this.getPanelLibrary(type);
        if (lib == null) {
            config.setResult(DBEditorConfig.Result.FAILED);
            DBObjectNode node = config.getOriginalObjectNode();
            if (node != null) {
                this.showUnsupportedError(type, node.getObjectName());
            }
        } else {
            DBObjectProvider pro = config.getProvider();
            if (pro == null) {
                this.throwConfigException(config, "DBObjectProvider");
            }
            String timestampKey = BaseDBEditorFactory.getTimestampKey(type) + System.nanoTime();
            try {
                boolean edit;
                DBUtil.suspendTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
                Schema schema = config.getSchema();
                SystemObject originalObject = config.getOriginalObject();
                boolean bl = edit = originalObject != null;
                if (edit) {
                    if (lib.canReplaceByDefault()) {
                        config.setReplaceAlwaysAllowed(true);
                    }
                    if (lib.shouldResetObjectBeforeEdit(config)) {
                        try {
                            DBUtil.forceObjectReset((SystemObject)originalObject, (DBObjectProvider)pro);
                        }
                        catch (DBException dbe) {
                            DBLog.getLogger((Object)this).warning("Couldn't reset object definition: " + dbe.getMessage());
                        }
                    }
                }
                SystemObject newObject = config.getUpdatedObject();
                if (edit) {
                    DBObjectID id = newObject.getID();
                    try {
                        if (!(id instanceof TemporaryObjectID) || ((TemporaryObjectID)id).resolveOriginalID() != originalObject) {
                            throw new IllegalStateException("newObject must be a temp copy of oldObject.");
                        }
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                Class clz = Metadata.getInstance().getObjectClass(type);
                if (edit && !clz.isAssignableFrom(originalObject.getClass())) {
                    Object child = config.getChildObject();
                    if (child == null) {
                        child = lib.getObjectForCreate(schema, pro, (DBObject)newObject);
                        edit = false;
                    } else if (TemporaryObjectID.findOriginalObject((DBObject)child) == null) {
                        edit = false;
                    }
                    config.setChildObject((DBObject)child);
                } else if (newObject == null) {
                    SchemaObject contextObject = config.getContextObject();
                    newObject = (SystemObject)lib.getObjectForCreate(schema, pro, (DBObject)contextObject);
                    config.setUpdatedObject(newObject);
                }
                if (newObject.getName() == null) {
                    lib.makeNameUnique((DBObject)newObject, schema, pro, null);
                }
                if (this.checkPrivilege((DBObject)newObject, pro, edit, lib)) {
                    this.launchDialog(config, lib, edit);
                }
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to launch editor", e);
                config.setResult(DBEditorConfig.Result.FAILED);
            }
            finally {
                DBUtil.resumeTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
            }
        }
    }

    protected void launchDialog(DBEditorConfig config, PanelLibrary lib, boolean edit) {
        DBObjectProvider pro = config.getProvider();
        DBEditorFactory.EditorType editorType = this.determineEditorType(config);
        config.setEditorType(editorType);
        List<Navigable> navs = lib.getNavigables(config);
        if (navs == null) {
            Object objForNavs = config.isChildEditOnly() ? config.getChildObject() : config.getUpdatedObject();
            config.setResult(DBEditorConfig.Result.FAILED);
            if (!edit && TemplateExpander.isPendingObject((DBObject)objForNavs)) {
                this.showInvalidTemplateError(objForNavs.getType(), TemplateExpander.getTemplateObjectName((DBObject)objForNavs));
            } else {
                this.showUnsupportedError(objForNavs.getType(), objForNavs.getName());
            }
        } else {
            Traversable mainPanel = lib.getMainDialogPanel(config, navs.toArray(new Navigable[navs.size()]));
            if (mainPanel == null) {
                lib.commitToProvider(config);
            } else {
                Map<String, Class> verifiers = edit ? lib.getEditVerifiers() : lib.getCreateVerifiers();
                Namespace ns = this.createNamespace(config, verifiers);
                if (ns != null) {
                    ns.put(PanelLibrary.class.getName(), (Object)lib);
                    String dialogName = (edit ? "edit" : "create") + config.getObjectType();
                    String dialogTitle = edit ? lib.getEditTitle() : lib.getCreateTitle();
                    Dimension size = lib.getSize(edit);
                    if (size == null && navs.size() == 0) {
                        size = OracleDBEditorFactory.NO_PANELS_DIALOG_SIZE;
                    }
                    if (!this.launchDialog(ns, dialogTitle, edit, mainPanel, lib, size, dialogName)) {
                        config.setResult(DBEditorConfig.Result.CANCELLED);
                    }
                }
            }
        }
        if (config.getResult() == DBEditorConfig.Result.SUCCESS) {
            this.commitPerformed(config, lib);
        }
    }

    protected DBEditorFactory.EditorType determineEditorType(DBEditorConfig config) {
        return config.isEdit() ? DBEditorFactory.EditorType.EDIT_MODAL : DBEditorFactory.EditorType.CREATE_MODAL;
    }

    public void commitPerformed(DBEditorConfig config, PanelLibrary lib) {
        if (lib.showEditorAfterCommit()) {
            this.showEditor(config);
        }
    }

    protected final void showEditor(final DBEditorConfig config) {
        DBObjectProvider pro = config.getProvider();
        final SystemObject newObject = config.getUpdatedObject();
        URL url = DBURLFactory.getURL(pro, newObject);
        try {
            final Node node = NodeFactory.findOrCreate((URL)url);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditorManager editorManager = EditorManager.getEditorManager();
                        Context context = Context.newIdeContext((Node)node);
                        List eds = editorManager.findEditors(context);
                        if (eds != null) {
                            for (Editor ed : eds) {
                                if (!(ed instanceof DBObjectOverviewEditor)) continue;
                                ((DBObjectOverviewEditor)ed).changeEditorConfig(config);
                                break;
                            }
                        }
                        if (config.getOriginalObject() == null) {
                            context.setProperty(BaseDBEditorFactory.CREATE_CONTEXT_PROP, (Object)Boolean.TRUE);
                        } else {
                            DBEditorConfig.setConfig(context, config);
                        }
                        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                        if (!(newObject instanceof SourceObject)) {
                            openEditorOptions.setEditorClass(DBObjectOverviewEditor.class);
                        }
                        editorManager.openEditor(openEditorOptions);
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Error opening editor.", e);
                    }
                }
            });
        }
        catch (Exception e) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Error finding object node.", e);
        }
    }

    private boolean checkPrivilege(DBObject newObj, DBObjectProvider pro, boolean edit, PanelLibrary lib) {
        boolean retval = true;
        DBObject sysObj = newObj;
        while (!(sysObj instanceof SystemObject) && sysObj.getParent() != null) {
            sysObj = sysObj.getParent();
        }
        if (pro instanceof Database) {
            if (edit && sysObj instanceof SystemObject) {
                retval = pro.hasObjectPrivilege((SystemObject)sysObj, "MODIFY");
            } else {
                String priv;
                String string = priv = edit ? "MODIFY" : "CREATE";
                String type = newObj instanceof PackageBody ? "PACKAGE" : (newObj instanceof TypeBody ? "TYPE" : newObj.getType());
                retval = pro.hasSystemPrivilege(type, DBUtil.getSchema((DBObject)newObj), priv);
            }
        }
        if (!retval) {
            MessageDialog.error(null, (Object)UIBundle.get("DBOBJECT_INSUFFICIENT_PRIVS"), (String)(edit ? lib.getEditTitle() : lib.getCreateTitle()), null);
        }
        return retval;
    }

    @Override
    public boolean canEditDBObject(DBObject obj, DBObjectProvider pro) {
        String dbObjectType;
        PanelLibrary lib;
        boolean retval = false;
        if (obj != null && (lib = this.getPanelLibrary(dbObjectType = obj.getType())) != null && lib.canEditObject(obj, pro)) {
            retval = true;
        }
        return retval;
    }

    @Override
    public String getCreateLabel(String dbObjectType) {
        PanelLibrary lib = this.getPanelLibrary(dbObjectType);
        if (lib != null) {
            return lib.getCreateText();
        }
        return null;
    }

    public Namespace createNamespace(DBEditorConfig config) {
        return this.createNamespace(config, null);
    }

    @Deprecated
    protected Namespace createNamespace(DBEditorConfig config, Map<String, Class> verifiers) {
        Namespace data = new Namespace();
        data.put(DBEditorConfig.class.getName(), (Object)config);
        DBObjectProvider provider = config.getProvider();
        data.put("oracle.javatools.db.DBObjectProvider", (Object)provider);
        SystemObject originalObject = config.getOriginalObject();
        boolean isEdit = originalObject != null;
        SystemObject newObject = config.getUpdatedObject();
        if (newObject != null) {
            data.put("OriginalObject", (Object)originalObject);
            data.put("NewObject", (Object)newObject);
            if (config.isChildEditOnly()) {
                data.put("NewChildObject", (Object)config.getChildObject());
            }
            boolean editable = !isEdit || !config.isCommitToProvider() || this.canUpdateObject((DBObject)newObject, provider);
            config.setEditable(editable);
            Schema schema = DBUtil.getSchema((DBObject)newObject);
            data.put("oracle.javatools.db.Schema", (Object)schema);
            if (verifiers != null) {
                for (String key : verifiers.keySet()) {
                    Class cls = verifiers.get(key);
                    try {
                        Object obj = cls.newInstance();
                        if (obj instanceof Verifier) {
                            Verifier verifier = (Verifier)obj;
                            verifier.initializeVerifier(provider, (SchemaObject)originalObject, (SchemaObject)newObject);
                            verifier.setEditable(editable);
                        }
                        data.put(key, obj);
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return data;
    }

    protected boolean canUpdateObject(DBObject obj, DBObjectProvider pro) {
        return true;
    }

    private boolean launchDialog(Namespace data, String title, boolean edit, Traversable panel, PanelLibrary lib, Dimension size, String dialogName) {
        Component parent = DBMessageDialog.getDialogParent();
        TraversableProxy proxyPanel = new TraversableProxy(panel);
        TDialogLauncher launcher = new TDialogLauncher(parent, title, (Traversable)proxyPanel, data);
        if (size != null) {
            launcher.setInitialSize(size);
        }
        JEWTDialog dialog = launcher.initDialog();
        dialog.setName(dialogName);
        data.put(JEWTDialog.class.getName(), (Object)dialog);
        if (Boolean.getBoolean("ide.db.liveValidate") && data.get(DBValidationManager.class) == null) {
            data.put(DBValidationManager.class.getName(), (Object)new ModalValidationManager(dialog));
        }
        DBEditorConfig config = (DBEditorConfig)data.find(DBEditorConfig.class);
        dialog.setOKButtonEnabled(config.isEditable());
        Component header = this.getDialogHeader(config);
        if (header != null) {
            dialog.setDialogHeader(header);
        }
        proxyPanel.enable();
        Component initialFocus = lib.getInitialFocus(panel);
        if (initialFocus != null) {
            dialog.setInitialFocus(initialFocus);
        }
        return launcher.showDialog();
    }

    protected Component getDialogHeader(DBEditorConfig config) {
        return null;
    }

    public static String getTimestampKey(String type) {
        return type + "EditDialog";
    }

    public static boolean isCreateContext(Context ideContext) {
        return Boolean.TRUE.equals(ideContext.getProperty(CREATE_CONTEXT_PROP));
    }

    public static void setEditorType(DBEditorConfig config, DBEditorFactory.EditorType editorType) {
        if (config != null) {
            config.setEditorType(editorType);
        }
    }
}

