/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;

public class CascadeConfirmDialog
extends DBExceptionDialog {
    private CascadeConfirmDialog() {
    }

    public static boolean confirmCascade(Component parent, CascadeRequiredException cre, String title, String helpTopic) {
        return DBMessageDialog.useDialog() && CascadeConfirmDialog.showConfirmDialog(parent, title, helpTopic, (DBException)cre);
    }

    public static boolean confirmReplace(DBEditorConfig config) {
        PropertyAction.Type actionType;
        boolean retval = true;
        DBObjectProvider pro = config.getProvider();
        SystemObject orig = config.getOriginalObject();
        SystemObject update = config.getUpdatedObject();
        PropertyManager pm = pro.getPropertyManager();
        PropertyAction action = pm.canUpdateObject(orig, update);
        PropertyAction.Type type = actionType = action == null ? null : action.getType();
        if (actionType == PropertyAction.Type.CREATE || actionType == PropertyAction.Type.REPLACE) {
            if (orig != null && !config.isReplaceAllowed()) {
                StringBuilder props = new StringBuilder();
                for (String s : action.getProperties()) {
                    props.append(PropertyDisplayRegistry.getDisplayName(s)).append("\n");
                }
                String propText = props.toString();
                if (MessageDialog.confirm((Component)DBMessageDialog.getDialogParent(), (Object)UIBundle.format("REPLACE_CONFIRM_TEXT", propText), (String)UIBundle.get("REPLACE_CONFIRM_TITLE"), null, (boolean)true)) {
                    config.setReplaceAllowed(true);
                } else {
                    retval = false;
                }
            }
        } else if (actionType == PropertyAction.Type.ALTER) {
            config.setReplaceAllowed(false);
        }
        return retval;
    }

    public static boolean updateObjects(Component parent, String title, DBObjectProvider pro, SystemObject[] oldObjects, SystemObject[] newObjects) {
        return CascadeConfirmDialog.updateObjects(parent, title, pro, oldObjects, newObjects, false);
    }

    public static boolean updateObjects(Component parent, String title, DBObjectProvider pro, SystemObject[] oldObjects, SystemObject[] newObjects, boolean replace) {
        try {
            Difference diff = pro.getDiffEngine().difference((Object)oldObjects, (Object)newObjects);
            return CascadeConfirmDialog.doUpdate(parent, title, pro, diff, replace);
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(parent, title, dbe);
            return false;
        }
    }

    private static boolean doUpdate(Component parent, String title, DBObjectProvider pro, Difference diff, boolean replace) throws DBException {
        boolean cascade = false;
        try {
            pro.canUpdate(diff, replace, false);
        }
        catch (CascadeRequiredException cre) {
            if (title == null) {
                title = UIBundle.get("DBOBJECT_EDIT_ERROR_TITLE");
            }
            if (CascadeConfirmDialog.confirmCascade(parent, cre, title, null)) {
                cascade = true;
            }
            return false;
        }
        pro.updateObjects(diff, replace, cascade);
        return true;
    }

    @Deprecated
    public static boolean updateObjects(Component parent, String title, DBEditorConfig config) {
        ProviderOperator oper = new ProviderOperator(config.getProvider());
        oper.updateObjects(config);
        return config.getResult() == DBEditorConfig.Result.SUCCESS;
    }
}

