/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;

public final class DBEditorConfig {
    private final DBObjectProvider m_provider;
    private Schema m_schema;
    private Schema[] m_schemaList;
    private String m_objectType;
    private SystemObject m_updatedObject;
    private SystemObject m_originalObject;
    private SchemaObject m_contextObject;
    private DBObject m_childObject;
    private DBObjectNode m_node;
    private String m_property;
    private boolean m_commitToProvider = true;
    private boolean m_allowReplace;
    private boolean m_alwaysAllowReplace;
    private boolean m_backgroundTask;
    private boolean m_editable = true;
    private boolean m_childEditOnly;
    private String m_startPage;
    private DBEditorFactory.EditorType m_editorType;
    private Result m_dialogResult = Result.IN_PROGRESS;
    private DBException m_exception;

    private DBEditorConfig(DBObjectProvider pro) {
        this.m_provider = pro;
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public void setReplaceAlwaysAllowed(boolean allowReplace) {
        this.m_alwaysAllowReplace = allowReplace;
    }

    public void setReplaceAllowed(boolean allowReplace) {
        this.m_allowReplace = allowReplace;
    }

    public boolean isReplaceAllowed() {
        return this.m_alwaysAllowReplace || this.m_allowReplace;
    }

    public void setCommitToProvider(boolean commit) {
        this.m_commitToProvider = commit;
    }

    public boolean isCommitToProvider() {
        return this.m_commitToProvider;
    }

    void setEditorType(DBEditorFactory.EditorType editorType) {
        this.m_editorType = editorType;
    }

    public DBEditorFactory.EditorType getEditorType() {
        return this.m_editorType;
    }

    public boolean isInFlatEditor() {
        return this.m_editorType == DBEditorFactory.EditorType.EDIT_FLAT;
    }

    public void setStartPage(String startPage) {
        this.m_startPage = startPage;
    }

    public String getStartPage() {
        return this.m_startPage;
    }

    public void setChildObject(DBObject childObject) {
        this.checkInitFromNode();
        this.m_childObject = childObject;
        this.checkChildIsFromUpdated();
    }

    private void checkChildIsFromUpdated() {
        DBObject otherChild;
        if (this.m_childObject != null && this.m_originalObject != null && this.m_updatedObject != null && DBUtil.getPropertyPath((DBObject)this.m_originalObject, (DBObject)this.m_childObject) != null && (otherChild = DBUtil.findChildInCopy((DBObject)this.m_originalObject, (DBObject)this.m_updatedObject, (DBObject)this.m_childObject)) != null) {
            this.m_childObject = otherChild;
        }
    }

    public DBObject getChildObject() {
        this.checkInitFromNode();
        return this.m_childObject;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public String getProperty() {
        return this.m_property;
    }

    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    public Schema getSchema() {
        this.checkInitFromNode();
        if (this.m_schema == null) {
            try {
                this.m_schema = this.m_provider.getDefaultSchema();
            }
            catch (DBException dbe) {
                DBLog.getLogger().warning(dbe.getMessage());
            }
        }
        return this.m_schema;
    }

    public void setSchemaList(Schema[] schemaList) {
        this.m_schemaList = schemaList;
    }

    public Schema[] getSchemaList() {
        if (this.m_schemaList == null) {
            try {
                this.m_schemaList = this.m_provider.listSchemas();
            }
            catch (DBException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIBundle.get("DBOBJECT_LIST_SCHEMAS_ERROR"), (SQLException)cause);
                }
                DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), UIBundle.get("DBOBJECT_LIST_SCHEMAS_ERROR"), ex);
            }
        }
        return this.m_schemaList;
    }

    private void checkDetails(DBObject obj) {
        if (this.m_objectType == null && obj != null) {
            this.m_objectType = obj.getType();
        }
        if (this.m_schema == null && obj instanceof SchemaObject) {
            this.setSchema(((SchemaObject)obj).getSchema());
        }
    }

    @Deprecated
    public void setNewObject(SystemObject newObject) {
        this.setUpdatedObject(newObject);
    }

    public void setUpdatedObject(SystemObject updatedObject) {
        DBObjectID parID;
        this.m_updatedObject = updatedObject;
        this.checkDetails((DBObject)updatedObject);
        if (updatedObject != null && this.m_originalObject == null && (parID = updatedObject.getID()) instanceof TemporaryObjectID) {
            try {
                SystemObject orig = (SystemObject)((TemporaryObjectID)parID).resolveOriginalID();
                if (orig != null) {
                    this.m_originalObject = orig;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        this.checkChildIsFromUpdated();
    }

    @Deprecated
    public SystemObject getNewObject() {
        return this.getUpdatedObject();
    }

    public SystemObject getUpdatedObject() {
        SystemObject orig;
        this.checkInitFromNode();
        if (this.m_updatedObject == null && (orig = this.getOriginalObject()) != null) {
            this.setUpdatedObject((SystemObject)DBUtil.makeTemporaryCopy((DBObject)orig));
        }
        return this.m_updatedObject;
    }

    public void setOriginalObject(SystemObject originalObject) {
        this.m_originalObject = originalObject;
        this.checkDetails((DBObject)originalObject);
    }

    public SystemObject getOriginalObject() {
        this.checkInitFromNode();
        return this.m_originalObject;
    }

    public boolean isEdit() {
        return this.m_node != null || this.m_originalObject != null;
    }

    @Deprecated
    public List<SystemObject> getAdditionalObjects() {
        return Collections.emptyList();
    }

    public void setUseBackgroundTask(boolean backgroundTask) {
        this.m_backgroundTask = backgroundTask;
    }

    public boolean isUseBackgroundTask() {
        return this.m_backgroundTask;
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setChildEditOnly(boolean childEditOnly) {
        this.m_childEditOnly = childEditOnly;
    }

    public boolean isChildEditOnly() {
        return this.m_childEditOnly;
    }

    public void setResult(Result dialogResult) {
        this.m_dialogResult = dialogResult;
    }

    public Result getResult() {
        return this.m_dialogResult;
    }

    public void setException(DBException exception) {
        this.m_exception = exception;
    }

    public DBException getException() {
        return this.m_exception;
    }

    public void setObjectType(String objectType) {
        this.m_objectType = objectType;
    }

    public String getObjectType() {
        if (this.m_objectType == null && this.m_node != null) {
            this.m_objectType = DBObjectNodeUtil.normalizeType(this.m_node);
        }
        return this.m_objectType;
    }

    public DBObjectNode getOriginalObjectNode() {
        return this.m_node;
    }

    public SchemaObject getContextObject() {
        return this.m_contextObject;
    }

    @Deprecated
    public Table getIndexParent() {
        SchemaObject rel = this.getContextObject();
        if (rel instanceof Table) {
            return (Table)rel;
        }
        return null;
    }

    private void checkInitFromNode() {
        if (this.m_node != null && this.m_originalObject == null) {
            this.initEditFromObject(this.m_node.getDBObject(), true);
        }
    }

    private void initEditFromObject(DBObject obj, boolean childEditOnly) {
        DBObject child;
        SystemObject systemObject;
        Schema schema = DBUtil.getSchema((DBObject)obj);
        this.setSchema(schema);
        if (obj instanceof SystemObject) {
            systemObject = (SystemObject)obj;
            child = null;
        } else {
            systemObject = DBUtil.getSystemObject((DBObject)obj);
            child = obj;
        }
        this.setOriginalObject(systemObject);
        if (systemObject != null) {
            this.setChildObject(child);
            if (child != null && childEditOnly) {
                this.setChildEditOnly(true);
                this.setObjectType(obj.getType());
            }
        }
    }

    public static DBEditorConfig newEditConfig(DBObjectNode node) {
        DBEditorConfig retval = new DBEditorConfig(node.getProvider());
        retval.m_node = node;
        return retval;
    }

    public static DBEditorConfig newEditConfig(DBObjectProvider pro, DBObject obj) {
        DBEditorConfig config = new DBEditorConfig(pro);
        config.initEditFromObject(obj, true);
        return config;
    }

    public static DBEditorConfig newEditConfig(BaseObjectID id, boolean childEditOnly) throws DBException {
        DBEditorConfig retval = null;
        DBObject obj = id.resolveID();
        if (obj != null) {
            DBObjectProvider pro = id.getProvider();
            retval = new DBEditorConfig(pro);
            retval.initEditFromObject(obj, childEditOnly);
        }
        return retval;
    }

    public static DBEditorConfig newCreateConfig(DBObjectTypeNode node) {
        DBObjectProvider pro = null;
        try {
            pro = DBObjectProviderFactory.findOrCreateProvider((String)node.getProviderType(), (Object)node.getProviderIdentifier());
        }
        catch (DBException dbe) {
            DBLog.getLogger().warning(dbe.getMessage());
        }
        return DBEditorConfig.newCreateConfig(pro, DBObjectNodeUtil.normalizeType(node), DBObjectNodeUtil.getSchema(node, true));
    }

    public static DBEditorConfig newCreateConfig(DBObjectProvider pro, String type, Schema schema) {
        DBEditorConfig config = new DBEditorConfig(pro);
        config.setSchema(schema);
        config.setObjectType(type);
        return config;
    }

    public static DBEditorConfig newCreateConfig(DBObjectProvider pro, DBObject obj) {
        DBEditorConfig config = new DBEditorConfig(pro);
        config.setSchema(DBUtil.getSchema((DBObject)obj));
        if (obj instanceof SystemObject) {
            config.setUpdatedObject((SystemObject)obj);
        } else {
            config.setUpdatedObject(DBUtil.getSystemObject((DBObject)obj));
            config.setOriginalObject(null);
            config.setObjectType(obj.getType());
            config.setChildObject(obj);
            config.setChildEditOnly(true);
        }
        return config;
    }

    public static DBEditorConfig newCreateConfig(DBObjectProvider pro, String type, DBObject parent) {
        DBEditorConfig config = new DBEditorConfig(pro);
        config.setSchema(DBUtil.getSchema((DBObject)parent));
        config.setObjectType(type);
        if (parent instanceof SystemObject) {
            if (Metadata.getInstance().isTypeOf(SystemObject.class, type)) {
                if (parent instanceof SchemaObject) {
                    config.m_contextObject = (SchemaObject)parent;
                }
            } else {
                config.setChildEditOnly(true);
                config.setOriginalObject((SystemObject)parent);
            }
        }
        return config;
    }

    public static DBEditorConfig newEmptyConfig(DBObjectProvider pro) {
        return new DBEditorConfig(pro);
    }

    public static void setConfig(Context context, DBEditorConfig config) {
        context.setProperty(DBEditorConfig.class.getName(), (Object)config);
    }

    public static DBEditorConfig getConfig(Context context) {
        return (DBEditorConfig)context.getProperty(DBEditorConfig.class.getName());
    }

    public static DBEditorConfig newClonedConfig(DBEditorConfig config) {
        DBEditorConfig retval = DBEditorConfig.newEmptyConfig(config.getProvider());
        retval.m_allowReplace = config.m_allowReplace;
        retval.m_alwaysAllowReplace = config.m_alwaysAllowReplace;
        retval.m_backgroundTask = config.m_backgroundTask;
        retval.m_childEditOnly = config.m_childEditOnly;
        retval.m_childObject = config.m_childObject;
        retval.m_commitToProvider = config.m_commitToProvider;
        retval.m_editable = config.m_editable;
        retval.m_contextObject = config.m_contextObject;
        retval.m_node = config.m_node;
        retval.m_objectType = config.m_objectType;
        retval.m_originalObject = config.m_originalObject;
        retval.m_property = config.m_property;
        retval.m_schema = config.m_schema;
        retval.m_schemaList = config.m_schemaList;
        retval.m_startPage = config.m_startPage;
        retval.m_updatedObject = config.m_updatedObject;
        return retval;
    }

    public static enum Result {
        FAILED,
        CANCELLED,
        IN_PROGRESS,
        SUCCESS;

    }
}

