/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.ide.config.Preferences;
import oracle.ide.db.insight.completion.DBCompletionModel;
import oracle.ide.db.insight.completion.DBInsightCellRenderer;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SourceObject;

class DBCompletionProvider
implements CompletionProvider<DBCompletionModel> {
    private final DBInsightContext m_insightContext;

    DBCompletionProvider(DBInsightContext insightContext) {
        this.m_insightContext = insightContext;
    }

    public DBCompletionModel getModel(CompletionContext insightContext) {
        InsightOptions options;
        JTextComponent component = insightContext.getTextComponent();
        this.m_insightContext.setSearchOffset(component.getCaretPosition());
        this.m_insightContext.setText(component.getText());
        Node node = insightContext.getContext().getNode();
        if (node instanceof BaseDBObjectTextNode) {
            SourceObject so = ((BaseDBObjectTextNode)node).getDBObject(true);
            this.m_insightContext.setContextObject((DBObject)so);
        }
        if (!(options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences())).isCompleteFiltered()) {
            this.m_insightContext.setFilterMode(null);
        } else if (options.isFilterByContains()) {
            this.m_insightContext.setFilterMode(DBInsightContext.FilterMode.CONTAINS);
        } else {
            this.m_insightContext.setFilterMode(DBInsightContext.FilterMode.STARTS_WITH);
        }
        return new DBCompletionModel(this.m_insightContext, component);
    }

    public DBCompletionModel updateModel(CompletionContext insightContext, DBCompletionModel lastModel) {
        return this.getModel(insightContext);
    }

    public Collection<Character> getTriggerCharacters() {
        ArrayList<Character> chars = new ArrayList<Character>();
        chars.add(Character.valueOf('.'));
        return chars;
    }

    public boolean isExactMatch(DBCompletionModel data) {
        List<DBInsightData> items = data.getMatchingItems();
        return items != null && items.size() == 1;
    }

    public void customizeView(InsightViewCustomizer customizer) {
        DBInsightCellRenderer renderer = new DBInsightCellRenderer(customizer);
        customizer.setRenderer((ListCellRenderer)((Object)renderer));
    }

    public String getDisplayName() {
        return null;
    }
}

